1;
__END__

=pod

=encoding Shift_JIS

=head1 \tgEFA

Sjis-JA - Source code filter to escape ShiftJIS (Japanese document)

=head1 Tv

   g: A

    XNvg ShiftJIS_script.pl ̒ɈȉLq...
      use Sjis;
      use Sjis version;          --- Sjis.pm ̃o[W`FbNsꍇ
      use Sjis qw(ord reverse);  --- ord, reverse ̊g@\gꍇ
      use Sjis version qw(ord reverse);

       no Sjis; ͗pł܂B

    R}hvvgňȉ̂悤Ɏs
      perl     ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl55   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl56   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl58   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl510  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl512  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl514  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl516  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl64   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32

      ? * găChJ[h̎w肪ł܂
      ' ` ' găNH[g邱Ƃł܂

   g: B

    R}hvvgňȉ̂悤Ɏs

      C:\>perl  Sjis.pm  ShiftJIS_script.pl  >  Escaped_script.pl.e
      C:\>perl  Escaped_script.pl.e

      ShiftJIS_script.pl  --- ShiftJIS ŏꂽXNvg
      Escaped_script.pl.e --- GXP[vꂽXNvg

   g֐
      Sjis::ord(...);
      Sjis::reverse(...);
      Sjis::length(...);
      Sjis::substr(...);
      Sjis::index(...);
      Sjis::rindex(...);
      CORE::chop(...);

   Perl5.6 G~[V(perl5.005̏ꍇ)
      use warnings;
      use warnings::register;

   ȉ̓_~[֐Ƃ
      utf8::upgrade(...);
      utf8::downgrade(...);
      utf8::encode(...);
      utf8::decode(...);
      utf8::is_utf8(...);
      utf8::valid(...);
      bytes::chr(...);
      bytes::index(...);
      bytes::length(...);
      bytes::ord(...);
      bytes::rindex(...);
      bytes::substr(...);

=head1 v

܂ł̗j͂߂܂傤BShiftJIS ̃T|[g jperl 4.019+1.3 n
܂܂Bɂ chop() Ȃǂ̊֐␳K\𕡎Gȓ{̕ɑ΂
Kpł悤ɂȂ܂B

Perl5.8 ȍ~ Encode W[ɂă}`KT|[gꂽ߁A
jperl ͕svɂȂƌĂ܂B

łA͖{̂Ƃł傤H

{ɂāAėp^Rs[^̓óAp[\iRs[^̓R[
hѓóAɂ͌gѓdbɎ܂ŁAShiftJIS {ƂR[h
LgĂ܂B̃\tgEFA͂ ShiftJIS 𒼐ڈ܂B
Latin-1 ܂B̂ UTF8 tO͎g܂B
̃\tgEFA Shift_JIS, Windows-31J, CP932, MacJapanese, SJIS(R90),
Shift_JISX0213, Shift_JIS-2004 Ȃǂ ShiftJIS ̈Ƃł܂B
̕ł͂𑍏̂ ShiftJIS Ƃŕ\Ă܂(u_vȂ)B

ȂGR[h̖肩GXP[v܂񂩁H

=head1 ЂƂ̖(݂炢)

JPerl ͂ƂĂDꂽ\tgEFAłBƁAł JPerl ͓{Ήł
Perl ̂ƂŁAJava  JVM Ƃ͊֌W܂BȂ킯ŁÃ\tgEFA
͏Փˉ̂߂ Sjis ƂOɂ܂B̌Agbvx̖O
 Char::Sjis ƂOŃfBXgr[V쐬悤ɂ܂A
] Sjis.pm, Esjis.pm ͈g悤ɂĂ܂B

ƂŁA JPerl ̓o[W 5.005_04 ȍ~AeiXĂ܂B

ώcOȂƂɁAJPerl̊Jsn  The Perl Confernce Japan
1998 ɂ

  "킽Ȃׂ͔ꂽ玟̐l낵"

ƂbZ[WcAPerl 痣ĂĂ܂܂B

XCh15 "jperl ̍"

ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt

ƒNpŏĂ邾낤B
ȂǂƊ҂Ȃ10NԁA҂ԂɐE͈ႤւƐił̂łB

̃\tgEFA ShiftJIS ŏꂽ Perl XNvgGXP[v邽߂
\[XR[htB^łBGXP[vɂĕR[hω邱Ƃ͂
܂B

\tgEFAȉ̂Ƃwł̃\tgEFA͍쐬܂B

=over 2

=item * Perl4  Perl5 ̂悤ȏʌ݊

=item * jcode.pl ̂悤ȍő̈ڐA

=item * JPerl ̂悤ɃVtgJIŜ܂܈AUTF8tOgȂ

=item * Encode W[̂悤 Perl 1̃C^v^̂܂

=item * Ruby ̂悤ɕWƗȎ@

=item * Perl ĝ悤 TMTOWTDI(There's more than one way to do it)

=back

AJPerl ̖ɂĂЂƂ̖܂傤B

=head1 {IȎdg

ŋ߁Aȉ̃[Ĕ܂B

[Tokyo.pm] jus Benkyoukai

http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

("SJIS.pm" Ƃt@CŕۑĂ̂Ƃ܂)

  package SJIS;
  use Filter::Util::Call;
  sub multibyte_filter {
      my $status;
      if (($status = filter_read()) > 0 ) {
          s/([\x81-\x9f\xe0-\xef])([\x40-\x7e\x80-\xfc])/
              sprintf("\\x%02x\\x%02x",ord($1),ord($2))
          /eg;
      }
      $status;
  }
  sub import {
      filter_add(\&multibyte_filter);
  }
  1;

{Iɂ́Ã\tgEFA͏L̂悤ȂƂs܂B
AFilter::Util::Call 𗘗pĂȂ_APerl ̍\͂ĕKvɉ
GXP[v_قȂ܂B

=head1 CXg[@(makegꍇ)

   perl Makefile.PL
   make test
   make install

   VXe strict.pm Ȃꍇ͕t strict.pm_  strict.pm Ƀl[
   ĎgpĂB

=head1 CXg[@(makegȂꍇ)

   perl pMakefile.pl         --- pMakefile.pl  pmake.bat 𐶐܂
   pmake.bat
   pmake.bat test

   pmake.bat install          --- ݎgp perl ɃCXg[܂
   perl55   pmake.bat install --- perl5.005 ɃCXg[܂
   perl56   pmake.bat install --- perl5.006 ɃCXg[܂
   perl58   pmake.bat install --- perl5.008 ɃCXg[܂
   perl510  pmake.bat install --- perl5.010 ɃCXg[܂
   perl512  pmake.bat install --- perl5.012 ɃCXg[܂
   perl514  pmake.bat install --- perl5.014 ɃCXg[܂
   perl516  pmake.bat install --- perl5.016 ɃCXg[܂
   perl64   pmake.bat install --- perl64    ɃCXg[܂

   VXe strict.pm Ȃꍇ͕t strict.pm_  strict.pm Ƀl[
   ĎgpĂB

   pmake.bat dist             --- CPAN zzppbP[W܂
   pmake.bat ptar.bat         --- ptar.bat 쐬܂

=head1 \tgEFÄꗗ

   Char/Sjis.pm          --- ShiftJIS \[XR[htB^
   Char/Esjis.pm         --- Sjis.pm ̃^C[`
   Sjis.pm               --- Char/Sjis.pm ̕ʖ(@\͓ł)
   Esjis.pm              --- Char/Esjis.pm ̕ʖ(@\͓ł)
   perl55.bat            --- ϐ PATH ̐ݒȂ perl5.5  TĎs
   perl56.bat            --- ϐ PATH ̐ݒȂ perl5.6  TĎs
   perl58.bat            --- ϐ PATH ̐ݒȂ perl5.8  TĎs
   perl510.bat           --- ϐ PATH ̐ݒȂ perl5.10 TĎs
   perl512.bat           --- ϐ PATH ̐ݒȂ perl5.12 TĎs
   perl514.bat           --- ϐ PATH ̐ݒȂ perl5.14 TĎs
   perl516.bat           --- ϐ PATH ̐ݒȂ perl5.16 TĎs
   perl64.bat            --- ϐ PATH ̐ݒȂ perl64   TĎs
   strict.pm_            --- _~[ strict.pm
   warnings.pm_          --- warnings.pm ̊ȈՔ
   warnings/register.pm_ --- warnings/register.pm ̊ȈՔ

=head1 GXP[vɂʌ݊̊m

̃\tgEFA͉ߋ̂̂󂵂͂AɁuGXP[vvɂċ@\ǉ
Ă܂B獡܂ŉ\łƂs\ɂȂ邱Ƃ͂܂B̃Av
[`́AނċȂɗLłBȂAʌ݊̊mۂ̂߂ɂ́A
܂łPerlƔ݊Ȋg͎菜Ƃ܂B

=head1 XNvg̃GXP[v

쐬XNvg 'use Sjis;' ƏKv܂B

  ---------------------------------
  ȑO        Ȍ
  ---------------------------------
  (Ȃ)      use Sjis;
  ---------------------------------

=head1 }`oCg̃GXP[v

̃\tgEFAɂāA}`oCg̑2oCg @  [  \  ]  ^  `  {  |  }
̒O chr(0x5c) }܂BΏۂ͈ȉ̉ӏłB

=over 2

=item * VONH[g̕ ('', q{}, <<'END' and qw{})

=item * _uNH[g̕ ("", qq{}, <<END, <<"END", ``, qx{} and <<`END`)

=item * VONH[g̐K\ (m'', s''', split(''), split(m'') and qr'')

=item * _uNH[g̐K\ (//, m//, ??, s///, split(//), split(m//) and qr//)

=item * tr/// ̒̕ (tr/// and y///)

=back

  : J^Jíu\vR[h "\x83\x5C"
  
                    _v
  -----------------------------------------
  source script   "`/"    [83 5c]
  -----------------------------------------
 
   use Sjis; s
                          _v
  -----------------------------------------
  escaped script  "`\/"   [83 [5c] 5c]
  -----------------------------------------
                    ^--- Sjis \tgEFAŃGXP[v
 
  Ql              _v
  -----------------------------------------
  your eye's      "`/\"   [83 5c] [5c]
  -----------------------------------------
  perl eye's      "`\/"   [83] \[5c]
  -----------------------------------------
 
                          _v
  -----------------------------------------
  in the perl     "`/"    [83] [5c]
  -----------------------------------------

=head1 K\ւ̃}`oCgAJ[O̒ǉ

Sjis.pm ͐K\̐擪Ƀ}`oCgAJ[Ot܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/regexp/               m/@{Esjis::anchor}(?:regexp).../
  --------------------------------------------------------------------------------

=head1 2INebg̃GXP[v

Sjis.pm ͐K\̃}`oCg̑2INebgGXP[v܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m{...`/...}             m{...`/\...}
  --------------------------------------------------------------------------------

=head1 K\̃}`oCg̈ɂ

Sjis.pm ̓}`oCgւ̗ʎwqAу}`oCg̃JX^NX
NX^O܂B܂NbVbN Perl NXAPOSIX X^C̕
NX}`oCgΉłɏ܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/...MULTIOCT+.../      m/...(?:MULTIOCT)+.../
  m/...[AN-EM].../        m/...(?:A[N-Z]|[B-D][A-Z]|E[A-M]).../
  m/...\D.../             m/...@{Esjis::eD}.../
  m/...[[:^digit:]].../   m/...@{Esjis::not_digit}.../
  --------------------------------------------------------------------------------

=head1 Esjis::ignorecase() ̌Ăяo

Sjis.pm  /i Cq̑ Esjis::ignorecase() ̌ďo܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/...$var.../i          m/...@{[Esjis::ignorecase($var)]}.../
  --------------------------------------------------------------------------------

=head1 w̐K\

/b Cq̂ȂK\͕w̓܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  /regexp/                / LQ @Esjis::matched/
  m/regexp/               m/ LQ @Esjis::matched/
  ?regexp?                m? LQ @Esjis::matched?
  m?regexp?               m? LQ @Esjis::matched?
  s/regexp//              ($_ =~ m/ LQ @Esjis::matched/) ?
                          eval{ Esjis::s_matched(); local $^W=0; my $__r=qq//; $_="${1}$__r$'"; 1 } :
                          undef
  split(/regexp/)         Esjis::split(qr/regexp/)
  split(m/regexp/)        Esjis::split(qr/regexp/)
  split(qr/regexp/)       Esjis::split(qr/regexp/)
  qr/regexp/              qr/ LQ @Esjis::matched/
  --------------------------------------------------------------------------------

=head1 oCgw̐K\

/b CqtK\̓oCgw̓܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  /regexp/b               /(?:regexp)@Esjis::matched/
  m/regexp/b              m/(?:regexp)@Esjis::matched/
  ?regexp?b               m?regexp@Esjis::matched?
  m?regexp?b              m?regexp@Esjis::matched?
  s/regexp//b             ($_ =~ m/(\G[\x00-\xFF]*?)(?:regexp)@Esjis::matched/) ?
                          eval{ Esjis::s_matched(); local $^W=0; my $__r=qq//; $_="${1}$__r$'"; 1 } :
                          undef
  split(/regexp/b)        split(qr/regexp/)
  split(m/regexp/b)       split(qr/regexp/)
  split(qr/regexp/b)      split(qr/regexp/)
  qr/regexp/b             qr/(?:regexp)@Esjis::matched/
  --------------------------------------------------------------------------------

=head1 NX̃GXP[v

ߋperlƂ̌݊ۂ߂ɕNX͈ȉ̂悤ɍĒ`Ă܂B

  ---------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------
   .            @{Esjis::dot}
                @{Esjis::dot_s}    (/s Cq)
  \d            [0-9]
  \s            [\x09\x0A\x0C\x0D\x20]
  \w            [0-9A-Z_a-z]
  \D            @{Esjis::eD}
  \S            @{Esjis::eS}
  \W            @{Esjis::eW}
  \h            [\x09\x20]
  \v            [\x0C\x0A\x0D]
  \H            @{Esjis::eH}
  \V            @{Esjis::eV}
  \C            [\x00-\xFF]
  \X            X (̉pAX ł)
  \R            @{Esjis::eR}
  \N            @{Esjis::eN}
  ---------------------------------------------------------------

l POSIX X^C̕NXĒ`Ă܂B

  ---------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------
  [:alnum:]     [\x30-\x39\x41-\x5A\x61-\x7A]
  [:alpha:]     [\x41-\x5A\x61-\x7A]
  [:ascii:]     [\x00-\x7F]
  [:blank:]     [\x09\x20]
  [:cntrl:]     [\x00-\x1F\x7F]
  [:digit:]     [\x30-\x39]
  [:graph:]     [\x21-\x7F]
  [:lower:]     [\x61-\x7A]
                [\x41-\x5A\x61-\x7A]     (/i Cq)
  [:print:]     [\x20-\x7F]
  [:punct:]     [\x21-\x2F\x3A-\x3F\x40\x5B-\x5F\x60\x7B-\x7E]
  [:space:]     [\x09\x0A\x0B\x0C\x0D\x20]
  [:upper:]     [\x41-\x5A]
                [\x41-\x5A\x61-\x7A]     (/i Cq)
  [:word:]      [\x30-\x39\x41-\x5A\x5F\x61-\x7A]
  [:xdigit:]    [\x30-\x39\x41-\x46\x61-\x66]
  [:^alnum:]    @{Esjis::not_alnum}
  [:^alpha:]    @{Esjis::not_alpha}
  [:^ascii:]    @{Esjis::not_ascii}
  [:^blank:]    @{Esjis::not_blank}
  [:^cntrl:]    @{Esjis::not_cntrl}
  [:^digit:]    @{Esjis::not_digit}
  [:^graph:]    @{Esjis::not_graph}
  [:^lower:]    @{Esjis::not_lower}
                @{Esjis::not_lower_i}    (/i Cq)
  [:^print:]    @{Esjis::not_print}
  [:^punct:]    @{Esjis::not_punct}
  [:^space:]    @{Esjis::not_space}
  [:^upper:]    @{Esjis::not_upper}
                @{Esjis::not_upper_i}    (/i Cq)
  [:^word:]     @{Esjis::not_word}
  [:^xdigit:]   @{Esjis::not_xdigit}
  ---------------------------------------------------------------

l \b  \B ߋperlƂ̌݊ۂ߂ɍĒ`Ă܂B

  ---------------------------------------------------------------
  escape      class
  ---------------------------------------------------------------
  \b          @{Esjis::eb}
  \B          @{Esjis::eB}
  ---------------------------------------------------------------

t@C Esjis.pm ̒ňȉ̂悤ɒ`Ă܂B

  ---------------------------------------------------------------------------------------------------------------------------------------------------------
  class                    Definition
  ---------------------------------------------------------------------------------------------------------------------------------------------------------
  @{Esjis::anchor}         qr{\G(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?}
  @{Esjis::dot}            qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x0A])}
  @{Esjis::dot_s}          qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])}
  @{Esjis::eD}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC0-9])}
  @{Esjis::eS}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x09\x0A\x0C\x0D\x20])}
  @{Esjis::eW}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC0-9A-Z_a-z])}
  @{Esjis::eH}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x09\x20])}
  @{Esjis::eV}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x0C\x0A\x0D])}
  @{Esjis::eR}             qr{(?:\x0D\x0A|[\x0A\x0D])}
  @{Esjis::eN}             qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x0A])}
  @{Esjis::not_alnum}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x5A\x61-\x7A])}
  @{Esjis::not_alpha}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x41-\x5A\x61-\x7A])}
  @{Esjis::not_ascii}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x00-\x7F])}
  @{Esjis::not_blank}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x09\x20])}
  @{Esjis::not_cntrl}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x00-\x1F\x7F])}
  @{Esjis::not_digit}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x30-\x39])}
  @{Esjis::not_graph}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x21-\x7F])}
  @{Esjis::not_lower}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x61-\x7A])}
  @{Esjis::not_lower_i}    qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])}
  @{Esjis::not_print}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x20-\x7F])}
  @{Esjis::not_punct}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x21-\x2F\x3A-\x3F\x40\x5B-\x5F\x60\x7B-\x7E])}
  @{Esjis::not_space}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x09\x0A\x0B\x0C\x0D\x20])}
  @{Esjis::not_upper}      qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x41-\x5A])}
  @{Esjis::not_upper_i}    qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])}
  @{Esjis::not_word}       qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x5A\x5F\x61-\x7A])}
  @{Esjis::not_xdigit}     qr{(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x46\x61-\x66])}
  @{Esjis::eb}             qr{(?:\A(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[0-9A-Z_a-z])|(?<=[0-9A-Z_a-z])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]|\z))}
  @{Esjis::eB}             qr{(?:(?<=[0-9A-Z_a-z])(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]))}
  ---------------------------------------------------------------------------------------------------------------------------------------------------------

=head1 \N, \p, \P, \X ̃AGXP[v

̃\tgEFAɂĉp̐K\^V{ \N, \p, \P, \X ̐擪
'\' 菜܂B̕@Œۉ㩂邱Ƃł܂B

  ------------------------------------
  O           
  ------------------------------------
  \N{CHARNAME}     N{CHARNAME}
  \p{L}            p{L}
  \p{^L}           p{^L}
  \p{\^L}          p{\^L}
  \pL              pL
  \P{L}            P{L}
  \P{^L}           P{^L}
  \P{\^L}          P{\^L}
  \PL              PL
  \X               X
  ------------------------------------

=head1 g݊֐̃GXP[v

̃\tgEFAɂĊ֐̐擪 'Esjis::' GXP[v܂B
Esjis::* ֐ Esjis.pm 񋟂܂B

  --------------------------------------------
  O                  
  --------------------------------------------
  length      length            oCgw
  substr      substr            oCgw
  pos         pos               oCgw
  split       Esjis::split      w
  tr///       Esjis::tr         w
  tr///b      tr///             oCgw
  tr///B      tr///             oCgw
  y///        Esjis::tr         w
  y///b       tr///             oCgw
  y///B       tr///             oCgw
  chop        Esjis::chop       w
  index       Esjis::index      w
  rindex      Esjis::rindex     w
  lc          Esjis::lc         w
  lcfirst     Esjis::lcfirst    w
  uc          Esjis::uc         w
  ucfirst     Esjis::ucfirst    w
  chr         Esjis::chr        w
  glob        Esjis::glob       w
  lstat       Esjis::lstat      w
  opendir     Esjis::opendir    w
  stat        Esjis::stat       w
  unlink      Esjis::unlink     w
  chdir       Esjis::chdir      w
  do          Esjis::do         w
  require     Esjis::require    w
  --------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------
  O                   
  ------------------------------------------------------------------------------------------------------------------------
  use Perl::Module;        BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import() if Perl::Module->can('import'); }
  use Perl::Module @list;  BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import(@list) if Perl::Module->can('import'); }
  use Perl::Module ();     BEGIN { Esjis::require 'Perl/Module.pm'; }
  no Perl::Module;         BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport() if Perl::Module->can('unimport'); }
  no Perl::Module @list;   BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport(@list) if Perl::Module->can('unimport'); }
  no Perl::Module ();      BEGIN { Esjis::require 'Perl/Module.pm'; }
  ------------------------------------------------------------------------------------------------------------------------

=head1 t@CeXgZq̃GXP[v

̃\tgEFAɂĉZq '-'  'Esjis::' ɏ܂B

  -------------------------------------------------------------------------------
  O          
  -------------------------------------------------------------------------------
  -r        Esjis::r     uid/gid œǂݏo
  -w        Esjis::w     uid/gid ŏ݉
  -x        Esjis::x     uid/gid Ŏs
  -o        Esjis::o     uid L
  -R        Esjis::R     uid/gid œǂݏo
  -W        Esjis::W     uid/gid ŏ݉
  -X        Esjis::X     uid/gid Ŏs
  -O        Esjis::O     uid/gid L
  -e        Esjis::e    t@C݂
  -z        Esjis::z    t@C̒ 0 ł
  -f        Esjis::f    ʂ̃t@Cł
  -d        Esjis::d    fBNgł
  -l        Esjis::l    V{bNNł
  -p        Esjis::p    OtpCv(FIFO)ł
  -S        Esjis::S    \Pbgł
  -b        Esjis::b    ubNXyVt@Cł
  -c        Esjis::c    LN^XyVt@Cł
  -t        -t          t@Cnh tty ɑ΂ăI[vĂ
  -u        Esjis::u    setuid rbgZbgĂ
  -g        Esjis::g    setgid rbgZbgĂ
  -k        Esjis::k    sticky rbgZbgĂ
  -T        Esjis::T    eLXgt@Cł
  -B        Esjis::B    oCit@Cł(-T Ƃ͋ẗӖ)
  -s        Esjis::s    t@C̒ 0 ł͂Ȃ(oCgPʂŕԂ)
  -M        Esjis::M    (sJnƂ)CĂ̓
  -A        Esjis::A    (sJnƂ)ŌɃANZXĂ̓
  -C        Esjis::C    (sJnƂ)inode ύXĂ̓
  -------------------------------------------------------------------------------

perl5.00503 gpĂꍇłt@CeXgZq́uςݏd˂vƂ
ł܂B

  if ( -w -r $file ) {
      print "The file is both readable and writable!\n";
  }

=head1 ֐̃GXP[v

ẘ֐gꍇ͈ȉ̂悤ɋLqKv܂Bꂼ
̋@\ɂẮuẘ֐vQƂĂB

  ----------------------------------------------------
  ֐    w        
  ----------------------------------------------------
  ord       Sjis::ord
  reverse   Sjis::reverse
  length    Sjis::length
  substr    Sjis::substr
  index     Sjis::index     ȉ̋LqQƂ̂
  rindex    Sjis::rindex    ȉ̋LqQƂ̂
  ----------------------------------------------------

  index ̒Ԃ
  --------------------------------------------------------------
  ֐                  Ԓl         
  --------------------------------------------------------------
  index          w     oCgP   JPerlƓ
  Sjis::index    w     P     w̓
  CORE::index    oCgw   oCgP   oCgw̓
  --------------------------------------------------------------

  rindex ̒Ԃ
  --------------------------------------------------------------
  ֐                  Ԓl         
  --------------------------------------------------------------
  rindex         w     oCgP   JPerlƓ
  Sjis::rindex   w     P     w̓
  CORE::rindex   oCgw   oCgP   oCgw̓
  --------------------------------------------------------------

=head1 ẘ֐

=over 2

=item * Sjis::ord

    $ord = Sjis::ord($string);

    Sjis::ord($string)  $string ̐擪̕ ShiftJIS R[hlԂ܂
    (Unicode ł͂܂)B$string ȗꂽꍇ $_ ΏۂƂȂ܂B
    ̊֐͏ɕȂ̒lԂ܂B

    "use Sjis qw(ord);" ɂăXNvgɋLq ord  Sjis::ord ɏ
    悤ɂȂ܂Bord  Sjis::ord ̓̂ JPerl Ɣ݊Ȃ
    ŖIɃC|[gꍇ̂ݏ܂B

=item * Sjis::reverse

    @reverse = Sjis::reverse(@list);
    $reverse = Sjis::reverse(@list);

    Sjis::reverse(@list) ̓XgReLXgł @list ̗vftɕׂ
    XglԂ܂B

    XJ[ReLXgł @list ׂ̂Ă̗vfAŁAShiftJIS 
    Pʂŋtɂ̂Ԃ܂B

    "use Sjis qw(reverse);" ɂăXNvgɋLq reverse 
    Sjis::reverse ɏ悤ɂȂ܂Breverse  Sjis::reverse ̓
    ̂ JPerl Ɣ݊Ȃ̂ŖIɃC|[gꍇ̂ݏ܂B

=item * Sjis::length

    $length = Sjis::length($string);
    $length = Sjis::length();

    Sjis::length($string) ̓XJ[l $string ̒ ShiftJIS ̕ŕ
    ܂B$string ȗꍇ $_ ̕Ԃ܂B

    ł͂ȂoCgPʂł̒𒲂ׂɂ́A܂܂Œʂ

    $bytes = length($string);

    ̂悤ɂ܂B

=item * Sjis::substr

    $substr = Sjis::substr($string,$offset,$length,$replacement);
    $substr = Sjis::substr($string,$offset,$length);
    $substr = Sjis::substr($string,$offset);

    Sjis::substr ́AShiftJIS  $string Ŏw肳ꂽ񂩂畔
    oĕԂ܂B́A̐擪琔 $offset ڂn܂A
    $length łB$offset Ȃ΁A̖ -$offset ߂
    Ƃ납畔񂪊Jn܂B$length ȗƁA̖܂łׂĂ
    Ԃ܂B$length Ȃ΁A̖ -$length c悤ɁA
    ߂܂BłȂ΁A$length ́AȂ҂悤ɁAo
    ̒\Ă܂B

    Sjis::substr Ӓl(̑ΏۂƂȂ)ƂĎgƂ͂ł܂B̑
    ɁA4 $replacement ɒup̕w肵܂B̏ꍇA
    Sjis::substr  $string ̈ꕔ𕶎 $replacement ŒuƂƂɁA
    (splice ̂悤)uꂽlƂĕԂ܂B̗́A$var ̍Ō
     "Curly" ŒuƂƂɁAuꂽ $oldstr ɃZbg
    :

    $oldstr = Sjis::substr($var, -1, 1, "Curly");

    $var ̐擪ɕ "Larry" tɂ́Â悤ɂ܂:

    Sjis::substr($var, 0, 0, "Larry");

    $var ̍ŏ1 "Moe" Œuɂ́Â悤ɂ܂:

    Sjis::substr($var, 0, 1, "Moe");

    $var ̍Ō1 "Curly" Œuɂ͎̂悤ɂ܂:

    Sjis::substr($var, -1, 1, "Curly");

=item * Sjis::index

    $index = Sjis::index($string,$substring,$start);
    $index = Sjis::index($string,$substring);

    Sjis::index ́AShiftJIS  $string ̒Ɋ܂܂A1 ShiftJIS 
     $substring T܂B$string ̒ŁA$substring ŏɏoʒu
    PʂŐĕԂ܂B$start w肳ĂꍇA$string ̐擪 $start
    ̕XLbvʒuA$substring Tn߂܂Bʒu 0 x[XƂ
    Đ܂B$substring Ȃ΁ASjis::index ֐̓x[X 1 
    l -1 Ԃ܂BSjis::index gāAŜ𒲂ׂɂ́Â悤
    ܂B

    $pos = -1;
    while (($pos = Sjis::index($string, $lookfor, $pos)) > -1) {
        print "Found at $pos\n";
        $pos++;
    }

=item * Sjis::rindex

    $rindex = Sjis::rindex($string,$substring,$position);
    $rindex = Sjis::rindex($string,$substring);

    Sjis::rindex  Sjis::index ƎĂ܂AShiftJIS  $string ̒ŁA
     $substring Ōɏoʒu𕶎PʂŐĕԂ܂(܂
    reverse Sjis::index ł)B$substring Ȃ΁A-1 Ԃ܂B
    $position ɂāAlƂĕԂƂAłËʒuw肷邱
    ł܂BSjis::rindex gāAŜ𖖔擪ɌĒׂ
    ́Â悤ɂ܂B

    $pos = Sjis::length($string);
    while (($pos = Sjis::rindex($string, $lookfor, $pos)) >= 0) {
        print "Found at $pos\n";
        $pos--;
    }

=back

=head1 oCgẘ֐

=over 2

=item * CORE::chop

    $byte = CORE::chop($string);
    $byte = CORE::chop(@list);
    $byte = CORE::chop;

    ϐ邢̓oCgϐ̍Ō̃oCg؂藎ƂÃoCglƂ
    Ԃ܂BCORE::chop Zq́Aɓ̓R[h̖s菜̂
    pAuZqg(s/\n$//)IłB肽Ƃꂾ
    Ȃ΁Achomp gقSłBȂȂACORE::chop ͖ɂoCg
    𖳏Ŏ菜̂ɑ΂āAchomp ͎菜̂IŎ菜łB

    e CORE::chop 邱Ƃ͂ł܂ --- CORE::chop ł͕̂ϐ
    B

    Ƃĕϐ̃Xg @list ^ƁAXg̊e̍Ō̃oCg؂
    Ƃ܂:

    @lines = `cat myfile`;
    CORE::chop @lines;

    ܂߁AӒlȂ΂ǂȂ̂ł CORE::chop 邱Ƃł܂:

    CORE::chop($cwd = `pwd`);
    CORE::chop($answer = <STDIN>);

    2śA̗Ƃ͈܂:

    $answer = CORE::chop($tmp = <STDIN>); # 

    ̃R[hł́ACORE::chop ́A($tmpɓĂ)cꂽł͂ȂA؂
    ƂoCgԂ̂ŁA$answer ɂ͉sZbgĂ܂܂BӐ}
    ʂ𓾂邽߂̕@1́Asubstr gƂł:

    $answer = substr <STDIN>, 0, -1;

    Â悤ɏ̂ʂł:

    CORE::chop($answer = <STDIN>);

    łʓIȃP[Xł́Asubstr gāACORE::chop 邱Ƃł܂:

    $last_byte = CORE::chop($var);
    $last_byte = substr($var, -1, 1, ""); # 

    炪ł邱Ƃ𗝉Ă܂΁A܂Ƃ߂ CORE::chop sƂł
    ܂B2ȏ̃oCg܂Ƃ߂Đ؂藎Ƃɂ́Asubstr ӒlƂĎgA
    󕶎܂B̃R[h $caravan ̍Ō5oCg菜܂:

    substr($caravan, -5) = "";

    ł substr ɕ̒l^邱ƂɂāA(擪ł͂Ȃ)̃I
    tZbgw肵Ă܂B폜oCgۑ΁A4 substr g
    5oCg CORE::chop ܂:

    $tail = substr($caravan, -5, 5, "");

    ȗƁAϐ $_ ΏۂƂȂ܂B

=item * CORE::ord

    $ord = CORE::ord($expr);

    CORE::ord($expr)  "use Sjis qw(ord);" ̋Lq̗LɊւ炸A $expr
    ̐擪̃oCglԂ܂B$expr ȗꂽꍇ $_ ΏۂƂȂ܂B
    ̊֐͏ɕȂ̒lԂ܂B

    t̒lKvł΁Aunpack('C',$expr) g܂B܂SẴoCgl
    XgƂĕKvł unpack('C',$expr) Ɏg܂B

=item * CORE::reverse

    @reverse = CORE::reverse(@list);
    $reverse = CORE::reverse(@list);

    CORE::reverse(@list) ̓XgReLXgł @list ̗vftɕׂ
    XglԂ܂B

    XJ[ReLXgł "use Sjis qw(ord);" ̋Lq̗LɊւ炸A @list
    ׂ̂Ă̗vfAŁAoCgPʂŋtɂ̂Ԃ܂B

=item * CORE::index

    $index = CORE::index($string,$substring,$start);
    $index = CORE::index($string,$substring);

    CORE::index ́AoCg $string ̒Ɋ܂܂A1̃oCg $substring
    T܂B$string ̒ŁA$substring ŏɏoʒuoCgPʂŐ
    Ԃ܂B$start w肳ĂꍇA$string ̐擪 $start oCgXLb
    vʒuA$substring Tn߂܂Bʒu 0 x[XɂĐ܂B
    $substring Ȃ΁ACORE::index ֐̓x[X 1 l -1
    Ԃ܂BCORE::index gāAoCgŜ𒲂ׂɂ́Â悤ɂ܂B

    $pos = -1;
    while (($pos = CORE::index($string, $lookfor, $pos)) > -1) {
        print "Found at $pos\n";
        $pos++;
    }

=item * CORE::rindex

    $rindex = CORE::rindex($string,$substring,$position);
    $rindex = CORE::rindex($string,$substring);

    CORE::rindex  CORE::index ƎĂ܂AoCg $string ̒ŁAoCg
     $substring ŌɏoʒuoCgPʂŐĕԂ܂(܂
    reverse CORE::index ł)B$substring Ȃ΁A-1 Ԃ܂B
    $position ɂāAlƂĕԂƂAłËʒuw肷邱
    ł܂BCORE::rindex gāAoCgŜ𖖔擪ɌĒׂ
    ɂ́Â悤ɂ܂B

    $pos = CORE::length($string);
    while (($pos = CORE::rindex($string, $lookfor, $pos)) >= 0) {
        print "Found at $pos\n";
        $pos--;
    }

=back

=head1 bytes::* ֐̃AGXP[v

̃\tgEFAɂ bytes::* ֐̐擪 'bytes::' 菜܂B

  -----------------------------------------
  O               
  -----------------------------------------
  bytes::chr       chr       oCgw
  bytes::index     index     oCgw
  bytes::length    length    oCgw
  bytes::ord       ord       oCgw
  bytes::rindex    rindex    oCgw
  bytes::substr    substr    oCgw
  -----------------------------------------

=head1 g݂̕WW[̃GXP[v

Esjis.pm ̐擪 "BEGIN { unshift @INC, '/Perl/site/lib/Sjis' }" sA
W[̌Aŏ '/Perl/site/lib/Sjis' QƂ悤ɂȂ܂BSjis
\tgEFAŎg悤ɉWW[Ɋi[āAƂ̕W
W[I[o[Ch܂B

=head1 WW[̓ẽGXP[v

WW[̃t@C /Perl/site/lib/Sjis ɃRs[ 'use utf8;' 
'use Sjis;' ɏ܂BKvɉĂ̑̏sĂB

=head1 perl5.005 ɂ Perl5.6 G~[V

  perl5.005 ɂ warnings vO}G~[g܂B
   warnings.pm_  warnings.pm ɁAwarnings/register.pm_ 
  warnings/register.pm Ƀt@CύXĎgpł܂B

=head1 vO}уW[

  -----------------------------------------------------------
  O                    
  -----------------------------------------------------------
  use strict;               use strict; no strict qw(refs);
  use 5.12.0;               use 5.12.0; no strict qw(refs);
  require utf8;             # require utf8;
  require bytes;            # require bytes;
  require charnames;        # require charnames;
  require I18N::Japanese;   # require I18N::Japanese;
  require I18N::Collate;    # require I18N::Collate;
  require I18N::JExt;       # require I18N::JExt;
  require File::DosGlob;    # require File::DosGlob;
  require Wild;             # require Wild;
  require Wildcard;         # require Wildcard;
  require Japanese;         # require Japanese;
  use utf8;                 # use utf8;
  use bytes;                # use bytes;
  use charnames;            # use charnames;
  use I18N::Japanese;       # use I18N::Japanese;
  use I18N::Collate;        # use I18N::Collate;
  use I18N::JExt;           # use I18N::JExt;
  use File::DosGlob;        # use File::DosGlob;
  use Wild;                 # use Wild;
  use Wildcard;             # use Wildcard;
  use Japanese;             # use Japanese;
  no utf8;                  # no utf8;
  no bytes;                 # no bytes;
  no charnames;             # no charnames;
  no I18N::Japanese;        # no I18N::Japanese;
  no I18N::Collate;         # no I18N::Collate;
  no I18N::JExt;            # no I18N::JExt;
  no File::DosGlob;         # no File::DosGlob;
  no Wild;                  # no Wild;
  no Wildcard;              # no Wildcard;
  no Japanese;              # no Japanese;
  -----------------------------------------------------------

  utf8 vO}Abytes vO}̓RgAEg܂Bt@CŒ񋟂
  ֐̑Ƃ Esjis.pm _~[֐񋟂܂B

=over 2

=item * _~[̊֐ utf8::upgrade

  $num_octets = utf8::upgrade($string);

  $string ̃INebgԂ܂B

=item * _~[̊֐ utf8::downgrade

  $success = utf8::downgrade($string[, FAIL_OK]);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ utf8::encode

  utf8::encode($string);

  ̊֐͉Ԃ܂B

=item * _~[̊֐ utf8::decode

  $success = utf8::decode($string);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ utf8::is_utf8

  $flag = utf8::is_utf8(STRING);

  ̊֐͏ɋU̒lԂ܂B

=item * _~[̊֐ utf8::valid

  $flag = utf8::valid(STRING);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ bytes::chr

  oCgẘ֐ chr ƂĎĂ܂B

=item * _~[̊֐ bytes::index

  oCgẘ֐ index ƂĎĂ܂B

=item * _~[̊֐ bytes::length

  oCgẘ֐ length ƂĎĂ܂B

=item * _~[̊֐ bytes::ord

  oCgẘ֐ ord ƂĎĂ܂B

=item * _~[̊֐ bytes::rindex

  oCgẘ֐ rindex ƂĎĂ܂B

=item * _~[̊֐ bytes::substr

  oCgẘ֐ substr ƂĎĂ܂B

=back

=head1 ϐ

 ̃\tgEFA͔r flock ֐gp܂Bt@Cǎ\ɂȂ܂
 邢͏݉\ɂȂ܂ŃvO̎s̓ubN܂B
 ϐ SJIS_NONBLOCK `邱ƂŃubNȂ悤ɂ邱Ƃł
 B

 :

   SET SJIS_NONBLOCK=1

 (l '1' ͈ӖȂ̂ŉł\܂)

=head1 MacJPerl ̋@\

 } Web ̏Qlɂ MacOS ɑΉĂ݂܂B@Ȃ߂ɃeXg
 łĂ܂B񍐁AoO񍐓ƂƂĂ肪łB
 
 sɂ͈ȉ̃\tgEFAKvłB
 1. MacPerl W[
 2. Mac::Files W[
 3. ToolServer
 4. MPW(Macintosh Programmer's Workshop)

=head1 oOƐ

̃\tgEFÁA̔\͂sāAeXgďƍ܂BłĂA
̐K\܂ރ\tgEFÁAx̃oOƂ܂ʂ邱Ƃł܂B
āAȂ̃XNvgł͂ȂāASjis\tgEFÃoO̂ȂA
ŏ̃eXgR[hɐ؂l߂ŁA҂܂ŕ񍐂ĒƏ܂B

邢͂ƗLpȃc[ɂ邽߂̂悢ACfBAȂAFƋLĒ
Ƃ肪łB

=over 2

=item * format

    IWi Perl Ƌ@\ł(ShiftJIS ɑΉĂ܂)B

=item * chdir

    perl5.005 łΏ chdir() 𐳏Ɏsł܂B

    DOS̃VXe($^O ̒l MSWin32, NetWare, symbian, dos ̂ꂩ
    ꍇ)́Aȉ̐܂B

    perl5.006 ܂ perl5.00800 ̏ꍇŕR[h(0x5C)ŏIfBNg
    w肵Ďsɂ jacode.pl CuKvłB

    perl5.008001ȍ~, perl5.010, perl5.012, perl5.014 ɂĕR[h(0x5C)
    IfBNgw肵ĎsƂAWin32 W[
    Win32::GetShortPathName() ɂĒZO擾łꍇ chdir() 
    ܂BAchdir() ̃JgfBNg
    Win32::GetShortPathName() ɂĎ擾ZOɂȂ܂B

    QlN
    Bug #81839
    chdir does not work with chr(0x5C) at end of path
    http://bugs.activestate.com/show_bug.cgi?id=81839

=item * ӒlƂĂ Sjis::substr

    Sjis::substr  CORE::substr Ƃ͈قȂAӒlƂĈƂł܂B
    ̈ꕔύXꍇ́ASjis::substr 4Ԗڂ̈ƂĒu
    w肵܂B
    
    Sjis::substr($string, 13, 4, "JPerl");

=item * ϐ $`  $& gƂ /( K\ŜLv` )/ Kv܂

    ȂȂ΁Aȉ̂悤ɕϊA$1 𗘗p邽߂łB
 
    -------------------------------------------------------------------------------------------
    O                         se
    -------------------------------------------------------------------------------------------
    $`              Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    $PREMATCH       Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    ${^PREMATCH}    Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    $&              Esjis::MATCH()       $1
    $MATCH          Esjis::MATCH()       $1
    ${^MATCH}       Esjis::MATCH()       $1
    $'              Esjis::POSTMATCH()   $'
    $POSTMATCH      Esjis::POSTMATCH()   $'
    ${^POSTMATCH}   Esjis::POSTMATCH()   $'
    -------------------------------------------------------------------------------------------

=item * K\Kp镶̒̏

    Oq̂ƂAGXP[v̐K\ɂ̓}`oCgAJ[Ô
    ߂̋Lq @{Esjis::anchor} ǉ܂A̒Ɋ܂܂ \G ̐
    ܂Bperl5.006, perl5.008, perl5.010, perl5.012, perl5.014 Ŏs
    AΏە32,767oCg𒴂ʒuł̃}b`ׂƂŃ}b`
    BȂA̍ۂɃG[xo͂܂B

    QlN
    Bug #89792
    \G can't treat over 32,767 octets
    http://bugs.activestate.com/show_bug.cgi?id=89792

=item * ??, m?? ̐

    ?? ܂ m?? ̓Ń}`oCgɑ΂ {n,m} {n,} {n} * + Ȃǂ̗ʎw
    qtꍇ́A̕ ( ) ň͂ŋLqKv܂B̌ʁA
    $1,$2,$3,... ͂Ă܂߁A̋LqCKv܂B
    Ȃ ?? ܂ m?? ̓f~^ ? Ȃ̂ŁA(?: ) ʎwq ? {n,m}? {n,}?
    {n}? ͋Lq邱Ƃł܂B

=item * ǂ݌

    ǂ݌(Ⴆ (?<=[A-Z]))O̓oCg̑oCgɌă}b`
    邱Ƃɂ͑ΏĂ܂B
    Ⴆ΁A'ACE' =~ /(?<=[A-Z])([ACE])/ sƃ}b` $1  'C'
    ɂȂ܂A͐܂B

=item * WJƋɂȂ鐳K\̕ϐ

    ̃eƂ͈قȂAK\ɓWJꂽϐ̒l󕶎ł
    ĂAOɐK\͎g܂B

=item * K\̏Cq /a /d /l /u

    ̃\tgEFÃRZvg͕̕𓯎ɗpȂ悤ɂ
    ƂłB]ďCq /a /d /l /u T|[g܂B
    \d ͐̂ [0-9] Ӗ܂B

=back

=head1 

̃vWFNg t  ina@cpan.org ɂĎn܂܂B

=head1 쌠

̃\tgEFA̓t[\tgEFAłBȂ Perl ƓCZX
̌ōĔzzyѕύXsƂo܂Bڂ perlartistic QƂ
B

̃\tgEFA͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
ߑS݂܂B

=head1 VtgJISR[hƂ({񏈗)

VtgJIŚA}CN\tgЂɂJꂽA{̃Rs[^ōł悭
p镄łBVtgJIŚuMS(Microsoft)vA܂́uSJIS
(ShiftJIS̗)vƂĂ΂Ă܂B

ē{̃Rs[^[U͔pЉgȂ߁A]Ƃ̌݊
ێړIŃVtgJISJ܂B

VtgJISɂẮA16i 0x81`0x9F ܂ 0xE0`0xEF ͈̔͂INebg
ɂ12INebg[hJn܂BẴINebǵAn܂
2INebg̑1INebgƂď܂B(2)INebǵA16i
0x40`0x7E ܂ 0x80`0xFC ͈̔͂lłȂ΂Ȃ܂B1INebg
͈͂͊gASCIIZbgA܂ŏʃrbgIɂȂ8rbgZbg͈̔
ɊSɎ܂Ă邱ƂɒڂĂB܂VtgJIŚApЉASCII/JIS
[}T|[gĂ܂B

ꕔ̃VtgJISdl(Ƀ[Jdl)ł́A[U`̃R[ḧAꍇɂ
͔pЉ󔒕̃R[hʒu`Ă܂B{iIȏ]ނ̂
΁Â悤ȃR[ḧR[hʒu͕ssłBƂ̂Â悤ȕ́A
ʂ̓{ꕄ(܂JISEUC)̃R[hʒuɕϊłȂ悤ɕĂ
܂łB

=head1 EBLyfBAɂuShift_JISv̒`

Shift_JIS (2011.10.27 00:00:00 JST). In Wikipedia: The Free Encyclopedia.
Retrieved from
http://ja.wikipedia.org/wiki/Shift_JIS

oT: t[SȎTwEBLyfBA(Wikipedia)x

Shift_JISiVtgWXj́Aݑ̃p\R̃t@Cœ{\
ɎgĂ镶R[hłBĂ̓x_[ɂƎg܂ޕR[h
Qɑ΂BȖ̂łA݂͕WJIS X 0208̕1ŋK肳
ĂBuShift_JISvIANAɂo^łB

Shift_JIS̒a

1980NAp\Rp16rbgCPU̕y܂āA≼\\ȃn[
hEFAp\RXƔꂽB̂߁A{\ł镶
͍ĂiShift_JISuVtgJISR[hvƌĂŕ
WiR[hj̖ʂ݂̂lc_邪Ał͕̖ʂ
œ_𓖂ĂjB

Shift_JIS̐݌v҂́AsĂ悭pĂJIS C 6220
i݂JIS X 0201j8rbgiȉupEpJivjƁAJIS C 6226
i݂JIS X 0208Aȉuvj̗W\悤ƂB܂At@
C̑傫⏈Ԃ̒Zk}邽߁AGXP[vV[PXȂō݉\
邱Ƃ}B

JIS C 6220JIS C 62262͂ƂɁAISO 2022ŕW؂ւėp
݌vBISO 2022ɊÂł́ApApJiA͂
A8rbgԂ̒GL/GRƂ̈1i2jgƂ
\łBpƊ2GXP[vV[PXȂō݂ȂA
pGLAGRɊ蓖Ă@BEUC-JṔA悻̂悤Ɏ
ĂB

Ap\Rł͂łɁAJIS X 02018rbgA܂GLɉpAGR1o
CgJ^JiipJ^Jij蓖ĂyĂBp1oCgJ
^Ji2𓮂Ƃ́ǍɂȂ邽ߔKvB
߁AISO 2022̘g̗̈Ɋ݂邱Ƃ͍B

1982NA̕ʒu𕡎GɈړiVtgjAԂ̌Ԃɉ
Shift JISaB邽߂ɂ́A1oCgڂƂāAISO 2022
ɂGRiA1(16)-FE(16)j̈31cĂgp̈ɉAISO 2022
ĔgpCRi80(16)-9F(16)j̈gp邱ƂƂBAGLi21(16)
-7E(16)j̈ɂẮAJIS X 0201̋Lɓ镔͋ɗ͔B2oC
gڂɂ́AISO 2022Ƃ͈قȂApEpJiɎgpς݂̗̈܂ށAGLA
CRAGRɂë̂قڑSĂgKvB

}CN\tgi{@lj̌Ð식ɂƁAShift_JIS̐ɂ́AAX
L[A}CN\tgiājAOHd@A}CN\tgEFAEA\VGCcAf
W^T[`iājւAɃAXL[̎RǑSƂȂč쐬
̂ƂBɑ΂ِƂāAsẅF́A}CN\
tgEFAEA\VGCcƎOHd@݂̂̋JƎ咣ĂAR{l
̔ɂ͎P񂷂锭ĂB܂ÂLife with UNIX
󏑁iISBN 4-7561-0783-4j́uUNIXlTv|ŉMip. 45jŁA[
OɁuMSR[h̍҂̈lvƂЉĂB

Shift_JIS̕W

Shift_JIŚAWƂ̗̕܂ތ̖
邽߂̋ZpłB䂦AJIS X 0208̕W𗘗pĂ͂̂́A
ISO 2022̕̕j͈̔͂̊OɂB

݂ł́AJIS X 0208:1997̕1ɁAuVtg\vƂO
dl`ĂB́Aft@NgX^_[hƂȂĂZpɂ
͏oƂAƂWĂ܂ƂӐ}{HƕW
 (JISC) ɂĂ̂ƂłB

JIS X 0208̊gKiłJIS X 0213ł́A2000N̏łŕ1Ƃ
Shift_JISX0213߂ꂽB2004N10ǉɔāAShift_JIS-2004
Ɩ̂ύXꂽB

IANAłuShift_JISvƂO蓖ĂĂB

_ƌ_

_
1. SpƁAJIS X 0201Œ`锼pJi𓯈̃R[ȟn
   \łB
2. {ɂẮAMS-DOSœ{pR[hƂč̗pĈȗAp\
   RɂĈ|IȕyxȂ̕ɔׂăf[^
   \B

_
1. pJî߂̗̈mۂ֌WAR[hV[NGX_ԍ́uv
   ̋؂ł͂ȂӏŕfĂB̂߁AR[hԍZŋ߂ۂ
   ώGȏKvłB
2. 2oCgڂ80(16)(ASCIĨR[ḧ)B̂߁A̋؂
   ɎԂBt@Cd̐擪當R[h̔ꍇ͂悢
   A납画悤ƂƁAň̏ꍇA擪܂łǂȂƂȂ
   Ƃ邽߁AvO̍ɍHvKvɂȂB܂Ä̗Ɋ܂
   ꕔ̈̂̕߁A}`oCgEUC-JPAUTF-8ȂǂɔׁAvO
   ~ÖiQƁjB
3. JIS⏕\łȂB⏕̕Shift_JIS̃R[ho^
   ܂ȂB
4. WɂĂ͎x_JIS X 0208ŋK肳ĂȂ@ˑ̊g
   {Ă邱ƂAgɊւĂ̓f[^\ႢB

2oCgڂ5CɂȂ肤邱Ƃɂ

Shift_JISł́Au\vu\vȂǈꕔ̎2oCgڂɁA5C(16)iShift_JISł́
LAASCIIȂǂł̓obNXbVjgpĂB̃vO~O
 (CAPerlABourne ShellȂǑ) ł́A5C(16)GXP[vƂĂB
āA\[XR[h╶f[^̏ɂShift_JISz肵ĂȂv
O~Oł͖肪NB̖́A悤2oCgڂ͈̔͂5C(16)
܂Big5A܂ł͂邪GBKȂǂ̕R[hłB

܂A5C(16)ȊOɂĂގ̖肪邱ƂBƂ΁AUnix
MS-DOSȂǂ̃VF7C(16) (Shift_JISASCIIł̓o[eBJo[) ܂ޕ
i|A|A|A|A|A|A|Accjt@CɎgp悤ƂƁApCv
LƔFAɃt@C쐬ȂAǂݍ݂sǂɂȂ
邱ƂB

݂łAVOoCgR[hΉ̃\tgEFAShift_JISŎgp
ƁAsȂǂ̓t@C̏Ȃǂɂ΂΂̖肪܂ƂB
sA2oCgڂ5C(16)͑ɁuߕvƌĂ΂A̒
́u\vu\vu\vu\vȂǈʂɎgppx̍܂܂B

̖`Iȕ@ƂāA\[XR[hŜEUCR[hUTF-8Ȃǂ
ϊĂRpCs肷@iFPerl encodingv
O}jB邢́u\vu\\v̂悤ɁA2oCgڂ̒OɃGXP[v
5C(16)LqAuߕv𕶎ƂĐF@iFPerl
Sjis\tgEFAjB邢͕܂͕ƂĈ킸Ώەѓ
\`𐔒l̔zƂĕϊsA舵ۂɕɕĈ@
iFPerl EncodeW[jB



u\ȂvƂ񂪂̌f\tgŁuȂvƕ
pɂɌB

   \         
  8d5c 82ed 82c8 82a2
  obNXbVɂ5cƁA
  8d   82ed 82c8 82a2
             

uvƂ̂ƂŃfR[hē͐̕ɖ߂B܂l
Ɂu|\Evu|EvɉB 

   |    \   E
  8c7c 945c 8a45
  obNXbVɂ5cƁA
  8c7c 94   8a45
   |       E

  \ 2oCgڂ5C(16)ꗗ  (16i) ǂ݁EӖ 

  \   815C _bV
  \   835C Љ́uv
  \   845C L̃EB
  \/? 875C Windowsł̓[}9
            MacłGB(MKoCg)
  \   895C 킳B
  \   8A5C C
  \   8B5C ނB\
  \   8C5C BlB
  \   8D5C ܂B\
  \   8E5C JCRB{\
  \   8F5C 10B
  \   905C AB\
  \   915C AЁBu]v̈ẂíjB\
  \   925C B\y
  \   935C ͂B\t
  \   945C ̂B\
  \   955C 킷AЂ傤B\
  \   965C ΂AڂB\
  \   975C 炩߁AB\
  \   985C 낭B\
  \   995C ƁABuevّ̈̎
  \   9A5C B\
  \   9B5C B\a(ua̔񏑊)
  \   9C5C B퐶́uv̐
  \   9D5C B\
  \   9E5C Ȃ̕ʑ
  \   9F5C AA傤B
  \   E05C 炤AB
  \   E15C ӂAقB
  \   E25C ƂAւB
  \   E35C AB
  \   E45C łAB\
  \   E55C BaC\X
  \   E65C G̋
  \   E75C ̂̌Î
  \   E85C ΁B\()B
  \   E95C ܂B\
  \   EA5C oB̖B
  x   ED5C B
  x   EE5C 傭B
  \   FA5C 킽AB
  \   FB5C B

R[hԂɂ镶

Shift_JIS2oCgR[h̋Ԃ́A1oCg81(16)-9F(16)ȂтE0(16)-
FC(16)A2oCg40(16)-7E(16)Ȃт80(16)-FC(16)łBāA
60~188=11280A1oCgR[h158iXy[X܂݁ADEL͐j
ł邽߁Av11438ƂȂB

ȂAShift_JIS-2004ł́A2oCg11233A1oCg158̂߁A
v11391gpĂB

Shift_JISɂuVtgvƂ

Shift JIŚuVtgvƂ́A256~256̕ʂ̒ŕ𕡎G"炷"ƂӖ
́uVtgvłB

ISO-2022-JP͎wV[PXŊƃAt@xbg؂ւ镄łB
܂AEUC-JP͕⏕ƔpJ^JiVOVtgňꎞIɐ؂ւĎg
łB̕ōsĂAeW̖ʂVtgR[
hɂĐ؂ւ鑀uVtgvƌĂ΂邪AShift_JIŚuVtgv͂
Ƃ͈قȂӖłB܂rbg炷irbgVtgjƂقȂB

Shift_JISƋ_ԍ

Shift_JIS̑Ώۂɂ镶ẂAJIS X 0208łB̕W
ɂ́A_ԍƂTO݂B́A94~94̕\̍sƗ̔ԍ̑g
łB

Shift_JISł́A8140(16)-FCFC(16)Ƃ悤ɁAJIS X 0208Ƃ͂܂R[
ȟnł邪AJIS X 0208vZɂό`̂ł邽߁A_ԍp
̃R[h|CgwƂBeɂẮAJIS X 02081`94
ƓłBA@ˑł́AVtgJIS̕ԂtA94
ɂ120܂łgĂ邩̂悤ɈƂB95ȏ́A
ISO/IEC 2022ɑJIS X 0208̍\ł݂͑Ȃ̂ŁA{͂B
x_Ǝ̔ȊTOłBȂAJIS X 0213̋Kïꕔł
Shift_JISX0213\ɂẮA1oCgF0(16)ȍ~2ʂ̕Ɋ蓖Ă
ASƂ悤ȑ݂Ȃԍ͓oꂵȂB

ux-sjisvƁuMS_Kanjiv

ux-sjisvƁuMS_Kanjiv͂ƂɁAHTMLhLǵucharsetv̎w
uShift_JISv̕ʖƂĎgƂoB

ux-sjisvIANAɁuShift_JISvƂOo^OɁANetscape Navigator
2.0ɂĎgĂGR[fBO̎wqłBꕔHTML\tg
ł̎wqgݍŎgĂB̂ߔF\ȃuEU邪A
uShift_JISvɏ邱Ƃ𐄏ĂB

uMS_KanjivIANAɂuShift_JISv̕ʖƂĊ蓖ĂĂB


=head1 ̃\tgEFAł "ShiftJIS"

̃\tgEFAł "ShiftJIS" ͏ĹuR[hԂɂ镶v
11438ׂĂ邱ƂڎwĂ܂B̂߂ɃASY2g
Ă܂B

* ASY 1

    INebg̕т當oƂA1INebgR[h2INebgR[h
    ̋ʂ͑1INebgR[ĥ݂ōs܂B2INebg͍l܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x00-0xFF (ׂ)

    s1INebgR[h:
      0x81-0x9F, 0xE0-0xFC
      * ̍ŏIINebg2INebgR[h̑1INebgƓꍇ

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

                                 2INebgR[h\
            1INebg                                    2INebg


   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


̍ŏIINebg2INebgR[h̑1INebgƓꍇ

słĂꂽAIɍ폜邱Ƃ͂܂B
Ⴆ΁AEsjis::chop ͂̃INebgԂ܂B

    *s* 1INebgR[h

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |M|M|M|M|M|M|M|M|M|M|M|M|M|M|M| 0x81-0x9F
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|M|M|M|M|M|M|M|M|M|M|M|M|M| | | |  0xE0-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 x_ SJIS R[hꗗ

http://home.m05.itscom.net/numa/cde/sjis-euc/sjis.html

 DEC PC                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 DEC WS                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu TrueType font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu FontCity font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi PC                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi WS                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 IBM                            0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC Windows (PC)               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC DOS (PC)                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 SONY NEWS-OS                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Sun Wabi                       0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Unisys PC                      0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 HP Japan Japanese HP-15        0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 AT&T Japan                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Mitsubishi Electric FONTRUNNER 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Concurrent Japan               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Informix ASCII INFORMIX V6 ALS 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC), (0xFD)(0xA1-0xFE)(0xA1-0xFE)
 Oracle Oracle7 (Release 7.1.3) 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x00-0xFF)
 Sybase SQL Server, Open Server 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 
 {񏈗(ISBN 4-89052-708-7)
 
 Hewlett-Packard HP-15          0x00-0x7F, 0xA1-0xDF, (0x80-0xA0, 0xE0-0xFE)(0x21-0x7E, 0x80-0xFF)


* ASY 2

    ASY 1 ɂւ炸Atr/// ɂ蕶͈̔͂w肳ꂽꍇ͈ȉ̕
    ݂̂LƂȂ܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x40-0x7E, 0x80-0xFC

Ⴆ΁A[\x81\x00-\x82\xFF] Əꂽꍇ [\x81\x82][\x40-\x7E\x80-\xFC] 
Ӗ܂B

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


                                 2INebgR[h\
            1INebg                                    2INebg

   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x40-0x7E
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x80-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 ڕWƂĂ

vO~O Perl 3 VOLUME 1 (ISBN 4-87311-096-3)
15 Unicode Q

Unicode T|[g perl ɓȑÓAeq Zq́A2̃XJ[ϐɂ
ĕ\ꂽoCgׂĂ܂Bperl5.8 ȍ~Aeq ́A2̃oCgׂ
Ɠ UTF8 tOl܂B

  perl5.8 ȍ~̏񏈗f
 
    +----------------------+---------------------+
    |     Text strings     |                     |
    +----------+-----------|    Binary strings   |
    |   UTF8   |  Latin-1  |                     |
    +----------+-----------+---------------------+
    | UTF8     |            Not UTF8             |
    | Flagged  |            Flagged              |
    +--------------------------------------------+
    http://perl-users.jp/articles/advent-calendar/2010/casual/4
 
    ̐}oȂƃvO܂B
 
    (ǂ Latin-1 ʈ̂ł傤H)

ʓIɂ̕ύX́Aߋ̃XNvgƐVXNvg̊Ԃɑ傫ȍa܂B
͂◼҂̃XNvg̓R[h݂ɍėp邱Ƃł܂B܂V@
vO}ɕS邽߁AXNvgׂĒû͂܂܂
Ǝv܂B

V@ŖƂȂĂ邱Ƃ UTF8 tO͎ۂ̕̕ƈvȂ
łBōXNvg͂̃fobȎO UTF8 tOɂăfobOȂ
΂Ȃ܂B

  ̃\tgEFAɂ񏈗f
 
    +--------------------------------------------+
    |       Text strings as Binary strings       |
    |       Binary strings as Text strings       |
    +--------------------------------------------+
    |              Not UTF8 Flagged              |
    +--------------------------------------------+

ŁÂ̕@ɖ߂ƂɂĂǂ̂悤ɉ̂Aقɂ܂݂ꂽÂ
Programming Perl, 3rd ed. (M vO~OPerl 3) 402y[Wx
ЂƂĂ݂܂傤EEEB

zIɂ́Aȉ5̃S[悤ƍlĂ܂B

=over 2

=item * S[1

    ̃oCgw̃XNvǵAȑOẴoCgw̃f[^ɑ΂
    āAȑOƓlɓ삷ׂłB

     ShiftJIS oCgwł ASCII  JIS X 0201 Ƒg킹ėp
    ł悤݌vꂽƂɂāAłɒBĂ܂B

=item * S[2

    ̃oCgw̃XNvǵAɁA(邱ƂK؂ł)
    Vw̃f[^ɑ΂Ă삷悤ɂȂׂłB

    g݊֐ length, substr, index, rindex, pos Ȃǂ̒̕ʒu
    ͍̂܂łǂ1INebg 1 Ɛ܂B̕ɂĉ͉
    ܂B2INebgR[h1 length  2 ɂȂ܂B

    AXNvg̐K\́A}`oCĝ߂̃AJ[O
    LqKv܂AȂɑẴ\tgEFAs܂B

    S[1ƃS[2̓e}܂B

                                   GOAL#1  GOAL#2
                            (a)     (b)     (c)     (d)     (e)
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    f[^AXNvgAC^v^̐VEɊւāA (a)  (e) ܂ł
    g܂B̕ꂽɑ݂Ȃ Encode W[
    ̃\tgEFAAё݂Ă JPerl Ă݂܂傤B

                            (a)     (b)     (c)     (d)     (e)
                                          JPerl           Encode,Sjis
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    JPerl ƂĂDĂ闝R (c) ̈ʒuɂ邩łBȂ킿{ꏈ
    s߂ɃXNvgɓʂȋLqsKv܂B

    ΏƓIȂ̂ Encode W[₱̃\tgEFAɂ "use Sjis;" Lq
    ꍇłB̏ꍇ͐VȃXNvg̏Kv܂B

=item * S[3

    XNvǵAVw[hłAȑÕoCgw[hƓXs[
    hœ삷ׂłB

    ͖BāAȉ̎ԂKv́B

    (1) XNvgGXP[vāAoCgw Perl ň悤ɏ邽߂
     ԁBAꂽXNvg͕ۑł邽߁A񂩂͂̎ԂȂ
     Ƃ\łB

    (2) GXP[vꂽXNvg}`oCgAJ[OsȂA
     K\s鎞ԁB

    łɑ݂ ASCII f[^11INebgɃpbNĂ܂B
    f[^ƌ݊ۂȂ當𑝂₻ƂƁAISO-2022 ̂悤ɃGXP[
    vV[PXKvłAShiftJIS  UTF-8 ̂悤 "GXP[vrbg"
    KvɂȂ肵܂B̃GXP[v邽߁AȑOƓXs[
    hœ삷ׂłƂ͖̂ȖڕWƎv܂B

=item * S[4

    Perl ́AoCgw Perl ƕw Perl Ɏ}ꂹɁA1̌
    葱ׂłB

    JPerl  Perl 𕪊򂳂Ȃ悤ɂ邽߂ɁAC^v^𕪊򂳂܂B
    ł Perl RA`[̓C^v^̕]łȂ̂ł傤BʓIɃS[
    4Ƃ͂͂Perlꂪ򂷂邱ƂɂȂAR~jeB͏k܂B

    oCgw perl ͂łɃoCif[^Ƃł邽߁Aw
    perl ʗĂō쐬Kv͂܂B܂̃\tgEFÁAPȂAv
    P[VvOȂ̂ŁAPerl RA`[ɂ܂邱ƂȂł傤A
    USz܂B

    ɖ Perl XNvgŉ悤ƂȂAPerl R~jeB̃T|[g
    𓾂ł傤B

=item * S[5

    JPerl [U Perl  JPerl ێł悤ɂȂB

    JPerl Ȃ̂΂ɂ܂悤 ...

=back

Programming Perl, 3rd ed. ꂽɂ́AUTF8 tO͐܂Ă炸APerl 
ȒPȎdȒPɂł悤ɐ݌vĂ܂B̃\tgEFÂ͓悤
vO~O񋟂܂B

=head1 QlAN

 vO~OPerl 
 By Larry Wall, Tom Christiansen, Randal L. Schwartz, ߓ Ð 
 1997N12 s
 759y[W
 ISBN 4-900900-48-6
 http://www.oreilly.co.jp/out/pperl/index.htm

 vO~OPerl 3 VOLUME 1
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 756y[W
 ISBN 4-87311-096-3
 http://www.oreilly.co.jp/books/4873110963/

 vO~OPerl 3 VOLUME 2
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 680y[W
 ISBN 4-87311-097-1
 http://www.oreilly.co.jp/books/4873110971/

 The Perl Language Reference Manual (for Perl version 5.12.1)
 by Larry Wall and others
 Paperback (6"x9"), 724 pages
 Retail Price: $39.95 (pound 29.95 in UK)
 ISBN-13: 978-1-906966-02-7
 http://www.network-theory.co.uk/perl/language/

 Perl Pocket Reference, 5th Edition
 By Johan Vromans
 Publisher: O'Reilly Media
 Released: July 2011
 Pages: 102
 http://shop.oreilly.com/product/0636920018476.do

 Programming Perl, 4th Edition
 By: Tom Christiansen, brian d foy, Larry Wall, Jon Orwant
 Publisher: O'Reilly Media
 Formats: Print, Ebook, Safari Books Online
 Released: March 2012
 Pages: 1130
 Print ISBN: 978-0-596-00492-7 | ISBN 10: 0-596-00492-3
 Ebook ISBN: 978-1-4493-9890-3 | ISBN 10: 1-4493-9890-1
 http://shop.oreilly.com/product/9780596004927.do

 PerlNbNubN 2 VOLUME 1
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 752y[W
 ISBN 4-87311-202-8
 http://www.oreilly.co.jp/books/4873112028/

 PerlNbNubN 2 VOLUME 2
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 464y[W
 ISBN 4-87311-203-6
 http://www.oreilly.co.jp/books/4873112036/

 PerlNCbNt@X
 By Stephen Spainhour, Ellen Siever, Nathan Patwardhan, ߓ Ð,  \ Ė
 2000N03 s
 784y[W
 ISBN 4-900900-72-9
 http://www.oreilly.co.jp/books/4900900729/

 ߂ĂPerl Win32VXe
 Randal L. Schwartz, Erik Olson, Tom Christiansen , Ln OY Ė, Ό q_ 
 1998N11 s
 348y[W
 ISBN 4-900900-79-6
 http://www.oreilly.co.jp/books/4900900796/

 ߂ĂPerl 5
 Randal L. Schwartz, Tom Phoenix, brian d foy 
 2009N1024 
 424y[W
 ISBN978-4-87311-427-9
 http://www.oreilly.co.jp/books/9784873114279/

 Perl\[XLbg - UNIX
 Futato, Irving, Jepson, Patwardhan, Siever , CG[[x R{ _ 
 ISBN4-900900-65-6
 http://www.oreilly.co.jp/out/presuni/

 {񏈗
 Understanding Japanese Information Processing
 By Ken Lunde, t ,   
 1995N8 s
 496y[W
 ISBN 4-89052-708-7
 http://www.fukkan.com/vote.php3?no=4293

 CJKV؉z񏈗
 Chinese, Japanese, Korean & Vietnamese Computing
 By Ken Lunde,  , t  
 2002N12 s
 1172y[W
 ISBN 4-87311-108-0
 http://www.oreilly.co.jp/books/4873111080/

 ڐ K\ 2
 By Jeffrey E. F. Friedl, ca  
 2003N05 s
 464y[W
 ISBN 4-87311-130-7
 http://www.oreilly.co.jp/books/4873111307/

 ڐ K\ 3
 By Jeffrey E. F. Friedl, ЃOe[^ O 
 2008N04 s
 528y[W
 ISBN 978-4-87311-359-3
 http://www.oreilly.co.jp/books/9784873113593/

 K\NbNubN
 Jan Goyvaerts, Steven Levithan ,  O 
 2010N04 s
 552y[W
 ISBN978-4-87311-450-7
 http://www.oreilly.co.jp/books/9784873114507/

 PerlvO~O
 Larry Wall, Randal L.Schwartz, ߓ Ð 
 1993N2s
 ISBN 4-89052-384-7
 http://www.context.co.jp/~cond/books/old-books.html

 JIST
 Ŗ ki Ғ
 1456 
 ISBN 4-542-20129-5
 http://www.webstore.jsa.or.jp/lib/lib.asp?fn=/manual/mnl01_12.htm

 UNIX MAGAZINE
 1993N8
 172y[W
 T1008901080816 G08901-8
 http://ascii.asciimw.jp/books/books/detail/978-4-7561-5008-0.shtml

 MacPerl
 Vicki Brown, Chris Nandor , ()RXEvlbg 
 1999N03 s
 399y[W
 ISBN 4-7561-3068-2

 Macintoshf[^pp
 Γc L 
 230y[W
 1995N2 s
 ISBN 4-89563-408-6

 MPWvO~Ou
 Handmade Intelligence 
 1992N8 s
 346y[W
 ISBN 4-7561-0963-2

 J E, ۉK\CuȂ
 http://lc.linux.or.jp/lc2001/papers/dfa-i18n-paper.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918h.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918p.pdf
 http://www.j-tokkyo.com/2003/G06F/JP2003-242179.shtml

 Oc א, }`oCgZbgpK\RpC\@yуvO 
 http://patent.astamuse.com/ja/published/JP/No/2007102744

 YAMAGAKI Norio, }`oCgƍpLI[g}gVXe
 http://www.wipo.int/pctdb/ja/wo.jsp?WO=2009116646&IA=JP2009055515

 Tokyo-pm ۑ
 http://mail.pm.org/pipermail/tokyo-pm/
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001844.html
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

 ruby-list
 http://blade.nagaokaut.ac.jp/ruby/ruby-list/index.shtml
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2440
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2446
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2569
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9427
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9431
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10500
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10501
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10502
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12385
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12392
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12393
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/19156

 ֘A\tgEFA
 http://search.cpan.org/dist/jacode/
 http://search.cpan.org/dist/Char/

 BackPAN
 http://backpan.perl.org/authors/id/I/IN/INA/

=head1 ӎ

cOȂAӂ邷ׂĂ̐lɏƂł܂BƂāA
𗝗RɂĈȉ̕Xւ̊ӂ͏ȗ킯ɂ͂Ȃł傤B

 R Ǒ, VtgJIS̃fUC̘b
 ttp://furukawablog.spaces.live.com/Blog/cns!1pmWgsL289nm7Shn7cS0jHzA!2225.entry (N؂)
 ttp://shino.tumblr.com/post/116166805/1981-us-jis
 (擪 'h' tăANZXĂ)
 http://www.wdic.org/w/WDIC/%E3%82%B7%E3%83%95%E3%83%88JIS
 
 {񏈗sہA܂ăVtgJISقǎpIȕ͂܂B
 ő̗_͂锼pJ^JiƋł邱ƂłBߋ̎Y݂Ɍpł
 ƂƂ́A݂̎Y𖢗֌pł邱ƂĂ܂B
 
 1981N̎_ŁA܂ōlĂR̓nbJ[ƌĂԂɂӂ킵ł傤B

 Larry Wall , Perl
 http://www.perl.org/
 
 Perl K\ɂăoCif[^邱ƂŁÃ\tgEFAĂ
 ܂Bo[WԂ̌݊̍ɂ܂BK\̃^eNH[
 g̃f~^́AׂΏۂłŁAۂ̎iƂĂ𗧂܂B
  Perl Ȃ΁A݂A܂тȂދȐl
 ƂłB
 
  Larry Wall ɂ͂ƂĂӂĂ܂I

 ̑ a, jcode.pl
 ftp://ftp.iij.ad.jp/pub/IIJ/dist/utashiro/perl/
 http://log.utashiro.com/pub/2006/07/jkondo_a580.html
 
 ŏ Perl ɏô͉̑コ̏ꂽ UNIX MAGAZINE ̋LłBt@C
 eXgZq -TA-B ̋@\R[h͋Lɏꂽ̂قڂ̂܂܎g
 ܂B܂{񏈗Mꂽ Ken Lunde ̐搶ł邵AJeffrey
 E. F. Friedl ̏ڐK\̊ĖĂāÃ\tgEFA̎͂ɂ͕K
 ̑コ񂪓oꂵ܂B
 
 Tokyo.pm ̃[OXgł́AV@\邽߂ɐVɎꍇłA
 ߋɍꂽ\tgEFAƓ̃C^tF[XɂƂA悢ACfBA
 ܂B
 
 قǎ͂ƌ܂A͓͂R̂ƂŁÃ\tgEFA jcode.pl 
 \[XƂɂč쐬ꂽłB牽ǂlĂ̑コȂŁÃ\
 tgEFA܂邱Ƃ͂Ȃ̂łB

 Jeffrey E. F. Friedl , ڐK\
 http://regex.info/
 
 ڐK\(2)͂߂ēǂ񂾂ƂAĂ̂SłAĂ
 pł𔃂Ă܂̂ł͂ȂƋ^قǂłBȂ P.340 Matching
 Nested Constructs with Embedded Code KvƂĂR[hƋCÂƂ
 ƂĂ̂oĂ܂(悭płł)B
 
 Ȃ킯ŃlXgʂł̂́A}(Fumie)̂łB
 (̊ӂ`܂悤...B)

 Ken Lunde , {񏈗ACJKV؉z񏈗
 http://www.fukkan.com/vote.php3?no=4293
 http://www.oreilly.co.jp/books/4873111080/
 
 u{񏈗vǂŕWKiƕwсAɂė[
 ܂܂B̌̂ЂƂƂāup҂̈ӎvƈقȂA̕ϊv
 ܂Bh߂ɁÃ\tgEFA͕ϊɏ񏈗
 s܂B
 
 Appendix W: Perl Code Examples ̒ CJKV Encoding TemplatesAMultiple-Byte
 AnchoringAMultiple-Byte Processing ƂĂQlɂȂ܂B

 A ms, Shift-JISeLXg𐳂
 http://homepage1.nifty.com/nomenclator/perl/shiftjis.htm
 
 uShift-JISeLXg𐳂vŁAPerlŃVtgJISƂ̃mEnE
 A肪Ƃ܂B̃TCg̓eƂɁAXNvg̃e
 ́u\vu\\vɕϊtB^vOƂ납n߁AO
 ĂƂł̃\tgEFAĂ܂B

 ܂ 䂫Ђ낳, Ruby on Perl(s)
 http://www.rubyist.net/~matz/slides/yapc2006/
 
 YAPC::Asia 2006 Tokyo "Ruby on Perl(s)" ŁuCSI͕s\ȂvƂ𕪂₷
 Ă炢܂Bx Ruby ł܂̂ł낵肢܂B

  av, jperl[U[̂߂
 http://homepage1.nifty.com/kazuf/jperl.html
 
 ver.0.71 쐬ہAڗpłȂł̃eXĝ߂60̃[
 AJɃfobOɕtĒ܂B肪Ƃ܂B

 Bruce. , Unicode in Perl
 http://www.rakunet.org/tsnet/TSabc/18/546.html

 a G, WindowsPerl 5.8/5.10gȂ
 http://www.aritia.jp/hizumi/perl/perlwin.html

 ˖{ q, Perl/Windowsł̃t@CpX
 http://digit.que.ne.jp/work/wiki.cgi?Perl%E3%83%A1%E3%83%A2%2FWindows%E3%81%A7%E3%81%AE%E3%83%95%E3%82%A1%E3%82%A4%E3%83%AB%E3%83%91%E3%82%B9

 chaichanPaPa, VtgJIS̃t@CɃ}b`Ă݂
 http://d.hatena.ne.jp/chaichanPaPa/20080802/1217660826

  Iv, Jperl
 http://homepage2.nifty.com/kipp/perl/jperl/

 n , Jperl
 http://www.cpan.org/src/5.0/jperl/
 http://search.cpan.org/~watanabe/
 ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt
 
 The Perl Confernce Japan (1998)JperlJ̌o܂𕷂Ă炢܂BJPerl 
 ́A{Ήł Perl ͂ǂ̂悤Ȃ̂g₷̂܂Btr///b 
 ord  reverse ݂ JPerl ̓^܂(ŃeXgvO܂
 炤Ƃł܂)B
 
 nӂ̂ƂƓN񂶂Ȃ()҂Ă킯łA
 ҂ĂԂ Perl Ńvg^CvĂ܂B҂̂͊yƂłB

 Chuck Houpt ,  qq, MacJPerl
 http://habilis.net/macjperl/index.j.html

 Ί_ ꂳ, Pod-PerldocJp, _Perl̐Eւ悤
 http://search.cpan.org/dist/Pod-PerldocJp/
 http://gihyo.jp/dev/serial/01/modern-perl/0031
 http://gihyo.jp/dev/serial/01/modern-perl/0032
 http://gihyo.jp/dev/serial/01/modern-perl/0033
 
 u_Perl̐Eւ悤v̘AڂƂĂQlɂȂ܂Bɑ31񂩂33
 JPerl Ɋ֘AeŁAZpIɂjIɂƂĂkȋLłB
 
 ̃\tgEFA_Perlւ̉˂ƂĖ𗧂Ă΍KłB

  e, Encode W[
 http://search.cpan.org/dist/Encode/
 http://www.archive.org/details/YAPCAsia2006TokyoPerl58andUnicodeMythsFactsandChanges ()
 http://yapc.g.hatena.ne.jp/jkondo/ ()
 
 YAPC::Asia 2006 Tokyo "Perl5.8 and Unicode: Myths, Facts and Changes"  Perl5.8
 ł̕ύX_ڂĂ炢܂BCPAN  face icon ͂̃XChɏoĂ
 Perl5.6 = a city without bridges ̉摜qg𓾂Ă܂B

 Juerd , Perl Unicode Advice
 http://juerd.nl/site.plp/perluniadvice

 daily dayflower , 2008-06-25 perluniadvice
 http://d.hatena.ne.jp/dayflower/20080625/1214374293

 Jesse Vincent , Compatibility is a virtue
 http://www.nntp.perl.org/group/perl.perl5.porters/2010/05/msg159825.html

=cut

