# $Id: /mirror/perl/Swarmage/trunk/lib/Swarmage/Task.pm 9170 2007-11-14T14:35:16.376408Z daisuke  $
#
# Copyright (c) 2007 Daisuke Maki <daisuke@endeworks.jp>
# All rights reserved.

package Swarmage::Task;
use strict;
use warnings;
use Swarmage::Message;
our @ISA = qw(Swarmage::Message);

__PACKAGE__->mk_group_accessors(simple => qw(task_class));

sub new
{
    my $class = shift;
    my %args = @_;
    my $self = $class->next::method(
        @_,
        type => 'task'
    );

    if (! $self->destination && $self->task_class) {
        $self->destination("task/" . $self->task_class);
    }
    
    return $self;
}

1;

__END__

=head1 NAME

Swarmage::Task

=head1 METHODS

=head2 new

=head2 type

=head2 data

=head2 destination

=head2 postback

=head2 persistent

=head2 task_class

=head2 source

=head2 attr

=cut
