use strict;
use warnings;

BEGIN { $ENV{PERL_RL} = 'Stub'; }

use Test::More;

use Term::ReadLine 1.09;
use Term::ReadLine::Event;

plan skip_all => "Tk is not installed" unless eval "
    use Tk;
    1";
plan tests => 2;

my $term = Term::ReadLine::Event->with_Tk('test');
isa_ok($term->trl, 'Term::ReadLine::Stub');

our $mw = MainWindow->new(-title => '');
$mw->withdraw();

my $w = sub {
    pass;
    print {$term->trl()->OUT()} $Term::ReadLine::Stub::rl_term_set[3];
    exit 0;
};
Tk::after($mw, 1000, $w);

$term->readline('> Do not type anything');
fail();
