
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.4007"
  },
  "configure_requires" => {
    "Module::Build" => "0.4007"
  },
  "dist_abstract" => "An evolution of POD",
  "dist_author" => [
    "Kent Fredric <kentfredric\@gmail.com>"
  ],
  "dist_name" => "MetaPOD",
  "dist_version" => "0.2.3",
  "license" => "perl",
  "module_name" => "MetaPOD",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Carp" => 0,
    "Data::Dump" => 0,
    "JSON" => 0,
    "List::AllUtils" => 0,
    "Module::Runtime" => 0,
    "Moo" => "1.000008",
    "Moo::Role" => 0,
    "Pod::Eventual" => 0,
    "Throwable::Error" => 0,
    "Try::Tiny" => 0,
    "perl" => "v5.10.0",
    "strict" => 0,
    "version" => "0.77",
    "warnings" => 0
  },
  "script_files" => [],
  "test_requires" => {
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Path::Iterator::Rule" => 0,
    "Path::Tiny" => 0,
    "Test::Fatal" => 0,
    "Test::More" => "0.98"
  }
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
