package BankAccount::Validator::UK::Rule;

use strict; use warnings;

=head1 NAME

BankAccount::Validator::UK::Rule - Rules for validating UK bank account.

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 DESCRIPTION

=head1 METHODS

=head2 get_sort_code()

Used by the module BankAccount::Validator::UK  internally & returns the substituting sort code
if found, as provided by VOCALINK in the document dated 13th June'2005. The document is called
SCSUBTAB.txt.

=cut

sub get_sort_code
{
    return {
        938173 => 938017,
        938289 => 938068,
        938297 => 938076,
        938600 => 938611,
        938602 => 938343,
        938604 => 938603,
        938608 => 938408,
        938609 => 938424,
        938613 => 938017,
        938616 => 938068,
        938618 => 938657,
        938620 => 938343,
        938622 => 938130,
        938628 => 938181,
        938643 => 938246,
        938647 => 938611,
        938648 => 938246,
        938649 => 938394,
        938651 => 938335,
        938653 => 938424,
        938654 => 938621,
    }
};

=head2 get_rules()

Used by the module BankAccount::Validator::UK  internally & returns every possible rules cover
by the document, as provided by VOCALINK dated 23rd April'2012 and is called VALACDOS.txt.

=cut

sub get_rules
{
    return [
        {
            start => '010004', end => '016715', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '050000', end => '050020', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 1, c => 7, d => 5, e => 8, f => 2, g => 4, h => 1,
        },
        {
            start => '050022', end => '058999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 1, c => 7, d => 5, e => 8, f => 2, g => 4, h => 1,
        },
        {
            start => '070116', end => '070116', mod => 'MOD11',
            ex => 12, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '070116', end => '070116', mod => 'MOD10',
            ex => 13, u => 0, v => 3, w => 2, x => 4, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '070246', end => '070246', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '070436', end => '070436', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '070806', end => '070806', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '070976', end => '070976', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '071096', end => '071096', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '071226', end => '071226', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '071306', end => '071306', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '071986', end => '071986', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '074456', end => '074456', mod => 'MOD11',
            ex => 12, u => 0, v => 0, w => 7, x => 6, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '074456', end => '074456', mod => 'MOD10',
            ex => 13, u => 0, v => 3, w => 2, x => 4, y => 5, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '080211', end => '080211', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '080228', end => '080228', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '086001', end => '086001', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '086020', end => '086020', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '086086', end => '086086', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 8, a => 9, b => 4, c => 5, d => 6, e => 7, f => 8, g => 9, h => -1,
        },
        {
            start => '086090', end => '086090', mod => 'MOD10',
            ex => 8, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '089000', end => '089999', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090013', end => '090013', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090118', end => '090118', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '090126', end => '090128', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090131', end => '090136', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '090150', end => '090156', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '090204', end => '090204', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090222', end => '090222', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090356', end => '090356', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '090500', end => '090599', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090710', end => '090710', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '090720', end => '090726', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '090736', end => '090739', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 3, x => 7, y => 1, z => 3, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '100000', end => '101099', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '101101', end => '101498', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '101500', end => '101999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '102400', end => '107999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '108000', end => '108079', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '108080', end => '108099', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '108100', end => '109999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '110000', end => '119280', mod => 'DBLAL',
            ex => 1, u => 0, v => 0, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '119282', end => '119283', mod => 'DBLAL',
            ex => 1, u => 0, v => 0, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '119285', end => '119999', mod => 'DBLAL',
            ex => 1, u => 0, v => 0, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '120000', end => '120961', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '120963', end => '122009', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '122011', end => '122101', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '122103', end => '122129', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '122131', end => '122135', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '122213', end => '122299', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '122400', end => '122999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '124000', end => '124999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '133000', end => '133999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 10, a => 7, b => 8, c => 4, d => 6, e => 3, f => 5, g => 2, h => 1,
        },
        {
            start => '134012', end => '134020', mod => 'MOD11',
            ex => 4, u => 0, v => 0, w => 0, x => 7, y => 5, z => 9, a => 8, b => 4, c => 6, d => 3, e => 5, f => 2, g => 0, h => 0,
        },
        {
            start => '134121', end => '134121', mod => 'MOD11',
            ex => 4, u => 0, v => 0, w => 0, x => 1, y => 0, z => 0, a => 8, b => 4, c => 6, d => 3, e => 5, f => 2, g => 0, h => 0,
        },
        {
            start => '150000', end => '158000', mod => 'MOD11',
            ex => 0, u => 4, v => 3, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '159800', end => '159800', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '159900', end => '159900', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '159910', end => '159910', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '160000', end => '161027', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161029', end => '161029', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161030', end => '161041', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161050', end => '161050', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161055', end => '161055', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161060', end => '161060', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161065', end => '161065', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161070', end => '161070', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161075', end => '161075', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161080', end => '161080', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161085', end => '161085', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161090', end => '161090', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '161100', end => '162028', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '162030', end => '164300', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '165901', end => '166001', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '166050', end => '167600', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 6, x => 5, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '168600', end => '168600', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180002', end => '180002', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180005', end => '180005', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180009', end => '180009', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180036', end => '180036', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180038', end => '180038', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180091', end => '180092', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180104', end => '180104', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180109', end => '180110', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '180156', end => '180156', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '185001', end => '185001', mod => 'MOD11',
            ex => 14, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '185003', end => '185025', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '185027', end => '185099', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200000', end => '200002', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200000', end => '200002', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200004', end => '200004', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200004', end => '200004', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200051', end => '200077', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200051', end => '200077', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200079', end => '200097', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200079', end => '200097', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200099', end => '200156', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200099', end => '200156', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200158', end => '200387', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200158', end => '200387', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200403', end => '200405', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200403', end => '200405', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200407', end => '200407', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200407', end => '200407', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200411', end => '200412', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200411', end => '200412', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200414', end => '200423', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200414', end => '200423', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200425', end => '200899', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200425', end => '200899', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '200901', end => '201159', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '200901', end => '201159', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '201161', end => '201177', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '201161', end => '201177', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '201179', end => '201351', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '201179', end => '201351', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '201353', end => '202698', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '201353', end => '202698', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '202700', end => '203239', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '202700', end => '203239', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '203241', end => '203255', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '203241', end => '203255', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '203259', end => '203519', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '203259', end => '203519', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '203521', end => '204476', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '203521', end => '204476', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '204478', end => '205475', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '204478', end => '205475', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '205477', end => '205954', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '205477', end => '205954', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '205956', end => '206124', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '205956', end => '206124', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '206126', end => '206157', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '206126', end => '206157', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '206159', end => '206390', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '206159', end => '206390', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '206392', end => '206799', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '206392', end => '206799', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '206802', end => '206874', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '206802', end => '206874', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '206876', end => '207170', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '206876', end => '207170', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '207173', end => '208092', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '207173', end => '208092', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '208094', end => '208721', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '208094', end => '208721', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '208723', end => '209034', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '208723', end => '209034', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '209036', end => '209128', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '209036', end => '209128', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '209130', end => '209999', mod => 'MOD11',
            ex => 6, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '209130', end => '209999', mod => 'DBLAL',
            ex => 6, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '230338', end => '230338', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '230338', end => '230338', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '230614', end => '230614', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '230614', end => '230614', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '230709', end => '230709', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '230709', end => '230709', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '230872', end => '230872', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '230872', end => '230872', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '230933', end => '230933', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '230933', end => '230933', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231018', end => '231018', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231018', end => '231018', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231213', end => '231213', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231213', end => '231213', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231354', end => '231354', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231354', end => '231354', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231469', end => '231469', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231469', end => '231469', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231558', end => '231558', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231558', end => '231558', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231679', end => '231679', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231679', end => '231679', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231843', end => '231843', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231843', end => '231843', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '231985', end => '231985', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '231985', end => '231985', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232130', end => '232130', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232130', end => '232130', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232279', end => '232279', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232279', end => '232279', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232445', end => '232445', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232445', end => '232445', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232571', end => '232571', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232571', end => '232571', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232636', end => '232636', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232636', end => '232636', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232725', end => '232725', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232725', end => '232725', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232813', end => '232813', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232813', end => '232813', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '232939', end => '232939', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '232939', end => '232939', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233080', end => '233080', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233080', end => '233080', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233171', end => '233171', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233171', end => '233171', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233188', end => '233188', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233188', end => '233188', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233231', end => '233231', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233231', end => '233231', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233344', end => '233344', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233344', end => '233344', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233438', end => '233438', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233438', end => '233438', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233483', end => '233483', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233556', end => '233556', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233556', end => '233556', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233693', end => '233693', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233693', end => '233693', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '233752', end => '233752', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '233752', end => '233752', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234081', end => '234081', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234081', end => '234081', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234193', end => '234193', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234193', end => '234193', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234252', end => '234252', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234252', end => '234252', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234377', end => '234377', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234377', end => '234377', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234570', end => '234570', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234570', end => '234570', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234666', end => '234666', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234666', end => '234666', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234779', end => '234779', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234779', end => '234779', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234828', end => '234828', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234828', end => '234828', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '234985', end => '234985', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '234985', end => '234985', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235054', end => '235054', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235054', end => '235054', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235164', end => '235164', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235164', end => '235164', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235262', end => '235262', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235262', end => '235262', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235323', end => '235323', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235323', end => '235323', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235451', end => '235451', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235459', end => '235459', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235459', end => '235459', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235519', end => '235519', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235519', end => '235519', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235676', end => '235676', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235676', end => '235676', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235756', end => '235756', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235756', end => '235756', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '235945', end => '235945', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '235945', end => '235945', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236006', end => '236006', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236006', end => '236006', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236119', end => '236119', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236119', end => '236119', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236233', end => '236233', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236233', end => '236233', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236422', end => '236422', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236422', end => '236422', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236527', end => '236527', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236527', end => '236527', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236643', end => '236643', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236643', end => '236643', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236761', end => '236761', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236761', end => '236761', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '236907', end => '236907', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '236907', end => '236907', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237130', end => '237130', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237130', end => '237130', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237265', end => '237265', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237265', end => '237265', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237355', end => '237355', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237355', end => '237355', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237427', end => '237427', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237427', end => '237427', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237563', end => '237563', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237563', end => '237563', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237622', end => '237622', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237622', end => '237622', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237726', end => '237726', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237728', end => '237728', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237728', end => '237728', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '237873', end => '237873', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '237873', end => '237873', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238043', end => '238043', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238043', end => '238043', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238051', end => '238051', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238051', end => '238051', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238175', end => '238175', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238175', end => '238175', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238257', end => '238257', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238257', end => '238257', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238392', end => '238431', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '238392', end => '238431', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238432', end => '238432', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238432', end => '238432', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238433', end => '238583', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '238433', end => '238583', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238585', end => '238590', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '238585', end => '238590', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238599', end => '238599', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238599', end => '238599', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238613', end => '238613', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238613', end => '238613', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238672', end => '238672', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238672', end => '238672', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238717', end => '238717', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238717', end => '238717', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '238890', end => '238899', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 4, z => 3, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238908', end => '238908', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '238908', end => '238908', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239071', end => '239071', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239071', end => '239071', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239126', end => '239126', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239126', end => '239126', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239136', end => '239140', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '239136', end => '239140', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239143', end => '239144', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '239143', end => '239144', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239282', end => '239283', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '239282', end => '239283', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239285', end => '239294', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '239285', end => '239294', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239295', end => '239295', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239295', end => '239295', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239296', end => '239318', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '239296', end => '239318', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239380', end => '239380', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239380', end => '239380', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239435', end => '239435', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239435', end => '239435', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239525', end => '239525', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239525', end => '239525', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239642', end => '239642', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239642', end => '239642', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '239751', end => '239751', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '239751', end => '239751', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '300000', end => '300006', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '300000', end => '300006', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '300008', end => '300009', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '300008', end => '300009', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '300050', end => '300051', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '300134', end => '300138', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '300134', end => '300138', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301001', end => '301001', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301001', end => '301001', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301004', end => '301004', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301004', end => '301004', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301007', end => '301007', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301007', end => '301007', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301012', end => '301012', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301012', end => '301012', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301022', end => '301022', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301027', end => '301027', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301047', end => '301047', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301047', end => '301047', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301049', end => '301049', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301049', end => '301049', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301052', end => '301052', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301052', end => '301052', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301075', end => '301076', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301075', end => '301076', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301108', end => '301108', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301108', end => '301108', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301112', end => '301112', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301112', end => '301112', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301127', end => '301127', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301127', end => '301127', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301137', end => '301137', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301142', end => '301142', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301148', end => '301148', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301148', end => '301148', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301154', end => '301155', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301161', end => '301161', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301161', end => '301161', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301166', end => '301166', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301170', end => '301170', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301174', end => '301175', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301174', end => '301175', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301191', end => '301191', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301191', end => '301191', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301194', end => '301195', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301194', end => '301195', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301204', end => '301205', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301204', end => '301205', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301209', end => '301210', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301209', end => '301210', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301215', end => '301215', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301215', end => '301215', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301218', end => '301218', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301218', end => '301218', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301220', end => '301221', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301220', end => '301221', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301234', end => '301234', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301234', end => '301234', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301251', end => '301251', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301251', end => '301251', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301259', end => '301259', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301259', end => '301259', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301274', end => '301274', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301274', end => '301274', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301280', end => '301280', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301280', end => '301280', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301286', end => '301286', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301286', end => '301286', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301295', end => '301296', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301295', end => '301296', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301299', end => '301299', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301299', end => '301299', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301301', end => '301301', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301301', end => '301301', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301305', end => '301305', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301305', end => '301305', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301318', end => '301318', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301318', end => '301318', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301330', end => '301330', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301330', end => '301330', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301332', end => '301332', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301332', end => '301332', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301335', end => '301335', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301335', end => '301335', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301342', end => '301342', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301342', end => '301342', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301350', end => '301355', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301350', end => '301355', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301364', end => '301364', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301364', end => '301364', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301368', end => '301368', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301368', end => '301368', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301376', end => '301376', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301376', end => '301376', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301380', end => '301380', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301380', end => '301380', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301388', end => '301388', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301388', end => '301388', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301390', end => '301390', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301390', end => '301390', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301395', end => '301395', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301395', end => '301395', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301400', end => '301400', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301400', end => '301400', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301424', end => '301424', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301424', end => '301424', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301432', end => '301432', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301432', end => '301432', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301433', end => '301433', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301435', end => '301435', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301437', end => '301437', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301437', end => '301437', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301439', end => '301439', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301440', end => '301440', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301440', end => '301440', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301443', end => '301443', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301444', end => '301444', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301444', end => '301444', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301447', end => '301447', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301447', end => '301447', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301451', end => '301451', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301451', end => '301451', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301456', end => '301456', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301456', end => '301456', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301458', end => '301458', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301460', end => '301460', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301460', end => '301460', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301463', end => '301463', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301464', end => '301464', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301464', end => '301464', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301466', end => '301466', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301469', end => '301469', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301469', end => '301469', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301471', end => '301471', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301471', end => '301471', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301474', end => '301474', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301477', end => '301477', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301477', end => '301477', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301482', end => '301482', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301483', end => '301483', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301483', end => '301483', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301485', end => '301485', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301487', end => '301487', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301504', end => '301504', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301504', end => '301504', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301510', end => '301510', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301514', end => '301514', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301517', end => '301517', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301525', end => '301525', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301539', end => '301539', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301539', end => '301539', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301542', end => '301542', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301542', end => '301542', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301552', end => '301553', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301552', end => '301553', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301557', end => '301557', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301557', end => '301557', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301573', end => '301573', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301593', end => '301593', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301593', end => '301593', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301595', end => '301595', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301595', end => '301595', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301597', end => '301597', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301597', end => '301597', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301599', end => '301599', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301599', end => '301599', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301607', end => '301607', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301609', end => '301609', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301609', end => '301609', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301611', end => '301611', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301611', end => '301611', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301620', end => '301620', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301620', end => '301620', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301628', end => '301628', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301628', end => '301628', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301634', end => '301634', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301634', end => '301634', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301641', end => '301642', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301641', end => '301642', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301653', end => '301653', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301653', end => '301653', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301657', end => '301657', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301662', end => '301662', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301662', end => '301662', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301664', end => '301664', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301664', end => '301664', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301670', end => '301670', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301670', end => '301670', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301674', end => '301674', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301674', end => '301674', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301684', end => '301684', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301684', end => '301684', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301695', end => '301696', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301695', end => '301696', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301700', end => '301702', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301700', end => '301702', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301705', end => '301705', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '301712', end => '301712', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301712', end => '301712', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301716', end => '301716', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301716', end => '301716', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301748', end => '301748', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301748', end => '301748', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301773', end => '301773', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301773', end => '301773', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301777', end => '301777', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301777', end => '301777', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301780', end => '301780', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301780', end => '301780', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301785', end => '301785', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301785', end => '301785', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301803', end => '301803', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301803', end => '301803', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301805', end => '301805', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301805', end => '301805', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301806', end => '301806', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301806', end => '301806', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301816', end => '301816', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301816', end => '301816', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301825', end => '301825', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301825', end => '301825', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301830', end => '301830', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301830', end => '301830', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301834', end => '301834', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301834', end => '301834', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301843', end => '301843', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301843', end => '301843', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301845', end => '301845', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301845', end => '301845', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301855', end => '301856', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301855', end => '301856', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301864', end => '301864', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301864', end => '301864', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301868', end => '301869', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301868', end => '301869', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301883', end => '301883', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301883', end => '301883', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301886', end => '301888', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301886', end => '301888', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301898', end => '301898', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301898', end => '301898', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301914', end => '301996', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '301914', end => '301996', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302500', end => '302500', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302500', end => '302500', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302556', end => '302556', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302556', end => '302556', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302579', end => '302580', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '302579', end => '302580', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '303460', end => '303461', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '303460', end => '303461', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305907', end => '305939', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305907', end => '305939', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305941', end => '305960', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305941', end => '305960', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305971', end => '305971', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305971', end => '305971', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305974', end => '305974', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305974', end => '305974', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305978', end => '305978', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305978', end => '305978', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305982', end => '305982', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305982', end => '305982', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305984', end => '305988', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305984', end => '305988', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305990', end => '305993', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '305990', end => '305993', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306017', end => '306018', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306017', end => '306018', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306020', end => '306020', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306020', end => '306020', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306028', end => '306028', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306028', end => '306028', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306038', end => '306038', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306038', end => '306038', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306150', end => '306151', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306150', end => '306151', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306154', end => '306155', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306154', end => '306155', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306228', end => '306228', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306228', end => '306228', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306229', end => '306229', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306229', end => '306229', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306232', end => '306232', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306232', end => '306232', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306242', end => '306242', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306242', end => '306242', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306245', end => '306245', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306245', end => '306245', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306249', end => '306249', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306249', end => '306249', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306255', end => '306255', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306255', end => '306255', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306259', end => '306263', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306259', end => '306263', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306272', end => '306279', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306272', end => '306279', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306281', end => '306281', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306281', end => '306281', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306289', end => '306289', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306289', end => '306289', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306296', end => '306296', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306296', end => '306296', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306299', end => '306299', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306299', end => '306299', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306300', end => '306300', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306300', end => '306300', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306347', end => '306347', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306347', end => '306347', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306354', end => '306355', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306354', end => '306355', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306357', end => '306357', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306357', end => '306357', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306359', end => '306359', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306359', end => '306359', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306364', end => '306364', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306364', end => '306364', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306394', end => '306394', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306394', end => '306394', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306397', end => '306397', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306397', end => '306397', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306410', end => '306410', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306410', end => '306410', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306412', end => '306412', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306412', end => '306412', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306414', end => '306415', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306414', end => '306415', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306418', end => '306419', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306418', end => '306419', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306422', end => '306422', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306422', end => '306422', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306434', end => '306434', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306434', end => '306434', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306437', end => '306438', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306437', end => '306438', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306442', end => '306444', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306442', end => '306444', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306457', end => '306457', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306457', end => '306457', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306472', end => '306472', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306472', end => '306472', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306479', end => '306479', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306479', end => '306479', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306497', end => '306497', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306497', end => '306497', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306521', end => '306522', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306521', end => '306522', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306537', end => '306539', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306537', end => '306539', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306541', end => '306541', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306541', end => '306541', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306549', end => '306549', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306549', end => '306549', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306562', end => '306565', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306562', end => '306565', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306572', end => '306572', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306572', end => '306572', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306585', end => '306586', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306585', end => '306586', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306592', end => '306593', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306592', end => '306593', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306675', end => '306677', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306675', end => '306677', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306689', end => '306689', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306689', end => '306689', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306695', end => '306696', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306695', end => '306696', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306733', end => '306735', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306733', end => '306735', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306747', end => '306749', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306747', end => '306749', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306753', end => '306753', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306753', end => '306753', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306756', end => '306756', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306756', end => '306756', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306759', end => '306759', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306759', end => '306759', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306762', end => '306762', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306762', end => '306762', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306764', end => '306764', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306764', end => '306764', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306766', end => '306767', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306766', end => '306767', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306769', end => '306769', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306769', end => '306769', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306772', end => '306772', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306772', end => '306772', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306775', end => '306776', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306775', end => '306776', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306779', end => '306779', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306779', end => '306779', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306782', end => '306782', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306782', end => '306782', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306788', end => '306789', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306788', end => '306789', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306799', end => '306799', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '306799', end => '306799', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307184', end => '307184', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307184', end => '307184', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307188', end => '307190', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307188', end => '307190', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307198', end => '307198', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307198', end => '307198', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307271', end => '307271', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307271', end => '307271', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307274', end => '307274', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307274', end => '307274', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307654', end => '307654', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307654', end => '307654', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307779', end => '307779', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307779', end => '307779', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307788', end => '307789', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307788', end => '307789', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307809', end => '307809', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '307809', end => '307809', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308012', end => '308012', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308012', end => '308012', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308016', end => '308016', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308016', end => '308016', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308026', end => '308027', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308026', end => '308027', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308033', end => '308034', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308033', end => '308034', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308037', end => '308037', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308037', end => '308037', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308042', end => '308042', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308042', end => '308042', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308045', end => '308045', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308045', end => '308045', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308048', end => '308049', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308048', end => '308049', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308054', end => '308055', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308054', end => '308055', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308063', end => '308063', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308063', end => '308063', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308076', end => '308077', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308076', end => '308077', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308082', end => '308083', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308082', end => '308083', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308085', end => '308085', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308085', end => '308085', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308087', end => '308089', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308087', end => '308089', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308095', end => '308097', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308095', end => '308097', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308404', end => '308404', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308404', end => '308404', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308412', end => '308412', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308412', end => '308412', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308420', end => '308427', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308420', end => '308427', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308433', end => '308434', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308433', end => '308434', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308441', end => '308446', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308441', end => '308446', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308448', end => '308448', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308448', end => '308448', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308451', end => '308454', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308451', end => '308454', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308457', end => '308459', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308457', end => '308459', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308462', end => '308463', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308462', end => '308463', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308467', end => '308469', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308467', end => '308469', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308472', end => '308473', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308472', end => '308473', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308475', end => '308477', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308475', end => '308477', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308479', end => '308479', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308479', end => '308479', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308482', end => '308482', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308482', end => '308482', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308484', end => '308487', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308484', end => '308487', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308784', end => '308784', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308784', end => '308784', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308804', end => '308804', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308804', end => '308804', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308822', end => '308822', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308822', end => '308822', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308952', end => '308952', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '308952', end => '308952', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309001', end => '309633', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309001', end => '309633', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309634', end => '309634', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309635', end => '309746', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309635', end => '309746', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309748', end => '309871', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309748', end => '309871', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309873', end => '309915', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309873', end => '309915', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309917', end => '309999', mod => 'MOD11',
            ex => 2, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 5, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '309917', end => '309999', mod => 'MOD11',
            ex => 9, u => 0, v => 0, w => 3, x => 2, y => 9, z => 8, a => 1, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '400000', end => '400514', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '400000', end => '400514', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '400515', end => '400515', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 5, c => 7, d => 3, e => 4, f => 9, g => 2, h => 1,
        },
        {
            start => '400516', end => '404799', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '400516', end => '404799', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '500000', end => '501029', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '502101', end => '560070', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600000', end => '600108', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600110', end => '600124', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600127', end => '600142', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600144', end => '600149', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600180', end => '600304', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600307', end => '600312', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600314', end => '600355', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600357', end => '600851', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '600901', end => '601360', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '601403', end => '608028', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '609593', end => '609593', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 1, c => 3, d => 7, e => 1, f => 3, g => 7, h => 1,
        },
        {
            start => '609599', end => '609599', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 5, c => 7, d => 5, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '640001', end => '640001', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '720000', end => '720249', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '720251', end => '724443', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '725000', end => '725616', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '726000', end => '726616', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '770100', end => '771799', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '771877', end => '771877', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '771900', end => '772799', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '772813', end => '772817', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '772901', end => '773999', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '774100', end => '774599', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '774700', end => '777789', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '777791', end => '777999', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '778001', end => '778001', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '778300', end => '778799', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '778855', end => '778855', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '778900', end => '779174', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '779414', end => '779999', mod => 'MOD11',
            ex => 7, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '800000', end => '802005', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802007', end => '802042', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802044', end => '802065', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802067', end => '802109', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802111', end => '802114', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802116', end => '802123', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802151', end => '802154', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802156', end => '802179', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '802181', end => '803599', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '803609', end => '819999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 1, x => 8, y => 2, z => 6, a => 3, b => 7, c => 9, d => 5, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '820000', end => '826917', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 0, c => 7, d => 3, e => 4, f => 9, g => 2, h => 1,
        },
        {
            start => '820000', end => '826917', mod => 'DBLAL',
            ex => 3, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '826919', end => '827999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 0, c => 7, d => 3, e => 4, f => 9, g => 2, h => 1,
        },
        {
            start => '826919', end => '827999', mod => 'DBLAL',
            ex => 3, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '829000', end => '829999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 0, c => 7, d => 3, e => 4, f => 9, g => 2, h => 1,
        },
        {
            start => '829000', end => '829999', mod => 'DBLAL',
            ex => 3, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '830000', end => '835700', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836500', end => '836501', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836505', end => '836506', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836510', end => '836510', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836515', end => '836515', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836530', end => '836530', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836535', end => '836535', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836540', end => '836540', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836560', end => '836560', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836565', end => '836565', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836570', end => '836570', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836585', end => '836585', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836590', end => '836590', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836595', end => '836595', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836620', end => '836620', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836625', end => '836625', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '836630', end => '836630', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '837550', end => '837550', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '837560', end => '837560', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '837570', end => '837570', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '837580', end => '837580', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 4, x => 3, y => 2, z => 7, a => 2, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '839105', end => '839106', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '839105', end => '839106', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '839130', end => '839131', mod => 'MOD11',
            ex => 0, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '839130', end => '839131', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '839147', end => '839147', mod => 'MOD10',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 5, c => 7, d => 5, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '870000', end => '876899', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '870000', end => '876899', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876919', end => '876919', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876919', end => '876919', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876921', end => '876923', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876921', end => '876923', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876925', end => '876932', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876925', end => '876932', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876935', end => '876935', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876935', end => '876935', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876951', end => '876951', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876951', end => '876951', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876953', end => '876955', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876953', end => '876955', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876957', end => '876957', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876957', end => '876957', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '876961', end => '876965', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '876961', end => '876965', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877000', end => '877070', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877000', end => '877070', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877071', end => '877071', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877071', end => '877071', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877078', end => '877078', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877078', end => '877078', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877088', end => '877088', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877088', end => '877088', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877090', end => '877090', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877090', end => '877090', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877098', end => '877098', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877098', end => '877098', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '877099', end => '879999', mod => 'MOD11',
            ex => 10, u => 0, v => 0, w => 1, x => 2, y => 5, z => 3, a => 6, b => 4, c => 8, d => 7, e => 10, f => 9, g => 3, h => 1,
        },
        {
            start => '877099', end => '879999', mod => 'MOD11',
            ex => 11, u => 0, v => 0, w => 5, x => 10, y => 9, z => 8, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '890000', end => '890699', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '891000', end => '891616', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '892000', end => '892616', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 9, a => 8, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '900000', end => '902396', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '900000', end => '902396', mod => 'MOD11',
            ex => 0, u => 32, v => 16, w => 8, x => 4, y => 2, z => 1, a => 0, b => 0, c => 0, d => 0, e => 0, f => 0, g => 0, h => 0,
        },
        {
            start => '902398', end => '909999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 128, b => 64, c => 32, d => 16, e => 8, f => 4, g => 2, h => 1,
        },
        {
            start => '902398', end => '909999', mod => 'MOD11',
            ex => 0, u => 32, v => 16, w => 8, x => 4, y => 2, z => 1, a => 0, b => 0, c => 0, d => 0, e => 0, f => 0, g => 0, h => 0,
        },
        {
            start => '938000', end => '938696', mod => 'MOD11',
            ex => 5, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 0, h => 0,
        },
        {
            start => '938000', end => '938696', mod => 'DBLAL',
            ex => 5, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 0,
        },
        {
            start => '938698', end => '938999', mod => 'MOD11',
            ex => 5, u => 7, v => 6, w => 5, x => 4, y => 3, z => 2, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 0, h => 0,
        },
        {
            start => '938698', end => '938999', mod => 'DBLAL',
            ex => 5, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 0,
        },
        {
            start => '950000', end => '950002', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '950000', end => '950002', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '950004', end => '950479', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '950004', end => '950479', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '950500', end => '959999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 0, b => 7, c => 6, d => 5, e => 4, f => 3, g => 2, h => 1,
        },
        {
            start => '950500', end => '959999', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '980000', end => '980004', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '980000', end => '980004', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '980006', end => '983000', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '980006', end => '983000', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '983003', end => '987000', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '983003', end => '987000', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
        {
            start => '987004', end => '989999', mod => 'MOD11',
            ex => 0, u => 0, v => 0, w => 0, x => 0, y => 0, z => 0, a => 7, b => 6, c => 5, d => 4, e => 3, f => 2, g => 1, h => 0,
        },
        {
            start => '987004', end => '989999', mod => 'DBLAL',
            ex => 0, u => 2, v => 1, w => 2, x => 1, y => 2, z => 1, a => 2, b => 1, c => 2, d => 1, e => 2, f => 1, g => 2, h => 1,
        },
    ];
}

=head1 AUTHOR

Mohammad S Anwar, C<< <mohammad.anwar at yahoo.com> >>

=head1 BUGS

Please report any bugs or feature  requests to C<bug-bankaccount-validator-uk at rt.cpan.org>, 
or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=BankAccount-Validator-UK>.  
I will be notified, & then you'll automatically be notified of progress on your bug  as I make 
changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc BankAccount::Validator::UK::Rule

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=BankAccount-Validator-UK>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/BankAccount-Validator-UK>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/BankAccount-Validator-UK>

=item * Search CPAN

L<http://search.cpan.org/dist/BankAccount-Validator-UK/>

=back

=head1 LICENSE AND COPYRIGHT

Copyright 2012 Mohammad S Anwar.

This program  is  free  software; you can redistribute it and/or modify it under  the terms of
either :  the  GNU General Public License as published by the Free Software Foundation; or the
Artistic License.

See http://dev.perl.org/licenses/ for more information.

=head1 DISCLAIMER

This  program  is  distributed  in  the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

=cut

1; # End of BankAccount::Validator::UK::Rule