use strict;
use warnings;
use Test::More tests => 15;
use Test::Deep;
use Test::Exception;
use Test::NoWarnings qw( clear_warnings had_no_warnings );

# silly workaround for spurious warning message generated by List::MoreUtils
# 0.33_005; note that we do not depend on List::MoreUtils directly, but
# probably some module that we depend on does require it
had_no_warnings;
require List::MoreUtils;
clear_warnings;

# force reloading Test::PDL on next 'require' + wipe functions living in the
# Test::PDL namespace to avoid redefinition warnings
sub wipe
{
	delete $INC{ 'Test/PDL.pm' };
	delete $Test::PDL::{ $_ } for qw( _approx _comparison_fails
		_dimensions_match eq_pdl eq_pdl_diag import is_pdl set_options
		test_byte test_double test_float test_long test_longlong
		test_pdl test_short test_ushort );
}

# we should start out without an 'is_pdl' function
ok ! __PACKAGE__->can( 'is_pdl' );

# use Test::PDL '';
package t1;
require Test::PDL;
::cmp_deeply \%Test::PDL::OPTIONS, {
	TOLERANCE   => ::code( sub { abs( $_[0]/1e-6 - 1 ) < 1e-6 ? 1 : ( 0, 'tolerance beyond specified value' ) } ),
	EQUAL_TYPES => 1,
};
::ok ! __PACKAGE__->can( 'is_pdl' );
::wipe;

# use Test::PDL;
package t2;
require Test::PDL;
Test::PDL->import();
::cmp_deeply \%Test::PDL::OPTIONS, {
	TOLERANCE   => ::code( sub { abs( $_[0]/1e-6 - 1 ) < 1e-6 ? 1 : ( 0, 'tolerance beyond specified value' ) } ),
	EQUAL_TYPES => 1,
};
::ok __PACKAGE__->can( 'is_pdl' );
::wipe;

# use Test::PDL -equal_types => 0;
package t3;
require Test::PDL;
Test::PDL->import( -equal_types => 0 );
::cmp_deeply \%Test::PDL::OPTIONS, {
	TOLERANCE   => ::code( sub { abs( $_[0]/1e-6 - 1 ) < 1e-6 ? 1 : ( 0, 'tolerance beyond specified value' ) } ),
	EQUAL_TYPES => 0,
};
::ok __PACKAGE__->can( 'is_pdl' );
::wipe;

# use Test::PDL -tolerance => 1e-8;
package t4;
require Test::PDL;
Test::PDL->import( -tolerance => 1e-8 );
::cmp_deeply \%Test::PDL::OPTIONS, {
	TOLERANCE   => ::code( sub { abs( $_[0]/1e-8 - 1 ) < 1e-6 ? 1 : ( 0, 'tolerance beyond specified value' ) } ),
	EQUAL_TYPES => 1,
};
::ok __PACKAGE__->can( 'is_pdl' );
::wipe;

# use Test::PDL -tolerance => 1e-8, -equal_types => 0, 'is_pdl';
package t5;
require Test::PDL;
Test::PDL->import( -tolerance => 1e-8, -equal_types => 0, 'is_pdl' );
::cmp_deeply \%Test::PDL::OPTIONS, {
	TOLERANCE   => ::code( sub { abs( $_[0]/1e-8 - 1 ) < 1e-6 ? 1 : ( 0, 'tolerance beyond specified value' ) } ),
	EQUAL_TYPES => 0,
};
::ok __PACKAGE__->can( 'is_pdl' );
::wipe;

# use Test::PDL -whatever => 42;
package t6;
require Test::PDL;
::throws_ok { Test::PDL->import( -whatever => 42 ) } qr/\binvalid option WHATEVER\b/;
::ok ! __PACKAGE__->can( 'is_pdl' );
::wipe;
