my $perldoc_data = <<'END_PERLDOC';
=begin Xhtml
<object type="video/quicktime" data="onion.mov">
=end Xhtml

or:

=Image http://www.perlfoundation.org/images/perl_logo_32x104.png

END_PERLDOC

my $expected_structure = <<'END_EXPECTED';
errors: []

tree: !!perl/hash:Perl6::Perldoc::Document 
  content: 
    - !!perl/hash:Perl6::Perldoc::Block::pod 
      content: 
        - !!perl/hash:Perl6::Perldoc::Block::Named::Xhtml 
          content: 
            - "<object type=\"video/quicktime\" data=\"onion.mov\">\n"
          style: delimited
          typename: Xhtml
        - !!perl/hash:Perl6::Perldoc::Block::para 
          content: 
            - "or:\n"
          style: implicit
          typename: para
        - !!perl/hash:Perl6::Perldoc::Block::Named::Image 
          content: 
            - "http://www.perlfoundation.org/images/perl_logo_32x104.png\n"
          style: abbreviated
          typename: Image
      typename: pod
  typename: (document)
warnings: []


END_EXPECTED

use Perl6::Perldoc::Parser;
use Test::More 'no_plan';

sub is_subset {
    my ($found, $expected) = @_;
    my @found    = split /\n/, $found;
    my @expected = split /\n/, $expected;

    while (@found && @expected) {
        if ($found[0] eq $expected[0]) {
            is $found[0], $expected[0], $expected[0];
            shift @found;
            shift @expected;
        }
        else {
            shift @found;
        }
    }
    
    for my $expected (@expected) {
        ok 0, "Missing '$expected'";
    }
}

open my $fh, '<', \$perldoc_data
    or die "Could not open file on test data";

my $representation = Perl6::Perldoc::Parser->parse($fh ,{all_pod=>1});

use YAML::Syck 'Dump';
is_subset Dump($representation), $expected_structure;
