/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;

public class Element
extends EventNode {
    private static final long serialVersionUID = 5616690634173934926L;
    private NamedNodeMap attributes_;

    public HTMLCollection jsxFunction_selectNodes(String expression) {
        HTMLCollection collection = new HTMLCollection(this);
        collection.init(this.getDomNodeOrDie(), expression);
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public final String jsxGet_tagName() {
        return this.jsxGet_nodeName();
    }

    public Object jsxGet_attributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    public Object jsxFunction_getAttribute(String attributeName) {
        attributeName = this.fixAttributeName(attributeName);
        String value = this.getDomNodeOrDie().getAttribute(attributeName);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            Object property;
            if (this.getBrowserVersion().isIE() && (property = this.get(attributeName, (Scriptable)this)) != NOT_FOUND) {
                return property;
            }
            return null;
        }
        return value;
    }

    protected String fixAttributeName(String attributeName) {
        return attributeName;
    }

    public void jsxFunction_setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        DomElement domNode = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(this);
        collection.init(domNode, ".//*[local-name()='" + tagName + "']");
        return collection;
    }

    public Object jsxFunction_getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    public String jsxGet_text() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        return buffer.toString();
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.toText(child, buffer);
                    break;
                }
                case 3: 
                case 4: {
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
    }

    public Object jsxFunction_getElementsByTagNameNS(Object namespaceURI, String localName) {
        String xpath;
        DomElement domNode = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(this);
        if (namespaceURI == null || namespaceURI.equals("*")) {
            xpath = ".//" + localName;
        } else {
            String prefix = XmlUtil.lookupPrefix(domNode, Context.toString((Object)namespaceURI));
            xpath = ".//" + prefix + ':' + localName;
        }
        collection.init(domNode, xpath);
        return collection;
    }

    public boolean jsxFunction_hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    public String jsxGet_xml() {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(format);
        serializer.setOutputCharStream((Writer)writer);
        try {
            serializer.serialize((org.w3c.dom.Element)this.getDomNodeOrDie());
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: failed to serialize", e);
        }
        return writer.toString();
    }

    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    public void jsxFunction_removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
        if (this.getBrowserVersion().isIE()) {
            this.delete(name);
        }
    }
}

