/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class StringWebResponse
extends WebResponse {
    private boolean fromJavascript_;

    private static WebResponseData getWebResponseData(String contentString, String charset) {
        byte[] content = TextUtil.stringToByteArray(contentString, charset);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", "text/html"));
        try {
            return new WebResponseData(content, 200, "OK", compiledHeaders);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StringWebResponse(String content, URL originatingURL) {
        this(content, "UTF-8", originatingURL);
    }

    public StringWebResponse(String content, String charset, URL originatingURL) {
        super(StringWebResponse.getWebResponseData(content, charset), StringWebResponse.buildWebRequest(originatingURL, charset), 0L);
    }

    private static WebRequest buildWebRequest(URL originatingURL, String charset) {
        WebRequest webRequest = new WebRequest(originatingURL, HttpMethod.GET);
        webRequest.setCharset(charset);
        return webRequest;
    }

    public boolean isFromJavascript() {
        return this.fromJavascript_;
    }

    public void setFromJavascript(boolean fromJavascript) {
        this.fromJavascript_ = fromJavascript;
    }
}

