/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript.commonjs.module.provider;

import java.net.URI;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.commonjs.module.ModuleScript;
import net.sourceforge.htmlunit.corejs.javascript.commonjs.module.ModuleScriptProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiModuleScriptProvider
implements ModuleScriptProvider {
    private final ModuleScriptProvider[] providers;

    public MultiModuleScriptProvider(Iterable<? extends ModuleScriptProvider> providers) {
        LinkedList<ModuleScriptProvider> l = new LinkedList<ModuleScriptProvider>();
        for (ModuleScriptProvider moduleScriptProvider : providers) {
            l.add(moduleScriptProvider);
        }
        this.providers = l.toArray(new ModuleScriptProvider[l.size()]);
    }

    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, URI uri, Scriptable paths) throws Exception {
        for (ModuleScriptProvider provider : this.providers) {
            ModuleScript script = provider.getModuleScript(cx, moduleId, uri, paths);
            if (script == null) continue;
            return script;
        }
        return null;
    }
}

