/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class History
implements Serializable {
    private final WebWindow window_;
    private final List<String> urls_ = new ArrayList<String>();
    private transient ThreadLocal<Boolean> ignoreNewPages_;
    private int index_ = -1;

    public History(WebWindow window) {
        this.window_ = window;
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.ignoreNewPages_ = new ThreadLocal();
    }

    public int getLength() {
        return this.urls_.size();
    }

    public int getIndex() {
        return this.index_;
    }

    public URL getUrl(int index) {
        if (index >= 0 && index < this.urls_.size()) {
            return UrlUtils.toUrlSafe(this.urls_.get(index));
        }
        return null;
    }

    public History back() throws IOException {
        if (this.index_ > 0) {
            --this.index_;
            this.goToUrlAtCurrentIndex();
        }
        return this;
    }

    public History forward() throws IOException {
        if (this.index_ < this.urls_.size() - 1) {
            ++this.index_;
            this.goToUrlAtCurrentIndex();
        }
        return this;
    }

    public History go(int relativeIndex) throws IOException {
        int i = this.index_ + relativeIndex;
        if (i < this.urls_.size() && i >= 0) {
            this.index_ = i;
        }
        this.goToUrlAtCurrentIndex();
        return this;
    }

    public String toString() {
        return this.urls_.toString();
    }

    protected void addPage(Page page) {
        Boolean ignoreNewPages = this.ignoreNewPages_.get();
        if (ignoreNewPages != null && ignoreNewPages.booleanValue()) {
            return;
        }
        ++this.index_;
        while (this.urls_.size() > this.index_) {
            this.urls_.remove(this.index_);
        }
        this.urls_.add(page.getWebResponse().getWebRequest().getUrl().toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToUrlAtCurrentIndex() throws IOException {
        URL url = UrlUtils.toUrlSafe(this.urls_.get(this.index_));
        WebRequest wrs = new WebRequest(url);
        Boolean old = this.ignoreNewPages_.get();
        try {
            this.ignoreNewPages_.set(Boolean.TRUE);
            this.window_.getWebClient().getPage(this.window_, wrs);
        }
        finally {
            this.ignoreNewPages_.set(old);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }
}

