/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;

public class HTMLTextAreaElement
extends FormField {
    private static final Pattern NORMALIZE_VALUE_PATTERN = Pattern.compile("([^\\r])\\n");

    public String jsxGet_type() {
        return "textarea";
    }

    public String jsxGet_value() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    public void jsxSet_value(String value) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setText(value);
    }

    public int jsxGet_cols() {
        String s = this.getDomNodeOrDie().getAttribute("cols");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_COLS_RETURNS_20)) {
                return 20;
            }
            return -1;
        }
    }

    public void jsxSet_cols(String cols) {
        int i;
        try {
            i = Float.valueOf(cols).intValue();
            if (i < 0) {
                throw new NumberFormatException("New value for cols smaller than zero.");
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            i = 0;
        }
        this.getDomNodeOrDie().setAttribute("cols", Integer.toString(i));
    }

    public int jsxGet_rows() {
        int rows;
        try {
            String s = this.getDomNodeOrDie().getAttribute("rows");
            rows = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            rows = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_174) ? -1 : 2;
        }
        return rows;
    }

    public void jsxSet_rows(String rows) {
        int i;
        try {
            i = new Float(rows).intValue();
            if (i < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_111)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            i = 0;
        }
        this.getDomNodeOrDie().setAttribute("rows", Integer.toString(i));
    }

    public String jsxGet_defaultValue() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getDefaultValue();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    public void jsxSet_defaultValue(String defaultValue) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    public int jsxGet_textLength() {
        return this.jsxGet_value().length();
    }

    public int jsxGet_selectionStart() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionStart();
    }

    public void jsxSet_selectionStart(int start) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionStart(start);
    }

    public int jsxGet_selectionEnd() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionEnd();
    }

    public void jsxSet_selectionEnd(int end) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionEnd(end);
    }

    public void jsxFunction_setSelectionRange(int start, int end) {
        this.jsxSet_selectionStart(start);
        this.jsxSet_selectionEnd(end);
    }

    public void jsxFunction_select() {
        ((HtmlTextArea)this.getDomNodeOrDie()).select();
    }

    public boolean jsxGet_readOnly() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).isReadOnly();
    }

    public void jsxSet_readOnly(boolean readOnly) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }
}

