/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TBXResolver
implements EntityResolver {
    public static final String RCSID = "$Id: TBXResolver.java 105 2009-04-04 17:40:36Z lanhel $";
    private static final Logger LOGGER = Logger.getLogger("org.ttt.salt");
    private final Map<String, String> uri2url = new HashMap<String, String>();
    private URL fallbackSearchLoc;

    public TBXResolver(URL fallback) throws IOException {
        String path = fallback.getPath();
        String ppath = path.substring(0, path.lastIndexOf(47) + 1);
        this.fallbackSearchLoc = new URL(fallback.getProtocol(), fallback.getHost(), fallback.getPort(), ppath);
        this.addPublicId("ISO 30042:2008A//DTD TBX core//EN", "/xml/TBXcoreStructV02.dtd");
        this.addPublicId("ISO 30042:2008A//DTD TBX XCS//EN", "/xml/tbxxcsdtd.dtd");
        this.addPublicId("Demo XCS", "/xml/TBXDCSv05.xml");
    }

    public void addPublicId(String publicId, String systemId) {
        this.uri2url.put(publicId, systemId);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOGGER.fine(String.format("Resolve entity PublicID=%s SystemId=%s", publicId, systemId));
        InputStreamReader reader = null;
        try {
            InputStream input;
            if (this.uri2url.containsKey(publicId)) {
                LOGGER.info("Entity is a known publicId: " + publicId);
                systemId = this.uri2url.get(publicId);
                input = this.getClass().getResourceAsStream(this.uri2url.get(publicId));
            } else if (systemId.matches("\\w+:.+")) {
                LOGGER.info("Entity is a URI: " + systemId);
                URI uri = new URI(systemId);
                input = uri.toURL().openStream();
            } else {
                LOGGER.fine("Unknown schema systemId: " + systemId);
                if (systemId.startsWith("/")) {
                    LOGGER.info("Entity is an absolute path: " + systemId);
                    File file = new File(systemId);
                    input = file.exists() ? new FileInputStream(file) : this.getClass().getResourceAsStream(systemId);
                } else {
                    systemId = this.fallbackSearchLoc.getPath() + systemId;
                    URL locurl = new URL(this.fallbackSearchLoc.getProtocol(), this.fallbackSearchLoc.getHost(), this.fallbackSearchLoc.getPort(), systemId);
                    LOGGER.info("Entity is a relative path: " + locurl.toString());
                    input = locurl.openStream();
                }
                if (input == null) {
                    throw new FileNotFoundException();
                }
            }
            if (!input.markSupported()) {
                input = new BufferedInputStream(input);
            }
            String enc = TBXResolver.getEncoding(input);
            reader = new InputStreamReader(input, enc);
        }
        catch (FileNotFoundException err) {
            String msg = String.format("Entity could not be resolved:\n  PUBLIC: '%s'\n  SYSTEM: '%s'\n  BUILT IN: %s", publicId, systemId, this.uri2url.containsKey(publicId) ? this.uri2url.get(publicId) : "NONE");
            throw new FileNotFoundException(msg);
        }
        catch (UnsupportedEncodingException err) {
            throw new UnsupportedEncodingException(String.format("PUBLIC %s SYSTEM %s", publicId, systemId));
        }
        catch (URISyntaxException err) {
            throw new SAXException("Invalid System ID format", err);
        }
        InputSource ret = new InputSource(reader);
        ret.setPublicId(publicId);
        ret.setSystemId(systemId);
        return ret;
    }

    public static String getEncoding(InputStream input) throws UnsupportedEncodingException, IOException {
        input.mark(16);
        int b0 = input.read();
        int b1 = input.read();
        int b2 = input.read();
        int b3 = input.read();
        int b4 = input.read();
        input.reset();
        int b1utf = b1 & 0xC0;
        int b2utf = b2 & 0xC0;
        int b3utf = b3 & 0xC0;
        String ret = null;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            b0 = input.read();
            b1 = input.read();
            b2 = input.read();
            ret = "UTF-8";
        } else if ((b0 & 0x80) == 0 || (b0 & 0xE0) == 192 && (b1 & 0xC0) == 128 || (b0 & 0xF0) == 224 && (b1 & 0xC0) == 128 && (b2 & 0xC0) == 128 || (b0 & 0xF8) == 240 && (b1 & 0xC0) == 128 && (b2 & 0xC0) == 128 && (b2 & 0xC0) == 128) {
            ret = "UTF-8";
        } else if (b0 == 254 && b1 == 255) {
            b0 = input.read();
            b1 = input.read();
            ret = "UTF-16BE";
        } else if (b0 == 255 && b1 == 254 && b2 != 0) {
            b0 = input.read();
            b1 = input.read();
            ret = "UTF-16LE";
        } else if (b0 == 0 && b1 == 0 && b2 == 254 && b3 == 255) {
            ret = "UTF-32BE";
            if (!Charset.isSupported(ret)) {
                throw new UnsupportedEncodingException("UTF-32BE encoding is unsupported.");
            }
        } else if (b0 == 255 && b2 == 254 && b2 == 0 && b3 == 0) {
            ret = "UTF-32LE";
            if (!Charset.isSupported(ret)) {
                throw new UnsupportedEncodingException("UTF-32LE encoding is unsupported.");
            }
        } else {
            throw new UnsupportedEncodingException("Unknown file encoding");
        }
        return ret;
    }
}

