/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ttt.salt.gui.ActionOpen;
import org.ttt.salt.gui.ISOReference;
import org.ttt.salt.gui.SpringUtilities;
import org.ttt.salt.gui.TBXAbstractAction;

public class TBXValidatorPanel
extends JPanel
implements HierarchyBoundsListener {
    public static final String RCSID = "$Id: TBXValidatorPanel.java 123 2010-06-23 01:51:03Z lanhel $";
    private static Logger LOGGER;
    private JComboBox boxCountry;
    private JComboBox boxLanguage;
    private JComboBox boxLogging;
    private JCheckBox cbNoLangCheck;
    private JButton buttonValidate;
    private JLabel labelCountry;
    private JLabel labelLanguage;
    private JLabel labelLogging;
    private JPanel panelButtons;
    private JPanel panelOptions;

    public TBXValidatorPanel(ResourceBundle bndl) {
        LOGGER = Logger.getLogger("org.ttt.salt");
        this.cbNoLangCheck = new JCheckBox("No xml:lang validation.");
        this.cbNoLangCheck.setActionCommand("NoLangCheckChanged");
        this.boxLogging = new JComboBox();
        this.boxLanguage = new JComboBox();
        this.boxCountry = new JComboBox();
        this.setLayout(new BorderLayout());
        this.layoutButtons(bndl);
        this.add((Component)this.panelButtons, "South");
        this.layoutPanelOptions(bndl);
        this.add((Component)this.panelOptions, "Center");
        try {
            System.setProperty("java.util.logging.config.class", "org.ttt.salt.LogConfig");
            LogManager.getLogManager().readConfiguration();
        }
        catch (IOException err) {
            err.printStackTrace();
            System.exit(1);
        }
    }

    private void layoutButtons(ResourceBundle bndl) {
        ActionOpen action = (ActionOpen)TBXAbstractAction.getAction(ActionOpen.class);
        this.buttonValidate = new JButton(action);
        this.cbNoLangCheck.addActionListener(action);
        this.boxLogging.addActionListener(action);
        this.panelButtons = new JPanel();
        this.panelButtons.setLayout(new FlowLayout());
        this.panelButtons.add(this.buttonValidate);
    }

    private void layoutPanelOptions(ResourceBundle bndl) {
        this.panelOptions = new JPanel();
        this.labelLogging = new JLabel("Logging");
        this.labelLanguage = new JLabel("Language");
        this.labelCountry = new JLabel("Country");
        String[] logvals = new String[]{"SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
        this.boxLogging.setModel(new DefaultComboBoxModel<String>(logvals));
        this.boxLogging.setSelectedItem("INFO");
        SortedSet<String> iso639 = ISOReference.getInstance().get639alpha2();
        this.boxLanguage.setModel(new DefaultComboBoxModel<Object>(iso639.toArray()));
        this.boxLanguage.setSelectedItem("en");
        SortedSet<String> iso3166 = ISOReference.getInstance().get3166alpha2();
        this.boxCountry.setModel(new DefaultComboBoxModel<Object>(iso3166.toArray()));
        this.boxCountry.setSelectedItem("US");
        this.panelOptions.setLayout(new SpringLayout());
        this.panelOptions.add(new JLabel(" "));
        this.panelOptions.add(this.cbNoLangCheck);
        this.labelLogging.setLabelFor(this.boxLogging);
        this.panelOptions.add(this.labelLogging);
        this.panelOptions.add(this.boxLogging);
        int rows = 2;
        int cols = 2;
        int initX = 6;
        int initY = 6;
        int xPad = 6;
        int yPad = 6;
        SpringUtilities.makeCompactGrid(this.panelOptions, 2, 2, 6, 6, 6, 6);
        this.panelOptions.setOpaque(true);
    }

    public void ancestorMoved(HierarchyEvent evt) {
    }

    public void ancestorResized(HierarchyEvent evt) {
    }
}

