# NAME

Math::Tau - provide the important mathematical constant tau = 6.2831...

# VERSION

version 1.001

# SYNOPSIS

    use Math::Tau;

    print tau/2;
    # 3.14159265358979

    use utf8;
    print τ/2;
    # 3.14159265358979

# DESCRIPTION

tau is one of the most fundamental and misunderstood mathematical constants.

See [The Tau Manifesto](http://tauday.com/) for why pi is a historical mistake.

# METHODS

## tau

The mathematical constant 6.2831... as floating point.

# SEE ALSO

[Math::Complex](http://search.cpan.org/perldoc?Math::Complex), [Math::Trig](http://search.cpan.org/perldoc?Math::Trig)

- [Math::Tau](http://search.cpan.org/perldoc?Math::Tau)

# AUTHOR

Franklin Chen <franklinchen@franklinchen.com>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Franklin Chen <franklinchen@franklinchen.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
