package Bundle::SDK::COG;

use warnings;
use strict;

=head1 NAME

Bundle::SDK::COG - CPAN Bundle for modules COG uses

=cut

our $VERSION = '0.02';

=head1 SYNOPSIS

cpan Bundle::SDK::COG

=head1 CONTENTS

Bundle::CPAN

Bundle::Test

Test::Warn

Test::Memory::Cycle

Test::Pod

Test::Pod::Coverage

Bundle::COG

Astro::MoonPhase

CPAN::Mini

Date::DayOfWeek

JSAN

Module::Starter

Perl::Tidy

Spork

Time::HiRes

WWW::Mechanize

=head1 AUTHOR

Jose Castro, C<< <cog@cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-bundle-sdk-cog@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Bundle-SDK-COG>.
I will be notified, and then you'll automatically be notified of
progress on your bug as I make changes.

=head1 ACKNOWLEDGEMENTS

I got the idea for this very useful (to me) Bundle out of Simon's
Bundle::SDK::SIMON. Apart from saving me much time whenever I go to a
new machine, it can also serve as a way to show others what I'm using.

I got the nerve to do it after reading this:
http://use.perl.org/~Ovid/journal/26818. Afterall, "What is the CPAN
for?"

=head1 COPYRIGHT & LICENSE

Copyright 2005 Jose Castro, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Bundle::SDK::COG
