# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Text-Smart.spec.PL,v 1.3 2005/09/08 20:49:23 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/Text/Smart.pm')
  {
    if ($@) { die $@ };
    die "lib/Text/Smart.pm: $!";
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Text::Smart::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by Text-Smart.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Text-Smart

Summary: Text::Smart - Simple text markup processor
Name: perl-%{appname}
Version: @VERSION@
Release: 1
License: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}

%description
Text::Smart provides a module for simple inline text
markup processing.

%prep
%setup -q -n %{appname}-%{version}


%build
perl Makefile.PL INSTALLDIRS=vendor PREFIX=$RPM_BUILD_ROOT/usr
make


%install
rm -rf $RPM_BUILD_ROOT
make install INSTALLVENDORMAN3DIR=$RPM_BUILD_ROOT%{perlvendorman3}
find $RPM_BUILD_ROOT -name perllocal.pod -exec rm -f {} \;
find $RPM_BUILD_ROOT -name .packlist -exec rm -f {} \;

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc COPYING
%doc README
%{perlvendorman3}/*
%{perlvendorlib}/Text/Smart.pm
%{perlvendorlib}/Text/Smart/
