package Google::Ads::AdWords::v201206::ConversionOptimizer;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201206::BiddingStrategy);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %BiddingStrategy__Type_of :ATTR(:get<BiddingStrategy__Type>);
my %pricingModel_of :ATTR(:get<pricingModel>);
my %conversionOptimizerBidType_of :ATTR(:get<conversionOptimizerBidType>);
my %deduplicationMode_of :ATTR(:get<deduplicationMode>);

__PACKAGE__->_factory(
    [ qw(        BiddingStrategy__Type
        pricingModel
        conversionOptimizerBidType
        deduplicationMode

    ) ],
    {
        'BiddingStrategy__Type' => \%BiddingStrategy__Type_of,
        'pricingModel' => \%pricingModel_of,
        'conversionOptimizerBidType' => \%conversionOptimizerBidType_of,
        'deduplicationMode' => \%deduplicationMode_of,
    },
    {
        'BiddingStrategy__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'pricingModel' => 'Google::Ads::AdWords::v201206::PricingModel',
        'conversionOptimizerBidType' => 'Google::Ads::AdWords::v201206::ConversionOptimizerBidType',
        'deduplicationMode' => 'Google::Ads::AdWords::v201206::ConversionDeduplicationMode',
    },
    {

        'BiddingStrategy__Type' => 'BiddingStrategy.Type',
        'pricingModel' => 'pricingModel',
        'conversionOptimizerBidType' => 'conversionOptimizerBidType',
        'deduplicationMode' => 'deduplicationMode',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::ConversionOptimizer

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConversionOptimizer from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Conversion optimizer bidding strategy. For more information, visit the <a href="http://www.google.com/adwords/conversionoptimizer/index.html" >Conversion Optimizer site</a>. <span class="constraint AdxEnabled">This is disabled for AdX.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * pricingModel


=item * conversionOptimizerBidType


=item * deduplicationMode




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::ConversionOptimizer
   pricingModel => $some_value, # PricingModel
   conversionOptimizerBidType => $some_value, # ConversionOptimizerBidType
   deduplicationMode => $some_value, # ConversionDeduplicationMode
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

