/* ------------------------------------------------------------------------
@NAME       : prototypes.h
@INPUT      : 
@OUTPUT     : 
@RETURNS    : 
@DESCRIPTION: Prototype declarations for functions from various places.
@GLOBALS    : 
@CALLS      : 
@CREATED    : 1997/10/12, Greg Ward
@MODIFIED   : 
@VERSION    : $Id: prototypes.h,v 1.4 1997/03/07 00:28:49 greg Exp $
-------------------------------------------------------------------------- */

#ifndef PROTOTYPES_H
#define PROTOTYPES_H

#include <stdio.h>
#include "btparse.h"
#include "bibtex_ast.h"                 /* my AST definition */
#include "ast.h"                        /* more general PCCTS stuff */

/* util.c */
#if !HAVE_STRLWR
char *strlwr (char *s);
#endif
#if !HAVE_STRUPR
char *strupr (char *s);
#endif

/* parse_auxiliary.c */
void  fix_token_names (void);
void show_stack (char *label);           /* for debugging */

/* post_parse.c */
void  postprocess_string (char *s,
                          int   collapse_whitespace,
                          int   delete_quotes,
                          int   convert_quotes);
char *postprocess_field (AST *field, bt_options_t *options, int replace);
void  postprocess_entry (AST *top, bt_options_t *options);

/* macros.c */
void  init_macros (void);
void  done_macros (void);
void  add_macro (AST *macrodef);
int   macro_length (char *macro);
char *macro_text (AST *macro_use);

/* traversal.c */
void dump_ast (char *msg, AST *root);

#endif /* PROTOTYPES_H */
