/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpOutputStream;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.LogSupport;

class ServletWriter
extends PrintWriter {
    private static Log log = LogFactory.getLog(ServletWriter.class);
    String encoding = null;
    OutputStream os = null;
    boolean written = false;

    ServletWriter(OutputStream os) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(null) : new OutputStreamWriter(os));
        this.os = os;
    }

    ServletWriter(OutputStream os, String encoding) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(encoding) : new OutputStreamWriter(os, encoding));
        this.os = os;
        this.encoding = encoding;
    }

    public void disable() {
        this.out = IO.getNullWriter();
    }

    public void reset() {
        try {
            this.out = IO.getNullWriter();
            super.flush();
            this.out = new OutputStreamWriter(this.os, this.encoding);
            this.written = false;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal(e);
            System.exit(1);
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    @Override
    public void print(boolean p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(char p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(char[] p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(double p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(float p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(int p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(long p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(Object p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void print(String p) {
        this.written = true;
        super.print(p);
    }

    @Override
    public void println() {
        this.written = true;
        super.println();
    }

    @Override
    public void println(boolean p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(char p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(char[] p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(double p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(float p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(int p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(long p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(Object p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void println(String p) {
        this.written = true;
        super.println(p);
    }

    @Override
    public void write(int c) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(c);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    @Override
    public void write(char[] cbuf) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, 0, cbuf.length);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    @Override
    public void write(String s, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    @Override
    public void write(String s) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, 0, s.length());
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }
}

