# Copyright 2013 Jeffrey Kegler
# This file is part of Marpa::R2.  Marpa::R2 is free software: you can
# redistribute it and/or modify it under the terms of the GNU Lesser
# General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
#
# Marpa::R2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser
# General Public License along with Marpa::R2.  If not, see
# http://www.gnu.org/licenses/.

package Marpa::R2::MetaG;

use 5.010;
use strict;
use warnings;

use vars qw($VERSION $STRING_VERSION);
$VERSION        = '2.073_000';
$STRING_VERSION = $VERSION;
## no critic(BuiltinFunctions::ProhibitStringyEval)
$VERSION = eval $VERSION;
## use critic

package Marpa::R2::Internal::MetaG;

use English qw( -no_match_vars );

sub hashed_grammar {
    my $hashed_metag;

## no critic(RegularExpressions::RequireDotMatchAnything)
## no critic(RegularExpressions::RequireExtendedFormatting)
## no critic(RegularExpressions::RequireLineBoundaryMatching)
## no critic(RegularExpressions::ProhibitEscapedMetacharacters)
## no critic(RegularExpressions::ProhibitComplexRegexes)

## The code after this line was automatically generated by sl_to_hash.pl
## Date: Sun Aug 25 21:04:51 2013
$hashed_metag = {
                  'character_classes' => {
                                           '[[\']]' => qr/(?msx-i:['])/,
                                           '[[+-]]' => qr/(?msx-i:[+-])/,
                                           '[[,]]' => qr/(?msx-i:[,])/,
                                           '[[01]]' => qr/(?msx-i:[01])/,
                                           '[[[:alnum:]]]' => qr/(?msx-i:[[:alnum:]])/,
                                           '[[\\#]]' => qr/(?msx-i:[\#])/,
                                           '[[\\(]]' => qr/(?msx-i:[\(])/,
                                           '[[\\)]]' => qr/(?msx-i:[\)])/,
                                           '[[\\*]]' => qr/(?msx-i:[\*])/,
                                           '[[\\+]]' => qr/(?msx-i:[\+])/,
                                           '[[\\-]]' => qr/(?msx-i:[\-])/,
                                           '[[\\:]]' => qr/(?msx-i:[\:])/,
                                           '[[\\;]]' => qr/(?msx-i:[\;])/,
                                           '[[\\<]]' => qr/(?msx-i:[\<])/,
                                           '[[\\=]]' => qr/(?msx-i:[\=])/,
                                           '[[\\>]]' => qr/(?msx-i:[\>])/,
                                           '[[\\[]]' => qr/(?msx-i:[\[])/,
                                           '[[\\\\]]' => qr/(?msx-i:[\\])/,
                                           '[[\\]]]' => qr/(?msx-i:[\]])/,
                                           '[[\\^]]' => qr/(?msx-i:[\^])/,
                                           '[[\\d]]' => qr/(?msx-i:[\d])/,
                                           '[[\\s\\w]]' => qr/(?msx-i:[\s\w])/,
                                           '[[\\s]]' => qr/(?msx-i:[\s])/,
                                           '[[\\w]]' => qr/(?msx-i:[\w])/,
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => qr/(?msx-i:[\x{A}\x{B}\x{C}\x{D}\x{2028}\x{2029}])/,
                                           '[[\\|]]' => qr/(?msx-i:[\|])/,
                                           '[[\\~]]' => qr/(?msx-i:[\~])/,
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => qr/(?msx-i:[^'\x{0A}\x{0B}\x{0C}\x{0D}\x{0085}\x{2028}\x{2029}])/,
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => qr/(?msx-i:[^\x{5d}\x{0A}\x{0B}\x{0C}\x{0D}\x{0085}\x{2028}\x{2029}])/,
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => qr/(?msx-i:[^\x{A}\x{B}\x{C}\x{D}\x{2028}\x{2029}])/,
                                           '[[a-zA-Z]]' => qr/(?msx-i:[a-zA-Z])/,
                                           '[[a]]' => qr/(?msx-i:[a])/,
                                           '[[b]]' => qr/(?msx-i:[b])/,
                                           '[[c]]' => qr/(?msx-i:[c])/,
                                           '[[d]]' => qr/(?msx-i:[d])/,
                                           '[[e]]' => qr/(?msx-i:[e])/,
                                           '[[f]]' => qr/(?msx-i:[f])/,
                                           '[[g]]' => qr/(?msx-i:[g])/,
                                           '[[h]]' => qr/(?msx-i:[h])/,
                                           '[[i]]' => qr/(?msx-i:[i])/,
                                           '[[k]]' => qr/(?msx-i:[k])/,
                                           '[[l]]' => qr/(?msx-i:[l])/,
                                           '[[m]]' => qr/(?msx-i:[m])/,
                                           '[[n]]' => qr/(?msx-i:[n])/,
                                           '[[o]]' => qr/(?msx-i:[o])/,
                                           '[[p]]' => qr/(?msx-i:[p])/,
                                           '[[r]]' => qr/(?msx-i:[r])/,
                                           '[[s]]' => qr/(?msx-i:[s])/,
                                           '[[t]]' => qr/(?msx-i:[t])/,
                                           '[[u]]' => qr/(?msx-i:[u])/,
                                           '[[v]]' => qr/(?msx-i:[v])/,
                                           '[[w]]' => qr/(?msx-i:[w])/,
                                           '[[x]]' => qr/(?msx-i:[x])/,
                                           '[[y]]' => qr/(?msx-i:[y])/
                                         },
                  'is_lexeme' => {
                                   'Perl name' => 1,
                                   '[:discard]' => 1,
                                   '[Lex-0]' => 1,
                                   '[Lex-10]' => 1,
                                   '[Lex-11]' => 1,
                                   '[Lex-12]' => 1,
                                   '[Lex-13]' => 1,
                                   '[Lex-14]' => 1,
                                   '[Lex-15]' => 1,
                                   '[Lex-16]' => 1,
                                   '[Lex-17]' => 1,
                                   '[Lex-18]' => 1,
                                   '[Lex-19]' => 1,
                                   '[Lex-1]' => 1,
                                   '[Lex-20]' => 1,
                                   '[Lex-21]' => 1,
                                   '[Lex-22]' => 1,
                                   '[Lex-23]' => 1,
                                   '[Lex-24]' => 1,
                                   '[Lex-25]' => 1,
                                   '[Lex-26]' => 1,
                                   '[Lex-27]' => 1,
                                   '[Lex-28]' => 1,
                                   '[Lex-29]' => 1,
                                   '[Lex-2]' => 1,
                                   '[Lex-30]' => 1,
                                   '[Lex-31]' => 1,
                                   '[Lex-32]' => 1,
                                   '[Lex-33]' => 1,
                                   '[Lex-34]' => 1,
                                   '[Lex-35]' => 1,
                                   '[Lex-36]' => 1,
                                   '[Lex-37]' => 1,
                                   '[Lex-38]' => 1,
                                   '[Lex-39]' => 1,
                                   '[Lex-3]' => 1,
                                   '[Lex-40]' => 1,
                                   '[Lex-41]' => 1,
                                   '[Lex-42]' => 1,
                                   '[Lex-43]' => 1,
                                   '[Lex-44]' => 1,
                                   '[Lex-45]' => 1,
                                   '[Lex-46]' => 1,
                                   '[Lex-47]' => 1,
                                   '[Lex-48]' => 1,
                                   '[Lex-49]' => 1,
                                   '[Lex-4]' => 1,
                                   '[Lex-5]' => 1,
                                   '[Lex-6]' => 1,
                                   '[Lex-7]' => 1,
                                   '[Lex-8]' => 1,
                                   '[Lex-9]' => 1,
                                   'array descriptor' => 1,
                                   'bare name' => 1,
                                   'before or after' => 1,
                                   'boolean' => 1,
                                   'bracketed name' => 1,
                                   'character class' => 1,
                                   'op declare bnf' => 1,
                                   'op declare match' => 1,
                                   'op equal priority' => 1,
                                   'op loosen' => 1,
                                   'reserved action name' => 1,
                                   'reserved blessing name' => 1,
                                   'signed integer' => 1,
                                   'single quoted name' => 1,
                                   'single quoted string' => 1,
                                   'standard name' => 1
                                 },
                  'rules' => {
                               'G0' => [
                                         {
                                           'lhs' => 'Perl identifier',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'Perl name',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'Perl identifier'
                                                    ],
                                           'separator' => 'double colon'
                                         },
                                         {
                                           'description' => 'Discard rule for <hash comment>',
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'hash comment'
                                                    ]
                                         },
                                         {
                                           'description' => 'Discard rule for <whitespace>',
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'whitespace'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <Perl name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'Perl name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[:discard]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[:discard]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-0]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-0]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-10]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-10]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-11]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-11]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-12]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-12]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-13]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-13]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-14]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-14]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-15]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-15]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-16]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-16]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-17]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-17]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-18]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-18]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-19]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-19]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-1]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-1]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-20]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-20]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-21]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-21]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-22]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-22]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-23]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-23]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-24]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-24]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-25]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-25]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-26]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-26]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-27]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-27]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-28]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-28]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-29]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-29]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-2]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-2]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-30]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-30]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-31]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-31]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-32]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-32]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-33]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-33]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-34]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-34]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-35]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-35]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-36]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-36]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-37]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-37]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-38]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-38]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-39]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-39]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-3]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-3]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-40]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-40]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-41]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-41]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-42]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-42]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-43]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-43]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-44]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-44]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-45]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-45]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-46]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-46]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-47]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-47]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-48]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-48]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-49]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-49]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-4]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-4]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-5]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-5]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-6]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-6]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-7]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-7]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-8]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-8]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <[Lex-9]>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      '[Lex-9]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <array descriptor>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'array descriptor'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <bare name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'bare name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <before or after>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'before or after'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <boolean>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'boolean'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <bracketed name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'bracketed name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <character class>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'character class'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <op declare bnf>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <op declare match>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'op declare match'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <op equal priority>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'op equal priority'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <op loosen>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'op loosen'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <reserved action name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'reserved action name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <reserved blessing name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <signed integer>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'signed integer'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <single quoted name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <single quoted string>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'single quoted string'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal lexical start rule for <standard name>',
                                           'lhs' => '[:start_lex]',
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \';\'',
                                           'lhs' => '[Lex-0]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\;]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'completed\'',
                                           'lhs' => '[Lex-10]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[c]]',
                                                      '[[o]]',
                                                      '[[m]]',
                                                      '[[p]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-11]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-12]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'nulled\'',
                                           'lhs' => '[Lex-13]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-14]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-15]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'predicted\'',
                                           'lhs' => '[Lex-16]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[e]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'action\'',
                                           'lhs' => '[Lex-17]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-18]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-19]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':start\'',
                                           'lhs' => '[Lex-1]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-20]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'left\'',
                                           'lhs' => '[Lex-21]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-22]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-23]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'right\'',
                                           'lhs' => '[Lex-24]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-25]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-26]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'group\'',
                                           'lhs' => '[Lex-27]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[u]]',
                                                      '[[p]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'separator\'',
                                           'lhs' => '[Lex-28]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[e]]',
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[o]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-29]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':default\'',
                                           'lhs' => '[Lex-2]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'proper\'',
                                           'lhs' => '[Lex-30]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[p]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-31]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'rank\'',
                                           'lhs' => '[Lex-32]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-33]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'null-ranking\'',
                                           'lhs' => '[Lex-34]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[\\-]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]',
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[g]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-35]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'low\'',
                                           'lhs' => '[Lex-36]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[o]]',
                                                      '[[w]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'high\'',
                                           'lhs' => '[Lex-37]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[h]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'priority\'',
                                           'lhs' => '[Lex-38]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[t]]',
                                                      '[[y]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-39]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'lexeme\'',
                                           'lhs' => '[Lex-3]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'pause\'',
                                           'lhs' => '[Lex-40]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[s]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-41]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-42]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-43]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'bless\'',
                                           'lhs' => '[Lex-44]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-45]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'(\'',
                                           'lhs' => '[Lex-46]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\(]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \')\'',
                                           'lhs' => '[Lex-47]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\)]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'*\'',
                                           'lhs' => '[Lex-48]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\*]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'+\'',
                                           'lhs' => '[Lex-49]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\+]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'default\'',
                                           'lhs' => '[Lex-4]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-5]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':discard\'',
                                           'lhs' => '[Lex-6]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':lexeme\'',
                                           'lhs' => '[Lex-7]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-8]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-9]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'result item descriptor list',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bare name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[f]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'boolean',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[01]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bracketed name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\<]]',
                                                      'bracketed name string',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bracketed name string',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'escaped cc character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'negated posix char class'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'posix char class'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'safe cc character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc elements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'cc element'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'character class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'cc elements',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'double colon',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'escaped cc character',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\\\]]',
                                                      'horizontal character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'terminated hash comment'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'unterminated final hash comment'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment body',
                                           'min' => 0,
                                           'rhs' => [
                                                      'hash comment char'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment char',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'horizontal character',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'integer',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\d]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'negated posix char class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      '[[\\^]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'one or more word characters',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op declare bnf',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op declare match',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\~]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op equal priority',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\|]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op loosen',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\|]]',
                                                      '[[\\|]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'posix char class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'posix char class name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[[:alnum:]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'reserved action name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'reserved blessing name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor list',
                                           'min' => 0,
                                           'rhs' => [
                                                      'result item descriptor'
                                                    ],
                                           'separator' => '[[,]]'
                                         },
                                         {
                                           'lhs' => 'safe cc character',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'sign',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[+-]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'integer'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'sign',
                                                      'integer'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'single quoted name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'single quoted string',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'standard name',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a-zA-Z]]',
                                                      'zero or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'string without single quote or vertical space',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'terminated hash comment',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body',
                                                      'vertical space char'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'unterminated final hash comment',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'vertical space char',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'whitespace',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'zero or more word characters',
                                           'min' => 0,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         }
                                       ],
                               'G1' => [
                                         {
                                           'action' => '::first',
                                           'lhs' => '[:start]',
                                           'rhs' => [
                                                      'statements'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action',
                                           'lhs' => 'action',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-17]',
                                                      '[Lex-18]',
                                                      'action name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'Perl name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'array descriptor'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'reserved action name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'action'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'blessing'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'event specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'group association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'left association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'null ranking specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'pause specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'priority specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'proper specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'rank specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'right association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'separator specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_list',
                                           'lhs' => 'adverb list',
                                           'min' => 0,
                                           'rhs' => [
                                                      'adverb item'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternative',
                                           'lhs' => 'alternative',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'rhs',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternatives',
                                           'lhs' => 'alternatives',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternative'
                                                    ],
                                           'separator' => 'op equal priority'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing',
                                           'lhs' => 'blessing',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-44]',
                                                      '[Lex-45]',
                                                      'blessing name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing_name',
                                           'lhs' => 'blessing name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing_name',
                                           'lhs' => 'blessing name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'completion_event_declaration',
                                           'lhs' => 'completion event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-8]',
                                                      'event name',
                                                      '[Lex-9]',
                                                      '[Lex-10]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'default_rule',
                                           'lhs' => 'default rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-2]',
                                                      'op declare bnf',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'discard_rule',
                                           'lhs' => 'discard rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-6]',
                                                      'op declare match',
                                                      'single symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'empty_rule',
                                           'lhs' => 'empty rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_name',
                                           'lhs' => 'event name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'single quoted name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_name',
                                           'lhs' => 'event name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_specification',
                                           'lhs' => 'event specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-42]',
                                                      '[Lex-43]',
                                                      'event name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'group_association',
                                           'lhs' => 'group association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'rhs' => [
                                                      '[Lex-25]',
                                                      '[Lex-26]',
                                                      '[Lex-27]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'left_association',
                                           'lhs' => 'left association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'rhs' => [
                                                      '[Lex-19]',
                                                      '[Lex-20]',
                                                      '[Lex-21]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexeme_default_statement',
                                           'lhs' => 'lexeme default statement',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-3]',
                                                      '[Lex-4]',
                                                      '[Lex-5]',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexeme_rule',
                                           'lhs' => 'lexeme rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-7]',
                                                      'op declare match',
                                                      'symbol',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lhs',
                                           'lhs' => 'lhs',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_constant',
                                           'lhs' => 'null ranking constant',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-36]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_constant',
                                           'lhs' => 'null ranking constant',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-37]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_specification',
                                           'lhs' => 'null ranking specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-34]',
                                                      '[Lex-35]',
                                                      'null ranking constant'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'nulled_event_declaration',
                                           'lhs' => 'nulled event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-11]',
                                                      'event name',
                                                      '[Lex-12]',
                                                      '[Lex-13]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'op_declare',
                                           'lhs' => 'op declare',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'op_declare',
                                           'lhs' => 'op declare',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'op declare match'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'parenthesized_rhs_primary_list',
                                           'lhs' => 'parenthesized rhs primary list',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0
                                                     ],
                                           'rhs' => [
                                                      '[Lex-46]',
                                                      'rhs primary list',
                                                      '[Lex-47]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'pause_specification',
                                           'lhs' => 'pause specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-40]',
                                                      '[Lex-41]',
                                                      'before or after'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'prediction_event_declaration',
                                           'lhs' => 'prediction event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'event name',
                                                      '[Lex-15]',
                                                      '[Lex-16]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priorities',
                                           'lhs' => 'priorities',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternatives'
                                                    ],
                                           'separator' => 'op loosen'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priority_rule',
                                           'lhs' => 'priority rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'priorities'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priority_specification',
                                           'lhs' => 'priority specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-38]',
                                                      '[Lex-39]',
                                                      'signed integer'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'proper_specification',
                                           'lhs' => 'proper specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-30]',
                                                      '[Lex-31]',
                                                      'boolean'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantified_rule',
                                           'lhs' => 'quantified rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'single symbol',
                                                      'quantifier',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantifier',
                                           'lhs' => 'quantifier',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-48]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantifier',
                                           'lhs' => 'quantifier',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-49]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rank_specification',
                                           'lhs' => 'rank specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-32]',
                                                      '[Lex-33]',
                                                      'signed integer'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs',
                                           'lhs' => 'rhs',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'parenthesized rhs primary list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'single quoted string'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'single symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary_list',
                                           'lhs' => 'rhs primary list',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'right_association',
                                           'lhs' => 'right association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'rhs' => [
                                                      '[Lex-22]',
                                                      '[Lex-23]',
                                                      '[Lex-24]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'separator_specification',
                                           'lhs' => 'separator specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-28]',
                                                      '[Lex-29]',
                                                      'single symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'single_symbol',
                                           'lhs' => 'single symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'character class'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'single_symbol',
                                           'lhs' => 'single symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'start_rule',
                                           'lhs' => 'start rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[Lex-1]',
                                                      'op declare bnf',
                                                      'symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'statement body'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'statement body',
                                                      '[Lex-0]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'completion event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'default rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'discard rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'empty rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'lexeme default statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'lexeme rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'nulled event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'prediction event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'priority rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'quantified rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_body',
                                           'lhs' => 'statement body',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'start rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statements',
                                           'lhs' => 'statements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol',
                                           'lhs' => 'symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol_name',
                                           'lhs' => 'symbol name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'bare name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol_name',
                                           'lhs' => 'symbol name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'bracketed name'
                                                    ]
                                         }
                                       ]
                             },
                  'symbols' => {
                                 'G0' => {
                                           '[:discard]' => {
                                                             'description' => 'Internal LHS for G0 discard',
                                                             'display_form' => ':discard'
                                                           },
                                           '[:start_lex]' => {
                                                               'description' => 'Internal G0 (lexical) start symbol',
                                                               'display_form' => ':start_lex'
                                                             },
                                           '[Lex-0]' => {
                                                          'description' => 'Internal lexical symbol for "\';\'"',
                                                          'display_form' => '\';\'',
                                                          'dsl_form' => '\';\''
                                                        },
                                           '[Lex-10]' => {
                                                           'description' => 'Internal lexical symbol for "\'completed\'"',
                                                           'display_form' => '\'completed\'',
                                                           'dsl_form' => '\'completed\''
                                                         },
                                           '[Lex-11]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-12]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-13]' => {
                                                           'description' => 'Internal lexical symbol for "\'nulled\'"',
                                                           'display_form' => '\'nulled\'',
                                                           'dsl_form' => '\'nulled\''
                                                         },
                                           '[Lex-14]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-15]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-16]' => {
                                                           'description' => 'Internal lexical symbol for "\'predicted\'"',
                                                           'display_form' => '\'predicted\'',
                                                           'dsl_form' => '\'predicted\''
                                                         },
                                           '[Lex-17]' => {
                                                           'description' => 'Internal lexical symbol for "\'action\'"',
                                                           'display_form' => '\'action\'',
                                                           'dsl_form' => '\'action\''
                                                         },
                                           '[Lex-18]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-19]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-1]' => {
                                                          'description' => 'Internal lexical symbol for "\':start\'"',
                                                          'display_form' => '\':start\'',
                                                          'dsl_form' => '\':start\''
                                                        },
                                           '[Lex-20]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-21]' => {
                                                           'description' => 'Internal lexical symbol for "\'left\'"',
                                                           'display_form' => '\'left\'',
                                                           'dsl_form' => '\'left\''
                                                         },
                                           '[Lex-22]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-23]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-24]' => {
                                                           'description' => 'Internal lexical symbol for "\'right\'"',
                                                           'display_form' => '\'right\'',
                                                           'dsl_form' => '\'right\''
                                                         },
                                           '[Lex-25]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-26]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-27]' => {
                                                           'description' => 'Internal lexical symbol for "\'group\'"',
                                                           'display_form' => '\'group\'',
                                                           'dsl_form' => '\'group\''
                                                         },
                                           '[Lex-28]' => {
                                                           'description' => 'Internal lexical symbol for "\'separator\'"',
                                                           'display_form' => '\'separator\'',
                                                           'dsl_form' => '\'separator\''
                                                         },
                                           '[Lex-29]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-2]' => {
                                                          'description' => 'Internal lexical symbol for "\':default\'"',
                                                          'display_form' => '\':default\'',
                                                          'dsl_form' => '\':default\''
                                                        },
                                           '[Lex-30]' => {
                                                           'description' => 'Internal lexical symbol for "\'proper\'"',
                                                           'display_form' => '\'proper\'',
                                                           'dsl_form' => '\'proper\''
                                                         },
                                           '[Lex-31]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-32]' => {
                                                           'description' => 'Internal lexical symbol for "\'rank\'"',
                                                           'display_form' => '\'rank\'',
                                                           'dsl_form' => '\'rank\''
                                                         },
                                           '[Lex-33]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-34]' => {
                                                           'description' => 'Internal lexical symbol for "\'null-ranking\'"',
                                                           'display_form' => '\'null-ranking\'',
                                                           'dsl_form' => '\'null-ranking\''
                                                         },
                                           '[Lex-35]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-36]' => {
                                                           'description' => 'Internal lexical symbol for "\'low\'"',
                                                           'display_form' => '\'low\'',
                                                           'dsl_form' => '\'low\''
                                                         },
                                           '[Lex-37]' => {
                                                           'description' => 'Internal lexical symbol for "\'high\'"',
                                                           'display_form' => '\'high\'',
                                                           'dsl_form' => '\'high\''
                                                         },
                                           '[Lex-38]' => {
                                                           'description' => 'Internal lexical symbol for "\'priority\'"',
                                                           'display_form' => '\'priority\'',
                                                           'dsl_form' => '\'priority\''
                                                         },
                                           '[Lex-39]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-3]' => {
                                                          'description' => 'Internal lexical symbol for "\'lexeme\'"',
                                                          'display_form' => '\'lexeme\'',
                                                          'dsl_form' => '\'lexeme\''
                                                        },
                                           '[Lex-40]' => {
                                                           'description' => 'Internal lexical symbol for "\'pause\'"',
                                                           'display_form' => '\'pause\'',
                                                           'dsl_form' => '\'pause\''
                                                         },
                                           '[Lex-41]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-42]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-43]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-44]' => {
                                                           'description' => 'Internal lexical symbol for "\'bless\'"',
                                                           'display_form' => '\'bless\'',
                                                           'dsl_form' => '\'bless\''
                                                         },
                                           '[Lex-45]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-46]' => {
                                                           'description' => 'Internal lexical symbol for "\'(\'"',
                                                           'display_form' => '\'(\'',
                                                           'dsl_form' => '\'(\''
                                                         },
                                           '[Lex-47]' => {
                                                           'description' => 'Internal lexical symbol for "\')\'"',
                                                           'display_form' => '\')\'',
                                                           'dsl_form' => '\')\''
                                                         },
                                           '[Lex-48]' => {
                                                           'description' => 'Internal lexical symbol for "\'*\'"',
                                                           'display_form' => '\'*\'',
                                                           'dsl_form' => '\'*\''
                                                         },
                                           '[Lex-49]' => {
                                                           'description' => 'Internal lexical symbol for "\'+\'"',
                                                           'display_form' => '\'+\'',
                                                           'dsl_form' => '\'+\''
                                                         },
                                           '[Lex-4]' => {
                                                          'description' => 'Internal lexical symbol for "\'default\'"',
                                                          'display_form' => '\'default\'',
                                                          'dsl_form' => '\'default\''
                                                        },
                                           '[Lex-5]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                           '[Lex-6]' => {
                                                          'description' => 'Internal lexical symbol for "\':discard\'"',
                                                          'display_form' => '\':discard\'',
                                                          'dsl_form' => '\':discard\''
                                                        },
                                           '[Lex-7]' => {
                                                          'description' => 'Internal lexical symbol for "\':lexeme\'"',
                                                          'display_form' => '\':lexeme\'',
                                                          'dsl_form' => '\':lexeme\''
                                                        },
                                           '[Lex-8]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                           '[Lex-9]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                           '[[\']]' => {
                                                         'description' => 'Character class: [\']',
                                                         'display_form' => '[\']',
                                                         'dsl_form' => '[\']'
                                                       },
                                           '[[+-]]' => {
                                                         'description' => 'Character class: [+-]',
                                                         'display_form' => '[+-]',
                                                         'dsl_form' => '[+-]'
                                                       },
                                           '[[,]]' => {
                                                        'description' => 'Character class: [,]',
                                                        'display_form' => '[,]',
                                                        'dsl_form' => '[,]'
                                                      },
                                           '[[01]]' => {
                                                         'description' => 'Character class: [01]',
                                                         'display_form' => '[01]',
                                                         'dsl_form' => '[01]'
                                                       },
                                           '[[[:alnum:]]]' => {
                                                                'description' => 'Character class: [[:alnum:]]',
                                                                'display_form' => '[[:alnum:]]',
                                                                'dsl_form' => '[[:alnum:]]'
                                                              },
                                           '[[\\#]]' => {
                                                          'description' => 'Character class: [\\#]',
                                                          'display_form' => '[\\#]',
                                                          'dsl_form' => '[\\#]'
                                                        },
                                           '[[\\(]]' => {
                                                          'description' => 'Character class: [\\(]',
                                                          'display_form' => '[\\(]',
                                                          'dsl_form' => '[\\(]'
                                                        },
                                           '[[\\)]]' => {
                                                          'description' => 'Character class: [\\)]',
                                                          'display_form' => '[\\)]',
                                                          'dsl_form' => '[\\)]'
                                                        },
                                           '[[\\*]]' => {
                                                          'description' => 'Character class: [\\*]',
                                                          'display_form' => '[\\*]',
                                                          'dsl_form' => '[\\*]'
                                                        },
                                           '[[\\+]]' => {
                                                          'description' => 'Character class: [\\+]',
                                                          'display_form' => '[\\+]',
                                                          'dsl_form' => '[\\+]'
                                                        },
                                           '[[\\-]]' => {
                                                          'description' => 'Character class: [\\-]',
                                                          'display_form' => '[\\-]',
                                                          'dsl_form' => '[\\-]'
                                                        },
                                           '[[\\:]]' => {
                                                          'description' => 'Character class: [\\:]',
                                                          'display_form' => '[\\:]',
                                                          'dsl_form' => '[\\:]'
                                                        },
                                           '[[\\;]]' => {
                                                          'description' => 'Character class: [\\;]',
                                                          'display_form' => '[\\;]',
                                                          'dsl_form' => '[\\;]'
                                                        },
                                           '[[\\<]]' => {
                                                          'description' => 'Character class: [\\<]',
                                                          'display_form' => '[\\<]',
                                                          'dsl_form' => '[\\<]'
                                                        },
                                           '[[\\=]]' => {
                                                          'description' => 'Character class: [\\=]',
                                                          'display_form' => '[\\=]',
                                                          'dsl_form' => '[\\=]'
                                                        },
                                           '[[\\>]]' => {
                                                          'description' => 'Character class: [\\>]',
                                                          'display_form' => '[\\>]',
                                                          'dsl_form' => '[\\>]'
                                                        },
                                           '[[\\[]]' => {
                                                          'description' => 'Character class: [\\[]',
                                                          'display_form' => '[\\[]',
                                                          'dsl_form' => '[\\[]'
                                                        },
                                           '[[\\\\]]' => {
                                                           'description' => 'Character class: [\\\\]',
                                                           'display_form' => '[\\\\]',
                                                           'dsl_form' => '[\\\\]'
                                                         },
                                           '[[\\]]]' => {
                                                          'description' => 'Character class: [\\]]',
                                                          'display_form' => '[\\]]',
                                                          'dsl_form' => '[\\]]'
                                                        },
                                           '[[\\^]]' => {
                                                          'description' => 'Character class: [\\^]',
                                                          'display_form' => '[\\^]',
                                                          'dsl_form' => '[\\^]'
                                                        },
                                           '[[\\d]]' => {
                                                          'description' => 'Character class: [\\d]',
                                                          'display_form' => '[\\d]',
                                                          'dsl_form' => '[\\d]'
                                                        },
                                           '[[\\s\\w]]' => {
                                                             'description' => 'Character class: [\\s\\w]',
                                                             'display_form' => '[\\s\\w]',
                                                             'dsl_form' => '[\\s\\w]'
                                                           },
                                           '[[\\s]]' => {
                                                          'description' => 'Character class: [\\s]',
                                                          'display_form' => '[\\s]',
                                                          'dsl_form' => '[\\s]'
                                                        },
                                           '[[\\w]]' => {
                                                          'description' => 'Character class: [\\w]',
                                                          'display_form' => '[\\w]',
                                                          'dsl_form' => '[\\w]'
                                                        },
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                 'description' => 'Character class: [\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 'display_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 'dsl_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]'
                                                                                               },
                                           '[[\\|]]' => {
                                                          'description' => 'Character class: [\\|]',
                                                          'display_form' => '[\\|]',
                                                          'dsl_form' => '[\\|]'
                                                        },
                                           '[[\\~]]' => {
                                                          'description' => 'Character class: [\\~]',
                                                          'display_form' => '[\\~]',
                                                          'dsl_form' => '[\\~]'
                                                        },
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                 'description' => 'Character class: [^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                 'display_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                 'dsl_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]'
                                                                                                               },
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                      'description' => 'Character class: [^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                      'display_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                      'dsl_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]'
                                                                                                                    },
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                  'description' => 'Character class: [^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                  'display_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                  'dsl_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]'
                                                                                                },
                                           '[[a-zA-Z]]' => {
                                                             'description' => 'Character class: [a-zA-Z]',
                                                             'display_form' => '[a-zA-Z]',
                                                             'dsl_form' => '[a-zA-Z]'
                                                           },
                                           '[[a]]' => {
                                                        'description' => 'Character class: [a]',
                                                        'display_form' => '[a]',
                                                        'dsl_form' => '[a]'
                                                      },
                                           '[[b]]' => {
                                                        'description' => 'Character class: [b]',
                                                        'display_form' => '[b]',
                                                        'dsl_form' => '[b]'
                                                      },
                                           '[[c]]' => {
                                                        'description' => 'Character class: [c]',
                                                        'display_form' => '[c]',
                                                        'dsl_form' => '[c]'
                                                      },
                                           '[[d]]' => {
                                                        'description' => 'Character class: [d]',
                                                        'display_form' => '[d]',
                                                        'dsl_form' => '[d]'
                                                      },
                                           '[[e]]' => {
                                                        'description' => 'Character class: [e]',
                                                        'display_form' => '[e]',
                                                        'dsl_form' => '[e]'
                                                      },
                                           '[[f]]' => {
                                                        'description' => 'Character class: [f]',
                                                        'display_form' => '[f]',
                                                        'dsl_form' => '[f]'
                                                      },
                                           '[[g]]' => {
                                                        'description' => 'Character class: [g]',
                                                        'display_form' => '[g]',
                                                        'dsl_form' => '[g]'
                                                      },
                                           '[[h]]' => {
                                                        'description' => 'Character class: [h]',
                                                        'display_form' => '[h]',
                                                        'dsl_form' => '[h]'
                                                      },
                                           '[[i]]' => {
                                                        'description' => 'Character class: [i]',
                                                        'display_form' => '[i]',
                                                        'dsl_form' => '[i]'
                                                      },
                                           '[[k]]' => {
                                                        'description' => 'Character class: [k]',
                                                        'display_form' => '[k]',
                                                        'dsl_form' => '[k]'
                                                      },
                                           '[[l]]' => {
                                                        'description' => 'Character class: [l]',
                                                        'display_form' => '[l]',
                                                        'dsl_form' => '[l]'
                                                      },
                                           '[[m]]' => {
                                                        'description' => 'Character class: [m]',
                                                        'display_form' => '[m]',
                                                        'dsl_form' => '[m]'
                                                      },
                                           '[[n]]' => {
                                                        'description' => 'Character class: [n]',
                                                        'display_form' => '[n]',
                                                        'dsl_form' => '[n]'
                                                      },
                                           '[[o]]' => {
                                                        'description' => 'Character class: [o]',
                                                        'display_form' => '[o]',
                                                        'dsl_form' => '[o]'
                                                      },
                                           '[[p]]' => {
                                                        'description' => 'Character class: [p]',
                                                        'display_form' => '[p]',
                                                        'dsl_form' => '[p]'
                                                      },
                                           '[[r]]' => {
                                                        'description' => 'Character class: [r]',
                                                        'display_form' => '[r]',
                                                        'dsl_form' => '[r]'
                                                      },
                                           '[[s]]' => {
                                                        'description' => 'Character class: [s]',
                                                        'display_form' => '[s]',
                                                        'dsl_form' => '[s]'
                                                      },
                                           '[[t]]' => {
                                                        'description' => 'Character class: [t]',
                                                        'display_form' => '[t]',
                                                        'dsl_form' => '[t]'
                                                      },
                                           '[[u]]' => {
                                                        'description' => 'Character class: [u]',
                                                        'display_form' => '[u]',
                                                        'dsl_form' => '[u]'
                                                      },
                                           '[[v]]' => {
                                                        'description' => 'Character class: [v]',
                                                        'display_form' => '[v]',
                                                        'dsl_form' => '[v]'
                                                      },
                                           '[[w]]' => {
                                                        'description' => 'Character class: [w]',
                                                        'display_form' => '[w]',
                                                        'dsl_form' => '[w]'
                                                      },
                                           '[[x]]' => {
                                                        'description' => 'Character class: [x]',
                                                        'display_form' => '[x]',
                                                        'dsl_form' => '[x]'
                                                      },
                                           '[[y]]' => {
                                                        'description' => 'Character class: [y]',
                                                        'display_form' => '[y]',
                                                        'dsl_form' => '[y]'
                                                      }
                                         },
                                 'G1' => {
                                           'Perl name' => {
                                                            'bless' => 'Perl_name',
                                                            'semantics' => '[start,length,value]'
                                                          },
                                           '[:start]' => {
                                                           'description' => 'Internal G1 start symbol',
                                                           'display_form' => ':start'
                                                         },
                                           '[Lex-0]' => {
                                                          'description' => 'Internal lexical symbol for "\';\'"',
                                                          'display_form' => '\';\'',
                                                          'dsl_form' => '\';\''
                                                        },
                                           '[Lex-10]' => {
                                                           'description' => 'Internal lexical symbol for "\'completed\'"',
                                                           'display_form' => '\'completed\'',
                                                           'dsl_form' => '\'completed\''
                                                         },
                                           '[Lex-11]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-12]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-13]' => {
                                                           'description' => 'Internal lexical symbol for "\'nulled\'"',
                                                           'display_form' => '\'nulled\'',
                                                           'dsl_form' => '\'nulled\''
                                                         },
                                           '[Lex-14]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-15]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-16]' => {
                                                           'description' => 'Internal lexical symbol for "\'predicted\'"',
                                                           'display_form' => '\'predicted\'',
                                                           'dsl_form' => '\'predicted\''
                                                         },
                                           '[Lex-17]' => {
                                                           'description' => 'Internal lexical symbol for "\'action\'"',
                                                           'display_form' => '\'action\'',
                                                           'dsl_form' => '\'action\''
                                                         },
                                           '[Lex-18]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-19]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-1]' => {
                                                          'description' => 'Internal lexical symbol for "\':start\'"',
                                                          'display_form' => '\':start\'',
                                                          'dsl_form' => '\':start\''
                                                        },
                                           '[Lex-20]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-21]' => {
                                                           'description' => 'Internal lexical symbol for "\'left\'"',
                                                           'display_form' => '\'left\'',
                                                           'dsl_form' => '\'left\''
                                                         },
                                           '[Lex-22]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-23]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-24]' => {
                                                           'description' => 'Internal lexical symbol for "\'right\'"',
                                                           'display_form' => '\'right\'',
                                                           'dsl_form' => '\'right\''
                                                         },
                                           '[Lex-25]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-26]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-27]' => {
                                                           'description' => 'Internal lexical symbol for "\'group\'"',
                                                           'display_form' => '\'group\'',
                                                           'dsl_form' => '\'group\''
                                                         },
                                           '[Lex-28]' => {
                                                           'description' => 'Internal lexical symbol for "\'separator\'"',
                                                           'display_form' => '\'separator\'',
                                                           'dsl_form' => '\'separator\''
                                                         },
                                           '[Lex-29]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-2]' => {
                                                          'description' => 'Internal lexical symbol for "\':default\'"',
                                                          'display_form' => '\':default\'',
                                                          'dsl_form' => '\':default\''
                                                        },
                                           '[Lex-30]' => {
                                                           'description' => 'Internal lexical symbol for "\'proper\'"',
                                                           'display_form' => '\'proper\'',
                                                           'dsl_form' => '\'proper\''
                                                         },
                                           '[Lex-31]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-32]' => {
                                                           'description' => 'Internal lexical symbol for "\'rank\'"',
                                                           'display_form' => '\'rank\'',
                                                           'dsl_form' => '\'rank\''
                                                         },
                                           '[Lex-33]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-34]' => {
                                                           'description' => 'Internal lexical symbol for "\'null-ranking\'"',
                                                           'display_form' => '\'null-ranking\'',
                                                           'dsl_form' => '\'null-ranking\''
                                                         },
                                           '[Lex-35]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-36]' => {
                                                           'description' => 'Internal lexical symbol for "\'low\'"',
                                                           'display_form' => '\'low\'',
                                                           'dsl_form' => '\'low\''
                                                         },
                                           '[Lex-37]' => {
                                                           'description' => 'Internal lexical symbol for "\'high\'"',
                                                           'display_form' => '\'high\'',
                                                           'dsl_form' => '\'high\''
                                                         },
                                           '[Lex-38]' => {
                                                           'description' => 'Internal lexical symbol for "\'priority\'"',
                                                           'display_form' => '\'priority\'',
                                                           'dsl_form' => '\'priority\''
                                                         },
                                           '[Lex-39]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-3]' => {
                                                          'description' => 'Internal lexical symbol for "\'lexeme\'"',
                                                          'display_form' => '\'lexeme\'',
                                                          'dsl_form' => '\'lexeme\''
                                                        },
                                           '[Lex-40]' => {
                                                           'description' => 'Internal lexical symbol for "\'pause\'"',
                                                           'display_form' => '\'pause\'',
                                                           'dsl_form' => '\'pause\''
                                                         },
                                           '[Lex-41]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-42]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-43]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-44]' => {
                                                           'description' => 'Internal lexical symbol for "\'bless\'"',
                                                           'display_form' => '\'bless\'',
                                                           'dsl_form' => '\'bless\''
                                                         },
                                           '[Lex-45]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-46]' => {
                                                           'description' => 'Internal lexical symbol for "\'(\'"',
                                                           'display_form' => '\'(\'',
                                                           'dsl_form' => '\'(\''
                                                         },
                                           '[Lex-47]' => {
                                                           'description' => 'Internal lexical symbol for "\')\'"',
                                                           'display_form' => '\')\'',
                                                           'dsl_form' => '\')\''
                                                         },
                                           '[Lex-48]' => {
                                                           'description' => 'Internal lexical symbol for "\'*\'"',
                                                           'display_form' => '\'*\'',
                                                           'dsl_form' => '\'*\''
                                                         },
                                           '[Lex-49]' => {
                                                           'description' => 'Internal lexical symbol for "\'+\'"',
                                                           'display_form' => '\'+\'',
                                                           'dsl_form' => '\'+\''
                                                         },
                                           '[Lex-4]' => {
                                                          'description' => 'Internal lexical symbol for "\'default\'"',
                                                          'display_form' => '\'default\'',
                                                          'dsl_form' => '\'default\''
                                                        },
                                           '[Lex-5]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                           '[Lex-6]' => {
                                                          'description' => 'Internal lexical symbol for "\':discard\'"',
                                                          'display_form' => '\':discard\'',
                                                          'dsl_form' => '\':discard\''
                                                        },
                                           '[Lex-7]' => {
                                                          'description' => 'Internal lexical symbol for "\':lexeme\'"',
                                                          'display_form' => '\':lexeme\'',
                                                          'dsl_form' => '\':lexeme\''
                                                        },
                                           '[Lex-8]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                           '[Lex-9]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                           'array descriptor' => {
                                                                   'bless' => 'array_descriptor',
                                                                   'semantics' => '[start,length,value]'
                                                                 },
                                           'bare name' => {
                                                            'bless' => 'bare_name',
                                                            'semantics' => '[start,length,value]'
                                                          },
                                           'before or after' => {
                                                                  'bless' => 'before_or_after',
                                                                  'semantics' => '[start,length,value]'
                                                                },
                                           'boolean' => {
                                                          'bless' => 'boolean',
                                                          'semantics' => '[start,length,value]'
                                                        },
                                           'bracketed name' => {
                                                                 'bless' => 'bracketed_name',
                                                                 'semantics' => '[start,length,value]'
                                                               },
                                           'character class' => {
                                                                  'bless' => 'character_class',
                                                                  'semantics' => '[start,length,value]'
                                                                },
                                           'op declare bnf' => {
                                                                 'bless' => 'op_declare_bnf',
                                                                 'semantics' => '[start,length,value]'
                                                               },
                                           'op declare match' => {
                                                                   'bless' => 'op_declare_match',
                                                                   'semantics' => '[start,length,value]'
                                                                 },
                                           'op equal priority' => {
                                                                    'bless' => 'op_equal_priority',
                                                                    'semantics' => '[start,length,value]'
                                                                  },
                                           'op loosen' => {
                                                            'bless' => 'op_loosen',
                                                            'semantics' => '[start,length,value]'
                                                          },
                                           'reserved action name' => {
                                                                       'bless' => 'reserved_action_name',
                                                                       'semantics' => '[start,length,value]'
                                                                     },
                                           'reserved blessing name' => {
                                                                         'bless' => 'reserved_blessing_name',
                                                                         'semantics' => '[start,length,value]'
                                                                       },
                                           'signed integer' => {
                                                                 'bless' => 'signed_integer',
                                                                 'semantics' => '[start,length,value]'
                                                               },
                                           'single quoted name' => {
                                                                     'bless' => 'single_quoted_name',
                                                                     'semantics' => '[start,length,value]'
                                                                   },
                                           'single quoted string' => {
                                                                       'bless' => 'single_quoted_string',
                                                                       'semantics' => '[start,length,value]'
                                                                     },
                                           'standard name' => {
                                                                'bless' => 'standard_name',
                                                                'semantics' => '[start,length,value]'
                                                              }
                                         }
                               }
                };
## The code before this line was automatically generated by sl_to_hash.pl

##use critic

    return $hashed_metag;

} ## end sub meta_grammar

1;

# vim: expandtab shiftwidth=4:
