package Business::EDI::CodeList::DateOrTimeOrPeriodFunctionCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {2005;}
my $usage       = 'C';

# 2005  Date or time or period function code qualifier          [C]
# Desc: Code qualifying the function of a date, time or
# period.
# Repr: an..3

my %code_hash = (
'1' => [ 'Service completion date/time, actual',
    'Actual date/time on which the service was completed.' ],
'2' => [ 'Delivery date/time, requested',
    'Date on which buyer requests goods to be delivered.' ],
'3' => [ 'Invoice document issue date time',
    '[2377] Date of issue of an invoice.' ],
'4' => [ 'Order document issue date time',
    '[2011] Date of order.' ],
'5' => [ 'Saleable stock demand cover period, expected',
    'A period of time when saleable stocks are expected to cover demand for a product.' ],
'6' => [ 'Moved from location date',
    'The date an entity moved from a location.' ],
'7' => [ 'Effective from date/time',
    '(2069) Date and/or time at which specified event or document becomes effective.' ],
'8' => [ 'Order received date/time',
    'Date/time when the purchase order is received by the seller.' ],
'9' => [ 'Processing date/time',
    'Date/time of processing.' ],
'10' => [ 'Shipment date/time, requested',
    'Date on which goods should be shipped or despatched by the supplier.' ],
'11' => [ 'Despatch date and or time',
    '(2170) Date/time on which the goods are or are expected to be despatched or shipped.' ],
'12' => [ 'Terms discount due date/time',
    'Date by which payment should be made if discount terms are to apply.' ],
'13' => [ 'Terms net due date',
    'Date by which payment must be made.' ],
'14' => [ 'Payment date/time, deferred',
    'Date/time when instalments are due.' ],
'15' => [ 'Promotion start date/time',
    'Date/time when promotion activities begin.' ],
'16' => [ 'Promotion end date/time',
    'Date/time when promotion activities end.' ],
'17' => [ 'Delivery date/time, estimated',
    'Date and/or time when the shipper of the goods expects delivery will take place.' ],
'18' => [ 'Installation date/time/period',
    'The date/time/period of the act, or an instance of installing something or someone.' ],
'19' => [ 'Meat ageing period',
    'Period of time between slaughter and delivery during which meat is ageing.' ],
'20' => [ 'Cheque date/time',
    'Date/time when cheque is issued.' ],
'21' => [ 'Charge back date/time',
    'The date/time of the charge back.' ],
'22' => [ 'Freight bill date/time',
    'Date/time when freight bill is issued.' ],
'23' => [ 'Equipment reconditioning date/time, actual',
    'Actual date/time of the reconditioning of a piece of equipment.' ],
'24' => [ 'Transfer note acceptance date and time',
    'Date and time when a transfer note (transfer document for transport exclusively using containers as equipment) is recognised as being valid by the carrier.' ],
'35' => [ 'Delivery date/time, actual',
    'Date/time on which goods or consignment are delivered at their destination.' ],
'36' => [ 'Expiry date',
    'Date of expiry of the validity of a referenced document, price information or any other referenced data element with a limited validity period.' ],
'37' => [ 'Ship not before date/time',
    'Goods should not be shipped before given date/time.' ],
'38' => [ 'Ship not later than date/time',
    'Date/time by which the goods should have been shipped.' ],
'39' => [ 'Ship week of date',
    'Date identifying the week during which goods should be shipped.' ],
'40' => [ 'Clinical information issue date and/or time',
    'Date and/or time when clinical information is issued.' ],
'41' => [ 'Event duration, expected',
    'The expected duration of an event.' ],
'42' => [ 'Superseded date/time',
    'Date/time being overlaid by a date given elsewhere.' ],
'43' => [ 'Event duration, intended',
    'The intended duration of an event.' ],
'44' => [ 'Availability',
    'Date/time when received item is available.' ],
'45' => [ 'Compilation date and time',
    'Date and time of the compilation.' ],
'46' => [ 'Cancellation date',
    'Date on which a document or message has been cancelled.' ],
'47' => [ 'Statistical time series date',
    'Date for statistical time series purposes.' ],
'48' => [ 'Duration',
    'Duration.' ],
'49' => [ 'Deliver not before and not after dates',
    'Deliver not before and not after a specific date range.' ],
'50' => [ 'Goods receipt date/time',
    'Date/time upon which the goods were received by a given party.' ],
'51' => [ 'Cumulative quantity start date',
    'First Date for accumulation of delivery quantities.' ],
'52' => [ 'Cumulative quantity end date',
    'Last Date for accumulation of delivery quantities.' ],
'53' => [ "Buyer's local time",
    "Time at the buyer's location." ],
'54' => [ "Seller's local time",
    "Time at the seller's location." ],
'55' => [ 'Confirmed date/time',
    'Date/time which has been confirmed.' ],
'56' => [ 'Original authorisation date and/or time',
    'Date and/or time when original authorisation was issued.' ],
'57' => [ 'Precaution relevant period',
    'The period when a precaution is relevant.' ],
'58' => [ 'Clearance date (Customs)',
    'Date on which Customs formalities necessary to allow goods to be exported, to enter home use, or to be placed under another Customs procedure has been accomplished (CCC).' ],
'59' => [ 'Inbound movement authorization date',
    'Inland movement authorization date.' ],
'60' => [ 'Engineering change level date',
    'Date the engineering level of goods is changed.' ],
'61' => [ 'Cancel if not delivered by this date',
    'The date on which cancellation should take place, if delivery has not occurred.' ],
'62' => [ 'Excluded date',
    'Date excluded from a period of time.' ],
'63' => [ 'Delivery date time, last',
    '[2025] Last date, and optionally time of a delivery.' ],
'64' => [ 'Delivery date/time, earliest',
    'Date identifying a point in time before which the goods shall not be delivered.' ],
'65' => [ 'Delivery date/time, 1st schedule',
    'The first scheduled date/time for delivery.' ],
'66' => [ 'Excluded period',
    'An interval of time excluded from a period of time.' ],
'67' => [ 'Delivery date/time, current schedule',
    'Delivery Date deriving from actual schedule.' ],
'68' => [ 'Additional period',
    'An interval of time added to a period of time.' ],
'69' => [ 'Delivery date time, promised before',
    '[2139] Date and optionally time by which the merchandise should be delivered to the buyer, as agreed between the seller and the buyer (generic term).' ],
'70' => [ 'Additional date',
    'Date added to a period of time.' ],
'71' => [ 'Delivery date/time, requested for (after and including)',
    'Delivery is requested to happen after or on given date.' ],
'72' => [ 'Delivery date/time, promised for (after and including)',
    'Delivery might take place earliest at given date.' ],
'73' => [ 'Guarantee period',
    'The period for which the guarantee is or will be granted.' ],
'74' => [ 'Delivery date/time, requested for (prior to and including)',
    'Delivery is requested to happen prior to or including the given date.' ],
'75' => [ 'Delivery date/time, promised for (prior to and including)',
    'Delivery might take place latest at given date.' ],
'76' => [ 'Delivery date/time, scheduled for',
    'The date/time for which delivery is scheduled.' ],
'77' => [ 'Specification revision date',
    'Date of revision to a specification.' ],
'78' => [ 'Event date/time/period, actual',
    'The actual date/time/period an event occurred.' ],
'79' => [ 'Shipment date/time, promised for',
    'Shipment might happen at given date/time.' ],
'80' => [ 'Planning end date and/or time, actual',
    'The actual date and/or time the planning ended.' ],
'81' => [ 'Shipment date/time, requested for (after and including)',
    'Shipment should happen earliest at given date.' ],
'82' => [ 'Medicine administration time',
    'Designated time of day for the administration of medicine.' ],
'83' => [ 'Dispensing interval, minimum',
    'The shortest interval allowed between one dispensing of an item and the next dispensing of the same item.' ],
'84' => [ 'Shipment date/time, requested for (prior to and including)',
    'Shipment should take place latest at given date.' ],
'85' => [ 'Shipment date/time, promised for (prior to and including)',
    'Shipment might take place latest at given date.' ],
'86' => [ 'Medication date/time, start',
    'Date and/or time when medication was started.' ],
'87' => [ 'Travel service connection time',
    'Time elapsing between the arrival of a travel service and the departure of a connecting travel service.' ],
'88' => [ 'Summer time, start',
    'Date/time at which the summer time starts.' ],
'89' => [ 'Inquiry date',
    'The date on which an inquiry is made.' ],
'90' => [ 'Report start date',
    'The date on which a report is to begin.' ],
'91' => [ 'Report end date',
    'The date on which a report is to end.' ],
'92' => [ 'Contract effective date',
    'Date when a contract becomes valid.' ],
'93' => [ 'Contract expiry date',
    'Date when a contract expires.' ],
'94' => [ 'Production/manufacture date',
    'Date on which goods are produced.' ],
'95' => [ 'Bill of lading date',
    'Date as specified on the bill of lading.' ],
'96' => [ 'Discharge date/time',
    'Date/time when goods should, might or have been discharged from the means of transport.' ],
'97' => [ 'Transaction creation date',
    'The date on which a transaction was originated or brought into being.' ],
'98' => [ 'Winter time, start',
    'Date/time at which the winter time starts.' ],
'99' => [ 'Quotation opening date',
    'The date on which the quotation has been or may be opened.' ],
'100' => [ 'Product ageing period before delivery',
    'Period of time before delivery during which the product is ageing.' ],
'101' => [ 'Production date, no schedule established as of',
    'Date as of there is no valid production schedule.' ],
'102' => [ 'Health problem period',
    'Period of time of health problem.' ],
'103' => [ 'Closing date/time for breakbulk STORO',
    'Date/time on which delivering period for breakbulk STORO cargo ends (STORO = Stowing on Roll on-Roll off vessel).' ],
'104' => [ 'Closing date/time for container RO-RO',
    'Date/time on which delivering period for container Roll on-Roll off (RO-RO) cargo ends.' ],
'105' => [ 'Starting date/time for breakbulk STORO',
    'Date/time on which delivering period for breakbulk STORO cargo starts (STORO = Stowing on Roll on-Roll off vessel).' ],
'106' => [ 'Starting date/time for container RO-RO',
    'Date/time on which delivering period for container Roll on-Roll off (RO-RO) cargo starts.' ],
'107' => [ 'Deposit date/time',
    'The date/time on which a deposit was made.' ],
'108' => [ 'Postmark date/time',
    'An official mark stamped on a letter identifying date/time of dispatch or arrival.' ],
'109' => [ 'Receive at lockbox date',
    'The date on which a financial institution, serving as collection agency for a company located in another part of the country, collects an amount of money on behalf of that company.' ],
'110' => [ 'Ship date, originally scheduled',
    'The date on which the shipment of goods was originally scheduled.' ],
'111' => [ 'Manifest/ship notice date',
    'The date of issuance of a manifest or ship notice.' ],
'112' => [ 'First interest-bearing date',
    'The first date from which interest is borne.' ],
'113' => [ 'Sample required date',
    'Date as of a sample has to be available customer defined.' ],
'114' => [ 'Tooling required date',
    'Date as of a tool has to be available customer defined.' ],
'115' => [ 'Sample available date',
    'Date as of a sample will be available seller defined.' ],
'116' => [ 'Equipment return period, expected',
    'Period until which equipment is expected to be hired.' ],
'117' => [ 'Delivery date/time, first',
    'First possible date/time for delivery.' ],
'118' => [ 'Cargo booking confirmed date/time',
    'Date/time at which the cargo booking has been accepted by the carrier.' ],
'119' => [ 'Test completion date',
    'Date when a test has been completed.' ],
'120' => [ 'Last interest-bearing date',
    'The last date from which interest is borne.' ],
'121' => [ 'Entry date',
    'Date of entry.' ],
'122' => [ 'Contract completion date',
    'The date a contract is completed.' ],
'123' => [ 'Documentary credit expiry date/time',
    '(2211) The latest date/time for presentation of the documents to the bank where the credit expires.' ],
'124' => [ 'Despatch note document issue date time',
    '[2219] Issue date of a despatch note.' ],
'125' => [ 'Import permit issue date time',
    '[2293] Date of issue of an import licence.' ],
'126' => [ 'Contract document issue date time',
    '[2327] Date on which a contract is issued.' ],
'127' => [ 'Previous report date',
    'Date of the previous report.' ],
'128' => [ 'Delivery date/time, last',
    'Date when the last delivery should be or has been accomplished.' ],
'129' => [ 'Exportation date',
    '[2043] Date when the imported vessel/merchandise last left the country of export for the country of import.' ],
'130' => [ 'Current report date',
    'Date of the current report.' ],
'131' => [ 'Tax point date time',
    '[2221] Date on which tax is due or calculated.' ],
'132' => [ 'Transport means arrival date time, estimated',
    '[2349] Date and or time of the estimated arrival of means of transport.' ],
'133' => [ 'Transport means departure date/time, estimated',
    'Date/time when carrier estimates that a means of transport should depart at the place of departure.' ],
'134' => [ 'Rate of exchange date/time',
    'Date/time on which the exchange rate was fixed.' ],
'135' => [ 'Telex date',
    'Date identifying when a telex message was sent.' ],
'136' => [ 'Transport means departure date time, actual',
    '[2281] Date and or time of the departure of a means of transport.' ],
'137' => [ 'Document issue date time',
    '[2007] Date that a document was issued and when appropriate, signed or otherwise authenticated.' ],
'138' => [ 'Payment availability date time',
    '[2035] Date that an amount due becomes available to a creditor under the terms of payment.' ],
'139' => [ 'Property mortgage date, start',
    'The date the mortgage on a piece of property begins.' ],
'140' => [ 'Payment due date',
    'Date/time at which funds should be made available.' ],
'141' => [ 'Customs declaration document lodgement date time',
    '[2033] Presentation date of a declaration to customs.' ],
'142' => [ 'Labour wage determination date',
    'The date a labour wage is determined.' ],
'143' => [ 'Consignment acceptance date time, actual',
    '[2127] Actual date and optionally time when a consignment of goods is taken over by the carrier at the place of acceptance.' ],
'144' => [ 'Quota date',
    'Date that the quota applies to.' ],
'145' => [ 'Event date',
    'A date specifying an event.' ],
'146' => [ 'Entry date, estimated (Customs)',
    'Date on which the official date of Customs entry is anticipated.' ],
'147' => [ 'Export permit effective end date time',
    '[2079] Date on which an export licence expires.' ],
'148' => [ 'Goods declaration document acceptance date time',
    '[2037] Date on which a Goods declaration has been or will be accepted by Customs in accordance with Customs legislation.' ],
'149' => [ 'Invoice date, required',
    'Date required for invoice issue.' ],
'150' => [ 'Declaration/presentation date',
    'Date when item has been or has to be declared/presented.' ],
'151' => [ 'Importation date',
    'Date on which goods are imported, as determined by the governing Customs administration.' ],
'152' => [ 'Exportation date for textiles',
    'Date when imported textiles last left the country of origin for the country of importation.' ],
'153' => [ 'Cancellation date/time, latest',
    'The latest date/time on which cancellation of the payment order may be requested.' ],
'154' => [ 'Acceptance date of document',
    'The date on which a document was accepted.' ],
'155' => [ 'Accounting period start date',
    'The first date of an accounting period.' ],
'156' => [ 'Accounting period end date',
    'The last date of an accounting period.' ],
'157' => [ 'Validity start date',
    'The first date of a period for which something is valid.' ],
'158' => [ 'Horizon start date',
    'The first date of a period forming a horizon.' ],
'159' => [ 'Horizon end date',
    'The last date of a period forming a horizon.' ],
'160' => [ 'Authorization date',
    'Date when an authorization was given.' ],
'161' => [ 'Release date of customer',
    "Date the customer authorised the goods' release." ],
'162' => [ 'Release date of supplier',
    'Date when the supplier released goods.' ],
'163' => [ 'Processing start date/time',
    'Date/Time when a specific process starts.' ],
'164' => [ 'Processing end date/time',
    'Date/Time when a specific process ends.' ],
'165' => [ 'Tax period start date',
    'Date when a tax period begins.' ],
'166' => [ 'Tax period end date',
    'Date when a tax period ends.' ],
'167' => [ 'Charge period start date',
    "The charge period's first date." ],
'168' => [ 'Charge period end date',
    "The charge period's last date." ],
'169' => [ 'Lead time',
    'Time required between order entry till earliest goods delivery.' ],
'170' => [ 'Settlement due date',
    "More generic than 'payment due date' and therefore more apt for reinsurance/insurance business." ],
'171' => [ 'Reference date/time',
    'Date/time on which the reference was issued.' ],
'172' => [ 'Hired from date',
    'Date from which an item has been or will be hired.' ],
'173' => [ 'Hired until date',
    'Date until which an item has been or will be hired.' ],
'174' => [ 'Advise after date/time',
    'The information must be advised after the date/time indicated.' ],
'175' => [ 'Advise before date/time',
    'The information must be advised before the date/time indicated.' ],
'176' => [ 'Advise completed date/time',
    'The advise has been completed at the date indicated.' ],
'177' => [ 'Advise on date/time',
    'The information must be advised on the date/time indicated.' ],
'178' => [ 'Transport means arrival date time, actual',
    '[2107] Date and or time of the arrival of means of transport.' ],
'179' => [ 'Booking date/time',
    'Date at which the booking was made.' ],
'180' => [ 'Closing date/time',
    'Final date for delivering cargo to a liner ship.' ],
'181' => [ 'Positioning date/time of equipment',
    'Date/time when equipment is positioned.' ],
'182' => [ 'Issue date',
    'Date when a document/message has been or will be issued.' ],
'183' => [ 'Date, as at',
    'Date related to a given context.' ],
'184' => [ 'Notification date/time',
    'Date/time of notification.' ],
'185' => [ 'Commenced tank cleaning date/time',
    'The date/and or time tank cleaning was started.' ],
'186' => [ 'Transport means departure date/time, actual',
    '(2280) Date (and time) of departure of means of transport.' ],
'187' => [ 'Authentication date/time of document',
    'Date/time when the document is signed or otherwise authenticated.' ],
'188' => [ 'Previous current account date',
    'Date of the previous current account.' ],
'189' => [ 'Transport means departure date/time, scheduled',
    'Date (and time) of scheduled departure of means of transport.' ],
'190' => [ 'Transhipment date/time',
    'Date and time of the transfer of the goods from one means of transport to another.' ],
'191' => [ 'Delivery date/time, expected',
    'Date/time on which goods are expected to be delivered.' ],
'192' => [ 'Expiration date/time of customs document',
    'Date on which validity of a customs document expires.' ],
'193' => [ 'Execution date',
    'The date when ordered bank initiated the transaction.' ],
'194' => [ 'Start date/time',
    'Date/time on which a period starts.' ],
'195' => [ 'Import permit effective end date time',
    '[2273] Date on which the validity of an import licence expires.' ],
'196' => [ 'Transport means departure date/time, earliest',
    'Date/time of earliest departure of means of transport.' ],
'197' => [ 'Lay-time first day',
    'First of a number of days allowed in a charter party of the loading and discharging of cargo.' ],
'198' => [ 'Lay-time last day',
    'Last of a number of days allowed in a charter party for the loading and discharging of cargo.' ],
'199' => [ 'Positioning date/time of goods',
    'The date and/or time the goods have to be or have been positioned.' ],
'200' => [ 'Cargo pick-up date / time',
    'Date/time at which the cargo is picked up. Synonym: collected.' ],
'201' => [ 'Equipment pick-up date / time',
    'Date/time at which the equipment is picked up.' ],
'202' => [ 'Posting date',
    'The date when an entry is posted to an account.' ],
'203' => [ 'Execution date/time, requested',
    'The date/time on which the ordered bank is requested to initiate the payment order, as specified by the originator (e.g. the date of the debit).' ],
'204' => [ 'Release date (Customs)',
    'Date on which Customs releases merchandise to the carrier or importer.' ],
'205' => [ 'Settlement date',
    'Date for settlement of financial transaction e.g. foreign exchange securities.' ],
'206' => [ 'End date/time',
    'Date/time on which a period (from - to) ends.' ],
'207' => [ 'Commenced pumping ballast date/time',
    'Date/time on which the intake of materials to be carried to improve the trim and the stability of the means of transport, was commenced.' ],
'208' => [ 'Transport means departure date/time, ultimate',
    'Date/time at which a means of transport has to depart ultimately.' ],
'209' => [ 'Value date',
    'Date on which the funds are at the disposal of the beneficiary or cease to be at the disposal of the ordering customer.' ],
'210' => [ 'Reinsurance current account period',
    'The date of the current reinsurance account.' ],
'211' => [ '360/30',
    'Calculation is based on year of 360 days, month of 30 days.' ],
'212' => [ '360/28-31',
    'Calculation is based on year of 360 days, month of 28-31 days.' ],
'213' => [ '365-6/30',
    'Calculation is based on year of 365-6 days, month of 30 days.' ],
'214' => [ '365-6/28-31',
    'Calculation is based on year of 365-6 days, month of 28- 31 days.' ],
'215' => [ '365/28-31',
    'Calculation is based on year of 365 days, month of 28-31 days.' ],
'216' => [ '365/30',
    'Calculation is based on year of 365 days, month of 30 days.' ],
'217' => [ 'From date of award to latest delivery',
    'Lead time to determine the latest date a delivery can be made based on the date an award is made.' ],
'218' => [ 'Authentication/validation date/time',
    'The date/time of authentication and/or validation.' ],
'219' => [ 'Crossborder date/time',
    'Date/time at which goods are transferred across a country border.' ],
'220' => [ 'Property mortgage scheduled date, end',
    'The date the mortgage on a piece of property is scheduled to end.' ],
'221' => [ 'Interest period',
    'Number of days used for the calculation of interests.' ],
'222' => [ 'Presentation date, latest',
    'Latest date for presentation of a document.' ],
'223' => [ 'Delivery date/time, deferred',
    "New date and time of delivery calculated on basis of a consignee's requirement (chargeable)." ],
'224' => [ 'Permit to admit date',
    'Date on which permission was granted to move merchandise into a bonded warehouse or free trade zone.' ],
'225' => [ 'Certification of weight date/time',
    'Date/time at which the carrier proceeds to the weighting of the goods.' ],
'226' => [ 'Discrepancy date/time',
    'Date/time at which a discrepancy has been found.' ],
'227' => [ "Beneficiary's banks due date",
    "Date on which funds should be made available to the beneficiary's bank." ],
'228' => [ 'Debit value date, requested',
    'Date on which the account owner wants the debit value to his account.' ],
'229' => [ 'Hoses connected date/time',
    'The date and/or time hoses were connected.' ],
'230' => [ 'Hoses disconnected date/time',
    'The date and/or time hoses were disconnected.' ],
'231' => [ 'Transport means arrival date/time, earliest',
    'Date/time of earliest arrival of means of transport.' ],
'232' => [ 'Transport means arrival date/time, scheduled',
    'Date (and time) of scheduled arrival of means of transport.' ],
'233' => [ 'Transport means arrival date/time, ultimate',
    'Date (and time) of ultimate arrival of means of transport.' ],
'234' => [ 'Collection date/time, earliest',
    'The transport order may be issued before the goods are ready for picking up. This date/time indicates from when on the carrier can have access to the consignment.' ],
'235' => [ 'Collection date/time, latest',
    'In relation with the arrangements agreed between buyer and seller or between sender and main transport it may be necessary to specify the latest collection date/time.' ],
'236' => [ 'Completed pumping ballast date/time',
    'Date/time at which the intake of materials, to be carried to improve the trim and the stability of the means of transport, was completed.' ],
'237' => [ 'Completed tank cleaning date/time',
    'The date and/or time tank cleaning was completed.' ],
'238' => [ 'Tanks accepted date/time',
    'The date and/or time the tanks are to be or have been accepted.' ],
'239' => [ 'Tanks inspected date/time',
    'The date and/or time the tanks are to be or have been inspected.' ],
'240' => [ 'Reinsurance accounting period',
    'To identify a reinsurance account period via start and end dates.' ],
'241' => [ 'From date of award to earliest delivery',
    'Lead time to determine the earliest date a delivery can be made based on the date an award is made.' ],
'242' => [ 'Preparation date/time of document',
    'Date and/or time that the document was prepared.' ],
'243' => [ 'Transmission date/time of document',
    'The date/time at which a document was transmitted.' ],
'244' => [ 'Settlement date, planned',
    'The date for which settlement is planned.' ],
'245' => [ 'Underwriting year',
    'Year in which the treaty was commenced.' ],
'246' => [ 'Accounting year',
    'Year considered for accounting of the treaty or portion of the treaty.' ],
'247' => [ 'Year of occurrence',
    'Year in which a specific event (e.g. a loss) took place.' ],
'248' => [ 'Loss',
    'Date, time, period on which a referenced loss occurred.' ],
'249' => [ 'Cash call date',
    'Date on which a cash call was made for a loss suffered and covered.' ],
'250' => [ 'Re-exportation date',
    'Date of re-exportation.' ],
'251' => [ 'Re-importation date',
    'Date of re-importation.' ],
'252' => [ 'Arrival date/time at initial port',
    'Date/time that the conveyance arrives at the initial port in the country of destination.' ],
'253' => [ 'Departure date/time from last port of call',
    'Date/time that conveyance departed from the last foreign port of call.' ],
'254' => [ 'Registration date of previous Customs declaration',
    'Registration date of the Customs declaration for the previous Customs procedure either in the same or another country.' ],
'255' => [ 'Availability due date',
    'Date when ordered items should be available at a specified location.' ],
'256' => [ 'From date of award to completion',
    'Lead time to determine the completion date of an effort based on the date an award is made.' ],
'257' => [ 'Calculation date time',
    '[2253] Date on which the calculation was made.' ],
'258' => [ 'Guarantee date',
    'Date when a guarantee is placed.' ],
'259' => [ 'Conveyance registration date',
    'Date when a vessel, vehicle or other means of transport was registered by a competent authority.' ],
'260' => [ 'Valuation date (Customs)',
    'Date when Customs valuation was made.' ],
'261' => [ 'Release date/time',
    'Date/time assigned to identify the release of a set of rules, conditions, conventions, productions, etc.' ],
'262' => [ 'Closure date/time/period',
    'Date/time/period when an enterprise is closed.' ],
'263' => [ 'Invoicing period',
    'Period for which an invoice is issued.' ],
'264' => [ 'Release frequency',
    'Frequency of a release.' ],
'265' => [ 'Due date',
    'The date on which some action should occur.' ],
'266' => [ 'Validation date',
    'The date on which something was made valid, ratified or confirmed.' ],
'267' => [ 'Rate/price date/time',
    'Date/time on which a rate/price is determined.' ],
'268' => [ 'Transit time/limits',
    'The time to go over a distance.' ],
'269' => [ 'Discharge date/time, started',
    'Date/time when discharge operations were started.' ],
'270' => [ 'Ship during date',
    'The date identifying the period during or in which the goods should be shipped.' ],
'271' => [ 'Ship on or about date',
    'Date on or about which goods should be shipped.' ],
'272' => [ 'Documentary credit presentation period',
    'The specification of the period of time, expressed in number of days, after the date of issuance of the transport document(s) within which the documents must be presented.' ],
'273' => [ 'Validity period',
    'Dates (from/to)/period referenced documents are valid.' ],
'274' => [ 'From date of order receipt to sample ready',
    'Lead time is the defined timespan.' ],
'275' => [ 'From date of tooling authorization to sample ready',
    'Lead time is the defined timespan.' ],
'276' => [ 'From date of receipt of tooling aids to sample ready',
    'Lead time is the defined timespan.' ],
'277' => [ 'From date of sample approval to first product shipment',
    'Lead time is the defined timespan.' ],
'278' => [ 'From date of order receipt to shipment',
    'Lead time is the defined timespan.' ],
'279' => [ 'From date of order receipt to delivery',
    'Lead time is the defined timespan.' ],
'280' => [ 'From last booked order to delivery',
    'Lead time is the defined timespan.' ],
'281' => [ 'Date of order lead time',
    'Lead time is referenced to the date of order.' ],
'282' => [ 'Confirmation date lead time',
    'Lead time is referenced to the date of confirmation.' ],
'283' => [ 'Arrival date/time of transport lead time',
    'Lead time is referenced to the date a transport will arrive or has arrived.' ],
'284' => [ 'Before inventory is replenished based on stock check lead',
    'time Lead time is the defined timespan.' ],
'285' => [ 'Invitation to tender date/time',
    'Date/time on which the invitation to tender has been made available to relevant parties.' ],
'286' => [ 'Tender submission date/time',
    'Date/time on which the tender was submitted.' ],
'287' => [ 'Contract award date/time',
    'Date/time on which the contract is awarded to a tenderer.' ],
'288' => [ 'Price base date/time',
    'Base date/time of prices.' ],
'289' => [ 'Interest rate validity period',
    'Validity period of the interest rate.' ],
'290' => [ 'Contractual start date/time',
    'Date/time on which activities stated in the contract must start.' ],
'291' => [ 'Start date/time, planned',
    'The date/time for which something is planned to begin or commence.' ],
'292' => [ 'Works completion date/time, planned',
    'The date/time for the completion of building or repair operations is planned.' ],
'293' => [ 'Works completion date/time, actual',
    'The actual date/time for the completion of building or repair operations.' ],
'294' => [ 'Hand over date/time, planned',
    'Date/time on which hand over (i.e. the transfer of responsibility for an object or activity such as documentation, system etc. from one party to another) is planned to take place.' ],
'295' => [ 'Hand over date/time, actual',
    'Date/time on which hand over (i.e. the transfer of responsibility for an object or activity such as documentation, system etc. from one party to another) actually takes place.' ],
'296' => [ 'Retention release date/time',
    'Date/time on which the retention is released.' ],
'297' => [ 'Retention release date/time, partial',
    'Date/time on which the retention is partially released.' ],
'298' => [ 'Goods pick-up date / time, planned',
    'Date/time at which goods can be picked up, according to a plan.' ],
'299' => [ 'Price adjustment start date',
    'Value date of the indexes appearing as denominators in a price adjustment formula.' ],
'300' => [ 'Price adjustment limit date',
    'Limit value date of indexes used as numerators in a price adjustment formula.' ],
'301' => [ 'Value date of index',
    'Date of validity of index values.' ],
'302' => [ 'Publication date',
    'The date of the act of making something publicly known.' ],
'303' => [ 'Escalation date',
    'Value date of indexes appearing as numerators in an escalation formula.' ],
'304' => [ 'Price adjustment date',
    'Value date of indexes appearing as numerators in a price adjustment formula.' ],
'305' => [ 'Latest price adjustment date',
    'Date on which the latest price adjustment took place.' ],
'306' => [ 'Work period',
    'Period of execution of works.' ],
'307' => [ 'Payment instruction date/time',
    'Date/time on which a payment instruction was given.' ],
'308' => [ 'Payment valuation presentation date/time',
    'Date/time on which the payment valuation is presented.' ],
'309' => [ "Banks' value date",
    'Date on which the funds are at the disposal of the receiving bank or cease to be at the disposal of the sending bank.' ],
'310' => [ 'Received date/time',
    'Date/time of receipt.' ],
'312' => [ 'Ship not before and not after date/time',
    'Shipment(s) of goods is/are to be made not before the first specified date/time and not after the second specified date/time.' ],
'313' => [ 'Order to proceed date',
    'Issue date of an instruction to start work.' ],
'314' => [ 'Planned duration of works',
    'The period of time planned for the completion of building or repair operations.' ],
'315' => [ 'Agreement to pay date',
    'Date on which the debtor agreed to pay.' ],
'316' => [ 'Valuation date/time',
    'Date/time of valuation.' ],
'317' => [ 'Reply date',
    'The date to answer or to respond in word or action.' ],
'318' => [ 'Request date',
    'The date on which something was asked for.' ],
'319' => [ 'Customer value date',
    'Date at which funds are taken into account for interest calculation (in debit or credit).' ],
'320' => [ 'Declaration reference period',
    'Reference period of a set of items reported on the same declaration.' ],
'321' => [ 'Promotion date/period',
    'Date/period relevant for specific promotion activities.' ],
'322' => [ 'Accounting period',
    'A period of time for the recording of financial transactions for accounting.' ],
'323' => [ 'Horizon period',
    'Period forming a (planning) horizon.' ],
'324' => [ 'Processing date/period',
    'Date/period a specific process happened/will happen.' ],
'325' => [ 'Tax period',
    'Period a tax rate/tax amount etc. is applicable.' ],
'326' => [ 'Charge period',
    'Period a specified charge is valid for.' ],
'327' => [ 'Instalment payment due date',
    'Date on which an instalment payment is due.' ],
'328' => [ 'Payroll deduction date/time',
    'Date/time of a monetary deduction made from the salary of a person on a payroll.' ],
'329' => [ 'Person birth date time',
    '[2491] Date on which an individual is or was born.' ],
'330' => [ 'Joined employer date',
    'Date when a person joins an employer.' ],
'331' => [ 'Contributions ceasing date/time',
    'Date/time when contributions cease.' ],
'332' => [ 'Contribution period end date/time',
    'Date/time when a contribution period ends.' ],
'333' => [ 'Part-time working change date/time',
    'Date/time when the proportion of part-time work changes.' ],
'334' => [ 'Status change date/time',
    'Date/time when a status changes.' ],
'335' => [ 'Contribution period start date/time',
    'Date/time when a contribution period commences.' ],
'336' => [ 'Salary change effective date',
    'Date when a change in salary becomes effective.' ],
'337' => [ 'Left employer date',
    'Date when a person leaves an employer.' ],
'338' => [ 'Benefit change date/time',
    'Date/time when a benefit provided by a service provider is changed.' ],
'339' => [ 'Category change date/time',
    'Date/time when a change of category is made.' ],
'340' => [ 'Joined fund date/time',
    'Date/time when a person joins a fund.' ],
'341' => [ 'Waiting time',
    'The period of time between the moment at which one wants an activity to begin and the moment at which this activity can actually begin.' ],
'342' => [ 'Consignment loading date time',
    '[2347] Date and optionally time when a consignment is to be or has been loaded onto a means of transport.' ],
'343' => [ 'Date/time of discount termination',
    'Date/time when the deduction from an amount comes to an end.' ],
'344' => [ 'Date/time of interest due',
    'Date/time when the interest has to be paid.' ],
'345' => [ 'Days of operation',
    'Week days of operation.' ],
'346' => [ 'Latest check-in time',
    'Latest time of check-in.' ],
'347' => [ 'Slaughtering start date',
    'Date on which slaughtering commenced.' ],
'348' => [ 'Packing start date',
    'Date on which packing commenced.' ],
'349' => [ 'Packing end date',
    'Date on which packing completed.' ],
'350' => [ 'Test start date',
    'Date when a test has been started.' ],
'351' => [ 'Inspection date',
    'Date of inspection.' ],
'352' => [ 'Slaughtering end date',
    'Date on which slaughtering completed.' ],
'353' => [ 'Accounting transaction date',
    'Date to which an accounting transaction refers.' ],
'354' => [ 'Activity period date range',
    'A specific date range associated with an activity.' ],
'355' => [ 'Contractual delivery date',
    'The date of delivery contractually agreed between parties.' ],
'356' => [ 'Sales date, and or time, and or period',
    'The date, and or time, and or period on which a sale took place.' ],
'357' => [ 'Cancel if not published by this date',
    'Cancel if not published by this date.' ],
'358' => [ 'Scheduled for delivery on or after',
    'Scheduled for delivery on or after the specified date, and or time.' ],
'359' => [ 'Scheduled for delivery on or before',
    'Scheduled for delivery on or before specified date and or time.' ],
'360' => [ 'Sell by date',
    'The date by which a product should be sold.' ],
'361' => [ 'Product best before date time',
    '[2497] Indication that freshness of goods is limited in time to the date shown.' ],
'362' => [ 'End availability date',
    'The end date of availability.' ],
'363' => [ 'Total shelf life period',
    'A period indicating the total shelf life of a product.' ],
'364' => [ 'Minimum shelf life remaining at time of despatch period',
    'Period indicating the minimum shelf life remaining for a product at the time of leaving the supplier.' ],
'365' => [ 'Packaging date',
    'The date on which the packaging of a product took place.' ],
'366' => [ 'Inventory report date',
    'Date on which a inventory report is made.' ],
'367' => [ 'Meter reading date, previous',
    'Date on which the previous reading of a meter took place.' ],
'368' => [ 'Meter reading date, latest',
    'Date on which the latest reading of a meter took place.' ],
'369' => [ 'Date and or time of handling, estimated',
    'The date and or time when the handling action is estimated to take place.' ],
'370' => [ 'Date when container equipment becomes domestic',
    'The date on which foreign-built container equipment has entered into the commerce of another country and has become domestic equipment.' ],
'371' => [ 'Hydrotest date',
    'The date equipment has been hydrotested.' ],
'372' => [ 'Equipment pre-trip date',
    'The date on which equipment is pre-tripped.' ],
'373' => [ 'Mooring, date and time',
    'Date and time of mooring.' ],
'374' => [ 'Road fund tax expiry date',
    'The date of expiry of the road fund tax.' ],
'375' => [ 'Date of first registration',
    'Date of first registration.' ],
'376' => [ 'Biannual terminal inspection date',
    'The date on which a biannual inspection of a terminal has taken or will take place.' ],
'377' => [ 'Federal HighWay Administration (FHWA) inspection date',
    'The date on which container equipment is to be or has been inspected in accordance with the requirements of the U.S. Federal Highway Administration.' ],
'378' => [ 'Container Safety Convention (CSC) inspection date',
    'The date on which container equipment is to be or has been inspected as per the Container Safety Convention (CSC).' ],
'379' => [ 'Periodic inspection date',
    'The date on which a periodic inspection has to take place.' ],
'380' => [ 'Drawing revision date',
    'Date the drawing revision has been allocated to a design.' ],
'381' => [ 'Product lifespan at time of production',
    'The total lifespan of a product at the time of its production.' ],
'382' => [ 'Earliest sale date',
    'The earliest date on which the product may be made available for sale.' ],
'383' => [ 'Cancel if not shipped by this date',
    'Cancel the order if goods not shipped by this date.' ],
'384' => [ 'Previous invoice date',
    'Indicates the date which was allocated to a previous invoice.' ],
'385' => [ 'Payment cancelled, violation of agreement',
    'Date/time when a payment is cancelled due to the fact that the transaction does not comply with the agreement.' ],
'386' => [ 'Payment cancelled due to administrative error',
    'Date/time when a payment is cancelled due to an administrative error.' ],
'387' => [ 'Repair turnaround time',
    'Provides the period of time necessary to turnaround a given repair.' ],
'388' => [ 'Order amendment binding date',
    'The date when an order amendment becomes binding for both parties.' ],
'389' => [ 'Cure time',
    'Specifies the length of time that an article was or should be cured.' ],
'390' => [ 'From date of award to delivery',
    'Lead time to determine the delivery date based on the date an award is made.' ],
'391' => [ 'From date of receipt of item to approval',
    'Lead time to determine the date an item will be approved based on the date the item was received.' ],
'392' => [ 'Equipment pick-up date / time, earliest',
    'Earliest date/time at which the equipment can be picked up.' ],
'393' => [ 'Equipment pick-up date / time, planned',
    'Date/time at which equipment can be picked up, either full or empty, according to a plan.' ],
'394' => [ 'Equipment positioning date/time, actual',
    'Date/time on which equipment was actually positioned (delivered).' ],
'395' => [ 'Equipment positioning date/time, estimated',
    'Date/time on which equipment is estimated to be positioned (delivered).' ],
'396' => [ 'Equipment positioning date/time, requested',
    'Date/time on which equipment is requested to be positioned (delivered).' ],
'397' => [ 'Equipment positioning date/time, ultimate',
    'Date/time on which equipment should be positioned (delivered) at the latest.' ],
'398' => [ 'Goods collection or pick-up date/time, planned',
    'Date/time at which goods can be picked up, according to a planning.' ],
'399' => [ 'Goods positioning date/time, expected',
    'Date/time on which goods are expected to be positioned.' ],
'400' => [ 'Cargo release date/time, ultimate',
    'Ultimate date/time at which goods or equipment should be released.' ],
'401' => [ 'Container Safety Convention (CSC) plate expiration date',
    'Date on which the validity of a Container Safety Convention (CSC) plate expires.' ],
'402' => [ 'Document received date/time',
    'Date/time on which the document was actually received.' ],
'403' => [ 'Discharge date/time, actual',
    'Date/time when the specified goods or transport equipment has or have been discharged from the means of transport.' ],
'404' => [ 'Transport means loading date/time, actual',
    'Date/time when the specified goods or transport equipment has or have been loaded in or on the means of transport.' ],
'405' => [ 'Equipment pick-up date / time, actual',
    'Date/time on which the equipment was actually collected.' ],
'406' => [ 'Goods positioning date/time, planned',
    'The date/time on which the goods will be positioned according to a planning.' ],
'407' => [ 'Document requested date/time',
    'Date/time on which the document is requested by a party.' ],
'408' => [ 'Expected container hire from date/time',
    'Estimated date and time when the containers are expected to go on-hire.' ],
'409' => [ 'Order completion date/time, ultimate',
    'Date/time on which the order should be completed at the latest.' ],
'410' => [ 'Equipment repair ready date/time, ultimate',
    'Ultimate date/time on which a piece of equipment must be repaired.' ],
'411' => [ 'Container stuffing date/time, ultimate',
    'Date/time on which the container stuffing should be completed at the latest.' ],
'412' => [ 'Container stripping date/time, ultimate',
    'Date/time on which the container stripping should be completed at the latest.' ],
'413' => [ 'Discharge and loading completed date/time',
    'Date/time when all discharge and loading operations on the transport means have been completed.' ],
'414' => [ 'Equipment stock check date/time',
    'Date/time on which equipment has been ascertained as being in stock.' ],
'415' => [ 'Activity reporting date',
    'The date applicable to the activity being reported.' ],
'416' => [ 'Submission date',
    'The date of a submission.' ],
'417' => [ 'Previous booking date/time',
    'Date/time at which the previous booking was made.' ],
'418' => [ 'Minimum shelf life remaining at time of receipt',
    'The minimum shelf life remaining at the time of receipt.' ],
'419' => [ 'Forecast period',
    'A period for which a forecast applies.' ],
'420' => [ 'Unloaded, date and time',
    'To report the date and time that an unloading action occurred.' ],
'421' => [ 'Estimated acceptance date',
    'To estimate the date of acceptance.' ],
'422' => [ 'Documentary credit issue date',
    'The date the documentary credit has been issued.' ],
'423' => [ 'First date of ordering',
    'The first date on which ordering may take place.' ],
'424' => [ 'Last date of ordering',
    'The last date on which ordering may take place.' ],
'425' => [ 'Original posting date',
    'Date when the entry was originally posted.' ],
'426' => [ 'Reinsurance payment frequency',
    'The frequency of payments of reinsurance premiums.' ],
'427' => [ 'Adjusted age',
    'The adjusted age used for purposes of calculation.' ],
'428' => [ 'Original issue age',
    'The original issue age.' ],
'429' => [ 'Coverage duration',
    'The period coverage has been in force.' ],
'430' => [ 'Coverage issue date',
    'Date from which the anniversary coverage is measured.' ],
'431' => [ 'Flat extra period',
    'Period for charging the additional extra.' ],
'432' => [ 'Paid to date',
    'Date to which payments have been paid.' ],
'433' => [ 'Reinsurance coverage duration',
    'The period for which reinsurance coverage has been in force.' ],
'434' => [ 'Maturity date',
    'Date at which maturity occurs.' ],
'435' => [ 'Reinsurance issue age',
    'The actual or equivalent age at time of issue.' ],
'436' => [ 'Reinsurance paid-up date',
    'The date up to which the reinsurance has been paid.' ],
'437' => [ 'Benefit period',
    'The period of time for which benefits are provided.' ],
'438' => [ 'Disability wait period',
    'The period of time the insured must be disabled before reinsurance coverage becomes effective.' ],
'439' => [ 'Deferred Period',
    'The period of time for which an activity has been postponed.' ],
'440' => [ 'Documentary credit amendment date',
    'Date of amendment of a documentary credit.' ],
'441' => [ 'Last on hire date',
    'Date the item was last placed on hire.' ],
'442' => [ 'Last off hire date',
    'Date the item was last returned from hire.' ],
'443' => [ 'Direct interchange date',
    'Date the item was directly interchanged.' ],
'444' => [ 'Approval date',
    'Date of approval.' ],
'445' => [ 'Original estimate date',
    'The date of the original estimate.' ],
'446' => [ 'Revised estimate date',
    'The date the estimate was revised.' ],
'447' => [ "Creditor's requested value date",
    'Date on which the creditor requests to be credited.' ],
'448' => [ 'Referenced item creation date',
    'Creation date of referenced item.' ],
'449' => [ 'Date for the last update',
    'Date for the last update.' ],
'450' => [ 'Opening date',
    'Date of opening.' ],
'451' => [ 'Source document capture date',
    'Date source document data is entered into a business application.' ],
'452' => [ 'Trial balance period',
    'Period covered by the trial balance.' ],
'453' => [ 'Date of source document',
    'The date of the source document.' ],
'454' => [ 'Accounting value date',
    'Date against which the entry has to be legally allocated.' ],
'455' => [ 'Expected value date',
    'Date on which the funds are expected to be at the disposal of the beneficiary.' ],
'456' => [ 'Chart of account period',
    'Period covered by the chart of account.' ],
'457' => [ 'Date of separation',
    'Date of marital separation.' ],
'458' => [ 'Date of divorce',
    'Date when two married persons are officially divorced.' ],
'459' => [ 'Date of marriage',
    'Date when two persons are married.' ],
'460' => [ 'Wage period, start date',
    'Date when a period of wage begins.' ],
'461' => [ 'Wage period, end date',
    'Date when a period of wage ends.' ],
'462' => [ 'Working period, start date',
    'Date when a period of work begins.' ],
'463' => [ 'Working period, end date',
    'Date when a period of work ends.' ],
'464' => [ 'Embarkation date and time',
    'Date and time at which crew and/or passengers board.' ],
'465' => [ 'Disembarkation date and time',
    'Date and time at which crew and/or passengers disembark.' ],
'466' => [ 'Time now date',
    'A time now date used for planning and scheduling purposes.' ],
'467' => [ 'Holiday',
    'A date or period that is a break from work.' ],
'468' => [ 'Non working',
    'To specify a non working date or period.' ],
'469' => [ 'Start date or time, earliest',
    'The earliest date or time for starting.' ],
'470' => [ 'Start date or time, latest',
    'The latest date or time for starting.' ],
'471' => [ 'Finish date or time, earliest',
    'The earliest date or time for finishing.' ],
'472' => [ 'Finish date or time, latest',
    'The latest date or time for finishing.' ],
'473' => [ 'Start date or time, mandatory',
    'The mandatory date or time for starting.' ],
'474' => [ 'Finish date or time, mandatory',
    'The mandatory date or time for finishing.' ],
'475' => [ 'Start date or time, actual',
    'The actual date or time for starting.' ],
'476' => [ 'Start date or time, estimated',
    'The estimated date or time for starting.' ],
'477' => [ 'Completion date or time, estimated',
    'The estimated date or time for completion.' ],
'478' => [ 'Start date or time, scheduled',
    'The scheduled date or time for starting.' ],
'479' => [ 'Completion date or time, scheduled',
    'The scheduled date or time for completion.' ],
'480' => [ 'Start date or time, not before',
    'The not before date or time for starting.' ],
'481' => [ 'Start date or time, not after',
    'The not after date or time for starting.' ],
'482' => [ 'Completion date or time, not before',
    'The not before date or time for completion.' ],
'483' => [ 'Completion date or time, not after',
    'The not after date or time for completion.' ],
'484' => [ 'Illness recovery date, expected',
    'Date when a person is expected to recover from illness.' ],
'485' => [ 'Period of illness, start date',
    'Date when a period of illness began.' ],
'486' => [ 'Period of illness, end date',
    'Date when a period of illness ends.' ],
'487' => [ 'Decease date',
    'Date when a person died.' ],
'488' => [ 'Benefit period, start date',
    'Date when a period of benefit begins.' ],
'489' => [ 'Benefit period, end date',
    'Date when a period of benefit ends.' ],
'490' => [ 'Selection period, start date',
    'Date when a period of selection begins.' ],
'491' => [ 'Selection period, end date',
    'Date when a period of selection ends.' ],
'492' => [ 'Balance date/time/period',
    'The date/time/period of a balance.' ],
'493' => [ 'Benefit payments termination date',
    'To identify the date on which benefit payments have ceased.' ],
'494' => [ 'Covered income period',
    'To identify the period over which covered income is measured.' ],
'495' => [ 'Current income period',
    'To identify the period over which current income is measured.' ],
'496' => [ 'Reinstatement date',
    'Identifies the date of reinstatement.' ],
'497' => [ 'Definition of disability duration',
    'To identify the period for which the definition of disability applies.' ],
'498' => [ 'Previous termination date',
    'Identifies the date of the previous termination.' ],
'499' => [ 'Premium change period',
    'To identify the period of the premium change.' ],
'500' => [ 'Off-hire survey date',
    'Date on which the equipment was surveyed at the end of the current leasing period.' ],
'501' => [ 'In service survey date',
    'Date of survey of equipment while in use.' ],
'502' => [ 'On hire survey date',
    'Date on which the equipment was surveyed at the beginning of the current leasing period.' ],
'503' => [ 'Production inspection date',
    'Date of production inspection.' ],
'504' => [ 'Overtime, start date',
    'Date when a period of overtime begins.' ],
'505' => [ 'Overtime, end date',
    'Date when a period of overtime ends.' ],
'506' => [ 'Back order delivery date/time/period',
    'The date/time/period during which the delivery of a back order will take, or has taken, place.' ],
'507' => [ 'Negotiations start date',
    'The date on which negotiations started.' ],
'508' => [ 'Work effective start date',
    'The date on which work will effectively start.' ],
'510' => [ 'Notification time limit',
    'The time limit which has been set for a notification to take place.' ],
'511' => [ 'Time limit',
    'The time limit in which an event must take place.' ],
'512' => [ 'Attendance date and or time and or period',
    'Date and or time and or period of attendance.' ],
'513' => [ 'Accident date and or time',
    'Date and or time when an accident occurred.' ],
'514' => [ 'Adoption date, actual',
    'Actual date when adoption occurs.' ],
'515' => [ 'Reimbursement claim issue date and or time',
    'Date and or time when a reimbursement claim is issued.' ],
'516' => [ 'Hospital admission date and or time',
    'Date and or time of admission to a hospital.' ],
'517' => [ 'Hospital discharge date and or time',
    'Date and or time of discharge from a hospital.' ],
'518' => [ 'Period of care start date and or time',
    'Date and or time when a period of care starts.' ],
'519' => [ 'Period of care end date and or time',
    'Date and or time when a period of care ends.' ],
'520' => [ 'Department admission date and or time',
    'Date and or time of admission to a department.' ],
'521' => [ 'Department discharge date and or time',
    'Date and or time of discharge from a department.' ],
'522' => [ 'Childbirth date and or time, actual',
    'Actual date and or time of childbirth.' ],
'523' => [ 'Prescription issue date and or time',
    'Date and or time when a prescription was issued.' ],
'524' => [ 'Prescription dispensing date and or time',
    'Date and or time when a prescription was dispensed.' ],
'525' => [ 'Clinical examination date and or time',
    'Date and or time of clinical examination.' ],
'526' => [ 'Death date and or time',
    'Date and or time of death.' ],
'527' => [ 'Childbirth date, estimated',
    'Estimated date of childbirth.' ],
'528' => [ 'Last menstrual cycle, start date',
    'Date when the last menstrual cycle started.' ],
'529' => [ 'Pregnancy duration, actual',
    'Actual duration of pregnancy.' ],
'530' => [ 'Fumigation date and/or time',
    'The date/or time on which fumigation is to occur or has taken place.' ],
'531' => [ 'Payment period',
    'A period of time in which a payment has been or will be made.' ],
'532' => [ 'Average delivery delay',
    'The average delay between deliveries.' ],
'533' => [ 'Budget line application date',
    'The date on which something has been applied to a budget line.' ],
'534' => [ 'Date of repair or service',
    'The date of a repair or service.' ],
'535' => [ 'Date of product failure',
    'The date the product failed.' ],
'536' => [ 'Review date',
    'Date the item was or will be reviewed.' ],
'537' => [ 'International review cycle start date',
    'Date the international review cycle starts.' ],
'538' => [ 'International assessment approval for publication date',
    'Date the Data Maintenance Request (DMR) was approved for publication after completing international review.' ],
'539' => [ 'Status assignment date',
    'Date a status was assigned.' ],
'540' => [ "Instruction's original execution date",
    'Original execution date for the instruction.' ],
'541' => [ 'First published date',
    'Date when material was first published.' ],
'542' => [ 'Last published date',
    'Date when material was last published.' ],
'543' => [ 'Balance sheet date, latest',
    'Date of the latest balance sheet.' ],
'544' => [ 'Security share price as of given date',
    'Date of the security share price.' ],
'545' => [ 'Assigned date',
    'Date when assigned.' ],
'546' => [ 'Business opened date',
    'Date opened for business.' ],
'547' => [ 'Initial financial accounts filed date',
    'Date when the initial financial accounts were filed.' ],
'548' => [ 'Stop work as of given date',
    'Date work stopped or will stop.' ],
'549' => [ 'Completion date',
    'Date of completion.' ],
'550' => [ 'Lease term, start date',
    'Start date of the lease term.' ],
'551' => [ 'Lease term, end date',
    'End date of the lease term.' ],
'552' => [ 'Start date, actual',
    'Actual date of start.' ],
'553' => [ 'Start date, estimated',
    'Date of estimated start.' ],
'554' => [ 'Filed date',
    'Date when filed.' ],
'555' => [ 'Return to work date',
    'Date of return to work.' ],
'556' => [ 'Purchased date',
    'Date of purchase.' ],
'557' => [ 'Returned date',
    'Date return takes place.' ],
'558' => [ 'Changed date',
    'Date change takes place.' ],
'559' => [ 'Terminated date',
    'Date termination takes place.' ],
'560' => [ 'Evaluation date',
    'Date evaluation takes place.' ],
'561' => [ 'Business termination date',
    'Date the business terminates.' ],
'562' => [ 'Release from bankruptcy date',
    'Date when an entity is released from bankruptcy status.' ],
'563' => [ 'Placement date, initial',
    'Date of initial placement.' ],
'564' => [ 'Signature date',
    'Date of signature.' ],
'565' => [ 'Bankruptcy filed date',
    'Date when bankruptcy was filed.' ],
'566' => [ 'End date, scheduled',
    'Date when activity is scheduled to end.' ],
'567' => [ 'Report period',
    'Period covered by the report.' ],
'568' => [ 'Suspended date',
    'Date of suspension.' ],
'569' => [ 'Renewal date',
    'Date of renewal.' ],
'570' => [ 'Reported date',
    'Date when reported.' ],
'571' => [ 'Checked date',
    'Date when checked.' ],
'572' => [ 'Present residence, start date',
    'The beginning date of residence at present location.' ],
'573' => [ 'Employment position, start date',
    'The start date of employment in a particular position.' ],
'574' => [ 'Account closed date',
    'Date when account was closed.' ],
'575' => [ 'Construction date, actual',
    'Date of actual construction.' ],
'576' => [ 'Employment profession start date',
    'Start date of employment in a particular profession.' ],
'577' => [ 'Next review date',
    'Date of next review.' ],
'578' => [ 'Meeting date',
    'Date of the meeting.' ],
'579' => [ 'Administrator ordered date',
    'Date when an administrator is ordered for a company.' ],
'580' => [ 'Last date to file a claim',
    'Date after which no claim can be filed.' ],
'581' => [ 'Convicted date',
    'Date when convicted.' ],
'582' => [ 'Interviewed date',
    'Date of an interview.' ],
'583' => [ 'Last visit date',
    'Date of last visit.' ],
'584' => [ 'Future period',
    'Period in the future.' ],
'585' => [ 'Preceding period',
    'Period preceding current period.' ],
'586' => [ 'Expected problem resolution date',
    'Date when problem is expected to be resolved.' ],
'587' => [ 'Action date',
    'Date of action.' ],
'588' => [ "Accountant's opinion date",
    "Date of an accountant's opinion." ],
'589' => [ 'Last activity date',
    'Date of last activity.' ],
'590' => [ 'Resolved date',
    'Date when resolved.' ],
'591' => [ 'Recorded date',
    'Date when recorded.' ],
'592' => [ 'Date of birth, estimated',
    'The estimated date of birth.' ],
'593' => [ 'Last annual report date',
    'Date of the last annual report.' ],
'594' => [ 'Net worth date',
    'Date of net worth.' ],
'595' => [ 'Payment cancellation rejected',
    'Date/time when a cancellation of a payment is rejected due to the fact that the payment is already done.' ],
'596' => [ 'Profit period',
    'Period over which profit was earned.' ],
'597' => [ 'Registration date',
    'Date when registered.' ],
'598' => [ 'Consolidation date',
    'Date when consolidation occurred.' ],
'599' => [ 'Board of directors not authorised as of given date',
    'As of this date the board of directors is not authorised.' ],
'600' => [ 'Board of directors not complete as of given date',
    'As of this date the board of directors is not fully filled.' ],
'601' => [ 'Manager not registered as of given date',
    'As of this date the manager is not registered.' ],
'602' => [ 'Citizenship change date',
    'Date of citizenship change.' ],
'603' => [ 'Participation date',
    'Date of participation.' ],
'604' => [ 'Capitalisation date',
    'Date of capitalisation.' ],
'605' => [ 'Board of directors registration date',
    'Date when the board of directors was registered.' ],
'606' => [ 'Operations ceased date',
    'Date when operations ceased.' ],
'607' => [ 'Satisfaction date',
    'Date when satisfaction was obtained.' ],
'608' => [ 'Legal settlement terms met date',
    'Date when terms specified in the legal settlement were met.' ],
'609' => [ 'Business control change date',
    'Date when a new authority took control.' ],
'610' => [ 'Court registration date',
    'Date of registration in the court.' ],
'611' => [ 'Annual report due date',
    'Date when annual report is due.' ],
'612' => [ 'Asset and liability schedule date',
    'Date of the asset and liability schedule.' ],
'613' => [ 'Annual report mailing date',
    'Date when the annual report was mailed.' ],
'614' => [ 'Annual report filing date',
    'Date when the annual report was filed.' ],
'615' => [ 'Annual report delinquent on date',
    'Date when annual report was considered delinquent.' ],
'616' => [ 'Accounting methodology change date',
    'Date when accounting methodology was changed.' ],
'617' => [ 'Closed until date',
    'Date when again open.' ],
'618' => [ 'Conversion into holding company date',
    'Date business was converted into a holding company.' ],
'619' => [ 'Deed not available as of given date',
    'Date when deed was not available.' ],
'620' => [ 'Detrimental information receipt date',
    'Date when detrimental information was received.' ],
'621' => [ 'Construction date, estimated',
    'Estimated date of construction.' ],
'622' => [ 'Financial information date',
    'Date of the financial information.' ],
'623' => [ 'Graduation date',
    'Date when graduation occurs.' ],
'624' => [ 'Insolvency discharge granted date',
    'Date when insolvency discharge was granted.' ],
'625' => [ 'Incorporation date',
    'Date of incorporation.' ],
'626' => [ 'Inactivity end date',
    'Date when inactivity ends.' ],
'627' => [ 'Last check for balance sheet update date',
    'Date balance sheet was last checked to determine if update had taken place.' ],
'628' => [ 'Last capital change date',
    'Date of last capital change.' ],
'629' => [ 'Letter of agreement date',
    'Date of a letter of agreement.' ],
'630' => [ 'Letter of liability date',
    'Date of a letter of liability.' ],
'631' => [ 'Liquidation date',
    'Date of liquidation.' ],
'632' => [ 'Lowest activity period',
    'Period of lowest activity.' ],
'633' => [ 'Legal structure change date',
    'Date when legal structure was changed.' ],
'634' => [ 'Current name effective date',
    'Date when current name became effective.' ],
'635' => [ 'Not registered as of given date',
    'Date when not yet registered.' ],
'636' => [ 'Current authority control start date',
    'Date when current authority took control.' ],
'637' => [ 'Privilege details verification date',
    'Date when privilege details were verified.' ],
'638' => [ 'Current legal structure effective date',
    'Date when current legal structure became effective.' ],
'639' => [ 'Peak activity period',
    'Period of peak activity.' ],
'640' => [ 'Presentation to bankruptcy receivers date',
    'Date when presented to the bankruptcy receivers.' ],
'641' => [ 'Resignation date',
    'Date of resignation.' ],
'642' => [ 'Legal action closed date',
    'Date when the legal action was closed.' ],
'643' => [ 'Mail receipt date',
    'Date mail was received.' ],
'644' => [ 'Social security claims verification date',
    'Date when social security claims were verified.' ],
'645' => [ 'Sole directorship registration date',
    'Date when sole directorship was registered.' ],
'646' => [ 'Trade style registration date',
    'Date when trade style was registered.' ],
'647' => [ 'Trial start date, scheduled',
    'Date when a trial is scheduled to begin.' ],
'648' => [ 'Trial start date, actual',
    'Date when the trial actually started.' ],
'649' => [ 'Value Added Tax (VAT) claims verification date',
    'Date when the Value Added Tax (VAT) claims were verified.' ],
'650' => [ 'Receivership result date',
    'Date when the result of the receivership occurs.' ],
'651' => [ 'Investigation end date',
    'The date when an investigation ended.' ],
'652' => [ 'Employee temporary laid-off period end date',
    'The ending date of a period in which employees were temporarily placed out of work.' ],
'653' => [ 'Investigation start date',
    'The date when an investigation began.' ],
'654' => [ 'Income period',
    'The period of time in which income is earned.' ],
'655' => [ 'Criminal sentence duration',
    'The period of time over which a criminal sentence applies.' ],
'656' => [ 'Age',
    'Length of time that a person or animal has lived or a thing has existed.' ],
'657' => [ 'Receivables collection period',
    'The period of time over which receivable accounts are collected.' ],
'658' => [ 'Comparison period',
    'The time period covered in a comparison.' ],
'659' => [ 'Adjournment',
    'The period of time over which an adjournment is in effect.' ],
'660' => [ 'Court dismissal date',
    'The date on which a court refused further hearing of a case.' ],
'661' => [ 'Insufficient assets judgement date',
    'The date on which assets were judged to be insufficient.' ],
'662' => [ 'Average payment period',
    'The average period of time over which money has been paid.' ],
'663' => [ 'Forecast period start',
    'The beginning of a forecast period.' ],
'664' => [ 'Period extended',
    'Number of time units added to the original end date/time/period.' ],
'665' => [ 'Employee temporary laid-off period start date',
    'The start date of a period in which employees were temporarily placed out of work.' ],
'666' => [ 'Management available date',
    'Date when management is available.' ],
'667' => [ 'Withdrawn date',
    'The date when something was retracted.' ],
'668' => [ 'Claim incurred date',
    'The date that the claim was incurred.' ],
'669' => [ 'Financial coverage period',
    'The period of time for which financial coverage applies.' ],
'670' => [ 'Claim made date',
    'The date on which a claim was made.' ],
'671' => [ 'Stop distribution date',
    'The date on which distribution is to stop.' ],
'672' => [ 'Period assigned',
    'The period assigned.' ],
'673' => [ 'Lease period',
    'The period associated with a lease.' ],
'674' => [ 'Forecast period end date',
    'The ending date of a forecast period.' ],
'675' => [ 'Judgement date',
    'The date on which a decision from a court of law was rendered.' ],
'676' => [ 'Period worked for the company',
    'Period of time that was worked for the company.' ],
'677' => [ 'Transport equipment stuffing date and/or time',
    'The date and/or time on which the stuffing of transport equipment is to or has taken place.' ],
'678' => [ 'Transport equipment stripping date and/or time',
    'The date and/or time on which the stripping of a transport equipment is to or has taken place.' ],
'679' => [ 'Initial request date',
    'Date of an initial request.' ],
'680' => [ 'Period overdue',
    'The period by which an event is overdue.' ],
'681' => [ 'Implementation date/time/period',
    'A date/time/period within which an implementation is to take place.' ],
'682' => [ 'Refusal period',
    'The period within which a refusal can be made.' ],
'683' => [ 'Suspension period',
    'The period for which something is suspended.' ],
'684' => [ 'Deletion date',
    'The date on which deletion occurs.' ],
'685' => [ 'First sale date and/or time and/or period',
    'The first date, and/or time, and/or period a product was sold.' ],
'686' => [ 'Last sale date and/or time and/or period',
    'The last date, and/or time, and/or period a product was sold.' ],
'687' => [ 'Date ready for collection',
    'A date on which an object is ready for collection.' ],
'688' => [ 'Shipping date, no schedule established as of',
    'As at this date no valid shipping schedule has been established.' ],
'689' => [ 'Shipping date and/or time, current schedule',
    'Shipping date and/or time as currently scheduled.' ],
'690' => [ "Suppliers' average credit period",
    'The average period of time that credit is extended by suppliers.' ],
'691' => [ 'Advising date',
    'Date of advice.' ],
'692' => [ 'Project over target baseline date',
    'The date an over target baseline was implemented for a project.' ],
'693' => [ 'Established date',
    'Date when an entity was established or created.' ],
'694' => [ 'Latest filing period',
    'Latest period for which a filing may be made.' ],
'695' => [ 'Mailing date',
    'Date when an item may be mailed.' ],
'696' => [ 'Date/time of latest accounts filing at public registry',
    'The latest date/time when financial accounts were filed at public registry.' ],
'697' => [ 'Date placed in disfavour',
    'Date when placed in a disfavoured category or status.' ],
'698' => [ 'Employment position start date, estimated',
    'Estimated start date of employment in a particular position.' ],
'699' => [ 'Registered contractor number assignment date, original',
    'Date when a registered contractor number was originally assigned.' ],
'700' => [ 'Ownership change date',
    'Date when ownership changes.' ],
'701' => [ 'Original duration',
    'Original length of time.' ],
'702' => [ 'Period between changes',
    'The period of time between changes.' ],
'703' => [ 'From date of notice to proceed to commencement of',
    'performance Period of time from notice to proceed until performance commencement.' ],
'704' => [ 'From date of notice to proceed to completion',
    'Period of time from date of notice to proceed until completion.' ],
'705' => [ 'Period an event is late due to customer',
    'The period of time an event is late due to the actions of a customer.' ],
'706' => [ 'File generation date and/or time',
    'Date and, or time of file generation.' ],
'707' => [ 'Endorsed certificate issue date',
    'Date on which a certificate, endorsed by signature or other agreed means, is issued.' ],
'708' => [ 'Patient first visit for condition',
    'The date of the first visit by a patient to a healthcare provider for this condition.' ],
'709' => [ 'Admission date and/or time, expected',
    'Expected date and/or time of admission.' ],
'710' => [ 'Symptoms onset, patient alleged',
    'Date and/or time of onset of symptoms according to the patient.' ],
'711' => [ 'Accident benefit period',
    'To identify the period of time for which benefits are provided in the event of an accident.' ],
'712' => [ 'Accident benefit age limit',
    'To identify the age to which benefits are provided to the insured in the event of an accident.' ],
'713' => [ 'Accident lifetime benefit qualification age',
    'To identify the qualification age for lifetime benefits provided to the insured in the event of an accident.' ],
'714' => [ 'Sickness benefit period',
    'To identify the period of time for which benefits are provided in the event of sickness.' ],
'715' => [ 'Sickness benefit age limit',
    'To identify the age to which benefits are provided to the insured in the event of sickness.' ],
'716' => [ 'Sickness lifetime benefit qualification age',
    'To identify the qualification age for lifetime benefits provided to the insured in the event of sickness.' ],
'717' => [ 'Accident insurance elimination period',
    'To identify the period of time the insured must be disabled in the event of an accident for benefits to be payable by the ceding company.' ],
'718' => [ 'Sickness insurance elimination period',
    'The period of time the insured must be disabled in the event of sickness for benefits to be payable by the ceding company.' ],
'719' => [ 'Provider signature date',
    'Date when the provider signed.' ],
'720' => [ 'Condition initial treatment date',
    'Date when initially treated for this condition.' ],
'721' => [ 'Information release authorization date',
    'Date when the information was authorized to be released.' ],
'722' => [ 'Benefit release authorization date',
    'Date when a benefit is authorized for release.' ],
'723' => [ 'Last seen date',
    'The date when last seen.' ],
'724' => [ 'Acute manifestation date',
    'The date the symptoms manifested themselves in an acute form.' ],
'725' => [ 'Similar illness onset date',
    'The date of the onset of an illness similar to the illness currently being treated.' ],
'726' => [ 'Last X-ray date',
    'The date the last X-ray was taken.' ],
'727' => [ 'Placement date, previous',
    'The date something was previously placed.' ],
'728' => [ 'Placement date',
    'The date something is placed.' ],
'729' => [ 'Temporary prosthesis date',
    'The date a temporary prosthetic device was provided.' ],
'730' => [ 'Orthodontic treatment period, remaining',
    'The period of time that the orthodontic treatment has remaining.' ],
'731' => [ 'Orthodontic treatment period, total',
    'The period of orthodontic treatment from beginning to end.' ],
'732' => [ 'Maximum credit granted date',
    'Date on which the highest credit was granted.' ],
'733' => [ 'Last date of accounts filed at public register',
    'Date on which accounts were last filed at the public register.' ],
'734' => [ 'Allowed renewal duration period',
    'The period of time a company can renew its duration period.' ],
'735' => [ 'Offset from Coordinated Universal Time (UTC)',
    "Number of hour's offset from Coordinated Universal Time (UTC)." ],
'736' => [ 'Appointment expiry date',
    'Date when an appointment will expire.' ],
'737' => [ 'Earliest filing period',
    'Earliest period for which a filing is made.' ],
'738' => [ 'Original name change date',
    'Date when the original name was changed.' ],
'739' => [ 'Education start date',
    'Date education begins at an educational institution.' ],
'740' => [ 'Education end date',
    'Date education is completed at an educational institution.' ],
'741' => [ 'Receivership period',
    'Period of time a receivership lasts.' ],
'742' => [ 'Financial information submission date/time',
    'Date/time when financial information is submitted.' ],
'743' => [ 'Purchase order latest possible change date',
    'Date identifying a point of time after which a purchase order cannot be changed.' ],
'744' => [ 'Investment number allocation date',
    'The date that an investment number was allocated.' ],
'745' => [ 'Payment impossible',
    'Date/time when a payment is recorded as being impossible.' ],
'746' => [ 'Record extraction period',
    'The period for extraction of records.' ],
'747' => [ 'Cost accounting value date',
    'Code identifying the value date of cost accounting. Value date is the date at which the entry is to effect a balance of the account.' ],
'748' => [ 'Open period',
    'Code identifying the period during which something is, was or will be open.' ],
'749' => [ 'Period between issue date and maturity date',
    'Interval of time between the date when the transaction was initiated and the date when the funds need to be collected.' ],
'750' => [ 'Before date',
    'The specified before date.' ],
'751' => [ 'After date',
    'The specified after date.' ],
'752' => [ 'Meter reading date, next scheduled',
    'Date on which the next reading of a meter is scheduled to take place.' ],
'753' => [ 'Maturity date, optimal',
    'Date at which optimal maturity occurs.' ],
'754' => [ 'Product ageing duration, maximum',
    'Maximum period of time during which the product is ageing.' ],
'755' => [ 'Product ageing duration, minimum',
    'Minimum period of time during which the product is ageing.' ],
'756' => [ 'Ultimate documentation date/time for 24-hour rule',
    'regulation of CBP (United States Customs and Border Protection) Ultimate date/time by which the documentation must be submitted in compliance with the 4-hour rule of United States Custom of Border Protection.' ],
'757' => [ 'Departure date/time from place of loading',
    'Date/time of the departure of the goods from the place of loading.' ],
'758' => [ 'Trade item ship date/time, earliest possible',
    'The earliest date/time that the trade item can be shipped.' ],
'759' => [ 'Trade item ship date/time, latest possible',
    'The latest date/time that the trade item can be shipped.' ],
'760' => [ 'Start date/time, maximum buying quantity',
    'The date/time from which the maximum buying quantity may be purchased.' ],
'761' => [ 'Start date/time, minimum buying quantity',
    'The date/time from which the minimum buying quantity may be purchased.' ],
'762' => [ 'Marketing campaign end date/time, suggested',
    'The date and or time suggested for the marketing campaign to end.' ],
'763' => [ 'Marketing campaign start date/time, suggested',
    'The date and or time suggested for the marketing campaign to start.' ],
'764' => [ 'Start availability date',
    'The start date of availability.' ],
'765' => [ 'Seasonal availabilty calendar year',
    'The calendar year of the season in which the trade item is available.' ],
'766' => [ 'Goods pickup lead time',
    'Minimum time required between order entry and goods release for pick-up.' ],
'767' => [ 'Change date/time, latest',
    'Most recent date and/or time that the information has been changed.' ],
'768' => [ 'End date/time, maximum buying quantity',
    'The date and/or time until which the maximum buying quantity may be purchased.' ],
'769' => [ 'End dat/time, minimum buying quantity',
    'The date and/or time until which the minimum buying quantity may be purchased.' ],
'770' => [ 'End date/time of exclusivity',
    'The date and/or time until which a product is exclusive.' ],
'771' => [ 'Data release date',
    'The date at which the data is released.' ],
'772' => [ 'Handling start date and/or time, actual',
    'The actual date and/or time when the start of the handling action takes place.' ],
'773' => [ 'Handling end date and/or time, estimated',
    'The date and/or time when the end of the handling action is estimated to take place.' ],
'774' => [ 'Handling end date and/or time, actual',
    'The actual date and/or time when the end of the handling action takes place.' ],
'775' => [ 'Minimum product lifespan for consumer',
    'The minimum life span of the product remaining after selling it to the consumer, i.e. between the "sell by date" and the "use by date" of the product.' ],
'776' => [ 'Entry date, elected',
    'Date used at the discretion of the filer for duty calculation of non-quota goods when there is no immediate transport entry date (related to immediate delivery).' ],
'777' => [ 'Arrival date/time at initial port with the intent to unload',
    'Date/ time that the conveyance arrives at the initial port in the country of destination.' ],
'778' => [ 'Conveyance port activity date/ time',
    'The date and time of conveyance activity, including cargo loading or unloading, fuelling etc.' ],
'779' => [ 'Date and time of importation into port limits',
    'Date and time on which the conveyance transporting the goods from the foreign country arrived within the limits of the port of destination.' ],
'780' => [ 'Free trade zone commodity status assignment date',
    'The filing date that corresponds to the current status of the commodity in the free trade zone.' ],
'781' => [ 'Jurisdiction entry date/time, actual',
    "Actual date/time at which the conveyance or goods enter an agency's jurisdiction." ],
'782' => [ 'Inspection start date/time',
    'Date/time at which an inspection begins.' ],
'783' => [ 'Inspection end date/time',
    'Date/time at which an inspection is completed.' ],
'784' => [ 'Document/message rejection date/time',
    'Date/time at which the document/message was rejected.' ],
'785' => [ 'Government service date/time, requested',
    'The date/time at which the government service is requested to be executed.' ],
'786' => [ 'Crop year',
    'The year that the crops were grown.' ],
'787' => [ 'Date of original manufacture',
    'Date that the item was originally manufactured.' ],
'788' => [ 'Model year',
    'The model year of the item.' ],
'789' => [ 'Opened trade item life span',
    'The number of days the trade item that has been opened can remain on the shelf before it must be removed.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
