/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.AbstractLinearClassifierFactory;
import edu.stanford.nlp.classify.AdaptedGaussianPriorObjectiveFunction;
import edu.stanford.nlp.classify.BiasedLogConditionalObjectiveFunction;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ClassifierCreator;
import edu.stanford.nlp.classify.CrossValidator;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.GeneralizedExpectationObjectiveFunction;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LogConditionalObjectiveFunction;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.classify.ProbabilisticClassifier;
import edu.stanford.nlp.classify.ProbabilisticClassifierCreator;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.classify.SemiSupervisedLogConditionalObjectiveFunction;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.CGMinimizer;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.GoldenSectionLineSearch;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.HybridMinimizer;
import edu.stanford.nlp.optimization.LineSearcher;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.optimization.SGDToQNMinimizer;
import edu.stanford.nlp.optimization.SMDMinimizer;
import edu.stanford.nlp.optimization.SQNMinimizer;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.optimization.StochasticInPlaceMinimizer;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.MultiClassAccuracyStats;
import edu.stanford.nlp.stats.Scorer;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearClassifierFactory<L, F>
extends AbstractLinearClassifierFactory<L, F> {
    private static final long serialVersionUID = 7893768984379107397L;
    private double TOL;
    private int mem = 15;
    private boolean verbose = false;
    private LogPrior logPrior;
    private Minimizer<DiffFunction> minimizer;
    private boolean tuneSigmaHeldOut = false;
    private boolean tuneSigmaCV = false;
    private int folds;
    private double min = 0.1;
    private double max = 10.0;
    private boolean retrainFromScratchAfterSigmaTuning = false;
    protected static double[] sigmasToTry = new double[]{0.5, 1.0, 2.0, 4.0, 10.0, 20.0, 100.0};
    private LineSearcher heldOutSearcher = null;

    public double[][] adaptWeights(double[][] origWeights, GeneralDataset<L, F> adaptDataset) {
        System.err.println("adaptWeights in LinearClassifierFactory. increase weight dim only");
        double[][] newWeights = new double[adaptDataset.featureIndex.size()][adaptDataset.labelIndex.size()];
        System.arraycopy(origWeights, 0, newWeights, 0, origWeights.length);
        AdaptedGaussianPriorObjectiveFunction<L, F> objective = new AdaptedGaussianPriorObjectiveFunction<L, F>(adaptDataset, this.logPrior, newWeights);
        double[] initial = objective.initial();
        double[] weights = this.minimizer.minimize(objective, this.TOL, initial);
        return objective.to2D(weights);
    }

    @Override
    public double[][] trainWeights(GeneralDataset<L, F> dataset) {
        return this.trainWeights(dataset, null);
    }

    public double[][] trainWeights(GeneralDataset<L, F> dataset, double[] initial) {
        return this.trainWeights(dataset, initial, false);
    }

    public double[][] trainWeights(GeneralDataset<L, F> dataset, double[] initial, boolean bypassTuneSigma) {
        if (dataset instanceof RVFDataset) {
            ((RVFDataset)dataset).ensureRealValues();
        }
        double[] interimWeights = null;
        if (!bypassTuneSigma) {
            if (this.tuneSigmaHeldOut) {
                interimWeights = this.heldOutSetSigma(dataset);
            } else if (this.tuneSigmaCV) {
                this.crossValidateSetSigma(dataset, this.folds);
            }
        }
        LogConditionalObjectiveFunction<L, F> objective = new LogConditionalObjectiveFunction<L, F>(dataset, this.logPrior);
        if (initial == null && interimWeights != null && !this.retrainFromScratchAfterSigmaTuning) {
            initial = interimWeights;
        }
        if (initial == null) {
            initial = objective.initial();
        }
        double[] weights = this.minimizer.minimize(objective, this.TOL, initial);
        return objective.to2D(weights);
    }

    public Classifier<L, F> trainClassifierSemiSup(GeneralDataset<L, F> data, GeneralDataset<L, F> biasedData, double[][] confusionMatrix, double[] initial) {
        double[][] weights = this.trainWeightsSemiSup(data, biasedData, confusionMatrix, initial);
        LinearClassifier<L, F> classifier = new LinearClassifier<L, F>(weights, data.featureIndex(), data.labelIndex());
        return classifier;
    }

    public double[][] trainWeightsSemiSup(GeneralDataset<L, F> data, GeneralDataset<L, F> biasedData, double[][] confusionMatrix, double[] initial) {
        LogConditionalObjectiveFunction<L, F> objective = new LogConditionalObjectiveFunction<L, F>(data, new LogPrior(LogPrior.LogPriorType.NULL));
        BiasedLogConditionalObjectiveFunction biasedObjective = new BiasedLogConditionalObjectiveFunction(biasedData, confusionMatrix, new LogPrior(LogPrior.LogPriorType.NULL));
        SemiSupervisedLogConditionalObjectiveFunction semiSupObjective = new SemiSupervisedLogConditionalObjectiveFunction(objective, biasedObjective, this.logPrior);
        if (initial == null) {
            initial = objective.initial();
        }
        double[] weights = this.minimizer.minimize(semiSupObjective, this.TOL, initial);
        return objective.to2D(weights);
    }

    public LinearClassifier<L, F> trainSemiSupGE(GeneralDataset<L, F> labeledDataset, List<? extends Datum<L, F>> unlabeledDataList, List<F> GEFeatures, double convexComboCoeff) {
        LogConditionalObjectiveFunction<L, F> objective = new LogConditionalObjectiveFunction<L, F>(labeledDataset, new LogPrior(LogPrior.LogPriorType.NULL));
        GeneralizedExpectationObjectiveFunction<L, F> geObjective = new GeneralizedExpectationObjectiveFunction<L, F>(labeledDataset, unlabeledDataList, GEFeatures);
        SemiSupervisedLogConditionalObjectiveFunction semiSupObjective = new SemiSupervisedLogConditionalObjectiveFunction(objective, geObjective, null, convexComboCoeff);
        double[] initial = objective.initial();
        double[] weights = this.minimizer.minimize(semiSupObjective, this.TOL, initial);
        return new LinearClassifier<L, F>(objective.to2D(weights), labeledDataset.featureIndex(), labeledDataset.labelIndex());
    }

    public LinearClassifier<L, F> trainSemiSupGE(GeneralDataset<L, F> labeledDataset, List<? extends Datum<L, F>> unlabeledDataList) {
        List<F> GEFeatures = this.getHighPrecisionFeatures(labeledDataset, 0.9, 10);
        return this.trainSemiSupGE(labeledDataset, unlabeledDataList, GEFeatures, 0.5);
    }

    public LinearClassifier<L, F> trainSemiSupGE(GeneralDataset<L, F> labeledDataset, List<? extends Datum<L, F>> unlabeledDataList, double convexComboCoeff) {
        List<F> GEFeatures = this.getHighPrecisionFeatures(labeledDataset, 0.9, 10);
        return this.trainSemiSupGE(labeledDataset, unlabeledDataList, GEFeatures, convexComboCoeff);
    }

    private List<F> getHighPrecisionFeatures(GeneralDataset<L, F> dataset, double minPrecision, int maxNumFeatures) {
        int[][] feature2label = new int[dataset.numFeatures()][dataset.numClasses()];
        for (int f = 0; f < dataset.numFeatures(); ++f) {
            Arrays.fill(feature2label[f], 0);
        }
        int[][] data = dataset.data;
        int[] labels = dataset.labels;
        for (int d = 0; d < data.length; ++d) {
            int label = labels[d];
            if (data[d] == null) continue;
            for (int n = 0; n < data[d].length; ++n) {
                int[] nArray = feature2label[data[d][n]];
                int n2 = label;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        ClassicCounter feature2freq = new ClassicCounter();
        for (int f = 0; f < dataset.numFeatures(); ++f) {
            int maxF = ArrayMath.max(feature2label[f]);
            int total = ArrayMath.sum(feature2label[f]);
            double precision = (double)maxF / (double)total;
            Object feature = dataset.featureIndex.get(f);
            if (!(precision >= minPrecision)) continue;
            feature2freq.incrementCount(feature, total);
        }
        if (feature2freq.size() > maxNumFeatures) {
            Counters.retainTop(feature2freq, maxNumFeatures);
        }
        return Counters.toSortedList(feature2freq);
    }

    public LinearClassifier<L, F> trainClassifierV(GeneralDataset<L, F> train, GeneralDataset<L, F> validation, double min, double max, boolean accuracy) {
        this.labelIndex = train.labelIndex();
        this.featureIndex = train.featureIndex();
        this.min = min;
        this.max = max;
        this.heldOutSetSigma(train, validation);
        double[][] weights = this.trainWeights(train);
        return new LinearClassifier<L, F>(weights, train.featureIndex(), train.labelIndex());
    }

    public LinearClassifier<L, F> trainClassifierV(GeneralDataset<L, F> train, double min, double max, boolean accuracy) {
        this.labelIndex = train.labelIndex();
        this.featureIndex = train.featureIndex();
        this.tuneSigmaHeldOut = true;
        this.min = min;
        this.max = max;
        this.heldOutSetSigma(train);
        double[][] weights = this.trainWeights(train);
        return new LinearClassifier<L, F>(weights, train.featureIndex(), train.labelIndex());
    }

    public LinearClassifierFactory() {
        this(new QNMinimizer(15));
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min) {
        this(min, false);
    }

    public LinearClassifierFactory(boolean useSum) {
        this(new QNMinimizer(15), useSum);
    }

    public LinearClassifierFactory(double tol) {
        this(new QNMinimizer(15), tol, false);
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, boolean useSum) {
        this(min, 1.0E-4, useSum);
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, double tol, boolean useSum) {
        this(min, tol, useSum, 1.0);
    }

    public LinearClassifierFactory(double tol, boolean useSum, double sigma) {
        this((Minimizer<DiffFunction>)new QNMinimizer(15), tol, useSum, sigma);
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, double tol, boolean useSum, double sigma) {
        this(min, tol, useSum, LogPrior.LogPriorType.QUADRATIC.ordinal(), sigma);
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, double tol, boolean useSum, int prior, double sigma) {
        this(min, tol, useSum, prior, sigma, 0.0);
    }

    public LinearClassifierFactory(double tol, boolean useSum, int prior, double sigma, double epsilon) {
        this((Minimizer<DiffFunction>)new QNMinimizer(15), tol, useSum, new LogPrior(prior, sigma, epsilon));
    }

    public LinearClassifierFactory(double tol, boolean useSum, int prior, double sigma, double epsilon, int mem) {
        this((Minimizer<DiffFunction>)new QNMinimizer(mem), tol, useSum, new LogPrior(prior, sigma, epsilon));
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, double tol, boolean useSum, int prior, double sigma, double epsilon) {
        this(min, tol, useSum, new LogPrior(prior, sigma, epsilon));
    }

    public LinearClassifierFactory(Minimizer<DiffFunction> min, double tol, boolean useSum, LogPrior logPrior) {
        this.minimizer = min;
        this.TOL = tol;
        this.logPrior = logPrior;
    }

    public void setTol(double tol) {
        this.TOL = tol;
    }

    public void setPrior(LogPrior logPrior) {
        this.logPrior = logPrior;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMinimizer(Minimizer<DiffFunction> min) {
        this.minimizer = min;
    }

    public void setEpsilon(double eps) {
        this.logPrior.setEpsilon(eps);
    }

    public void setSigma(double sigma) {
        this.logPrior.setSigma(sigma);
    }

    public double getSigma() {
        return this.logPrior.getSigma();
    }

    public void useQuasiNewton() {
        this.minimizer = new QNMinimizer(this.mem);
    }

    public void useQuasiNewton(boolean useRobust) {
        this.minimizer = new QNMinimizer(this.mem, useRobust);
    }

    public void useStochasticQN(double initialSMDGain, int stochasticBatchSize) {
        this.minimizer = new SQNMinimizer<DiffFunction>(this.mem, initialSMDGain, stochasticBatchSize, false);
    }

    public void useStochasticMetaDescent() {
        this.useStochasticMetaDescent(0.1, 15, StochasticCalculateMethods.ExternalFiniteDifference, 20);
    }

    public void useStochasticMetaDescent(double initialSMDGain, int stochasticBatchSize, StochasticCalculateMethods stochasticMethod, int passes) {
        this.minimizer = new SMDMinimizer<DiffFunction>(initialSMDGain, stochasticBatchSize, stochasticMethod, passes);
    }

    public void useStochasticGradientDescent() {
        this.useStochasticGradientDescent(0.1, 15);
    }

    public void useStochasticGradientDescent(double gainSGD, int stochasticBatchSize) {
        this.minimizer = new SGDMinimizer<DiffFunction>(gainSGD, stochasticBatchSize);
    }

    public void useInPlaceStochasticGradientDescent() {
        this.useInPlaceStochasticGradientDescent(-1, -1, 1.0);
    }

    public void useInPlaceStochasticGradientDescent(int SGDPasses, int tuneSampleSize, double sigma) {
        this.minimizer = new StochasticInPlaceMinimizer(sigma, SGDPasses, tuneSampleSize);
    }

    public void useHybridMinimizerWithInPlaceSGD(int SGDPasses, int tuneSampleSize, double sigma) {
        StochasticInPlaceMinimizer firstMinimizer = new StochasticInPlaceMinimizer(sigma, SGDPasses, tuneSampleSize);
        QNMinimizer secondMinimizer = new QNMinimizer(this.mem);
        this.minimizer = new HybridMinimizer(firstMinimizer, secondMinimizer, SGDPasses);
    }

    public void useStochasticGradientDescentToQuasiNewton(SeqClassifierFlags p) {
        this.minimizer = new SGDToQNMinimizer(p);
    }

    public void useHybridMinimizer() {
        this.useHybridMinimizer(0.1, 15, StochasticCalculateMethods.ExternalFiniteDifference, 0);
    }

    public void useHybridMinimizer(double initialSMDGain, int stochasticBatchSize, StochasticCalculateMethods stochasticMethod, int cutoffIteration) {
        SMDMinimizer<DiffFunction> firstMinimizer = new SMDMinimizer<DiffFunction>(initialSMDGain, stochasticBatchSize, stochasticMethod, cutoffIteration);
        QNMinimizer secondMinimizer = new QNMinimizer(this.mem);
        this.minimizer = new HybridMinimizer(firstMinimizer, secondMinimizer, cutoffIteration);
    }

    public void setMem(int mem) {
        this.mem = mem;
    }

    public void useConjugateGradientAscent(boolean verbose) {
        this.verbose = verbose;
        this.useConjugateGradientAscent();
    }

    public void useConjugateGradientAscent() {
        this.minimizer = new CGMinimizer(!this.verbose);
    }

    public void setUseSum(boolean useSum) {
    }

    public void setTuneSigmaHeldOut() {
        this.tuneSigmaHeldOut = true;
        this.tuneSigmaCV = false;
    }

    public void setTuneSigmaCV(int folds) {
        this.tuneSigmaCV = true;
        this.tuneSigmaHeldOut = false;
        this.folds = folds;
    }

    public void resetWeight() {
    }

    public void crossValidateSetSigma(GeneralDataset<L, F> dataset) {
        this.crossValidateSetSigma(dataset, 5);
    }

    public void crossValidateSetSigma(GeneralDataset<L, F> dataset, int kfold) {
        System.err.println("##you are here.");
        this.crossValidateSetSigma(dataset, kfold, new MultiClassAccuracyStats(2), new GoldenSectionLineSearch(true, 0.01, this.min, this.max));
    }

    public void crossValidateSetSigma(GeneralDataset<L, F> dataset, int kfold, Scorer<L> scorer) {
        this.crossValidateSetSigma(dataset, kfold, scorer, new GoldenSectionLineSearch(true, 0.01, this.min, this.max));
    }

    public void crossValidateSetSigma(GeneralDataset<L, F> dataset, int kfold, LineSearcher minimizer) {
        this.crossValidateSetSigma(dataset, kfold, new MultiClassAccuracyStats(2), minimizer);
    }

    public void crossValidateSetSigma(GeneralDataset<L, F> dataset, int kfold, final Scorer<L> scorer, LineSearcher minimizer) {
        System.err.println("##in Cross Validate, folds = " + kfold);
        System.err.println("##Scorer is " + scorer);
        this.featureIndex = dataset.featureIndex;
        this.labelIndex = dataset.labelIndex;
        final CrossValidator<L, F> crossValidator = new CrossValidator<L, F>(dataset, kfold);
        final Function score = new Function<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, CrossValidator.SavedState>, Double>(){

            @Override
            public Double apply(Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, CrossValidator.SavedState> fold) {
                GeneralDataset trainSet = fold.first();
                GeneralDataset devSet = fold.second();
                double[] weights = (double[])fold.third().state;
                double[][] weights2D = LinearClassifierFactory.this.trainWeights(trainSet, weights, true);
                fold.third().state = ArrayUtils.flatten(weights2D);
                LinearClassifier classifier = new LinearClassifier(weights2D, trainSet.featureIndex, trainSet.labelIndex);
                double score = scorer.score(classifier, devSet);
                System.out.print(".");
                return score;
            }
        };
        Function<Double, Double> negativeScorer = new Function<Double, Double>(){

            @Override
            public Double apply(Double sigmaToTry) {
                LinearClassifierFactory.this.setSigma(sigmaToTry);
                Double averageScore = crossValidator.computeAverage(score);
                System.err.print("##sigma = " + LinearClassifierFactory.this.getSigma() + " ");
                System.err.println("-> average Score: " + averageScore);
                return -averageScore.doubleValue();
            }
        };
        double bestSigma = minimizer.minimize(negativeScorer);
        System.err.println("##best sigma: " + bestSigma);
        this.setSigma(bestSigma);
    }

    public void setHeldOutSearcher(LineSearcher heldOutSearcher) {
        this.heldOutSearcher = heldOutSearcher;
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> train) {
        Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> data = train.split(0.3);
        return this.heldOutSetSigma(data.first(), data.second());
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> train, Scorer<L> scorer) {
        Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> data = train.split(0.3);
        return this.heldOutSetSigma(data.first(), data.second(), scorer);
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> train, GeneralDataset<L, F> dev) {
        return this.heldOutSetSigma(train, dev, new MultiClassAccuracyStats(2), this.heldOutSearcher == null ? new GoldenSectionLineSearch(true, 0.01, this.min, this.max) : this.heldOutSearcher);
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> train, GeneralDataset<L, F> dev, Scorer<L> scorer) {
        return this.heldOutSetSigma(train, dev, scorer, new GoldenSectionLineSearch(true, 0.01, this.min, this.max));
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> train, GeneralDataset<L, F> dev, LineSearcher minimizer) {
        return this.heldOutSetSigma(train, dev, new MultiClassAccuracyStats(2), minimizer);
    }

    public double[] heldOutSetSigma(GeneralDataset<L, F> trainSet, GeneralDataset<L, F> devSet, Scorer<L> scorer, LineSearcher minimizer) {
        this.featureIndex = trainSet.featureIndex;
        this.labelIndex = trainSet.labelIndex;
        Timing timer = new Timing();
        NegativeScorer negativeScorer = new NegativeScorer(trainSet, devSet, scorer, timer);
        timer.start();
        double bestSigma = minimizer.minimize(negativeScorer);
        System.err.println("##best sigma: " + bestSigma);
        this.setSigma(bestSigma);
        return ArrayUtils.flatten(this.trainWeights(trainSet, negativeScorer.weights, true));
    }

    public void setRetrainFromScratchAfterSigmaTuning(boolean retrainFromScratchAfterSigmaTuning) {
        this.retrainFromScratchAfterSigmaTuning = retrainFromScratchAfterSigmaTuning;
    }

    @Override
    public Classifier<L, F> trainClassifier(Iterable<Datum<L, F>> dataIterable) {
        Index featureIndex = Generics.newIndex();
        Index labelIndex = Generics.newIndex();
        for (Datum<L, F> d : dataIterable) {
            labelIndex.add(d.label());
            featureIndex.addAll(d.asFeatures());
        }
        System.err.println(String.format("Training linear classifier with %d features and %d labels", featureIndex.size(), labelIndex.size()));
        LogConditionalObjectiveFunction<L, F> objective = new LogConditionalObjectiveFunction<L, F>(dataIterable, this.logPrior, featureIndex, labelIndex);
        objective.setPrior(new LogPrior(LogPrior.LogPriorType.QUADRATIC));
        double[] initial = objective.initial();
        double[] weights = this.minimizer.minimize(objective, this.TOL, initial);
        LinearClassifier classifier = new LinearClassifier(objective.to2D(weights), featureIndex, labelIndex);
        return classifier;
    }

    public Classifier<L, F> trainClassifier(GeneralDataset<L, F> dataset, float[] dataWeights, LogPrior prior) {
        if (dataset instanceof RVFDataset) {
            ((RVFDataset)dataset).ensureRealValues();
        }
        LogConditionalObjectiveFunction<L, F> objective = new LogConditionalObjectiveFunction<L, F>(dataset, dataWeights, this.logPrior);
        double[] initial = objective.initial();
        double[] weights = this.minimizer.minimize(objective, this.TOL, initial);
        LinearClassifier<L, F> classifier = new LinearClassifier<L, F>(objective.to2D(weights), dataset.featureIndex(), dataset.labelIndex());
        return classifier;
    }

    @Override
    public LinearClassifier<L, F> trainClassifier(GeneralDataset<L, F> dataset) {
        return this.trainClassifier(dataset, null);
    }

    public LinearClassifier<L, F> trainClassifier(GeneralDataset<L, F> dataset, double[] initial) {
        if (dataset instanceof RVFDataset) {
            ((RVFDataset)dataset).ensureRealValues();
        }
        double[][] weights = this.trainWeights(dataset, initial, false);
        LinearClassifier<L, F> classifier = new LinearClassifier<L, F>(weights, dataset.featureIndex(), dataset.labelIndex());
        return classifier;
    }

    public Classifier<String, String> loadFromFilename(String file) {
        try {
            File tgtFile = new File(file);
            BufferedReader in = new BufferedReader(new FileReader(tgtFile));
            Index<String> labelIndex = HashIndex.loadFromReader(in);
            Index<String> featureIndex = HashIndex.loadFromReader(in);
            double[][] weights = new double[featureIndex.size()][labelIndex.size()];
            String line = in.readLine();
            int currLine = 1;
            while (line != null && line.length() > 0) {
                double value;
                String[] tuples = line.split("\t");
                if (tuples.length != 3) {
                    throw new Exception("Error: incorrect number of tokens in weight specifier, line=" + currLine + " in file " + tgtFile.getAbsolutePath());
                }
                ++currLine;
                int feature = Integer.valueOf(tuples[0]);
                int label = Integer.valueOf(tuples[1]);
                weights[feature][label] = value = Double.valueOf(tuples[2]).doubleValue();
                line = in.readLine();
            }
            int numThresholds = Integer.valueOf(in.readLine());
            double[] thresholds = new double[numThresholds];
            int curr = 0;
            while ((line = in.readLine()) != null) {
                double tval = Double.valueOf(line.trim());
                thresholds[curr++] = tval;
            }
            in.close();
            LinearClassifier<String, String> classifier = new LinearClassifier<String, String>(weights, featureIndex, labelIndex);
            return classifier;
        }
        catch (Exception e) {
            System.err.println("Error in LinearClassifierFactory, loading from file=" + file);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Deprecated
    public LinearClassifier<L, F> trainClassifier(List<RVFDatum<L, F>> examples) {
        return null;
    }

    public boolean setEvaluators(int iters, Evaluator[] evaluators) {
        if (this.minimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)this.minimizer)).setEvaluators(iters, evaluators);
            return true;
        }
        return false;
    }

    public LinearClassifierCreator<L, F> getClassifierCreator(GeneralDataset<L, F> dataset) {
        return new LinearClassifierCreator(dataset.featureIndex, dataset.labelIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinearClassifierCreator<L, F>
    implements ClassifierCreator,
    ProbabilisticClassifierCreator {
        LogConditionalObjectiveFunction objective;
        Index<F> featureIndex;
        Index<L> labelIndex;

        public LinearClassifierCreator(LogConditionalObjectiveFunction objective, Index<F> featureIndex, Index<L> labelIndex) {
            this.objective = objective;
            this.featureIndex = featureIndex;
            this.labelIndex = labelIndex;
        }

        public LinearClassifierCreator(Index<F> featureIndex, Index<L> labelIndex) {
            this.featureIndex = featureIndex;
            this.labelIndex = labelIndex;
        }

        public LinearClassifier createLinearClassifier(double[] weights) {
            double[][] weights2D = this.objective != null ? this.objective.to2D(weights) : ArrayUtils.to2D(weights, this.featureIndex.size(), this.labelIndex.size());
            return new LinearClassifier<L, F>(weights2D, this.featureIndex, this.labelIndex);
        }

        public Classifier createClassifier(double[] weights) {
            return this.createLinearClassifier(weights);
        }

        public ProbabilisticClassifier createProbabilisticClassifier(double[] weights) {
            return this.createLinearClassifier(weights);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NegativeScorer
    implements Function<Double, Double> {
        public double[] weights = null;
        GeneralDataset<L, F> trainSet;
        GeneralDataset<L, F> devSet;
        Scorer<L> scorer;
        Timing timer;

        public NegativeScorer(GeneralDataset<L, F> trainSet, GeneralDataset<L, F> devSet, Scorer<L> scorer, Timing timer) {
            this.trainSet = trainSet;
            this.devSet = devSet;
            this.scorer = scorer;
            this.timer = timer;
        }

        @Override
        public Double apply(Double sigmaToTry) {
            LinearClassifierFactory.this.setSigma(sigmaToTry);
            double[][] weights2D = LinearClassifierFactory.this.trainWeights(this.trainSet, this.weights, true);
            this.weights = ArrayUtils.flatten(weights2D);
            LinearClassifier classifier = new LinearClassifier(weights2D, this.trainSet.featureIndex, this.trainSet.labelIndex);
            double score = this.scorer.score(classifier, this.devSet);
            System.err.print("##sigma = " + LinearClassifierFactory.this.getSigma() + " ");
            System.err.println("-> average Score: " + score);
            System.err.println("##time elapsed: " + this.timer.stop() + " milliseconds.");
            this.timer.restart();
            return -score;
        }
    }
}

