/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.classify.WeightedDataset;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.math.ADMath;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.DoubleAD;
import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffUpdateFunction;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.util.Index;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConditionalObjectiveFunction<L, F>
extends AbstractStochasticCachingDiffUpdateFunction {
    protected LogPrior prior;
    protected int numFeatures = 0;
    protected int numClasses = 0;
    protected int[][] data = null;
    protected Iterable<Datum<L, F>> dataIterable = null;
    protected double[][] values = null;
    protected int[] labels = null;
    protected float[] dataweights = null;
    protected double[] derivativeNumerator = null;
    protected DoubleAD[] xAD = null;
    protected double[] priorDerivative = null;
    protected DoubleAD[] derivativeAD = null;
    protected DoubleAD[] sums = null;
    protected DoubleAD[] probs = null;
    protected Index<L> labelIndex = null;
    protected Index<F> featureIndex = null;
    protected boolean useIterable = false;
    protected boolean useSummedConditionalLikelihood = false;

    public void setPrior(LogPrior prior) {
        this.prior = prior;
        this.clearCache();
    }

    @Override
    public int domainDimension() {
        return this.numFeatures * this.numClasses;
    }

    @Override
    public int dataDimension() {
        return this.data.length;
    }

    int classOf(int index) {
        return index % this.numClasses;
    }

    int featureOf(int index) {
        return index / this.numClasses;
    }

    protected int indexOf(int f, int c) {
        return f * this.numClasses + c;
    }

    public double[][] to2D(double[] x) {
        double[][] x2 = new double[this.numFeatures][this.numClasses];
        for (int i = 0; i < this.numFeatures; ++i) {
            for (int j = 0; j < this.numClasses; ++j) {
                x2[i][j] = x[this.indexOf(i, j)];
            }
        }
        return x2;
    }

    @Override
    protected void calculate(double[] x) {
        if (this.useSummedConditionalLikelihood) {
            this.calculateSCL(x);
        } else {
            this.calculateCL(x);
        }
    }

    @Override
    public void calculateStochastic(double[] x, double[] v, int[] batch) {
        if (this.method.calculatesHessianVectorProduct() && v != null) {
            if (this.method.equals((Object)StochasticCalculateMethods.AlgorithmicDifferentiation)) {
                this.calculateStochasticAlgorithmicDifferentiation(x, v, batch);
            } else if (this.method.equals((Object)StochasticCalculateMethods.IncorporatedFiniteDifference)) {
                this.calculateStochasticFiniteDifference(x, v, this.finiteDifferenceStepSize, batch);
            }
        } else {
            this.calculateStochasticGradientOnly(x, batch);
        }
    }

    private void calculateSCL(double[] x) {
        this.value = 0.0;
        Arrays.fill(this.derivative, 0.0);
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        double[] counts = new double[this.numClasses];
        Arrays.fill(counts, 0.0);
        for (int d = 0; d < this.data.length; ++d) {
            int[] features = this.data[d];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i];
                }
            }
            double total = ArrayMath.logSum(sums);
            int ld = this.labels[d];
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + probs[ld] * probs[c];
                }
            }
            for (int f = 0; f < features.length; ++f) {
                int i;
                int n = i = this.indexOf(features[f], this.labels[d]);
                this.derivative[n] = this.derivative[n] - probs[ld];
            }
            this.value -= probs[ld];
        }
        int i = 0;
        while (i < x.length) {
            double k = 1.0;
            double w = x[i];
            this.value += k * w * w / 2.0;
            int n = i++;
            this.derivative[n] = this.derivative[n] + k * w;
        }
    }

    private void calculateCL(double[] x) {
        if (this.values != null) {
            this.rvfcalculate(x);
            return;
        }
        this.value = 0.0;
        if (this.derivative == null) {
            this.derivative = new double[x.length];
        } else {
            Arrays.fill(this.derivative, 0.0);
        }
        if (this.derivativeNumerator == null) {
            this.derivativeNumerator = new double[x.length];
            if (this.data != null) {
                for (int d = 0; d < this.data.length; ++d) {
                    int[] features = this.data[d];
                    for (int f = 0; f < features.length; ++f) {
                        int i = this.indexOf(features[f], this.labels[d]);
                        if (this.dataweights == null) {
                            int n = i;
                            this.derivativeNumerator[n] = this.derivativeNumerator[n] - 1.0;
                            continue;
                        }
                        int n = i;
                        this.derivativeNumerator[n] = this.derivativeNumerator[n] - (double)this.dataweights[d];
                    }
                }
            } else if (this.dataIterable != null) {
                for (Datum<L, F> datum : this.dataIterable) {
                    Collection features = datum.asFeatures();
                    for (Object feature : features) {
                        int i = this.indexOf(this.featureIndex.indexOf(feature), this.labelIndex.indexOf(datum.label()));
                        if (this.dataweights != null) continue;
                        int n = i;
                        this.derivativeNumerator[n] = this.derivativeNumerator[n] - 1.0;
                    }
                }
            } else {
                System.err.println("Both were null!  Couldn't calculate.");
                System.exit(-1);
            }
        }
        this.copy(this.derivative, this.derivativeNumerator);
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        Iterator<Datum<L, F>> iter = null;
        int d = -1;
        if (this.useIterable) {
            iter = this.dataIterable.iterator();
        }
        Datum<L, F> datum = null;
        while (true) {
            int c;
            if (this.useIterable) {
                if (!iter.hasNext()) break;
                datum = iter.next();
            } else if (++d >= this.data.length) break;
            Arrays.fill(sums, 0.0);
            double total = 0.0;
            if (!this.useIterable) {
                int i;
                int f;
                int[] featuresArr = this.data[d];
                for (c = 0; c < this.numClasses; ++c) {
                    for (f = 0; f < featuresArr.length; ++f) {
                        i = this.indexOf(featuresArr[f], c);
                        int n = c;
                        sums[n] = sums[n] + x[i];
                    }
                }
                total = ArrayMath.logSum(sums);
                for (c = 0; c < this.numClasses; ++c) {
                    probs[c] = Math.exp(sums[c] - total);
                    if (this.dataweights != null) {
                        int n = c;
                        probs[n] = probs[n] * (double)this.dataweights[d];
                    }
                    for (f = 0; f < featuresArr.length; ++f) {
                        int n = i = this.indexOf(featuresArr[f], c);
                        this.derivative[n] = this.derivative[n] + probs[c];
                    }
                }
            } else {
                int i;
                Collection features = datum.asFeatures();
                for (c = 0; c < this.numClasses; ++c) {
                    for (Object feature : features) {
                        i = this.indexOf(this.featureIndex.indexOf(feature), c);
                        int n = c;
                        sums[n] = sums[n] + x[i];
                    }
                }
                total = ArrayMath.logSum(sums);
                for (c = 0; c < this.numClasses; ++c) {
                    probs[c] = Math.exp(sums[c] - total);
                    if (this.dataweights != null) {
                        int n = c;
                        probs[n] = probs[n] * (double)this.dataweights[d];
                    }
                    for (Object feature : features) {
                        int n = i = this.indexOf(this.featureIndex.indexOf(feature), c);
                        this.derivative[n] = this.derivative[n] + probs[c];
                    }
                }
            }
            int labelindex = this.useIterable ? this.labelIndex.indexOf(datum.label()) : this.labels[d];
            double dV = sums[labelindex] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[d];
            }
            this.value -= dV;
        }
        this.value += this.prior.compute(x, this.derivative);
    }

    public void calculateStochasticFiniteDifference(double[] x, double[] v, double h, int[] batch) {
        if (this.values != null) {
            this.rvfcalculate(x);
            return;
        }
        this.value = 0.0;
        if (this.priorDerivative == null) {
            this.priorDerivative = new double[x.length];
        }
        double priorFactor = (double)batch.length / ((double)this.data.length * this.prior.getSigma() * this.prior.getSigma());
        this.derivative = ArrayMath.multiply(x, priorFactor);
        this.HdotV = ArrayMath.multiply(v, priorFactor);
        double[] sums = new double[this.numClasses];
        double[] sumsV = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        double[] probsV = new double[this.numClasses];
        for (int d = 0; d < batch.length; ++d) {
            int m = batch[d];
            int[] features = this.data[m];
            Arrays.fill(sums, 0.0);
            Arrays.fill(sumsV, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i];
                    int n2 = c;
                    sumsV[n2] = sumsV[n2] + (x[i] + h * v[i]);
                }
            }
            double total = ArrayMath.logSum(sums);
            double totalV = ArrayMath.logSum(sumsV);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                probsV[c] = Math.exp(sumsV[c] - totalV);
                if (this.dataweights != null) {
                    int n = c;
                    probs[n] = probs[n] * (double)this.dataweights[m];
                    int n3 = c;
                    probsV[n3] = probsV[n3] * (double)this.dataweights[m];
                }
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + probs[c];
                    int n4 = i;
                    this.HdotV[n4] = this.HdotV[n4] + (probsV[c] - probs[c]) / h;
                    if (c != this.labels[m]) continue;
                    int n5 = i;
                    this.derivative[n5] = this.derivative[n5] - 1.0;
                }
            }
            double dV = sums[this.labels[m]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[m];
            }
            this.value -= dV;
        }
        this.value += (double)batch.length / (double)this.data.length * this.prior.compute(x, this.priorDerivative);
    }

    public void calculateStochasticGradientOnly(double[] x, int[] batch) {
        if (this.values != null) {
            this.rvfcalculate(x);
            return;
        }
        this.value = 0.0;
        int batchSize = batch.length;
        if (this.priorDerivative == null) {
            this.priorDerivative = new double[x.length];
        }
        double priorFactor = (double)batchSize / ((double)this.data.length * this.prior.getSigma() * this.prior.getSigma());
        this.derivative = ArrayMath.multiply(x, priorFactor);
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        for (int d = 0; d < batchSize; ++d) {
            int m = batch[d];
            int[] features = this.data[m];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i];
                }
            }
            double total = ArrayMath.logSum(sums);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                if (this.dataweights != null) {
                    int n = c;
                    probs[n] = probs[n] * (double)this.dataweights[m];
                }
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + probs[c];
                    if (c != this.labels[m]) continue;
                    int n2 = i;
                    this.derivative[n2] = this.derivative[n2] - 1.0;
                }
            }
            double dV = sums[this.labels[m]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[m];
            }
            this.value -= dV;
        }
        this.value += (double)batchSize / (double)this.data.length * this.prior.compute(x, this.priorDerivative);
    }

    @Override
    public double valueAt(double[] x, double xscale, int[] batch) {
        this.value = 0.0;
        int batchSize = batch.length;
        double[] sums = new double[this.numClasses];
        for (int d = 0; d < batchSize; ++d) {
            int m = batch[d];
            int[] features = this.data[m];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    if (this.values != null) {
                        int n = c;
                        sums[n] = sums[n] + x[i] * xscale * this.values[m][f];
                        continue;
                    }
                    int n = c;
                    sums[n] = sums[n] + x[i] * xscale;
                }
            }
            double total = ArrayMath.logSum(sums);
            double dV = sums[this.labels[m]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[m];
            }
            this.value -= dV;
        }
        return this.value;
    }

    @Override
    public double calculateStochasticUpdate(double[] x, double xscale, int[] batch, double gain) {
        this.value = 0.0;
        int batchSize = batch.length;
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        for (int d = 0; d < batchSize; ++d) {
            int m = batch[d];
            int[] features = this.data[m];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    if (this.values != null) {
                        int n = c;
                        sums[n] = sums[n] + x[i] * xscale * this.values[m][f];
                        continue;
                    }
                    int n = c;
                    sums[n] = sums[n] + x[i] * xscale;
                }
            }
            for (int f = 0; f < features.length; ++f) {
                int i = this.indexOf(features[f], this.labels[m]);
                double v = this.values != null ? this.values[m][f] : 1.0;
                double delta = this.dataweights != null ? (double)this.dataweights[m] * v : v;
                int n = i;
                x[n] = x[n] + delta * gain;
            }
            double total = ArrayMath.logSum(sums);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                if (this.dataweights != null) {
                    int n = c;
                    probs[n] = probs[n] * (double)this.dataweights[m];
                }
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    double v = this.values != null ? this.values[m][f] : 1.0;
                    double delta = probs[c] * v;
                    int n = i;
                    x[n] = x[n] - delta * gain;
                }
            }
            double dV = sums[this.labels[m]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[m];
            }
            this.value -= dV;
        }
        return this.value;
    }

    protected void calculateStochasticAlgorithmicDifferentiation(double[] x, double[] v, int[] batch) {
        int c;
        int i;
        System.err.print("*");
        this.value = 0.0;
        if (this.derivativeAD == null) {
            this.derivativeAD = new DoubleAD[x.length];
            for (i = 0; i < x.length; ++i) {
                this.derivativeAD[i] = new DoubleAD(0.0, 0.0);
            }
        }
        if (this.xAD == null) {
            this.xAD = new DoubleAD[x.length];
            for (i = 0; i < x.length; ++i) {
                this.xAD[i] = new DoubleAD(x[i], v[i]);
            }
        }
        if (this.sums == null) {
            this.sums = new DoubleAD[this.numClasses];
            for (c = 0; c < this.numClasses; ++c) {
                this.sums[c] = new DoubleAD(0.0, 0.0);
            }
        }
        if (this.probs == null) {
            this.probs = new DoubleAD[this.numClasses];
            for (c = 0; c < this.numClasses; ++c) {
                this.probs[c] = new DoubleAD(0.0, 0.0);
            }
        }
        for (i = 0; i < x.length; ++i) {
            this.xAD[i].set(x[i], v[i]);
            this.derivativeAD[i].set(0.0, 0.0);
        }
        for (int d = 0; d < batch.length; ++d) {
            int c2;
            int m = (this.curElement + d) % this.data.length;
            int[] features = this.data[m];
            for (c2 = 0; c2 < this.numClasses; ++c2) {
                this.sums[c2].set(0.0, 0.0);
            }
            for (c2 = 0; c2 < this.numClasses; ++c2) {
                for (int f = 0; f < features.length; ++f) {
                    int i2 = this.indexOf(features[f], c2);
                    this.sums[c2] = ADMath.plus(this.sums[c2], this.xAD[i2]);
                }
            }
            DoubleAD total = ADMath.logSum(this.sums);
            for (int c3 = 0; c3 < this.numClasses; ++c3) {
                this.probs[c3] = ADMath.exp(ADMath.minus(this.sums[c3], total));
                if (this.dataweights != null) {
                    this.probs[c3] = ADMath.multConst(this.probs[c3], this.dataweights[d]);
                }
                for (int f = 0; f < features.length; ++f) {
                    int i3 = this.indexOf(features[f], c3);
                    if (c3 == this.labels[m]) {
                        this.derivativeAD[i3].plusEqualsConst(-1.0);
                    }
                    this.derivativeAD[i3].plusEquals(this.probs[c3]);
                }
            }
            double dV = this.sums[this.labels[m]].getval() - total.getval();
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[d];
            }
            this.value -= dV;
        }
        double[] tmp = new double[x.length];
        for (int i4 = 0; i4 < x.length; ++i4) {
            tmp[i4] = this.derivativeAD[i4].getval();
            this.derivativeAD[i4].plusEquals(ADMath.multConst(this.xAD[i4], (double)batch.length / ((double)this.data.length * this.prior.getSigma() * this.prior.getSigma())));
            this.derivative[i4] = this.derivativeAD[i4].getval();
            this.HdotV[i4] = this.derivativeAD[i4].getdot();
        }
        this.value += (double)batch.length / (double)this.data.length * this.prior.compute(x, tmp);
    }

    protected void rvfcalculate(double[] x) {
        this.value = 0.0;
        if (this.derivativeNumerator == null) {
            this.derivativeNumerator = new double[x.length];
            for (int d = 0; d < this.data.length; ++d) {
                int[] features = this.data[d];
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], this.labels[d]);
                    if (this.dataweights == null) {
                        int n = i;
                        this.derivativeNumerator[n] = this.derivativeNumerator[n] - this.values[d][f];
                        continue;
                    }
                    int n = i;
                    this.derivativeNumerator[n] = this.derivativeNumerator[n] - (double)this.dataweights[d] * this.values[d][f];
                }
            }
        }
        this.copy(this.derivative, this.derivativeNumerator);
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        for (int d = 0; d < this.data.length; ++d) {
            int[] features = this.data[d];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i] * this.values[d][f];
                }
            }
            double total = ArrayMath.logSum(sums);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                if (this.dataweights != null) {
                    int n = c;
                    probs[n] = probs[n] * (double)this.dataweights[d];
                }
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + probs[c] * this.values[d][f];
                }
            }
            double dV = sums[this.labels[d]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[d];
            }
            this.value -= dV;
        }
        this.value += this.prior.compute(x, this.derivative);
    }

    public void setUseSumCondObjFun(boolean value) {
        this.useSummedConditionalLikelihood = value;
    }

    public LogConditionalObjectiveFunction(GeneralDataset<L, F> dataset) {
        this(dataset, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public LogConditionalObjectiveFunction(GeneralDataset<L, F> dataset, LogPrior prior) {
        this(dataset, prior, false);
    }

    public LogConditionalObjectiveFunction(GeneralDataset<L, F> dataset, float[] dataWeights, LogPrior prior) {
        this(dataset, prior, false);
        this.dataweights = dataWeights;
        System.err.println("correct constructor");
    }

    public LogConditionalObjectiveFunction(GeneralDataset<L, F> dataset, LogPrior prior, boolean useSumCondObjFun) {
        this.setPrior(prior);
        this.setUseSumCondObjFun(useSumCondObjFun);
        this.numFeatures = dataset.numFeatures();
        this.numClasses = dataset.numClasses();
        this.data = dataset.getDataArray();
        this.labels = dataset.getLabelsArray();
        this.values = dataset.getValuesArray();
        if (dataset instanceof WeightedDataset) {
            this.dataweights = ((WeightedDataset)dataset).getWeights();
        }
    }

    public LogConditionalObjectiveFunction(Iterable<Datum<L, F>> dataIterable, LogPrior logPrior, Index<F> featureIndex, Index<L> labelIndex) {
        this.setPrior(this.prior);
        this.setUseSumCondObjFun(false);
        this.useIterable = true;
        this.numFeatures = featureIndex.size();
        this.numClasses = labelIndex.size();
        this.data = null;
        this.dataIterable = dataIterable;
        this.labelIndex = labelIndex;
        this.featureIndex = featureIndex;
        this.labels = null;
        this.values = null;
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, boolean useSumCondObjFun) {
        this(numFeatures, numClasses, data, labels);
        this.useSummedConditionalLikelihood = useSumCondObjFun;
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels) {
        this(numFeatures, numClasses, data, labels, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, LogPrior prior) {
        this(numFeatures, numClasses, data, labels, null, prior);
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, float[] dataweights) {
        this(numFeatures, numClasses, data, labels, dataweights, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, float[] dataweights, LogPrior prior) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        this.data = data;
        this.labels = labels;
        this.prior = prior;
        this.dataweights = dataweights;
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, int intPrior, double sigma, double epsilon) {
        this(numFeatures, numClasses, data, null, labels, intPrior, sigma, epsilon);
    }

    public LogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, double[][] values, int[] labels, int intPrior, double sigma, double epsilon) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        this.data = data;
        this.values = values;
        this.labels = labels;
        this.prior = new LogPrior(intPrior, sigma, epsilon);
    }
}

