/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import java.util.HashSet;
import java.util.Map;

public class ScorerMUC
extends CorefScorer {
    public ScorerMUC() {
        this.scoreType = CorefScorer.ScoreType.MUC;
    }

    protected void calculateRecall(Document doc) {
        int rDen = 0;
        int rNum = 0;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (CorefCluster g : doc.goldCorefClusters.values()) {
            if (g.corefMentions.size() == 0) continue;
            rDen += g.corefMentions.size() - 1;
            rNum += g.corefMentions.size();
            HashSet<CorefCluster> partitions = new HashSet<CorefCluster>();
            for (Mention goldMention : g.corefMentions) {
                if (!predictedMentions.containsKey(goldMention.mentionID)) {
                    --rNum;
                    continue;
                }
                partitions.add(doc.corefClusters.get(predictedMentions.get((Object)Integer.valueOf((int)goldMention.mentionID)).corefClusterID));
            }
            rNum -= partitions.size();
        }
        assert (rDen == doc.allGoldMentions.size() - doc.goldCorefClusters.values().size());
        this.recallNumSum += (double)rNum;
        this.recallDenSum += (double)rDen;
    }

    protected void calculatePrecision(Document doc) {
        int pDen = 0;
        int pNum = 0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        for (CorefCluster c : doc.corefClusters.values()) {
            if (c.corefMentions.size() == 0) continue;
            pDen += c.corefMentions.size() - 1;
            pNum += c.corefMentions.size();
            HashSet<CorefCluster> partitions = new HashSet<CorefCluster>();
            for (Mention predictedMention : c.corefMentions) {
                if (!goldMentions.containsKey(predictedMention.mentionID)) {
                    --pNum;
                    continue;
                }
                partitions.add(doc.goldCorefClusters.get(goldMentions.get((Object)Integer.valueOf((int)predictedMention.mentionID)).goldCorefClusterID));
            }
            pNum -= partitions.size();
        }
        assert (pDen == doc.allPredictedMentions.size() - doc.corefClusters.values().size());
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += (double)pNum;
    }
}

