/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import java.util.Map;

public class ScorerPairwise
extends CorefScorer {
    public ScorerPairwise() {
        this.scoreType = CorefScorer.ScoreType.Pairwise;
    }

    protected void calculateRecall(Document doc) {
        int rDen = 0;
        int rNum = 0;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (CorefCluster g : doc.goldCorefClusters.values()) {
            int clusterSize = g.getCorefMentions().size();
            rDen += clusterSize * (clusterSize - 1) / 2;
            for (Mention m1 : g.getCorefMentions()) {
                for (Mention m2 : g.getCorefMentions()) {
                    if (m1.mentionID >= m2.mentionID || !predictedMentions.containsKey(m1.mentionID) || !predictedMentions.containsKey(m2.mentionID) || predictedMentions.get((Object)Integer.valueOf((int)m1.mentionID)).corefClusterID != predictedMentions.get((Object)Integer.valueOf((int)m2.mentionID)).corefClusterID) continue;
                    ++rNum;
                }
            }
        }
        this.recallDenSum += (double)rDen;
        this.recallNumSum += (double)rNum;
    }

    protected void calculatePrecision(Document doc) {
        int pDen = 0;
        int pNum = 0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        for (CorefCluster c : doc.corefClusters.values()) {
            int clusterSize = c.getCorefMentions().size();
            pDen += clusterSize * (clusterSize - 1) / 2;
            for (Mention m1 : c.getCorefMentions()) {
                for (Mention m2 : c.getCorefMentions()) {
                    if (m1.mentionID >= m2.mentionID || !goldMentions.containsKey(m1.mentionID) || !goldMentions.containsKey(m2.mentionID) || goldMentions.get((Object)Integer.valueOf((int)m1.mentionID)).goldCorefClusterID != goldMentions.get((Object)Integer.valueOf((int)m2.mentionID)).goldCorefClusterID) continue;
                    ++pNum;
                }
            }
        }
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += (double)pNum;
    }
}

