/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.ACEMentionExtractor;
import edu.stanford.nlp.dcoref.CoNLLMentionExtractor;
import edu.stanford.nlp.dcoref.Constants;
import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefMentionFinder;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.MUCMentionExtractor;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.ScorerBCubed;
import edu.stanford.nlp.dcoref.ScorerMUC;
import edu.stanford.nlp.dcoref.ScorerPairwise;
import edu.stanford.nlp.dcoref.WordNet;
import edu.stanford.nlp.dcoref.sievepasses.DeterministicCorefSieve;
import edu.stanford.nlp.dcoref.sievepasses.ExactStringMatch;
import edu.stanford.nlp.io.StringOutputStream;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.stats.OpenAddressCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.SystemUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SieveCoreferenceSystem {
    public static final Logger logger = Logger.getLogger(SieveCoreferenceSystem.class.getName());
    private final boolean doScore;
    private final boolean doPostProcessing;
    private final int maxSentDist;
    private final boolean useSemantics;
    private final boolean replicateCoNLL;
    private final String conllMentionEvalScript;
    private final DeterministicCorefSieve[] sieves;
    private final String[] sieveClassNames;
    private final Dictionaries dictionaries;
    private final Semantics semantics;
    public int currentSieve = -1;
    public List<Pair<Integer, Integer>> linksCountInPass = new ArrayList<Pair<Integer, Integer>>();
    public List<CorefScorer> scorePairwise = new ArrayList<CorefScorer>();
    public List<CorefScorer> scoreBcubed = new ArrayList<CorefScorer>();
    public List<CorefScorer> scoreMUC = new ArrayList<CorefScorer>();
    private List<CorefScorer> scoreSingleDoc;
    int additionalCorrectLinksCount;
    int additionalLinksCount;

    public SieveCoreferenceSystem(Properties props) throws Exception {
        int i;
        String sievePasses = props.getProperty("dcoref.sievePasses", "MarkRole, DiscourseMatch, ExactStringMatch, RelaxedExactStringMatch, PreciseConstructs, StrictHeadMatch1, StrictHeadMatch2, StrictHeadMatch3, StrictHeadMatch4, RelaxedHeadMatch, PronounMatch");
        this.sieveClassNames = sievePasses.trim().split(",\\s*");
        this.sieves = new DeterministicCorefSieve[this.sieveClassNames.length];
        for (i = 0; i < this.sieveClassNames.length; ++i) {
            this.sieves[i] = (DeterministicCorefSieve)Class.forName("edu.stanford.nlp.dcoref.sievepasses." + this.sieveClassNames[i]).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sieves[i].init(props);
        }
        this.doScore = Boolean.parseBoolean(props.getProperty("dcoref.score", "false"));
        this.doPostProcessing = Boolean.parseBoolean(props.getProperty("dcoref.postprocessing", "false"));
        this.maxSentDist = Integer.parseInt(props.getProperty("dcoref.maxdist", "-1"));
        this.useSemantics = sievePasses.contains("AliasMatch") || sievePasses.contains("LexicalChainMatch");
        this.replicateCoNLL = Boolean.parseBoolean(props.getProperty("dcoref.replicate.conll", "false"));
        this.conllMentionEvalScript = props.getProperty("dcoref.conll.score", "/scr/nlp/data/conll-2011/scorer/v3/scorer.pl");
        if (this.doScore) {
            for (i = 0; i < this.sieveClassNames.length; ++i) {
                this.scorePairwise.add(new ScorerPairwise());
                this.scoreBcubed.add(new ScorerBCubed(ScorerBCubed.BCubedType.Bconll));
                this.scoreMUC.add(new ScorerMUC());
                this.linksCountInPass.add(new Pair<Integer, Integer>(0, 0));
            }
        }
        this.dictionaries = new Dictionaries(props);
        this.semantics = this.useSemantics ? new Semantics(this.dictionaries) : null;
    }

    public boolean doScore() {
        return this.doScore;
    }

    public Dictionaries dictionaries() {
        return this.dictionaries;
    }

    public Semantics semantics() {
        return this.semantics;
    }

    private static LexicalizedParser makeParser(Properties props) {
        LexicalizedParser parser = new LexicalizedParser(props.getProperty("parser.model", "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz"));
        int maxLen = Integer.parseInt(props.getProperty("parser.maxlen", "100"));
        parser.setOptionFlags("-maxLength", Integer.toString(maxLen));
        return parser;
    }

    public static void main(String[] args) throws Exception {
        Document document;
        Properties props = StringUtils.argsToProperties(args);
        String timeStamp = Calendar.getInstance().getTime().toString().replaceAll("\\s", "-");
        try {
            String logFileName = props.getProperty("dcoref.logFile", "log.txt");
            logFileName = logFileName.endsWith(".txt") ? logFileName.substring(0, logFileName.length() - 4) + "_" + timeStamp + ".txt" : logFileName + "_" + timeStamp + ".txt";
            FileHandler fh = new FileHandler(logFileName, false);
            logger.addHandler(fh);
            logger.setLevel(Level.FINE);
            fh.setFormatter(new LogFormatter());
        }
        catch (SecurityException e) {
            System.err.println("ERROR: cannot initialize logger!");
            throw e;
        }
        catch (IOException e) {
            System.err.println("ERROR: cannot initialize logger!");
            throw e;
        }
        logger.fine(timeStamp);
        logger.fine(props.toString());
        Constants.printConstants(logger);
        SieveCoreferenceSystem corefSystem = new SieveCoreferenceSystem(props);
        LexicalizedParser parser = SieveCoreferenceSystem.makeParser(props);
        PrintWriter writerGold = null;
        PrintWriter writerPredicted = null;
        PrintWriter writerPredictedCoref = null;
        String conllOutputMentionGoldFile = null;
        String conllOutputMentionPredictedFile = null;
        String conllOutputMentionCorefPredictedFile = null;
        String conllMentionEvalFile = null;
        String conllMentionEvalErrFile = null;
        String conllMentionCorefEvalFile = null;
        String conllMentionCorefEvalErrFile = null;
        if (corefSystem.replicateCoNLL) {
            String conllOutput = props.getProperty("dcoref.conll.output", "conlloutput");
            conllOutputMentionGoldFile = conllOutput + "-" + timeStamp + ".gold.txt";
            conllOutputMentionPredictedFile = conllOutput + "-" + timeStamp + ".predicted.txt";
            conllOutputMentionCorefPredictedFile = conllOutput + "-" + timeStamp + ".coref.predicted.txt";
            conllMentionEvalFile = conllOutput + "-" + timeStamp + ".eval.txt";
            conllMentionEvalErrFile = conllOutput + "-" + timeStamp + ".eval.err.txt";
            conllMentionCorefEvalFile = conllOutput + "-" + timeStamp + ".coref.eval.txt";
            conllMentionCorefEvalErrFile = conllOutput + "-" + timeStamp + ".coref.eval.err.txt";
            logger.info("CONLL MENTION GOLD FILE: " + conllOutputMentionGoldFile);
            logger.info("CONLL MENTION PREDICTED FILE: " + conllOutputMentionPredictedFile);
            logger.info("CONLL MENTION EVAL FILE: " + conllMentionEvalFile);
            logger.info("CONLL MENTION PREDICTED WITH COREF FILE: " + conllOutputMentionCorefPredictedFile);
            logger.info("CONLL MENTION WITH COREF EVAL FILE: " + conllMentionCorefEvalFile);
            writerGold = new PrintWriter(new FileOutputStream(conllOutputMentionGoldFile));
            writerPredicted = new PrintWriter(new FileOutputStream(conllOutputMentionPredictedFile));
            writerPredictedCoref = new PrintWriter(new FileOutputStream(conllOutputMentionCorefPredictedFile));
        }
        MentionExtractor mentionExtractor = null;
        if (props.containsKey("dcoref.muc")) {
            mentionExtractor = new MUCMentionExtractor(parser, corefSystem.dictionaries, props, corefSystem.semantics);
        } else if (props.containsKey("dcoref.ace2004") || props.containsKey("dcoref.ace2005")) {
            mentionExtractor = new ACEMentionExtractor(parser, corefSystem.dictionaries, props, corefSystem.semantics);
        } else if (props.containsKey("dcoref.conll2011")) {
            mentionExtractor = new CoNLLMentionExtractor(parser, corefSystem.dictionaries, props, corefSystem.semantics);
        }
        if (mentionExtractor == null) {
            throw new RuntimeException("No input file specified!");
        }
        String mentionFinderClass = props.getProperty("dcoref.mentionFinder");
        if (mentionFinderClass != null) {
            CorefMentionFinder mentionFinder;
            String mentionFinderPropFilename = props.getProperty("dcoref.mentionFinder.props");
            if (mentionFinderPropFilename != null) {
                Properties mentionFinderProps = new Properties();
                mentionFinderProps.load(new FileInputStream(mentionFinderPropFilename));
                mentionFinder = (CorefMentionFinder)Class.forName(mentionFinderClass).getConstructor(Properties.class).newInstance(mentionFinderProps);
            } else {
                mentionFinder = (CorefMentionFinder)Class.forName(mentionFinderClass).newInstance();
            }
            mentionExtractor.setMentionFinder(mentionFinder);
        }
        if (mentionExtractor.mentionFinder == null) {
            logger.warning("No mention finder specified, but not using gold mentions");
        }
        while ((document = mentionExtractor.nextDoc()) != null) {
            if (!props.containsKey("dcoref.muc")) {
                SieveCoreferenceSystem.printRawDoc(document, true);
                SieveCoreferenceSystem.printRawDoc(document, false);
            }
            SieveCoreferenceSystem.printDiscourseStructure(document);
            if (corefSystem.doScore()) {
                document.extractGoldCorefClusters();
            }
            if (corefSystem.replicateCoNLL) {
                SieveCoreferenceSystem.printConllOutput(document, writerGold, true);
                SieveCoreferenceSystem.printConllOutput(document, writerPredicted, false);
            }
            corefSystem.coref(document);
            if (corefSystem.doScore()) {
                corefSystem.printTopK(logger, document, corefSystem.semantics);
                logger.fine("pairwise score for this doc: ");
                corefSystem.scoreSingleDoc.get(corefSystem.sieves.length - 1).printF1(logger);
                logger.fine("accumulated score: ");
                corefSystem.printF1(true);
                logger.fine("\n");
            }
            if (!corefSystem.replicateCoNLL) continue;
            SieveCoreferenceSystem.printConllOutput(document, writerPredictedCoref, false, true);
        }
        if (corefSystem.replicateCoNLL) {
            writerGold.close();
            writerPredicted.close();
            writerPredictedCoref.close();
            if (props.containsKey("dcoref.conll.score")) {
                SieveCoreferenceSystem.runConllEval(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionPredictedFile, conllMentionEvalFile, conllMentionEvalErrFile);
                String summary = SieveCoreferenceSystem.getConllEvalSummary(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionPredictedFile);
                logger.info("CONLL EVAL SUMMARY (Before COREF)\n" + summary);
                SieveCoreferenceSystem.runConllEval(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionCorefPredictedFile, conllMentionCorefEvalFile, conllMentionCorefEvalErrFile);
                summary = SieveCoreferenceSystem.getConllEvalSummary(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionCorefPredictedFile);
                logger.info("CONLL EVAL SUMMARY (After COREF)\n" + summary);
                SieveCoreferenceSystem.printFinalScore(summary);
            }
        }
        logger.info("done");
    }

    public Map<Integer, CorefChain> coref(Document document) {
        for (int i = 0; i < this.sieves.length; ++i) {
            this.currentSieve = i;
            DeterministicCorefSieve sieve = this.sieves[i];
            this.coreference(document, sieve);
        }
        if (this.doPostProcessing || this.replicateCoNLL) {
            this.postProcessing(document);
        }
        HashMap<Integer, CorefChain> result = new HashMap<Integer, CorefChain>();
        for (CorefCluster c : document.corefClusters.values()) {
            result.put(c.clusterID, new CorefChain(c, document.positions));
        }
        return result;
    }

    private void coreference(Document document, DeterministicCorefSieve sieve) {
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        Map<Integer, CorefCluster> corefClusters = document.corefClusters;
        Set<Mention> roleSet = document.roleSet;
        logger.finest("ROLE SET (Skip exact string match): ------------------");
        for (Mention m : roleSet) {
            logger.finest("\t" + m.spanToString());
        }
        logger.finest("-------------------------------------------------------");
        this.additionalCorrectLinksCount = 0;
        this.additionalLinksCount = 0;
        for (int sentI = 0; sentI < orderedMentionsBySentence.size(); ++sentI) {
            List<Mention> orderedMentions = orderedMentionsBySentence.get(sentI);
            block2: for (int mentionI = 0; mentionI < orderedMentions.size(); ++mentionI) {
                Mention m1 = orderedMentions.get(mentionI);
                if (sieve.skipThisMention(document, m1, corefClusters.get(m1.corefClusterID), this.dictionaries)) continue;
                for (int sentJ = sentI; sentJ >= 0; --sentJ) {
                    List<Mention> l = sieve.getOrderedAntecedents(sentJ, sentI, orderedMentions, orderedMentionsBySentence, m1, mentionI, corefClusters, this.dictionaries);
                    if (this.maxSentDist != -1 && sentJ - sentI > this.maxSentDist) continue;
                    for (int i = 0; i < l.size(); ++i) {
                        for (int j = 0; j < l.size(); ++j) {
                            if (!l.get((int)i).headString.equals(l.get((int)j).headString) || l.get((int)i).startIndex != l.get((int)j).startIndex || !l.get(i).sameSentence(l.get(j)) || j <= i || l.get(i).spanToString().length() <= l.get(j).spanToString().length()) continue;
                            logger.finest("FLIPPED: " + l.get(i).spanToString() + "(" + i + "), " + l.get(j).spanToString() + "(" + j + ")");
                            l.set(j, l.set(i, l.get(j)));
                        }
                    }
                    for (Mention m2 : l) {
                        if (m1.corefClusterID == m2.corefClusterID) continue;
                        CorefCluster c1 = corefClusters.get(m1.corefClusterID);
                        CorefCluster c2 = corefClusters.get(m2.corefClusterID);
                        if (sieve.useRoleSkip()) {
                            if (m1.isRoleAppositive(m2, this.dictionaries)) {
                                roleSet.add(m1);
                                continue;
                            }
                            if (!m2.isRoleAppositive(m1, this.dictionaries)) continue;
                            roleSet.add(m2);
                            continue;
                        }
                        if (!sieve.coreferent(document, c1, c2, m1, m2, this.dictionaries, roleSet, this.semantics)) continue;
                        if (this.doScore()) {
                            SieveCoreferenceSystem.printLogs(c1, c2, m1, m2, document, this.currentSieve);
                        }
                        int removeID = c1.clusterID;
                        CorefCluster.mergeClusters(c2, c1);
                        corefClusters.remove(removeID);
                        continue block2;
                    }
                }
            }
        }
        if (this.doScore()) {
            this.scoreMUC.get(this.currentSieve).calculateScore(document);
            this.scoreBcubed.get(this.currentSieve).calculateScore(document);
            this.scorePairwise.get(this.currentSieve).calculateScore(document);
            if (this.currentSieve == 0) {
                this.scoreSingleDoc = new ArrayList<CorefScorer>();
                this.scoreSingleDoc.add(new ScorerPairwise());
                this.scoreSingleDoc.get(this.currentSieve).calculateScore(document);
                this.additionalCorrectLinksCount = (int)this.scoreSingleDoc.get((int)this.currentSieve).precisionNumSum;
                this.additionalLinksCount = (int)this.scoreSingleDoc.get((int)this.currentSieve).precisionDenSum;
            } else {
                this.scoreSingleDoc.add(new ScorerPairwise());
                this.scoreSingleDoc.get(this.currentSieve).calculateScore(document);
                this.additionalCorrectLinksCount = (int)(this.scoreSingleDoc.get((int)this.currentSieve).precisionNumSum - this.scoreSingleDoc.get((int)(this.currentSieve - 1)).precisionNumSum);
                this.additionalLinksCount = (int)(this.scoreSingleDoc.get((int)this.currentSieve).precisionDenSum - this.scoreSingleDoc.get((int)(this.currentSieve - 1)).precisionDenSum);
            }
            this.linksCountInPass.get(this.currentSieve).setFirst(this.linksCountInPass.get(this.currentSieve).first() + this.additionalCorrectLinksCount);
            this.linksCountInPass.get(this.currentSieve).setSecond(this.linksCountInPass.get(this.currentSieve).second() + this.additionalLinksCount);
            this.printSieveScore(document, sieve);
        }
    }

    private void postProcessing(Document document) {
        HashSet<IntTuple> removeSet = new HashSet<IntTuple>();
        HashSet<Integer> removeClusterSet = new HashSet<Integer>();
        for (CorefCluster c : document.corefClusters.values()) {
            HashSet<Mention> removeMentions = new HashSet<Mention>();
            for (Mention m : c.getCorefMentions()) {
                if (!(m.appositions != null && m.appositions.size() > 0 || m.predicateNominatives != null && m.predicateNominatives.size() > 0) && (m.relativePronouns == null || m.relativePronouns.size() <= 0)) continue;
                removeMentions.add(m);
                removeSet.add(document.positions.get(m));
                m.corefClusterID = m.mentionID;
            }
            c.corefMentions.removeAll(removeMentions);
            if (c.getCorefMentions().size() != 1) continue;
            removeClusterSet.add(c.clusterID);
        }
        Iterator<CorefCluster> i$ = removeClusterSet.iterator();
        while (i$.hasNext()) {
            int removeId = (Integer)((Object)i$.next());
            document.corefClusters.remove(removeId);
        }
        for (IntTuple pos : removeSet) {
            document.positions.remove(pos);
        }
    }

    private static List<List<Mention>> filterMentionsWithSingletonClusters(Document document, List<List<Mention>> mentions) {
        ArrayList<List<Mention>> res = new ArrayList<List<Mention>>(mentions.size());
        for (List<Mention> ml : mentions) {
            ArrayList<Mention> filtered = new ArrayList<Mention>();
            for (Mention m : ml) {
                CorefCluster cluster = document.corefClusters.get(m.corefClusterID);
                if (cluster == null || cluster.getCorefMentions().size() <= 1) continue;
                filtered.add(m);
            }
            res.add(filtered);
        }
        return res;
    }

    private static void runConllEval(String conllMentionEvalScript, String goldFile, String predictFile, String evalFile, String errFile) throws IOException {
        ProcessBuilder process = new ProcessBuilder(conllMentionEvalScript, "all", goldFile, predictFile);
        PrintWriter out2 = new PrintWriter(new FileOutputStream(evalFile));
        PrintWriter err2 = new PrintWriter(new FileOutputStream(errFile));
        SystemUtils.run(process, out2, err2);
        out2.close();
        err2.close();
    }

    private static String getConllEvalSummary(String conllMentionEvalScript, String goldFile, String predictFile) throws IOException {
        ProcessBuilder process = new ProcessBuilder(conllMentionEvalScript, "all", goldFile, predictFile, "none");
        StringOutputStream errSos = new StringOutputStream();
        StringOutputStream outSos = new StringOutputStream();
        PrintWriter out2 = new PrintWriter(outSos);
        PrintWriter err2 = new PrintWriter(errSos);
        SystemUtils.run(process, out2, err2);
        out2.close();
        err2.close();
        String summary = outSos.toString();
        String errStr = errSos.toString();
        if (errStr.length() > 0) {
            summary = summary + "\nERROR: " + errStr;
        }
        return summary;
    }

    public void printTopK(Logger logger, Document document, Semantics semantics) {
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        Map<Integer, CorefCluster> corefClusters = document.corefClusters;
        HashMap<Mention, IntTuple> positions = document.positions;
        Map<Integer, Mention> golds = document.allGoldMentions;
        logger.fine("=======ERROR ANALYSIS=========================================================");
        for (int i = 0; i < orderedMentionsBySentence.size(); ++i) {
            for (int j = 0; j < orderedMentionsBySentence.get(i).size(); ++j) {
                Mention m = orderedMentionsBySentence.get(i).get(j);
                List<Mention> orderedMentions = orderedMentionsBySentence.get(i);
                logger.fine("=========Line: " + i + "\tmention: " + j + "=======================================================");
                logger.fine(m.spanToString() + "\tmentionID: " + m.mentionID + "\tcorefClusterID: " + m.corefClusterID + "\tgoldCorefClusterID: " + m.goldCorefClusterID);
                CorefCluster corefCluster = corefClusters.get(m.corefClusterID);
                if (corefCluster != null) {
                    corefCluster.printCorefCluster(logger);
                } else {
                    logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                }
                logger.fine("-------------------------------------------------------");
                boolean oneRecallErrorPrinted = false;
                boolean onePrecisionErrorPrinted = false;
                boolean alreadyChoose = false;
                for (int sentJ = i; sentJ >= 0; --sentJ) {
                    int ii;
                    List<Mention> l = new ExactStringMatch().getOrderedAntecedents(sentJ, i, orderedMentions, orderedMentionsBySentence, m, j, corefClusters, this.dictionaries);
                    for (ii = 0; ii < l.size(); ++ii) {
                        for (int jj = 0; jj < l.size(); ++jj) {
                            if (!l.get((int)ii).headString.equals(l.get((int)jj).headString) || l.get((int)ii).startIndex != l.get((int)jj).startIndex || !l.get(ii).sameSentence(l.get(jj)) || jj <= ii || l.get(ii).spanToString().length() <= l.get(jj).spanToString().length()) continue;
                            logger.finest("FLIPPED: " + l.get(ii).spanToString() + "(" + ii + "), " + l.get(jj).spanToString() + "(" + jj + ")");
                            l.set(jj, l.set(ii, l.get(jj)));
                        }
                    }
                    logger.finest("Candidates in sentence #" + sentJ + " for mention: " + m.spanToString());
                    for (ii = 0; ii < l.size(); ++ii) {
                        logger.finest("\tCandidate #" + ii + ": " + l.get(ii).spanToString());
                    }
                    for (Mention antecedent : l) {
                        boolean chosen = m.corefClusterID == antecedent.corefClusterID;
                        IntTuple src = new IntTuple(2);
                        src.set(0, i);
                        src.set(1, j);
                        IntTuple ant = positions.get(antecedent);
                        boolean coreferent = golds.containsKey(m.mentionID) && golds.containsKey(antecedent.mentionID) && golds.get((Object)Integer.valueOf((int)m.mentionID)).goldCorefClusterID == golds.get((Object)Integer.valueOf((int)antecedent.mentionID)).goldCorefClusterID;
                        boolean correct = chosen == coreferent;
                        String chosenness = chosen ? "Chosen" : "Not Chosen";
                        String correctness = correct ? "Correct" : "Incorrect";
                        logger.fine("\t" + correctness + "\t\t" + chosenness + "\t" + antecedent.spanToString());
                        CorefCluster mC = corefClusters.get(m.corefClusterID);
                        CorefCluster aC = corefClusters.get(antecedent.corefClusterID);
                        if (chosen && !correct && !onePrecisionErrorPrinted && !alreadyChoose) {
                            onePrecisionErrorPrinted = true;
                            SieveCoreferenceSystem.printLinkWithContext(logger, "\nPRECISION ERROR ", src, ant, document, semantics);
                            logger.fine("END of PRECISION ERROR LOG");
                        }
                        if (!chosen && !correct && !oneRecallErrorPrinted && (!alreadyChoose || alreadyChoose && onePrecisionErrorPrinted)) {
                            oneRecallErrorPrinted = true;
                            SieveCoreferenceSystem.printLinkWithContext(logger, "\nRECALL ERROR ", src, ant, document, semantics);
                            logger.finer("cluster info: ");
                            if (mC != null) {
                                mC.printCorefCluster(logger);
                            } else {
                                logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                            }
                            logger.finer("----------------------------------------------------------");
                            if (aC != null) {
                                aC.printCorefCluster(logger);
                            } else {
                                logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                            }
                            logger.finer("");
                            logger.fine("END of RECALL ERROR LOG");
                        }
                        if (!chosen) continue;
                        alreadyChoose = true;
                    }
                }
                logger.fine("\n");
            }
        }
        logger.fine("===============================================================================");
    }

    public void printF1(boolean printF1First) {
        this.scoreMUC.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
        this.scoreBcubed.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
        this.scorePairwise.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
    }

    private void printSieveScore(Document document, DeterministicCorefSieve sieve) {
        logger.fine("===========================================");
        logger.fine("pass" + this.currentSieve + ": " + sieve.flagsToString());
        this.scoreMUC.get(this.currentSieve).printF1(logger);
        this.scoreBcubed.get(this.currentSieve).printF1(logger);
        this.scorePairwise.get(this.currentSieve).printF1(logger);
        logger.fine("# of Clusters: " + document.corefClusters.size() + ",\t# of additional links: " + this.additionalLinksCount + ",\t# of additional correct links: " + this.additionalCorrectLinksCount + ",\tprecision of new links: " + 1.0 * (double)this.additionalCorrectLinksCount / (double)this.additionalLinksCount);
        logger.fine("# of total additional links: " + this.linksCountInPass.get(this.currentSieve).second() + ",\t# of total additional correct links: " + this.linksCountInPass.get(this.currentSieve).first() + ",\taccumulated precision of this pass: " + 1.0 * (double)this.linksCountInPass.get(this.currentSieve).first().intValue() / (double)this.linksCountInPass.get(this.currentSieve).second().intValue());
        logger.fine("--------------------------------------");
    }

    private static void printLink(Logger logger, String header, IntTuple src, IntTuple dst, List<List<Mention>> orderedMentionsBySentence) {
        Mention srcMention = orderedMentionsBySentence.get(src.get(0)).get(src.get(1));
        Mention dstMention = orderedMentionsBySentence.get(dst.get(0)).get(dst.get(1));
        if (src.get(0) == dst.get(0)) {
            logger.fine(header + ": [" + srcMention.spanToString() + "](id=" + srcMention.mentionID + ") in sent #" + src.get(0) + " => [" + dstMention.spanToString() + "](id=" + dstMention.mentionID + ") in sent #" + dst.get(0) + " Same Sentence");
        } else {
            logger.fine(header + ": [" + srcMention.spanToString() + "](id=" + srcMention.mentionID + ") in sent #" + src.get(0) + " => [" + dstMention.spanToString() + "](id=" + dstMention.mentionID + ") in sent #" + dst.get(0));
        }
    }

    protected static void printList(Logger logger, String ... args) {
        String p = "";
        for (String arg : args) {
            p = p + arg + "\t";
        }
        logger.fine(p);
    }

    private static void printLinkWithContext(Logger logger, String header, IntTuple src, IntTuple dst, Document document, Semantics semantics) {
        int i;
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        List<List<Mention>> goldOrderedMentionsBySentence = document.goldOrderedMentionsBySentence;
        Mention srcMention = orderedMentionsBySentence.get(src.get(0)).get(src.get(1));
        Mention dstMention = orderedMentionsBySentence.get(dst.get(0)).get(dst.get(1));
        List<CoreLabel> srcSentence = srcMention.sentenceWords;
        List<CoreLabel> dstSentence = dstMention.sentenceWords;
        SieveCoreferenceSystem.printLink(logger, header, src, dst, orderedMentionsBySentence);
        SieveCoreferenceSystem.printList(logger, "Mention:" + srcMention.spanToString(), "Gender:" + srcMention.gender.toString(), "Number:" + srcMention.number.toString(), "Animacy:" + srcMention.animacy.toString(), "Person:" + srcMention.person.toString(), "NER:" + srcMention.nerString, "Head:" + srcMention.headString, "Type:" + srcMention.mentionType.toString(), "utter: " + srcMention.headWord.get(CoreAnnotations.UtteranceAnnotation.class), "speakerID: " + (String)srcMention.headWord.get(CoreAnnotations.SpeakerAnnotation.class), "twinless:" + srcMention.twinless);
        logger.fine("Context:");
        String p = "";
        for (int i2 = 0; i2 < srcSentence.size(); ++i2) {
            if (i2 == srcMention.startIndex) {
                p = p + "[";
            }
            if (i2 == srcMention.endIndex) {
                p = p + "]";
            }
            p = p + srcSentence.get(i2).word() + " ";
        }
        logger.fine(p);
        StringBuilder golds = new StringBuilder();
        golds.append("Gold mentions in the sentence:\n");
        OpenAddressCounter<Integer> mBegin = new OpenAddressCounter<Integer>();
        OpenAddressCounter<Integer> mEnd = new OpenAddressCounter<Integer>();
        for (Mention m : goldOrderedMentionsBySentence.get(src.get(0))) {
            mBegin.incrementCount(m.startIndex);
            mEnd.incrementCount(m.endIndex);
        }
        List l = (List)((CoreMap)((List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(src.get(0))).get(CoreAnnotations.TokensAnnotation.class);
        for (i = 0; i < l.size(); ++i) {
            int j = 0;
            while ((double)j < mEnd.getCount(i)) {
                golds.append("]");
                ++j;
            }
            j = 0;
            while ((double)j < mBegin.getCount(i)) {
                golds.append("[");
                ++j;
            }
            golds.append((String)((CoreLabel)l.get(i)).get(CoreAnnotations.TextAnnotation.class));
            golds.append(" ");
        }
        logger.fine(golds.toString());
        SieveCoreferenceSystem.printList(logger, "\nAntecedent:" + dstMention.spanToString(), "Gender:" + dstMention.gender.toString(), "Number:" + dstMention.number.toString(), "Animacy:" + dstMention.animacy.toString(), "Person:" + dstMention.person.toString(), "NER:" + dstMention.nerString, "Head:" + dstMention.headString, "Type:" + dstMention.mentionType.toString(), "utter: " + dstMention.headWord.get(CoreAnnotations.UtteranceAnnotation.class), "speakerID: " + (String)dstMention.headWord.get(CoreAnnotations.SpeakerAnnotation.class), "twinless:" + dstMention.twinless);
        logger.fine("Context:");
        p = "";
        for (i = 0; i < dstSentence.size(); ++i) {
            if (i == dstMention.startIndex) {
                p = p + "[";
            }
            if (i == dstMention.endIndex) {
                p = p + "]";
            }
            p = p + dstSentence.get(i).word() + " ";
        }
        logger.fine(p);
        golds = new StringBuilder();
        golds.append("Gold mentions in the sentence:\n");
        mBegin = new OpenAddressCounter();
        mEnd = new OpenAddressCounter();
        for (Mention m : goldOrderedMentionsBySentence.get(dst.get(0))) {
            mBegin.incrementCount(m.startIndex);
            mEnd.incrementCount(m.endIndex);
        }
        l = (List)((CoreMap)((List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(dst.get(0))).get(CoreAnnotations.TokensAnnotation.class);
        for (int i3 = 0; i3 < l.size(); ++i3) {
            int j = 0;
            while ((double)j < mEnd.getCount(i3)) {
                golds.append("]");
                ++j;
            }
            j = 0;
            while ((double)j < mBegin.getCount(i3)) {
                golds.append("[");
                ++j;
            }
            golds.append((String)((CoreLabel)l.get(i3)).get(CoreAnnotations.TextAnnotation.class));
            golds.append(" ");
        }
        logger.fine(golds.toString());
        logger.finer("\nMention:: --------------------------------------------------------");
        try {
            logger.finer(srcMention.dependency.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.finer("Parse:");
        logger.finer(SieveCoreferenceSystem.formatPennTree(srcMention.contextParseTree));
        logger.finer("\nAntecedent:: -----------------------------------------------------");
        try {
            logger.finer(dstMention.dependency.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.finer("Parse:");
        logger.finer(SieveCoreferenceSystem.formatPennTree(dstMention.contextParseTree));
    }

    public static String formatPennTree(Tree parseTree) {
        String treeString = parseTree.pennString();
        treeString = treeString.replaceAll("\\[TextAnnotation=", "");
        treeString = treeString.replaceAll("(NamedEntityTag|Value|Index|PartOfSpeech)Annotation.+?\\)", ")");
        treeString = treeString.replaceAll("\\[.+?\\]", "");
        return treeString;
    }

    private static void printLogs(CorefCluster c1, CorefCluster c2, Mention m1, Mention m2, Document document, int sieveIndex) {
        HashMap<Mention, IntTuple> positions = document.positions;
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        List<Pair<IntTuple, IntTuple>> goldLinks = document.getGoldLinks();
        IntTuple p1 = positions.get(m1);
        assert (p1 != null);
        IntTuple p2 = positions.get(m2);
        assert (p2 != null);
        int menDist = 0;
        for (int i = p2.get(0); i <= p1.get(0); ++i) {
            if (p1.get(0) == p2.get(0)) {
                menDist = p1.get(1) - p2.get(1);
                break;
            }
            if (i == p2.get(0)) {
                menDist += orderedMentionsBySentence.get(p2.get(0)).size() - p2.get(1);
                continue;
            }
            if (i == p1.get(0)) {
                menDist += p1.get(1);
                continue;
            }
            if (p2.get(0) >= i || i >= p1.get(0)) continue;
            menDist += orderedMentionsBySentence.get(i).size();
        }
        String correct = goldLinks.contains(new Pair<IntTuple, IntTuple>(p1, p2)) ? "\tCorrect" : "\tIncorrect";
        logger.finest("\nsentence distance: " + (p1.get(0) - p2.get(0)) + "\tmention distance: " + menDist + correct);
        if (!goldLinks.contains(new Pair<IntTuple, IntTuple>(p1, p2))) {
            logger.finer("-------Incorrect merge in pass" + sieveIndex + "::--------------------");
            c1.printCorefCluster(logger);
            logger.finer("--------------------------------------------");
            c2.printCorefCluster(logger);
            logger.finer("--------------------------------------------");
        }
        logger.finer("antecedent: " + m2.spanToString() + "(" + m2.mentionID + ")\tmention: " + m1.spanToString() + "(" + m1.mentionID + ")\tsentDistance: " + Math.abs(m1.sentNum - m2.sentNum) + "\t" + correct + " Pass" + sieveIndex + ":");
    }

    private static void printDiscourseStructure(Document document) {
        logger.finer("DISCOURSE STRUCTURE==============================");
        logger.finer("doc type: " + (Object)((Object)document.docType));
        int previousUtterIndex = -1;
        String previousSpeaker = "";
        StringBuilder sb = new StringBuilder();
        for (CoreMap s : (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel l : (List)s.get(CoreAnnotations.TokensAnnotation.class)) {
                int utterIndex = (Integer)l.get(CoreAnnotations.UtteranceAnnotation.class);
                String speaker = (String)l.get(CoreAnnotations.SpeakerAnnotation.class);
                String word = (String)l.get(CoreAnnotations.TextAnnotation.class);
                if (previousUtterIndex != utterIndex) {
                    try {
                        int previousSpeakerID = Integer.parseInt(previousSpeaker);
                        logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + document.allPredictedMentions.get(previousSpeakerID).spanToString());
                    }
                    catch (Exception e) {
                        logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + previousSpeaker);
                    }
                    logger.finer(sb.toString());
                    sb.setLength(0);
                    previousUtterIndex = utterIndex;
                    previousSpeaker = speaker;
                }
                sb.append(" ").append(word);
            }
            sb.append("\n");
        }
        try {
            int previousSpeakerID = Integer.parseInt(previousSpeaker);
            logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + document.allPredictedMentions.get(previousSpeakerID).spanToString());
        }
        catch (Exception e) {
            logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + previousSpeaker);
        }
        logger.finer(sb.toString());
        logger.finer("END OF DISCOURSE STRUCTURE==============================");
    }

    private static void printFinalScore(String summary) {
        Pattern f1 = Pattern.compile("Coreference:.*F1: (.*)%");
        Matcher f1Matcher = f1.matcher(summary);
        double[] F1s = new double[5];
        int i = 0;
        while (f1Matcher.find()) {
            F1s[i++] = Double.parseDouble(f1Matcher.group(1));
        }
        logger.info("Final score ((muc+bcub+ceafe)/3) = " + (F1s[0] + F1s[1] + F1s[3]) / 3.0);
    }

    private static void printConllOutput(Document document, PrintWriter writer, boolean gold) {
        SieveCoreferenceSystem.printConllOutput(document, writer, gold, false);
    }

    private static void printConllOutput(Document document, PrintWriter writer, boolean gold, boolean filterSingletons) {
        List<List<Mention>> orderedMentions = gold ? document.goldOrderedMentionsBySentence : document.predictedOrderedMentionsBySentence;
        if (filterSingletons) {
            orderedMentions = SieveCoreferenceSystem.filterMentionsWithSingletonClusters(document, orderedMentions);
        }
        SieveCoreferenceSystem.printConllOutput(document, writer, orderedMentions, gold);
    }

    protected static void printConllOutput(Document document, PrintWriter writer, List<List<Mention>> orderedMentions, boolean gold) {
        Annotation anno = document.annotation;
        List<List<String[]>> conllDocSentences = document.conllDoc.sentenceWordLists;
        String docID = (String)anno.get(CoreAnnotations.DocIDAnnotation.class);
        StringBuilder sb = new StringBuilder();
        sb.append("#begin document ").append(docID).append("\n");
        List sentences = (List)anno.get(CoreAnnotations.SentencesAnnotation.class);
        for (int sentNum = 0; sentNum < sentences.size(); ++sentNum) {
            int i;
            List sentence = (List)((CoreMap)sentences.get(sentNum)).get(CoreAnnotations.TokensAnnotation.class);
            List<String[]> conllSentence = conllDocSentences.get(sentNum);
            HashMap mentionBeginOnly = new HashMap();
            HashMap mentionEndOnly = new HashMap();
            HashMap mentionBeginEnd = new HashMap();
            for (i = 0; i < sentence.size(); ++i) {
                mentionBeginOnly.put(i, new LinkedHashSet());
                mentionEndOnly.put(i, new LinkedHashSet());
                mentionBeginEnd.put(i, new LinkedHashSet());
            }
            for (Mention m : orderedMentions.get(sentNum)) {
                if (m.startIndex == m.endIndex - 1) {
                    ((Set)mentionBeginEnd.get(m.startIndex)).add(m);
                    continue;
                }
                ((Set)mentionBeginOnly.get(m.startIndex)).add(m);
                ((Set)mentionEndOnly.get(m.endIndex - 1)).add(m);
            }
            for (i = 0; i < sentence.size(); ++i) {
                int corefClusterId;
                StringBuilder sb2 = new StringBuilder();
                for (Mention m : (Set)mentionBeginOnly.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append("(").append(corefClusterId);
                }
                for (Mention m : (Set)mentionBeginEnd.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append("(").append(corefClusterId).append(")");
                }
                for (Mention m : (Set)mentionEndOnly.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append(corefClusterId).append(")");
                }
                if (sb2.length() == 0) {
                    sb2.append("-");
                }
                String[] columns = conllSentence.get(i);
                for (int j = 0; j < columns.length - 1; ++j) {
                    String column = columns[j];
                    sb.append(column).append("\t");
                }
                sb.append((CharSequence)sb2).append("\n");
            }
            sb.append("\n");
        }
        sb.append("#end document").append("\n");
        writer.print(sb.toString());
        writer.flush();
    }

    private static void printRawDoc(Document document, boolean gold) throws FileNotFoundException {
        List sentences = (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        List<List<Mention>> allMentions = gold ? document.goldOrderedMentionsBySentence : document.predictedOrderedMentionsBySentence;
        StringBuilder doc = new StringBuilder();
        int previousOffset = 0;
        OpenAddressCounter<Integer> mentionCount = new OpenAddressCounter<Integer>();
        for (List<Mention> l : allMentions) {
            for (Mention m : l) {
                mentionCount.incrementCount(m.goldCorefClusterID);
            }
        }
        for (int i = 0; i < sentences.size(); ++i) {
            CoreMap sentence = (CoreMap)sentences.get(i);
            List<Mention> mentions = allMentions.get(i);
            String[] tokens = ((String)sentence.get(CoreAnnotations.TextAnnotation.class)).split(" ");
            List t = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            if (previousOffset + 2 < (Integer)((CoreLabel)t.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                doc.append("\n");
            }
            previousOffset = (Integer)((CoreLabel)t.get(t.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            OpenAddressCounter<Integer> startCounts = new OpenAddressCounter<Integer>();
            OpenAddressCounter<Integer> endCounts = new OpenAddressCounter<Integer>();
            HashMap endMentions = new HashMap();
            for (Mention m : mentions) {
                startCounts.incrementCount(m.startIndex);
                endCounts.incrementCount(m.endIndex);
                if (!endMentions.containsKey(m.endIndex)) {
                    endMentions.put(m.endIndex, new HashSet());
                }
                ((Set)endMentions.get(m.endIndex)).add(m);
            }
            for (int j = 0; j < tokens.length; ++j) {
                if (endMentions.containsKey(j)) {
                    for (Mention m : (Set)endMentions.get(j)) {
                        int corefChainId = gold ? m.goldCorefClusterID : m.corefClusterID;
                        doc.append("]_").append(corefChainId);
                    }
                }
                int k = 0;
                while ((double)k < startCounts.getCount(j)) {
                    int lastChar;
                    int n = lastChar = doc.length() > 0 ? (int)doc.charAt(doc.length() - 1) : 32;
                    if (lastChar != 91) {
                        doc.append(" ");
                    }
                    doc.append("[");
                    ++k;
                }
                doc.append(" ");
                doc.append(tokens[j]);
            }
            if (endMentions.containsKey(tokens.length)) {
                for (Mention m : (Set)endMentions.get(tokens.length)) {
                    int corefChainId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    doc.append("]_").append(corefChainId);
                }
            }
            doc.append("\n");
        }
        logger.fine((String)document.annotation.get(CoreAnnotations.DocIDAnnotation.class));
        if (gold) {
            logger.fine("New DOC: (GOLD MENTIONS) ==================================================");
        } else {
            logger.fine("New DOC: (Predicted Mentions) ==================================================");
        }
        logger.fine(doc.toString());
    }

    public static List<Pair<IntTuple, IntTuple>> getLinks(Map<Integer, CorefChain> result) {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        CorefChain.MentionComparator comparator = new CorefChain.MentionComparator();
        for (CorefChain c : result.values()) {
            List<CorefChain.CorefMention> s = c.getCorefMentions();
            for (CorefChain.CorefMention m1 : s) {
                for (CorefChain.CorefMention m2 : s) {
                    if (comparator.compare(m1, m2) != 1) continue;
                    links.add(new Pair<IntTuple, IntTuple>(m1.position, m2.position));
                }
            }
        }
        return links;
    }

    static class LogFormatter
    extends Formatter {
        LogFormatter() {
        }

        public String format(LogRecord rec) {
            StringBuilder buf = new StringBuilder(1000);
            buf.append(this.formatMessage(rec));
            buf.append('\n');
            return buf.toString();
        }
    }

    public class Semantics {
        public WordNet wordnet = new WordNet();

        public Semantics(Dictionaries dict) throws Exception {
        }
    }
}

