/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.ner.CMMClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierCombiner
extends AbstractSequenceClassifier<CoreLabel> {
    private static final boolean DEBUG = false;
    private List<AbstractSequenceClassifier> baseClassifiers;
    private static final String DEFAULT_AUX_CLASSIFIER_PATH = "/u/nlp/data/ner/goodClassifiers/muc.7class.distsim.crf.ser.gz";
    private static final String DEFAULT_CLASSIFIER_PATH = "/u/nlp/data/ner/goodClassifiers/all.3class.distsim.crf.ser.gz";

    public ClassifierCombiner(Properties p) throws FileNotFoundException {
        super(p);
        String loadPath2;
        ArrayList<String> paths = new ArrayList<String>();
        String loadPath1 = p.getProperty("loadClassifier1");
        if (loadPath1 != null && (loadPath2 = p.getProperty("loadClassifier2")) != null) {
            paths.add(loadPath1);
            paths.add(loadPath2);
            for (int i = 3; i <= 10; ++i) {
                String path = p.getProperty("loadClassifier" + i);
                if (path == null) continue;
                paths.add(path);
            }
            this.loadClassifiers(paths);
        } else {
            loadPath1 = p.getProperty("loadClassifier");
            if (loadPath1 != null && (loadPath2 = p.getProperty("loadAuxClassifier")) != null) {
                paths.add(loadPath1);
                paths.add(loadPath2);
                this.loadClassifiers(paths);
            } else {
                paths.add(DEFAULT_CLASSIFIER_PATH);
                paths.add(DEFAULT_AUX_CLASSIFIER_PATH);
                this.loadClassifiers(paths);
            }
        }
    }

    public ClassifierCombiner(String ... loadPaths) throws FileNotFoundException {
        super(new Properties());
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : loadPaths) {
            paths.add(path);
        }
        this.loadClassifiers(paths);
    }

    public ClassifierCombiner(AbstractSequenceClassifier ... classifiers) {
        super(new Properties());
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier>();
        for (AbstractSequenceClassifier cls : classifiers) {
            this.baseClassifiers.add(cls);
        }
        this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
    }

    private void loadClassifiers(List<String> paths) throws FileNotFoundException {
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier>();
        for (String path : paths) {
            AbstractSequenceClassifier cls = ClassifierCombiner.loadClassifierFromPath(path);
            this.baseClassifiers.add(cls);
        }
        this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
    }

    public static AbstractSequenceClassifier loadClassifierFromPath(String path) throws FileNotFoundException {
        try {
            return CRFClassifier.getClassifier(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return CMMClassifier.getClassifier(path);
            }
            catch (Exception e2) {
                FileNotFoundException fnfe = new FileNotFoundException();
                fnfe.initCause(e2);
                throw fnfe;
            }
        }
    }

    @Override
    public Set<String> labels() {
        HashSet<String> labs = new HashSet<String>();
        for (AbstractSequenceClassifier cls : this.baseClassifiers) {
            labs.addAll(cls.labels());
        }
        return labs;
    }

    private List<CoreLabel> mergeDocuments(List<List<CoreLabel>> baseDocuments) {
        assert (!this.baseClassifiers.isEmpty() && !baseDocuments.isEmpty());
        for (int i = 1; i < baseDocuments.size(); ++i) {
            assert (baseDocuments.get(0).size() == baseDocuments.get(i).size());
        }
        ArrayList<Set<String>> baseLabels = new ArrayList<Set<String>>();
        HashSet<String> seenLabels = new HashSet<String>();
        for (int i = 0; i < this.baseClassifiers.size(); ++i) {
            Set<String> labs = this.baseClassifiers.get(i).labels();
            labs.removeAll(seenLabels);
            seenLabels.addAll(labs);
            baseLabels.add(labs);
        }
        String background = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        List<CoreLabel> mainDocument = baseDocuments.get(0);
        for (int i = 1; i < baseDocuments.size(); ++i) {
            this.mergeTwoDocuments(mainDocument, baseDocuments.get(i), (Set)baseLabels.get(i), background);
        }
        return mainDocument;
    }

    private void mergeTwoDocuments(List<CoreLabel> mainDocument, List<CoreLabel> auxDocument, Set<String> auxLabels, String background) {
        boolean insideAuxTag = false;
        boolean auxTagValid = true;
        String prevAnswer = background;
        ArrayList<CoreLabel> constituents = new ArrayList<CoreLabel>();
        ListIterator<CoreLabel> auxIterator = auxDocument.listIterator();
        for (CoreLabel wMain : mainDocument) {
            boolean insideMainTag;
            CoreLabel wAux = (CoreLabel)auxIterator.next();
            String auxAnswer = (String)wAux.get(CoreAnnotations.AnswerAnnotation.class);
            String mainAnswer = (String)wMain.get(CoreAnnotations.AnswerAnnotation.class);
            boolean bl = insideMainTag = !mainAnswer.equals(background);
            if (auxLabels.contains(auxAnswer)) {
                if (!prevAnswer.equals(auxAnswer) && !prevAnswer.equals(background)) {
                    if (auxTagValid) {
                        for (CoreLabel wi : constituents) {
                            wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                        }
                    }
                    constituents = new ArrayList();
                }
                insideAuxTag = true;
                if (insideMainTag) {
                    auxTagValid = false;
                }
                prevAnswer = auxAnswer;
                constituents.add(wMain);
                continue;
            }
            if (insideAuxTag) {
                if (auxTagValid) {
                    for (CoreLabel wi : constituents) {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                    }
                }
                constituents = new ArrayList();
            }
            insideAuxTag = false;
            auxTagValid = true;
            prevAnswer = background;
        }
    }

    private List<CoreLabel> deepCopy(List<CoreLabel> tokens) {
        ArrayList<CoreLabel> copy = new ArrayList<CoreLabel>();
        for (CoreLabel ml : tokens) {
            CoreLabel ml1 = new CoreLabel(ml);
            copy.add(ml1);
        }
        return copy;
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> tokens) {
        int i;
        if (this.baseClassifiers.isEmpty()) {
            return tokens;
        }
        ArrayList<List<CoreLabel>> baseOutputs = new ArrayList<List<CoreLabel>>();
        List output = this.baseClassifiers.get(0).classifySentence(tokens);
        for (i = 0; i < output.size(); ++i) {
            tokens.get(i).set(CoreAnnotations.AnswerAnnotation.class, ((CoreLabel)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class));
        }
        baseOutputs.add(tokens);
        for (i = 1; i < this.baseClassifiers.size(); ++i) {
            List<CoreLabel> copy = tokens;
            output = this.baseClassifiers.get(i).classifySentence(copy);
            baseOutputs.add(output);
        }
        assert (baseOutputs.size() == this.baseClassifiers.size());
        List<CoreLabel> finalAnswer = this.mergeDocuments(baseOutputs);
        return finalAnswer;
    }

    @Override
    public void train(Collection<List<CoreLabel>> docs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printProbsDocument(List<CoreLabel> document) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serializeClassifier(String serializePath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        ClassifierCombiner ec = new ClassifierCombiner(props);
        System.err.println(ec.classifyToString("Marketing : Sony Hopes to Win Much Bigger Market For Wide Range of Small-Video Products ---- By Andrew B. Cohen Staff Reporter of The Wall Street Journal"));
    }
}

