/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.ClassifierCombiner;
import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NERClassifierCombiner
extends ClassifierCombiner {
    private final boolean applyNumericClassifiers;
    public static final String APPLY_NUMERIC_CLASSIFIERS_STRING = "true";
    public static final boolean APPLY_NUMERIC_CLASSIFIERS_DEFAULT = true;
    public static final String APPLY_NUMERIC_CLASSIFIERS_PROPERTY = "ner.applyNumericClassifiers";
    private AbstractSequenceClassifier nsc = new NumberSequenceClassifier();

    public NERClassifierCombiner(Properties props) throws FileNotFoundException {
        super(props);
        this.applyNumericClassifiers = Boolean.parseBoolean(props.getProperty(APPLY_NUMERIC_CLASSIFIERS_PROPERTY, APPLY_NUMERIC_CLASSIFIERS_STRING));
    }

    public NERClassifierCombiner(String ... loadPaths) throws FileNotFoundException {
        this(true, loadPaths);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, String ... loadPaths) throws FileNotFoundException {
        super(loadPaths);
        this.applyNumericClassifiers = applyNumericClassifiers;
    }

    public NERClassifierCombiner(AbstractSequenceClassifier ... classifiers) throws FileNotFoundException {
        this(true, classifiers);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, AbstractSequenceClassifier ... classifiers) throws FileNotFoundException {
        super(classifiers);
        this.applyNumericClassifiers = applyNumericClassifiers;
    }

    public boolean isApplyNumericClassifiers() {
        return this.applyNumericClassifiers;
    }

    private static void copyAnswerFieldsToNERField(List<? extends CoreLabel> l) {
        for (CoreLabel coreLabel : l) {
            coreLabel.set(CoreAnnotations.NamedEntityTagAnnotation.class, coreLabel.get(CoreAnnotations.AnswerAnnotation.class));
        }
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> tokens) {
        List<CoreLabel> output = super.classify(tokens);
        if (this.applyNumericClassifiers) {
            this.recognizeNumberSequences(output);
            NERClassifierCombiner.copyAnswerFieldsToNERField(output);
            try {
                QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(output);
            }
            catch (Exception e) {
                System.err.println("Ignored an exception in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                System.out.println("Tokens: " + StringUtils.joinWords(tokens, " "));
                e.printStackTrace(System.err);
            }
            catch (AssertionError e) {
                System.err.println("Ignored an assertion in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                System.out.println("Tokens: " + StringUtils.joinWords(tokens, " "));
                ((Throwable)((Object)e)).printStackTrace(System.err);
            }
        } else {
            NERClassifierCombiner.copyAnswerFieldsToNERField(output);
        }
        return output;
    }

    private void recognizeNumberSequences(List<CoreLabel> words) {
        ArrayList<CoreLabel> newWords = new ArrayList<CoreLabel>();
        for (CoreLabel fl : words) {
            CoreLabel newFL = new CoreLabel();
            newFL.setWord(fl.word());
            newFL.setTag(fl.tag());
            newWords.add(newFL);
        }
        this.nsc.classify(newWords);
        int sz = words.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel origWord = words.get(i);
            CoreLabel newWord = (CoreLabel)newWords.get(i);
            String before = (String)origWord.get(CoreAnnotations.AnswerAnnotation.class);
            String newGuess = (String)newWord.get(CoreAnnotations.AnswerAnnotation.class);
            if (before != null && !before.equals(this.nsc.flags.backgroundSymbol) && !before.equals("MISC") || newGuess.equals(this.nsc.flags.backgroundSymbol)) continue;
            origWord.set(CoreAnnotations.AnswerAnnotation.class, newGuess);
        }
    }
}

