/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.sequences.SequenceListener;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniformPrior<IN extends CoreMap>
implements SequenceModel,
SequenceListener {
    protected int[] sequence;
    protected int backgroundSymbol;
    protected int numClasses;
    protected int[] possibleValues;
    protected Index<String> classIndex;
    protected List<IN> doc;

    public UniformPrior(String backgroundSymbol, Index<String> classIndex, List<IN> doc) {
        this.classIndex = classIndex;
        this.backgroundSymbol = classIndex.indexOf(backgroundSymbol);
        this.numClasses = classIndex.size();
        this.possibleValues = new int[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.possibleValues[i] = i;
        }
        this.doc = doc;
    }

    @Override
    public double scoreOf(int[] sequence) {
        return 0.0;
    }

    @Override
    public double[] scoresOf(int[] sequence, int position) {
        double[] probs = new double[this.numClasses];
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 0.0;
        }
        return probs;
    }

    @Override
    public int[] getPossibleValues(int position) {
        return this.possibleValues;
    }

    @Override
    public int leftWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int length() {
        return this.doc.size();
    }

    @Override
    public int rightWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double scoreOf(int[] sequence, int position) {
        return 0.0;
    }

    @Override
    public void setInitialSequence(int[] sequence) {
    }

    @Override
    public void updateSequenceElement(int[] sequence, int pos, int oldVal) {
    }
}

