/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEvent;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEventMentionArgument;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceMention;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceEventMention
extends AceMention {
    private Map<String, AceEventMentionArgument> mRolesToArguments = new HashMap<String, AceEventMentionArgument>();
    private AceEvent mParent;
    private AceCharSeq mAnchor;

    public AceEventMention(String id, AceCharSeq extent, AceCharSeq anchor) {
        super(id, extent);
        this.mAnchor = anchor;
    }

    public String toString() {
        return "AceEventMention [mAnchor=" + this.mAnchor + ", mParent=" + this.mParent + ", mRolesToArguments=" + this.mRolesToArguments + ", mExtent=" + this.mExtent + ", mId=" + this.mId + "]";
    }

    public Collection<AceEventMentionArgument> getArgs() {
        return this.mRolesToArguments.values();
    }

    public Set<String> getRoles() {
        return this.mRolesToArguments.keySet();
    }

    public AceEntityMention getArg(String role) {
        return this.mRolesToArguments.get(role).getContent();
    }

    public void addArg(AceEntityMention em, String role) {
        this.mRolesToArguments.put(role, new AceEventMentionArgument(role, em));
    }

    public void setParent(AceEvent e) {
        this.mParent = e;
    }

    public AceEvent getParent() {
        return this.mParent;
    }

    public void setAnchor(AceCharSeq anchor) {
        this.mAnchor = anchor;
    }

    public AceCharSeq getAnchor() {
        return this.mAnchor;
    }

    public int getMinTokenStart() {
        Collection<AceEventMentionArgument> args = this.getArgs();
        int earliestTokenStart = -1;
        for (AceEventMentionArgument arg : args) {
            int tokenStart = arg.getContent().getHead().getTokenStart();
            if (earliestTokenStart == -1) {
                earliestTokenStart = tokenStart;
                continue;
            }
            earliestTokenStart = Math.min(earliestTokenStart, tokenStart);
        }
        if (earliestTokenStart == -1) {
            return this.mExtent.getTokenStart();
        }
        return earliestTokenStart;
    }

    public int getMaxTokenEnd() {
        Collection<AceEventMentionArgument> args = this.getArgs();
        int latestTokenStart = -1;
        for (AceEventMentionArgument arg : args) {
            int tokenStart = arg.getContent().getHead().getTokenStart();
            if (latestTokenStart == -1) {
                latestTokenStart = tokenStart;
                continue;
            }
            latestTokenStart = Math.max(latestTokenStart, tokenStart);
        }
        if (latestTokenStart == -1) {
            return this.mExtent.getTokenStart();
        }
        return latestTokenStart;
    }
}

