/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitRegExIterator<T>
extends AbstractIterator<T> {
    private Iterator<String> tokens;
    private final Function<String, T> op;
    private T nextToken;

    public static DelimitRegExIterator<String> defaultDelimitRegExIterator(Reader in, String delimiter) {
        return new DelimitRegExIterator<String>(in, delimiter, new IdentityFunction());
    }

    public DelimitRegExIterator(Reader r, String delimiter, Function<String, T> op) {
        this.op = op;
        BufferedReader in = new BufferedReader(r);
        try {
            String line;
            StringBuilder input = new StringBuilder();
            while ((line = in.readLine()) != null) {
                input.append(line).append("\n");
            }
            line = input.toString();
            Pattern p = Pattern.compile("^" + delimiter);
            Matcher m = p.matcher(line);
            line = m.replaceAll("");
            p = Pattern.compile(delimiter + "$");
            m = p.matcher(line);
            line = m.replaceAll("");
            line = line.trim();
            this.tokens = Arrays.asList(line.split(delimiter)).iterator();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setNext();
    }

    private void setNext() {
        if (this.tokens.hasNext()) {
            String s = this.tokens.next();
            this.nextToken = this.parseString(s);
        } else {
            this.nextToken = null;
        }
    }

    protected T parseString(String s) {
        return this.op.apply(s);
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public T next() {
        if (this.nextToken == null) {
            throw new NoSuchElementException("DelimitRegExIterator exhausted");
        }
        T token = this.nextToken;
        this.setNext();
        return token;
    }

    public Object peek() {
        return this.nextToken;
    }

    public static IteratorFromReaderFactory<String> getFactory(String delim) {
        return DelimitRegExIteratorFactory.defaultDelimitRegExIteratorFactory(delim);
    }

    public static IteratorFromReaderFactory<String> getFactory(String delim, boolean eolIsSignificant) {
        return DelimitRegExIteratorFactory.defaultDelimitRegExIteratorFactory(delim, eolIsSignificant);
    }

    public static <T> IteratorFromReaderFactory<T> getFactory(String delim, Function<String, T> op) {
        return new DelimitRegExIteratorFactory<T>(delim, op);
    }

    public static <T> IteratorFromReaderFactory<T> getFactory(String delim, Function<String, T> op, boolean eolIsSignificant) {
        return new DelimitRegExIteratorFactory<T>(delim, op, eolIsSignificant);
    }

    public static void main(String[] args) {
        String s = "@@123\nthis\nis\na\nsentence\n\n@@124\nThis\nis\nanother\n.\n\n@125\nThis\nis\nthe\nlast\n";
        DelimitRegExIterator<String> di = DelimitRegExIterator.defaultDelimitRegExIterator(new StringReader(s), "\n\n");
        while (di.hasNext()) {
            System.out.println("****\n" + di.next() + "\n****");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DelimitRegExIteratorFactory<T>
    implements IteratorFromReaderFactory<T>,
    Serializable {
        private static final long serialVersionUID = 6846060575832573082L;
        private final String delim;
        private final Function<String, T> op;
        private final boolean eolIsSignificant;

        public static DelimitRegExIteratorFactory<String> defaultDelimitRegExIteratorFactory(String delim) {
            return new DelimitRegExIteratorFactory<String>(delim, new IdentityFunction());
        }

        public static DelimitRegExIteratorFactory<String> defaultDelimitRegExIteratorFactory(String delim, boolean eolIsSignificant) {
            return new DelimitRegExIteratorFactory<String>(delim, new IdentityFunction(), eolIsSignificant);
        }

        public DelimitRegExIteratorFactory(String delim, Function<String, T> op) {
            this(delim, op, true);
        }

        public DelimitRegExIteratorFactory(String delim, Function<String, T> op, boolean eolIsSignificant) {
            this.delim = delim;
            this.op = op;
            this.eolIsSignificant = eolIsSignificant;
        }

        @Override
        public Iterator<T> getIterator(Reader r) {
            return new DelimitRegExIterator<T>(r, this.delim, this.op);
        }
    }
}

