/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.Minimizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGMinimizer
implements Minimizer<DiffFunction> {
    private static NumberFormat nf = new DecimalFormat("0.000E0");
    private Function monitor;
    private static final int numToPrint = 5;
    private static final boolean simpleGD = false;
    private static final boolean checkSimpleGDConvergence = true;
    private static final boolean verbose = false;
    private boolean silent;
    private static final int ITMAX = 2000;
    private static final double EPS = 1.0E-30;
    private static final int resetFrequency = 10;
    private static final double GOLD = 1.618034;
    private static final double GLIMIT = 100.0;
    private static final double TINY = 1.0E-20;

    static double[] copyArray(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    private static String arrayToString(double[] x, int num) {
        StringBuilder sb = new StringBuilder("(");
        if (num > x.length) {
            num = x.length;
        }
        for (int j = 0; j < num; ++j) {
            sb.append(x[j]);
            if (j == x.length - 1) continue;
            sb.append(", ");
        }
        if (num < x.length) {
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    private static double fabs(double x) {
        if (x < 0.0) {
            return -x;
        }
        return x;
    }

    private static double fmax(double x, double y) {
        if (x < y) {
            return y;
        }
        return x;
    }

    private static double sign(double x, double y) {
        if (y >= 0.0) {
            return CGMinimizer.fabs(x);
        }
        return -CGMinimizer.fabs(x);
    }

    private static Triple mnbrak(Triple abc, OneDimDiffFunction function) {
        double ax = abc.a;
        double fa = function.valueAt(ax);
        double bx = abc.b;
        double fb = function.valueAt(bx);
        if (fb > fa) {
            double temp = fa;
            fa = fb;
            fb = temp;
            temp = ax;
            ax = bx;
            bx = temp;
        }
        double cx = bx + 1.618034 * (bx - ax);
        double fc = function.valueAt(cx);
        while (fb > fc) {
            double fu;
            double r = (bx - ax) * (fb - fc);
            double q = (bx - cx) * (fb - fa);
            double u = bx - ((bx - cx) * q - (bx - ax) * r) / (2.0 * CGMinimizer.sign(CGMinimizer.fmax(CGMinimizer.fabs(q - r), 1.0E-20), q - r));
            double ulim = bx + 100.0 * (cx - bx);
            if ((bx - u) * (u - cx) > 0.0) {
                fu = function.valueAt(u);
                if (fu < fc) {
                    return new Triple(bx, u, cx);
                }
                if (fu > fb) {
                    return new Triple(ax, bx, u);
                }
                u = cx + 1.618034 * (cx - bx);
                fu = function.valueAt(u);
            } else if ((cx - u) * (u - ulim) > 0.0) {
                fu = function.valueAt(u);
                if (fu < fc) {
                    bx = cx;
                    cx = u;
                    u = cx + 1.618034 * (cx - bx);
                    fb = fc;
                    fc = fu;
                    fu = function.valueAt(u);
                }
            } else if ((u - ulim) * (ulim - cx) >= 0.0) {
                u = ulim;
                fu = function.valueAt(u);
            } else {
                u = cx + 1.618034 * (cx - bx);
                fu = function.valueAt(u);
            }
            ax = bx;
            bx = cx;
            cx = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        return new Triple(ax, bx, cx);
    }

    private static double dbrent(OneDimDiffFunction function, double ax, double bx, double cx) {
        double dx;
        double fx;
        boolean dbVerbose = false;
        int ITMAX = 100;
        double TOL = 1.0E-4;
        double d = 0.0;
        double e = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double x = bx;
        double v = bx;
        double w = bx;
        double fv = fx = function.valueAt(x);
        double fw = fx;
        double dv = dx = function.derivativeAt(x);
        double dw = dx;
        for (int iteration = 0; iteration < 100; ++iteration) {
            double fu;
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = 1.0E-4 * CGMinimizer.fabs(x);
            double tol2 = 2.0 * tol1;
            if (CGMinimizer.fabs(x - xm) <= tol2 - 0.5 * (b - a)) {
                return x;
            }
            if (CGMinimizer.fabs(e) > tol1) {
                double d1;
                double d2 = d1 = 2.0 * (b - a);
                if (dw != dx) {
                    d1 = (w - x) * dx / (dx - dw);
                }
                if (dv != dx) {
                    d2 = (v - x) * dx / (dx - dv);
                }
                double u1 = x + d1;
                double u2 = x + d2;
                boolean ok1 = (a - u1) * (u1 - b) > 0.0 && dx * d1 <= 0.0;
                boolean ok2 = (a - u2) * (u2 - b) > 0.0 && dx * d2 <= 0.0;
                double olde = e;
                e = d;
                if (ok1 || ok2) {
                    d = ok1 && ok2 ? (CGMinimizer.fabs(d1) < CGMinimizer.fabs(d2) ? d1 : d2) : (ok1 ? d1 : d2);
                    if (CGMinimizer.fabs(d) <= CGMinimizer.fabs(0.5 * olde)) {
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = CGMinimizer.sign(tol1, xm - x);
                        }
                    } else {
                        e = dx >= 0.0 ? a - x : b - x;
                        d = 0.5 * e;
                    }
                } else {
                    e = dx >= 0.0 ? a - x : b - x;
                    d = 0.5 * e;
                }
            } else {
                e = dx >= 0.0 ? a - x : b - x;
                d = 0.5 * e;
            }
            if (CGMinimizer.fabs(d) >= tol1) {
                u = x + d;
                fu = function.valueAt(u);
            } else {
                u = x + CGMinimizer.sign(tol1, d);
                fu = function.valueAt(u);
                if (fu > fx) {
                    return x;
                }
            }
            double du = function.derivativeAt(u);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                dv = dw;
                w = x;
                fw = fx;
                dw = dx;
                x = u;
                fx = fu;
                dx = du;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                dv = dw;
                w = u;
                fw = fu;
                dw = du;
                continue;
            }
            if (!(fu < fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
            dv = du;
        }
        if (fx < function.valueAt(0.0)) {
            return x;
        }
        return 0.0;
    }

    double[] lineMinimize(DiffFunction function, double[] initial, double[] direction) {
        OneDimDiffFunction oneDim = new OneDimDiffFunction(function, initial, direction);
        double guess = 0.01;
        if (!this.silent) {
            System.err.print("[");
        }
        Triple bracketing = CGMinimizer.mnbrak(new Triple(0.0, guess, 0.0), oneDim);
        if (!this.silent) {
            System.err.print("]");
        }
        double ax = bracketing.a;
        double xx = bracketing.b;
        double bx = bracketing.c;
        if (!(ax <= xx && xx <= bx || bx <= xx && xx <= ax)) {
            System.err.println("Bad bracket order!");
        }
        if (!this.silent) {
            System.err.print("<");
        }
        double xmin = CGMinimizer.dbrent(oneDim, ax, xx, bx);
        if (!this.silent) {
            System.err.print(">");
        }
        return oneDim.vectorOf(xmin);
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, 2000);
    }

    @Override
    public double[] minimize(DiffFunction dfunction, double functionTolerance, double[] initial, int maxIterations) {
        int dimension = dfunction.domainDimension();
        double fp = dfunction.valueAt(initial);
        double[] xi = CGMinimizer.copyArray(dfunction.derivativeAt(initial));
        double[] g = new double[dimension];
        double[] h = new double[dimension];
        double[] p = new double[dimension];
        for (int j = 0; j < dimension; ++j) {
            g[j] = -xi[j];
            xi[j] = g[j];
            h[j] = g[j];
            p[j] = initial[j];
        }
        boolean simpleGDStep = false;
        for (int iterations = 1; iterations < maxIterations; ++iterations) {
            int j;
            double monitorReturn;
            if (!this.silent) {
                System.err.print("Iter " + iterations + " ");
            }
            double[] p2 = this.lineMinimize(dfunction, p, xi);
            double fp2 = dfunction.valueAt(p2);
            if (!this.silent) {
                System.err.printf(" %s (delta: %s)\n", nf.format(fp2), nf.format(fp - fp2));
            }
            if (this.monitor != null && (monitorReturn = this.monitor.valueAt(p2)) < functionTolerance) {
                return p2;
            }
            if (2.0 * CGMinimizer.fabs(fp2 - fp) <= functionTolerance * (CGMinimizer.fabs(fp2) + CGMinimizer.fabs(fp) + 1.0E-30)) {
                if (simpleGDStep) {
                    return p2;
                }
                simpleGDStep = true;
            } else {
                simpleGDStep = false;
            }
            for (int j2 = 0; j2 < dimension; ++j2) {
                xi[j2] = p2[j2] - p[j2];
                p[j2] = p2[j2];
            }
            fp = fp2;
            xi = CGMinimizer.copyArray(dfunction.derivativeAt(p));
            if (!simpleGDStep && iterations % 10 != 0) {
                double dgg = 0.0;
                double gg = 0.0;
                for (int j3 = 0; j3 < dimension; ++j3) {
                    gg += g[j3] * g[j3];
                    dgg += (xi[j3] + g[j3]) * xi[j3];
                }
                if (gg == 0.0) {
                    return p;
                }
                double gam = dgg / gg;
                for (int j4 = 0; j4 < dimension; ++j4) {
                    g[j4] = -xi[j4];
                    h[j4] = g[j4] + gam * h[j4];
                    xi[j4] = h[j4];
                }
                continue;
            }
            double xixi = 0.0;
            for (j = 0; j < dimension; ++j) {
                xixi += xi[j] * xi[j];
            }
            for (j = 0; j < dimension; ++j) {
                g[j] = -xi[j];
                xi[j] = g[j];
                h[j] = g[j];
            }
            if (xixi != 0.0) continue;
            return p;
        }
        System.err.println("Warning: exiting minimize because ITER exceeded!");
        return p;
    }

    public CGMinimizer() {
        this(true);
    }

    public CGMinimizer(boolean silent) {
        this.silent = silent;
    }

    public CGMinimizer(Function monitor) {
        this();
        this.monitor = monitor;
    }

    private static class Triple {
        public double a;
        public double b;
        public double c;

        public Triple(double a, double b, double c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    static class OneDimDiffFunction {
        private DiffFunction function;
        private double[] initial;
        private double[] direction;
        private double[] tempVector;

        private double[] vectorOf(double x) {
            for (int j = 0; j < this.initial.length; ++j) {
                this.tempVector[j] = this.initial[j] + x * this.direction[j];
            }
            return this.tempVector;
        }

        double valueAt(double x) {
            return this.function.valueAt(this.vectorOf(x));
        }

        double derivativeAt(double x) {
            double[] g = this.function.derivativeAt(this.vectorOf(x));
            double d = 0.0;
            for (int j = 0; j < g.length; ++j) {
                d += g[j] * this.direction[j];
            }
            return d;
        }

        OneDimDiffFunction(DiffFunction function, double[] initial, double[] direction) {
            this.function = function;
            this.initial = CGMinimizer.copyArray(initial);
            this.direction = CGMinimizer.copyArray(direction);
            this.tempVector = new double[function.domainDimension()];
        }
    }
}

