/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.TTags;
import java.util.ArrayList;
import java.util.HashSet;

public class AmbiguityClass {
    private final HashSet<String> s = new HashSet();
    private final ArrayList<Integer> sortedIds = new ArrayList();
    private String key;
    private String word;
    private boolean single;

    public AmbiguityClass() {
    }

    protected AmbiguityClass(String word, Dictionary dict, TTags ttags) {
        this();
        String[] tags;
        for (String tag : tags = dict.getTags(word)) {
            this.add(ttags.getIndex(tag));
        }
        this.init(ttags);
    }

    protected AmbiguityClass(String word, boolean single, Dictionary dict, TTags ttags) {
        this();
        this.word = word;
        this.single = single;
        if (!single) {
            String[] tags;
            for (String tag : tags = dict.getTags(word)) {
                this.add(ttags.getIndex(tag));
            }
        }
        this.init(ttags);
    }

    public String getWord() {
        return this.word;
    }

    private boolean add(int tagId) {
        for (int j = 0; j < this.sortedIds.size(); ++j) {
            if (tagId < this.sortedIds.get(j)) {
                this.sortedIds.add(j, tagId);
                return true;
            }
            if (tagId != this.sortedIds.get(j)) continue;
            return false;
        }
        this.sortedIds.add(tagId);
        return true;
    }

    public String toString() {
        if (this.single) {
            return this.word;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer sID : this.sortedIds) {
            sb.append(':').append(sID);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof AmbiguityClass && this.key.equals(((AmbiguityClass)o).key);
    }

    void init(String str, TTags ttags) {
        this.key = str;
        this.s.add(str);
        this.init(ttags);
    }

    protected void init(TTags ttags) {
        if (!this.single) {
            for (Integer sortedId : this.sortedIds) {
                this.s.add(ttags.getTag(sortedId));
            }
        }
        this.key = this.toString();
    }
}

