/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TregexPattern
implements Serializable {
    static Function<String, String> currentBasicCatFunction;
    private boolean neg = false;
    private boolean opt = false;
    private String patternString;
    private static final Pattern codePattern;
    private static Treebank treebank;
    private static final long serialVersionUID = 5060298043763944913L;

    static void setBasicCatFunction(Function<String, String> f) {
        currentBasicCatFunction = f;
    }

    void negate() {
        this.neg = true;
        if (this.opt) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
    }

    void makeOptional() {
        this.opt = true;
        if (this.neg) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
    }

    private void prettyPrint(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.print("   ");
        }
        if (this.neg) {
            pw.print('!');
        }
        if (this.opt) {
            pw.print('?');
        }
        pw.println(this.localString());
        for (TregexPattern child : this.getChildren()) {
            child.prettyPrint(pw, indent + 1);
        }
    }

    TregexPattern() {
    }

    abstract List<TregexPattern> getChildren();

    abstract String localString();

    boolean isNegated() {
        return this.neg;
    }

    boolean isOptional() {
        return this.opt;
    }

    abstract TregexMatcher matcher(Tree var1, Tree var2, Map<String, Tree> var3, VariableStrings var4);

    public TregexMatcher matcher(Tree t) {
        return this.matcher(t, t, new HashMap<String, Tree>(), new VariableStrings());
    }

    public static TregexPattern compile(String tregex) throws ParseException {
        return TregexPatternCompiler.defaultCompiler.compile(tregex);
    }

    public static TregexPattern safeCompile(String tregex, boolean verbose) {
        TregexPattern result;
        block2: {
            result = null;
            try {
                result = TregexPatternCompiler.defaultCompiler.compile(tregex);
            }
            catch (ParseException ex) {
                if (!verbose) break block2;
                System.err.println("Could not parse " + tregex + ":");
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String pattern() {
        return this.patternString;
    }

    public void setPatternString(String patternString) {
        this.patternString = patternString;
    }

    public abstract String toString();

    public void prettyPrint(PrintWriter pw) {
        this.prettyPrint(pw, 0);
    }

    public void prettyPrint(PrintStream ps) {
        this.prettyPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true));
    }

    public void prettyPrint() {
        this.prettyPrint(System.out);
    }

    private static void extractSubtrees(List<String> codeStrings, String treeFile) {
        ArrayList<Pair<Integer, Integer>> codes = new ArrayList<Pair<Integer, Integer>>();
        for (String s : codeStrings) {
            Matcher m = codePattern.matcher(s);
            if (m.matches()) {
                codes.add(new Pair<Integer, Integer>(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))));
                continue;
            }
            throw new RuntimeException("Error: illegal node code " + s);
        }
        TRegexTreeReaderFactory trf = new TRegexTreeReaderFactory();
        MemoryTreebank treebank = new MemoryTreebank(trf);
        treebank.loadPath(treeFile, null, true);
        for (Pair pair : codes) {
            Tree t = treebank.get((Integer)pair.first() - 1);
            t.getNodeNumber((Integer)pair.second()).pennPrint();
        }
    }

    public static void main(String[] args) throws IOException {
        Timing.startTime();
        StringBuilder treePrintFormats = new StringBuilder();
        String printNonMatchingTreesOption = "-v";
        String subtreeCodeOption = "-x";
        String extractSubtreesOption = "-extract";
        String extractSubtreesFileOption = "-extractFile";
        String inputFileOption = "-i";
        String headFinderOption = "-hf";
        String headFinderArgOption = "-hfArg";
        String trfOption = "-trf";
        String headFinderClassName = null;
        String[] headFinderArgs = StringUtils.EMPTY_STRING_ARRAY;
        String treeReaderFactoryClassName = null;
        String printHandleOption = "-h";
        String markHandleOption = "-k";
        String encodingOption = "-encoding";
        String encoding = "UTF-8";
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put(extractSubtreesOption, 2);
        flagMap.put(extractSubtreesFileOption, 2);
        flagMap.put(subtreeCodeOption, 0);
        flagMap.put(printNonMatchingTreesOption, 0);
        flagMap.put(encodingOption, 1);
        flagMap.put(inputFileOption, 1);
        flagMap.put(printHandleOption, 1);
        flagMap.put(markHandleOption, 2);
        flagMap.put(headFinderOption, 1);
        flagMap.put(headFinderArgOption, 1);
        flagMap.put(trfOption, 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.containsKey(encodingOption)) {
            encoding = argsMap.get(encodingOption)[0];
            System.err.println("Encoding set to " + encoding);
        }
        PrintWriter errPW = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, encoding), true);
        if (argsMap.containsKey(extractSubtreesOption)) {
            List<String> subTreeStrings = Collections.singletonList(argsMap.get(extractSubtreesOption)[0]);
            TregexPattern.extractSubtrees(subTreeStrings, argsMap.get(extractSubtreesOption)[1]);
            return;
        }
        if (argsMap.containsKey(extractSubtreesFileOption)) {
            List<String> subTreeStrings = Arrays.asList(IOUtils.slurpFile(argsMap.get(extractSubtreesFileOption)[0]).split("\n|\r|\n\r"));
            TregexPattern.extractSubtrees(subTreeStrings, argsMap.get(extractSubtreesFileOption)[0]);
            return;
        }
        if (args.length < 1) {
            errPW.println("Usage: java edu.stanford.nlp.trees.tregex.TregexPattern [-T] [-C] [-w] [-f] [-o] [-n] [-s] [-filter]  [-hf class] [-trf class] [-h handle]* pattern [filepath]");
            return;
        }
        String matchString = args[0];
        if (argsMap.containsKey(headFinderOption)) {
            headFinderClassName = argsMap.get(headFinderOption)[0];
            errPW.println("Using head finder " + headFinderClassName + "...");
        }
        if (argsMap.containsKey(headFinderArgOption)) {
            headFinderArgs = argsMap.get(headFinderArgOption);
        }
        if (argsMap.containsKey(trfOption)) {
            treeReaderFactoryClassName = argsMap.get(trfOption)[0];
            errPW.println("Using tree reader factory " + treeReaderFactoryClassName + "...");
        }
        if (argsMap.containsKey("-T")) {
            TRegexTreeVisitor.printTree = true;
        }
        if (argsMap.containsKey(inputFileOption)) {
            String inputFile = argsMap.get(inputFileOption)[0];
            matchString = IOUtils.slurpFile(inputFile, encoding);
            String[] newArgs = new String[args.length + 1];
            System.arraycopy(args, 0, newArgs, 1, args.length);
            args = newArgs;
        }
        if (argsMap.containsKey("-C")) {
            TRegexTreeVisitor.printMatches = false;
            TRegexTreeVisitor.printNumMatchesToStdOut = true;
        }
        if (argsMap.containsKey("-v")) {
            TRegexTreeVisitor.printNonMatchingTrees = true;
        }
        if (argsMap.containsKey("-x")) {
            TRegexTreeVisitor.printSubtreeCode = true;
            TRegexTreeVisitor.printMatches = false;
        }
        if (argsMap.containsKey("-w")) {
            TRegexTreeVisitor.printWholeTree = true;
        }
        if (argsMap.containsKey("-f")) {
            TRegexTreeVisitor.printFilename = true;
        }
        if (argsMap.containsKey("-o")) {
            TRegexTreeVisitor.oneMatchPerRootNode = true;
        }
        if (argsMap.containsKey("-n")) {
            TRegexTreeVisitor.reportTreeNumbers = true;
        }
        if (argsMap.containsKey("-u")) {
            treePrintFormats.append("rootSymbolOnly").append(',');
        } else if (argsMap.containsKey("-s")) {
            treePrintFormats.append("oneline,");
        } else if (argsMap.containsKey("-t")) {
            treePrintFormats.append("words,");
        } else {
            treePrintFormats.append("penn,");
        }
        HeadFinder hf = new CollinsHeadFinder();
        if (headFinderClassName != null) {
            Class[] hfArgClasses = new Class[headFinderArgs.length];
            for (int i = 0; i < hfArgClasses.length; ++i) {
                hfArgClasses[i] = String.class;
            }
            try {
                hf = (HeadFinder)Class.forName(headFinderClassName).getConstructor(hfArgClasses).newInstance(headFinderArgs);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred while constructing HeadFinder: " + e);
            }
        }
        TRegexTreeVisitor.tp = new TreePrint(treePrintFormats.toString(), new PennTreebankLanguagePack());
        try {
            TregexPatternCompiler tpc = new TregexPatternCompiler(hf);
            TregexPattern p = tpc.compile(matchString);
            errPW.println("Pattern string:\n" + p.pattern());
            errPW.println("Parsed representation:");
            p.prettyPrint(errPW);
            String[] handles = argsMap.get(printHandleOption);
            if (argsMap.containsKey("-filter")) {
                TreeReaderFactory trf = TregexPattern.getTreeReaderFactory(treeReaderFactoryClassName);
                treebank = new MemoryTreebank(trf, encoding);
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, encoding));
                ((MemoryTreebank)treebank).load(reader);
                ((Reader)reader).close();
            } else if (args.length == 1) {
                errPW.println("using default tree");
                PennTreeReader r = new PennTreeReader(new StringReader("(VP (VP (VBZ Try) (NP (NP (DT this) (NN wine)) (CC and) (NP (DT these) (NNS snails)))) (PUNCT .))"), new LabeledScoredTreeFactory(new StringLabelFactory()));
                Tree t = r.readTree();
                treebank = new MemoryTreebank();
                treebank.add(t);
            } else {
                int last = args.length - 1;
                errPW.println("Reading trees from file(s) " + args[last]);
                TreeReaderFactory trf = TregexPattern.getTreeReaderFactory(treeReaderFactoryClassName);
                treebank = new DiskTreebank(trf, encoding);
                treebank.loadPath(args[last], null, true);
            }
            TRegexTreeVisitor vis = new TRegexTreeVisitor(p, handles, encoding);
            treebank.apply(vis);
            Timing.endTime();
            if (TRegexTreeVisitor.printMatches) {
                errPW.println("There were " + vis.numMatches() + " matches in total.");
            }
            if (TRegexTreeVisitor.printNumMatchesToStdOut) {
                System.out.println(vis.numMatches());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            errPW.println("Error parsing expression: " + args[0]);
            errPW.println("Parse exception: " + e.toString());
        }
    }

    private static TreeReaderFactory getTreeReaderFactory(String treeReaderFactoryClassName) {
        TreeReaderFactory trf = new TRegexTreeReaderFactory();
        if (treeReaderFactoryClassName != null) {
            try {
                trf = (TreeReaderFactory)Class.forName(treeReaderFactoryClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred while constructing TreeReaderFactory: " + e);
            }
        }
        return trf;
    }

    static {
        codePattern = Pattern.compile("([0-9]+):([0-9]+)");
    }

    public static class TRegexTreeReaderFactory
    implements TreeReaderFactory {
        private TreeNormalizer tn;

        public TRegexTreeReaderFactory() {
            this(new TreeNormalizer(){
                private static final long serialVersionUID = -2998972954089638189L;

                public String normalizeNonterminal(String str) {
                    if (str == null) {
                        return "";
                    }
                    return str;
                }
            });
        }

        public TRegexTreeReaderFactory(TreeNormalizer tn) {
            this.tn = tn;
        }

        public TreeReader newTreeReader(Reader in) {
            return new PennTreeReader(new BufferedReader(in), new LabeledScoredTreeFactory(), this.tn);
        }
    }

    static class TRegexTreeVisitor
    implements TreeVisitor {
        private static boolean printNumMatchesToStdOut = false;
        static boolean printNonMatchingTrees = false;
        static boolean printSubtreeCode = false;
        static boolean printTree = false;
        static boolean printWholeTree = false;
        static boolean printMatches = true;
        static boolean printFilename = false;
        static boolean oneMatchPerRootNode = false;
        static boolean reportTreeNumbers = false;
        static TreePrint tp;
        PrintWriter pw;
        int treeNumber = 0;
        TregexPattern p;
        String[] handles;
        int numMatches;

        TRegexTreeVisitor(TregexPattern p, String[] handles, String encoding) {
            this.p = p;
            this.handles = handles;
            try {
                this.pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Error -- encoding " + encoding + " is unsupported.  Using ASCII print writer instead.");
                this.pw = new PrintWriter(System.out, true);
            }
            tp.setPrintWriter(this.pw);
        }

        public void visitTree(Tree t) {
            ++this.treeNumber;
            if (printTree) {
                this.pw.print(this.treeNumber + ":");
                this.pw.println("Next tree read:");
                tp.printTree(t, this.pw);
            }
            TregexMatcher match = this.p.matcher(t);
            if (printNonMatchingTrees) {
                if (match.find()) {
                    ++this.numMatches;
                } else {
                    tp.printTree(t, this.pw);
                }
                return;
            }
            Tree lastMatchingRootNode = null;
            while (match.find()) {
                if (oneMatchPerRootNode) {
                    if (lastMatchingRootNode == match.getMatch()) continue;
                    lastMatchingRootNode = match.getMatch();
                }
                ++this.numMatches;
                if (printFilename && treebank instanceof DiskTreebank) {
                    DiskTreebank dtb = (DiskTreebank)treebank;
                    this.pw.print("# ");
                    this.pw.println(dtb.getCurrentFile());
                }
                if (printSubtreeCode) {
                    this.pw.println(this.treeNumber + ":" + match.getMatch().nodeNumber(t));
                }
                if (!printMatches) continue;
                if (reportTreeNumbers) {
                    this.pw.print(this.treeNumber + ": ");
                }
                if (printTree) {
                    this.pw.println("Found a full match:");
                }
                if (printWholeTree) {
                    tp.printTree(t, this.pw);
                    continue;
                }
                if (this.handles != null) {
                    if (printTree) {
                        this.pw.println("Here's the node you were interested in:");
                    }
                    for (String handle : this.handles) {
                        Tree labeledNode = match.getNode(handle);
                        if (labeledNode == null) {
                            System.err.println("Error!!  There is no matched node \"" + handle + "\"!  Did you specify such a label in the pattern?");
                            continue;
                        }
                        tp.printTree(labeledNode, this.pw);
                    }
                    continue;
                }
                tp.printTree(match.getMatch(), this.pw);
            }
        }

        public int numMatches() {
            return this.numMatches;
        }
    }
}

