/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Date;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaClass {
    private String classname;

    public MetaClass(String classname) {
        this.classname = classname;
    }

    public MetaClass(Class<?> classname) {
        this.classname = classname.getName();
    }

    public <E> ClassFactory<E> createFactory(Class<?> ... classes) {
        try {
            return new ClassFactory(this.classname, (Class[])classes);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> ClassFactory<E> createFactory(String ... classes) {
        try {
            return new ClassFactory(this.classname, classes);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> ClassFactory<E> createFactory(Object ... objects) {
        try {
            return new ClassFactory(this.classname, objects);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> E createInstance(Object ... objects) {
        ClassFactory<E> fact = this.createFactory(objects);
        return fact.createInstance(objects);
    }

    public <E, F extends E> F createInstance(Class<E> type, Object ... params) {
        E obj = this.createInstance(params);
        if (type.isInstance(obj)) {
            return (F)obj;
        }
        throw new ClassCreationException("Cannot cast " + this.classname + " into " + type.getName());
    }

    public boolean checkConstructor(Object ... params) {
        try {
            this.createInstance(params);
            return true;
        }
        catch (ConstructorNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.classname;
    }

    public boolean equals(Object o) {
        if (o instanceof MetaClass) {
            return ((MetaClass)o).classname.equals(this.classname);
        }
        return false;
    }

    public int hashCode() {
        return this.classname.hashCode();
    }

    public static MetaClass create(String classname) {
        return new MetaClass(classname);
    }

    public static MetaClass create(Class<?> clazz) {
        return new MetaClass(clazz);
    }

    private static Class<?> type2class(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return MetaClass.type2class(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return MetaClass.type2class(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return MetaClass.type2class(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Cannot convert type to class: " + type);
    }

    private static final String[] decodeArray(String encoded) {
        char[] chars = encoded.trim().toCharArray();
        int quoteCloseChar = 0;
        LinkedList<StringBuilder> terms = new LinkedList<StringBuilder>();
        StringBuilder current = new StringBuilder();
        int start = 0;
        int end = chars.length;
        if (chars[0] == '(') {
            ++start;
            if (chars[--end] != ')') {
                throw new IllegalArgumentException("Unclosed paren in encoded array: " + encoded);
            }
        }
        if (chars[0] == '[') {
            ++start;
            if (chars[--end] != ']') {
                throw new IllegalArgumentException("Unclosed bracket in encoded array: " + encoded);
            }
        }
        for (int i = start; i < end; ++i) {
            if (chars[i] == '\\') {
                if (i == chars.length - 1) {
                    throw new IllegalArgumentException("Last character of encoded pair is escape character: " + encoded);
                }
                current.append(chars[i + 1]);
                ++i;
                continue;
            }
            if (quoteCloseChar != 0) {
                if (chars[i] == quoteCloseChar) {
                    quoteCloseChar = 0;
                    continue;
                }
                current.append(chars[i]);
                continue;
            }
            if (chars[i] == '\"') {
                quoteCloseChar = 34;
                continue;
            }
            if (chars[i] == '\'') {
                quoteCloseChar = 39;
                continue;
            }
            if (chars[i] == ',') {
                terms.add(current);
                current = new StringBuilder();
                continue;
            }
            current.append(chars[i]);
        }
        if (current.length() > 0) {
            terms.add(current);
        }
        String[] rtn = new String[terms.size()];
        int i = 0;
        for (StringBuilder b : terms) {
            rtn[i] = b.toString().trim();
            ++i;
        }
        return rtn;
    }

    public static final <E> E cast(String value, Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = MetaClass.type2class(type);
            throw new IllegalArgumentException("Cannot cast to type (unhandled type): " + type);
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (E)value;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            if (value.equals("1")) {
                return (E)new Boolean(true);
            }
            return (E)new Boolean(Boolean.parseBoolean(value));
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (E)new Integer(Integer.parseInt(value));
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (E)new Long(Long.parseLong(value));
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)new Float(Float.NaN);
            }
            return (E)new Float(Float.parseFloat(value));
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)new Double(Double.NaN);
            }
            return (E)new Double(Double.parseDouble(value));
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return (E)new Short(Short.parseShort(value));
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return (E)new Byte(Byte.parseByte(value));
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            return (E)new Character((char)Integer.parseInt(value));
        }
        if (Date.class.isAssignableFrom(clazz)) {
            try {
                return (E)new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (clazz.isArray()) {
            if (value == null) {
                return null;
            }
            Class<?> subType = clazz.getComponentType();
            String[] strings = MetaClass.decodeArray(value);
            Object[] array = (Object[])Array.newInstance(clazz.getComponentType(), strings.length);
            for (int i = 0; i < strings.length; ++i) {
                array[i] = MetaClass.cast(strings[i], subType);
            }
            return (E)array;
        }
        if (clazz.isEnum()) {
            Class c = clazz;
            if (value == null) {
                return null;
            }
            return (E)Enum.valueOf(c, value);
        }
        return null;
    }

    private static final <E> E argmin(E[] elems, int[] scores, int atLeast) {
        int argmin = MetaClass.argmin(scores, atLeast);
        return argmin >= 0 ? (E)elems[argmin] : null;
    }

    private static final int argmin(int[] scores, int atLeast) {
        int min = Integer.MAX_VALUE;
        int argmin = -1;
        for (int i = 0; i < scores.length; ++i) {
            if (scores[i] >= min || scores[i] < atLeast) continue;
            min = scores[i];
            argmin = i;
        }
        return argmin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassFactory<T> {
        private Class<?>[] classParams;
        private Class<T> cl;
        private Constructor<T> constructor;

        private boolean samePrimitive(Class<?> a, Class<?> b) {
            if (!a.isPrimitive() && !b.isPrimitive()) {
                return false;
            }
            if (a.isPrimitive()) {
                try {
                    Class type = (Class)b.getField("TYPE").get(null);
                    return type.equals(a);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (b.isPrimitive()) {
                try {
                    Class type = (Class)a.getField("TYPE").get(null);
                    return type.equals(b);
                }
                catch (Exception e) {
                    return false;
                }
            }
            throw new IllegalStateException("Impossible case");
        }

        private int superDistance(Class<?> candidate, Class<?> target) {
            if (candidate == null) {
                return Integer.MIN_VALUE;
            }
            if (candidate.equals(target)) {
                return 0;
            }
            if (this.samePrimitive(candidate, target)) {
                return 0;
            }
            Class<?> directSuper = candidate.getSuperclass();
            int superDist = this.superDistance(directSuper, target);
            if (superDist >= 0) {
                return superDist + 1;
            }
            Class<?>[] interfaces = candidate.getInterfaces();
            int minDist = Integer.MAX_VALUE;
            for (Class<?> i : interfaces) {
                superDist = this.superDistance(i, target);
                if (superDist < 0) continue;
                minDist = Math.min(minDist, superDist);
            }
            if (minDist != Integer.MAX_VALUE) {
                return minDist + 1;
            }
            return -1;
        }

        private void construct(String classname, Class<?> ... params) throws ClassNotFoundException, NoSuchMethodException {
            Object target;
            this.classParams = params;
            try {
                this.cl = Class.forName(classname);
            }
            catch (ClassCastException e) {
                throw new ClassCreationException("Class " + classname + " could not be cast to the correct type");
            }
            Constructor<?>[] constructors = this.cl.getDeclaredConstructors();
            Object[] potentials = new Constructor[constructors.length];
            Class[][] constructorParams = new Class[constructors.length][];
            int[] distances = new int[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                constructorParams[i] = constructors[i].getParameterTypes();
                if (params.length == constructorParams[i].length) {
                    potentials[i] = constructors[i];
                    distances[i] = 0;
                    continue;
                }
                potentials[i] = null;
                distances[i] = -1;
            }
            for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
                target = params[paramIndex];
                for (int conIndex = 0; conIndex < potentials.length; ++conIndex) {
                    if (potentials[conIndex] == null) continue;
                    Class cand = constructorParams[conIndex][paramIndex];
                    int dist = this.superDistance((Class<?>)target, cand);
                    if (dist >= 0) {
                        int n = conIndex;
                        distances[n] = distances[n] + dist;
                        continue;
                    }
                    potentials[conIndex] = null;
                    distances[conIndex] = -1;
                }
            }
            this.constructor = (Constructor)MetaClass.argmin(potentials, distances, 0);
            if (this.constructor == null) {
                StringBuilder b = new StringBuilder();
                b.append(classname).append("(");
                for (Class<?> c : params) {
                    b.append(c.getName()).append(", ");
                }
                target = b.substring(0, params.length == 0 ? b.length() : b.length() - 2) + ")";
                throw new ConstructorNotFoundException("No constructor found to match: " + (String)target);
            }
        }

        private ClassFactory(String classname, Class<?> ... params) throws ClassNotFoundException, NoSuchMethodException {
            this.construct(classname, params);
        }

        private ClassFactory(String classname, Object ... params) throws ClassNotFoundException, NoSuchMethodException {
            Class[] classParams = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    throw new ClassCreationException("Argument " + i + " to class constructor is null");
                }
                classParams[i] = params[i].getClass();
            }
            this.construct(classname, classParams);
        }

        private ClassFactory(String classname, String ... params) throws ClassNotFoundException, NoSuchMethodException {
            Class[] classParams = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classParams[i] = Class.forName(params[i]);
            }
            this.construct(classname, classParams);
        }

        public T createInstance(Object ... params) {
            try {
                boolean accessible = true;
                if (!this.constructor.isAccessible()) {
                    accessible = false;
                    this.constructor.setAccessible(true);
                }
                T rtn = this.constructor.newInstance(params);
                if (!accessible) {
                    this.constructor.setAccessible(false);
                }
                return rtn;
            }
            catch (Exception e) {
                throw new ClassCreationException(e);
            }
        }

        public String getName() {
            return this.cl.getName();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.cl.getName()).append("(");
            for (Class<?> cl : this.classParams) {
                b.append(" ").append(cl.getName()).append(",");
            }
            b.replace(b.length() - 1, b.length(), " ");
            b.append(")");
            return b.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassFactory) {
                ClassFactory other = (ClassFactory)o;
                if (!this.cl.equals(other.cl)) {
                    return false;
                }
                for (int i = 0; i < this.classParams.length; ++i) {
                    if (this.classParams[i].equals(other.classParams[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.cl.hashCode();
        }
    }

    public static final class ConstructorNotFoundException
    extends ClassCreationException {
        private static final long serialVersionUID = -5980065992461870357L;

        private ConstructorNotFoundException() {
        }

        private ConstructorNotFoundException(String msg) {
            super(msg);
        }

        private ConstructorNotFoundException(Throwable cause) {
            super(cause);
        }
    }

    public static class ClassCreationException
    extends RuntimeException {
        private static final long serialVersionUID = -5980065992461870357L;

        private ClassCreationException() {
        }

        private ClassCreationException(String msg) {
            super(msg);
        }

        private ClassCreationException(Throwable cause) {
            super(cause);
        }
    }
}

