/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ClassifierFactory;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinearClassifierFactory<L, F>
implements ClassifierFactory<L, F, Classifier<L, F>> {
    private static final long serialVersionUID = 1L;
    Index<L> labelIndex = new HashIndex<L>();
    Index<F> featureIndex = new HashIndex<F>();

    int numFeatures() {
        return this.featureIndex.size();
    }

    int numClasses() {
        return this.labelIndex.size();
    }

    @Override
    public Classifier<L, F> trainClassifier(List<RVFDatum<L, F>> examples) {
        Dataset<L, F> dataset = new Dataset<L, F>();
        dataset.addAll(examples);
        return this.trainClassifier((GeneralDataset)dataset);
    }

    protected abstract double[][] trainWeights(GeneralDataset<L, F> var1);

    @Override
    public LinearClassifier<L, F> trainClassifier(Collection<Datum<L, F>> examples) {
        Dataset<L, F> dataset = new Dataset<L, F>();
        dataset.addAll(examples);
        return this.trainClassifier((GeneralDataset)dataset);
    }

    public LinearClassifier<L, F> trainClassifier(Reference<Collection<Datum<L, F>>> ref) {
        Collection<Datum<L, F>> examples = ref.get();
        return this.trainClassifier(examples);
    }

    @Override
    public LinearClassifier<L, F> trainClassifier(GeneralDataset<L, F> data) {
        this.labelIndex = data.labelIndex();
        this.featureIndex = data.featureIndex();
        double[][] weights = this.trainWeights(data);
        return new LinearClassifier<L, F>(weights, this.featureIndex, this.labelIndex);
    }
}

