/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVMLightClassifier<L, F>
extends LinearClassifier<L, F> {
    private static final long serialVersionUID = 1L;
    public LinearClassifier<L, L> platt = null;

    public SVMLightClassifier(ClassicCounter<Pair<F, L>> weightCounter, ClassicCounter<L> thresholds) {
        super(weightCounter, thresholds);
    }

    public SVMLightClassifier(ClassicCounter<Pair<F, L>> weightCounter, ClassicCounter<L> thresholds, LinearClassifier<L, L> platt) {
        super(weightCounter, thresholds);
        this.platt = platt;
    }

    public void setPlatt(LinearClassifier<L, L> platt) {
        this.platt = platt;
    }

    @Override
    public Counter<L> logProbabilityOf(Datum<L, F> example) {
        if (this.platt == null) {
            throw new UnsupportedOperationException("If you want to ask for the probability, you must train a Platt model!");
        }
        Counter<L> scores = this.scoresOf(example);
        scores.incrementCount(null);
        Counter<L> probs = this.platt.logProbabilityOf(new RVFDatum(scores));
        return probs;
    }

    @Override
    public Counter<L> logProbabilityOf(RVFDatum<L, F> example) {
        if (this.platt == null) {
            throw new UnsupportedOperationException("If you want to ask for the probability, you must train a Platt model!");
        }
        Counter<L> scores = this.scoresOf(example);
        scores.incrementCount(null);
        Counter<L> probs = this.platt.logProbabilityOf(new RVFDatum(scores));
        return probs;
    }
}

