/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefMentionFinder;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedCorefMentionFinder
implements CorefMentionFinder {
    boolean assignIds = true;
    int maxID = -1;
    HeadFinder headFinder;
    protected Annotator parserProcessor;

    public RuleBasedCorefMentionFinder() {
        SieveCoreferenceSystem.logger.fine("Using SEMANTIC HEAD FINDER!!!!!!!!!!!!!!!!!!!");
        this.headFinder = new SemanticHeadFinder();
    }

    public List<List<Mention>> filterPredictedMentions(List<List<Mention>> allGoldMentions, Annotation doc, Dictionaries dict) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        for (int i = 0; i < allGoldMentions.size(); ++i) {
            CoreMap s = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
            List<Mention> goldMentions = allGoldMentions.get(i);
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            mentions.addAll(goldMentions);
            this.findHead(s, mentions);
            HashSet<IntPair> mentionSpanSet = new HashSet<IntPair>();
            HashSet<IntPair> namedEntitySpanSet = new HashSet<IntPair>();
            for (Mention m : mentions) {
                mentionSpanSet.add(new IntPair(m.startIndex, m.endIndex));
                if (((String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O")) continue;
                namedEntitySpanSet.add(new IntPair(m.startIndex, m.endIndex));
            }
            RuleBasedCorefMentionFinder.setBarePlural(mentions);
            RuleBasedCorefMentionFinder.removeSpuriousMentions(s, mentions, dict);
        }
        return predictedMentions;
    }

    @Override
    public List<List<Mention>> extractPredictedMentions(Annotation doc, int _maxID, Dictionaries dict) {
        this.maxID = _maxID;
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            HashSet<IntPair> mentionSpanSet = new HashSet<IntPair>();
            HashSet<IntPair> namedEntitySpanSet = new HashSet<IntPair>();
            this.extractNamedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.extractNPorPRP(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.extractEnumerations(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.findHead(s, mentions);
            RuleBasedCorefMentionFinder.setBarePlural(mentions);
            RuleBasedCorefMentionFinder.removeSpuriousMentions(s, mentions, dict);
        }
        return predictedMentions;
    }

    private static void setBarePlural(List<Mention> mentions) {
        for (Mention m : mentions) {
            String pos = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (m.originalSpan.size() != 1 || !pos.equals("NNS")) continue;
            m.generic = true;
        }
    }

    private void extractNamedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        IntPair mSpan;
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph dependency = (SemanticGraph)((Object)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        String preNE = "O";
        int beginIndex = -1;
        int endIndex = -1;
        for (CoreLabel w : sent) {
            String nerString = (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerString.equals(preNE)) continue;
            endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            if (!(preNE.equals("O") || preNE.equals("QUANTITY") || preNE.equals("CARDINAL") || preNE.equals("PERCENT"))) {
                IntPair mSpan2;
                if (((String)w.get(CoreAnnotations.TextAnnotation.class)).equals("'s")) {
                    ++endIndex;
                }
                if (!mentionSpanSet.contains(mSpan2 = new IntPair(beginIndex, endIndex))) {
                    int n;
                    if (this.assignIds) {
                        n = this.maxID + 1;
                        this.maxID = this.maxID;
                    } else {
                        n = -1;
                    }
                    int mentionId = n;
                    Mention m = new Mention(mentionId, beginIndex, endIndex, dependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                    mentions.add(m);
                    mentionSpanSet.add(mSpan2);
                    namedEntitySpanSet.add(mSpan2);
                }
            }
            beginIndex = endIndex;
            preNE = nerString;
        }
        if (!(preNE.equals("O") || preNE.equals("QUANTITY") || preNE.equals("CARDINAL") || preNE.equals("PERCENT") || mentionSpanSet.contains(mSpan = new IntPair(beginIndex, sent.size())))) {
            int mentionId = this.assignIds ? (this.maxID = this.maxID + 1) : -1;
            Mention m = new Mention(mentionId, beginIndex, sent.size(), dependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, sent.size())));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
            namedEntitySpanSet.add(mSpan);
        }
    }

    private void extractNPorPRP(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(CoreAnnotations.TreeAnnotation.class);
        tree.indexLeaves();
        SemanticGraph dependency = (SemanticGraph)((Object)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        try {
            String mentionPattern = "/^(?:NP|PRP)/";
            TregexPattern tgrepPattern = TregexPattern.compile("/^(?:NP|PRP)/");
            TregexMatcher matcher = tgrepPattern.matcher(tree);
            while (matcher.find()) {
                int n;
                int endIdx;
                Tree t = matcher.getMatch();
                List<Tree> mLeaves = t.getLeaves();
                int beginIdx = (Integer)((CoreLabel)mLeaves.get(0).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
                IntPair mSpan = new IntPair(beginIdx, endIdx = ((Integer)((CoreLabel)mLeaves.get(mLeaves.size() - 1).label()).get(CoreAnnotations.IndexAnnotation.class)).intValue());
                if (mentionSpanSet.contains(mSpan) || RuleBasedCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
                if (this.assignIds) {
                    n = this.maxID + 1;
                    this.maxID = this.maxID;
                } else {
                    n = -1;
                }
                int mentionID = n;
                Mention m = new Mention(mentionID, beginIdx, endIdx, dependency, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)), t);
                mentions.add(m);
                mentionSpanSet.add(mSpan);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private void extractEnumerations(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(CoreAnnotations.TreeAnnotation.class);
        SemanticGraph dependency = (SemanticGraph)((Object)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        try {
            String mentionPattern = "NP < (/^(?:NP|NNP|NML)/=m1 $.. (/^CC|,/ $.. /^(?:NP|NNP|NML)/=m2))";
            TregexPattern tgrepPattern = TregexPattern.compile("NP < (/^(?:NP|NNP|NML)/=m1 $.. (/^CC|,/ $.. /^(?:NP|NNP|NML)/=m2))");
            TregexMatcher matcher = tgrepPattern.matcher(tree);
            HashMap<IntPair, Tree> spanToMentionSubTree = new HashMap<IntPair, Tree>();
            while (matcher.find()) {
                matcher.getMatch();
                Tree m1 = matcher.getNode("m1");
                Tree m2 = matcher.getNode("m2");
                List<Tree> mLeaves = m1.getLeaves();
                int beginIdx = (Integer)((CoreLabel)mLeaves.get(0).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
                int endIdx = (Integer)((CoreLabel)mLeaves.get(mLeaves.size() - 1).label()).get(CoreAnnotations.IndexAnnotation.class);
                spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m1);
                mLeaves = m2.getLeaves();
                beginIdx = (Integer)((CoreLabel)mLeaves.get(0).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
                endIdx = (Integer)((CoreLabel)mLeaves.get(mLeaves.size() - 1).label()).get(CoreAnnotations.IndexAnnotation.class);
                spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m2);
            }
            for (IntPair mSpan : spanToMentionSubTree.keySet()) {
                int n;
                if (mentionSpanSet.contains(mSpan) || RuleBasedCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
                if (this.assignIds) {
                    n = this.maxID + 1;
                    this.maxID = this.maxID;
                } else {
                    n = -1;
                }
                int mentionID = n;
                Mention m = new Mention(mentionID, mSpan.get(0), mSpan.get(1), dependency, new ArrayList<CoreLabel>(sent.subList(mSpan.get(0), mSpan.get(1))), (Tree)spanToMentionSubTree.get(mSpan));
                mentions.add(m);
                mentionSpanSet.add(mSpan);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static boolean insideNE(IntPair mSpan, Set<IntPair> namedEntitySpanSet) {
        for (IntPair span : namedEntitySpanSet) {
            if (span.get(0) > mSpan.get(0) || mSpan.get(1) > span.get(1)) continue;
            return true;
        }
        return false;
    }

    private void findHead(CoreMap s, List<Mention> mentions) {
        Tree tree = (Tree)s.get(CoreAnnotations.TreeAnnotation.class);
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        tree.indexSpans(0);
        for (Mention m : mentions) {
            Tree head = this.findSyntacticHead(m, tree, sent);
            m.headIndex = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            m.headWord = (CoreLabel)sent.get(m.headIndex);
            m.headString = ((String)m.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
        }
    }

    protected Tree findSyntacticHead(Mention m, Tree root, List<CoreLabel> tokens) {
        Tree exactMatch;
        int endIdx = m.endIndex;
        if (((String)m.originalSpan.get(m.originalSpan.size() - 1).get(CoreAnnotations.TextAnnotation.class)).equals("'s") && m.originalSpan.size() != 1) {
            --endIdx;
        }
        if ((exactMatch = RuleBasedCorefMentionFinder.findTreeWithSpan(root, m.startIndex, endIdx)) != null) {
            return this.safeHead(exactMatch);
        }
        int approximateness = 0;
        ArrayList<CoreLabel> extentTokens = new ArrayList<CoreLabel>();
        extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("It"));
        extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("was"));
        int ADDED_WORDS = 2;
        for (int i = m.startIndex; i < endIdx; ++i) {
            CoreLabel label = tokens.get(i);
            if (!"-".equals(label.word())) {
                extentTokens.add(tokens.get(i));
                continue;
            }
            ++approximateness;
        }
        extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("."));
        Test.Constraint constraint = new Test.Constraint(2, extentTokens.size() - 1, Pattern.compile(".*"));
        Test.constraints = Collections.singletonList(constraint);
        Tree tree = this.parse(extentTokens);
        Test.constraints = null;
        RuleBasedCorefMentionFinder.convertToCoreLabels(tree);
        tree.indexSpans(m.startIndex - 2);
        Tree subtree = RuleBasedCorefMentionFinder.findPartialSpan(tree, m.startIndex);
        Tree extentHead = this.safeHead(subtree);
        assert (extentHead != null);
        CoreLabel l = (CoreLabel)extentHead.label();
        Tree realHead = RuleBasedCorefMentionFinder.funkyFindLeafWithApproximateSpan(root, l.value(), (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class), approximateness);
        assert (realHead != null);
        return realHead;
    }

    private static Tree findPartialSpan(Tree root, int start) {
        CoreLabel label = (CoreLabel)root.label();
        int startIndex = (Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class);
        if (startIndex == start) {
            return root;
        }
        for (Tree kid : root.children()) {
            CoreLabel kidLabel = (CoreLabel)kid.label();
            int kidStart = (Integer)kidLabel.get(CoreAnnotations.BeginIndexAnnotation.class);
            int kidEnd = (Integer)kidLabel.get(CoreAnnotations.EndIndexAnnotation.class);
            if (kidStart > start || kidEnd <= start) continue;
            return RuleBasedCorefMentionFinder.findPartialSpan(kid, start);
        }
        throw new RuntimeException("Shouldn't happen: " + start + " " + root);
    }

    private static Tree funkyFindLeafWithApproximateSpan(Tree root, String token, int index, int approximateness) {
        List<Tree> leaves = root.getLeaves();
        for (Tree leaf : leaves) {
            CoreLabel label = (CoreLabel)CoreLabel.class.cast(leaf.label());
            int ind = (Integer)label.get(CoreAnnotations.IndexAnnotation.class) - 1;
            if (!token.equals(leaf.value()) || ind < index || ind > index + approximateness) continue;
            return leaf;
        }
        throw new RuntimeException("RuleBasedCorefMentionFinder: ERROR: Failed to find head token");
    }

    private static CoreLabel initCoreLabel(String token) {
        CoreLabel label = new CoreLabel();
        label.setWord(token);
        label.set(CoreAnnotations.TextAnnotation.class, token);
        return label;
    }

    private Tree parse(List<CoreLabel> tokens) {
        Annotation sent = new Annotation("");
        sent.set(CoreAnnotations.TokensAnnotation.class, tokens);
        Annotation doc = new Annotation("");
        List sents = new ArrayList<Annotation>();
        sents.add(sent);
        doc.set(CoreAnnotations.SentencesAnnotation.class, sents);
        this.getParser().annotate(doc);
        sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Tree)((CoreMap)sents.get(0)).get(CoreAnnotations.TreeAnnotation.class);
    }

    private Annotator getParser() {
        if (this.parserProcessor == null) {
            this.parserProcessor = StanfordCoreNLP.getExistingAnnotator("parse");
            assert (this.parserProcessor != null);
        }
        return this.parserProcessor;
    }

    private static void convertToCoreLabels(Tree tree) {
        Label l = tree.label();
        if (!(l instanceof CoreLabel)) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(l.value());
            tree.setLabel(cl);
        }
        for (Tree kid : tree.children()) {
            RuleBasedCorefMentionFinder.convertToCoreLabels(kid);
        }
    }

    private Tree safeHead(Tree top) {
        Tree head = top.headTerminal(this.headFinder);
        if (head != null) {
            return head;
        }
        List<Tree> leaves = top.getLeaves();
        if (leaves.size() > 0) {
            return leaves.get(leaves.size() - 1);
        }
        return top;
    }

    private static Tree findTreeWithSpan(Tree tree, int start, int end) {
        CoreLabel l = (CoreLabel)tree.label();
        if (l != null && l.has(CoreAnnotations.BeginIndexAnnotation.class) && l.has(CoreAnnotations.EndIndexAnnotation.class)) {
            int myStart = (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class);
            int myEnd = (Integer)l.get(CoreAnnotations.EndIndexAnnotation.class);
            if (start == myStart && end == myEnd) {
                return tree;
            }
            if (end < myStart) {
                return null;
            }
            if (start >= myEnd) {
                return null;
            }
        }
        for (Tree kid : tree.children()) {
            Tree ret;
            if (kid == null || (ret = RuleBasedCorefMentionFinder.findTreeWithSpan(kid, start, end)) == null) continue;
            return ret;
        }
        return null;
    }

    private static void removeSpuriousMentions(CoreMap s, List<Mention> mentions, Dictionaries dict) {
        Tree tree = (Tree)s.get(CoreAnnotations.TreeAnnotation.class);
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        HashSet<Mention> remove = new HashSet<Mention>();
        for (Mention m : mentions) {
            String headPOS = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            String headNE = (String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (RuleBasedCorefMentionFinder.isPleonastic(m, tree)) {
                remove.add(m);
            }
            if (dict.nonWords.contains(m.headString)) {
                remove.add(m);
            }
            if (dict.quantifiers.contains(((String)m.originalSpan.get(0).get(CoreAnnotations.TextAnnotation.class)).toLowerCase())) {
                remove.add(m);
            }
            if (RuleBasedCorefMentionFinder.partitiveRule(m, sent, dict)) {
                remove.add(m);
            }
            if (headPOS.equals("NN") && !dict.temporals.contains(m.headString) && (m.originalSpan.size() == 1 || ((String)m.originalSpan.get(0).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("JJ"))) {
                remove.add(m);
            }
            if (m.headString.equals("%")) {
                remove.add(m);
            }
            if (headNE.equals("PERCENT") || headNE.equals("MONEY")) {
                remove.add(m);
            }
            if (dict.adjectiveNation.contains(m.spanToString().toLowerCase())) {
                remove.add(m);
            }
            if (!RuleBasedCorefMentionFinder.inStopList(m)) continue;
            remove.add(m);
        }
        for (Mention m1 : mentions) {
            for (Mention m2 : mentions) {
                if (m1 == m2 || remove.contains(m1) || remove.contains(m2) || m1.sentNum != m2.sentNum || m1.headWord != m2.headWord || !m2.insideIn(m1) || m2.endIndex < sent.size() && (((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",") || ((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CC"))) continue;
                remove.add(m2);
            }
        }
        mentions.removeAll(remove);
    }

    private static boolean inStopList(Mention m) {
        String mentionSpan = m.spanToString().toLowerCase();
        if (mentionSpan.equals("u.s.") || mentionSpan.equals("u.k.") || mentionSpan.equals("u.s.s.r")) {
            return true;
        }
        if (mentionSpan.equals("there") || mentionSpan.startsWith("etc.") || mentionSpan.equals("ltd.")) {
            return true;
        }
        if (mentionSpan.startsWith("'s ")) {
            return true;
        }
        return mentionSpan.endsWith("etc.");
    }

    private static boolean partitiveRule(Mention m, List<CoreLabel> sent, Dictionaries dict) {
        return m.startIndex >= 2 && ((String)sent.get(m.startIndex - 1).get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("of") && dict.parts.contains(((String)sent.get(m.startIndex - 2).get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
    }

    private static boolean isPleonastic(Mention m, Tree tree) {
        String[] patterns;
        if (!m.spanToString().equalsIgnoreCase("it")) {
            return false;
        }
        for (String p : patterns = new String[]{"NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (VP < (VBN $.. /S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP $.. (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP < (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP < /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP $.. ADVP $.. /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < (MD $ .. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (VP < (VBN $.. /S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $ .. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP $.. (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $ .. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP < (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $ .. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP < /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < (MD $ .. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP $.. ADVP $.. /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:seems|appears|means|follows)/) $.. /S|SBAR/))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:turns|turned)/) $.. PRT $.. /S|SBAR/))"}) {
            if (!RuleBasedCorefMentionFinder.checkPleonastic(m, tree, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPleonastic(Mention m, Tree tree, String pattern) {
        try {
            TregexPattern tgrepPattern = TregexPattern.compile(pattern);
            TregexMatcher matcher = tgrepPattern.matcher(tree);
            while (matcher.find()) {
                Tree np1 = matcher.getNode("m1");
                if ((Integer)((CoreLabel)np1.label()).get(CoreAnnotations.BeginIndexAnnotation.class) + 1 != (Integer)m.headWord.get(CoreAnnotations.IndexAnnotation.class)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

