/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.DFSAState;
import edu.stanford.nlp.util.Scored;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DFSATransition<T, S>
implements Scored {
    private Object transitionID;
    private DFSAState<T, S> source;
    protected DFSAState<T, S> target;
    private double score;
    private T input;
    private Object output;

    public DFSATransition(Object transitionID, DFSAState<T, S> source, DFSAState<T, S> target, T input, Object output, double score) {
        this.transitionID = transitionID;
        this.source = source;
        this.target = target;
        this.input = input;
        this.output = output;
        this.score = score;
    }

    public DFSAState<T, S> getSource() {
        return this.source;
    }

    public DFSAState<T, S> source() {
        return this.source;
    }

    public DFSAState<T, S> getTarget() {
        return this.target;
    }

    public DFSAState<T, S> target() {
        return this.target;
    }

    public Object getID() {
        return this.transitionID;
    }

    @Override
    public double score() {
        return this.score;
    }

    public T getInput() {
        return this.input;
    }

    public T input() {
        return this.input;
    }

    public Object getOutput() {
        return this.output;
    }

    public Object output() {
        return this.output;
    }

    public String toString() {
        return "[" + this.transitionID + "]" + this.source + " -" + this.input + ":" + this.output + "-> " + this.target;
    }
}

