/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.Entity;
import edu.stanford.nlp.ie.EntityCachingAbstractSequencePrior;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalNERPrior<IN extends CoreMap>
extends EntityCachingAbstractSequencePrior<IN> {
    static final String ORG = "ORGANIZATION";
    static final String PER = "PERSON";
    static final String LOC = "LOCATION";
    static final String MISC = "MISC";
    double p1 = -Math.log(0.01);
    double dem1 = 6631.0;
    double p2 = -Math.log(6436.0 / this.dem1) / 2.0;
    double p3 = -Math.log(188.0 / this.dem1) / 2.0;
    double p4 = -Math.log(4.0 / this.dem1) / 2.0;
    double p5 = -Math.log(3.0 / this.dem1) / 2.0;
    double dem2 = 3169.0;
    double p6 = -Math.log(188.0 / this.dem2) / 2.0;
    double p7 = -Math.log(2975.0 / this.dem2) / 2.0;
    double p8 = -Math.log(5.0 / this.dem2) / 2.0;
    double p9 = -Math.log(1.0 / this.dem2) / 2.0;
    double dem3 = 3151.0;
    double p10 = -Math.log(4.0 / this.dem3) / 2.0;
    double p11 = -Math.log(5.0 / this.dem3) / 2.0;
    double p12 = -Math.log(3141.0 / this.dem3) / 2.0;
    double p13 = -Math.log(1.0 / this.dem3) / 2.0;
    double dem4 = 2035.0;
    double p14 = -Math.log(3.0 / this.dem4) / 2.0;
    double p15 = -Math.log(1.0 / this.dem4) / 2.0;
    double p16 = -Math.log(1.0 / this.dem4) / 2.0;
    double p17 = -Math.log(2030.0 / this.dem4) / 2.0;
    double dem5 = 724.0;
    double p18 = -Math.log(167.0 / this.dem5);
    double p19 = -Math.log(328.0 / this.dem5);
    double p20 = -Math.log(5.0 / this.dem5);
    double p21 = -Math.log(224.0 / this.dem5);
    double dem6 = 834.0;
    double p22 = -Math.log(6.0 / this.dem6);
    double p23 = -Math.log(819.0 / this.dem6);
    double p24 = -Math.log(2.0 / this.dem6);
    double p25 = -Math.log(7.0 / this.dem6);
    double dem7 = 1978.0;
    double p26 = -Math.log(1.0 / this.dem7);
    double p27 = -Math.log(22.0 / this.dem7);
    double p28 = -Math.log(1941.0 / this.dem7);
    double p29 = -Math.log(14.0 / this.dem7);
    double dem8 = 622.0;
    double p30 = -Math.log(63.0 / this.dem8);
    double p31 = -Math.log(191.0 / this.dem8);
    double p32 = -Math.log(3.0 / this.dem8);
    double p33 = -Math.log(365.0 / this.dem8);

    public EmpiricalNERPrior(String backgroundSymbol, Index<String> classIndex, List<IN> doc) {
        super(backgroundSymbol, classIndex, doc);
    }

    @Override
    public double scoreOf(int[] sequence) {
        double p = 0.0;
        for (int i = 0; i < this.entities.length; ++i) {
            Entity entity = this.entities[i];
            if (i != 0 && this.entities[i - 1] == entity || entity == null) continue;
            int length = entity.words.size();
            String tag1 = (String)this.classIndex.get(entity.type);
            if (tag1.equals(LOC)) {
                tag1 = LOC;
            } else if (tag1.equals(ORG)) {
                tag1 = ORG;
            } else if (tag1.equals(PER)) {
                tag1 = PER;
            } else if (tag1.equals(MISC)) {
                tag1 = MISC;
            }
            int[] other = this.entities[i].otherOccurrences;
            for (int j = 0; j < other.length; ++j) {
                Entity otherEntity = null;
                for (int k = other[j]; k < other[j] + length && k < this.entities.length && (otherEntity = this.entities[k]) == null; ++k) {
                }
                if (otherEntity == null) continue;
                int oLength = otherEntity.words.size();
                String tag2 = (String)this.classIndex.get(otherEntity.type);
                if (tag2.equals(LOC)) {
                    tag2 = LOC;
                } else if (tag2.equals(ORG)) {
                    tag2 = ORG;
                } else if (tag2.equals(PER)) {
                    tag2 = PER;
                } else if (tag2.equals(MISC)) {
                    tag2 = MISC;
                }
                boolean exact = false;
                int[] oOther = otherEntity.otherOccurrences;
                for (int k = 0; k < oOther.length; ++k) {
                    if (oOther[k] < i || oOther[k] > i + length - 1) continue;
                    exact = true;
                    break;
                }
                if (exact) {
                    if (length != oLength) {
                        if (tag1 == tag2) {
                            p -= (double)Math.abs(oLength - length) * this.p1;
                        } else if (!(tag1.equals(ORG) && tag2.equals(LOC) || tag2.equals(LOC) && tag1.equals(ORG))) {
                            p -= (double)(oLength + length) * this.p1;
                        }
                    }
                    if (tag1 == LOC) {
                        if (tag2 == LOC) continue;
                        if (tag2 == ORG) {
                            p -= (double)length * this.p3;
                            continue;
                        }
                        if (tag2 == PER) {
                            p -= (double)length * this.p4;
                            continue;
                        }
                        if (tag2 != MISC) continue;
                        p -= (double)length * this.p5;
                        continue;
                    }
                    if (tag1 == ORG) {
                        if (tag2 == LOC) {
                            p -= (double)length * this.p6;
                            continue;
                        }
                        if (tag2 == ORG) continue;
                        if (tag2 == PER) {
                            p -= (double)length * this.p8;
                            continue;
                        }
                        if (tag2 != MISC) continue;
                        p -= (double)length * this.p9;
                        continue;
                    }
                    if (tag1 == PER) {
                        if (tag2 == LOC) {
                            p -= (double)length * this.p10;
                            continue;
                        }
                        if (tag2 == ORG) {
                            p -= (double)length * this.p11;
                            continue;
                        }
                        if (tag2 == PER || tag2 != MISC) continue;
                        p -= (double)length * this.p13;
                        continue;
                    }
                    if (tag1 != MISC) continue;
                    if (tag2 == LOC) {
                        p -= (double)length * this.p14;
                        continue;
                    }
                    if (tag2 == ORG) {
                        p -= (double)length * this.p15;
                        continue;
                    }
                    if (tag2 == PER) {
                        p -= (double)length * this.p16;
                        continue;
                    }
                    if (tag2 != MISC) continue;
                    continue;
                }
                if (tag1 == LOC) {
                    if (tag2 == LOC || tag2 == ORG) continue;
                    if (tag2 == PER) {
                        p -= (double)length * this.p20;
                        continue;
                    }
                    if (tag2 != MISC) continue;
                    p -= (double)length * this.p21;
                    continue;
                }
                if (tag1 == ORG) {
                    if (tag2 == LOC) {
                        p -= (double)length * this.p22;
                        continue;
                    }
                    if (tag2 == ORG) continue;
                    if (tag2 == PER) {
                        p -= (double)length * this.p24;
                        continue;
                    }
                    if (tag2 != MISC) continue;
                    p -= (double)length * this.p25;
                    continue;
                }
                if (tag1 == PER) {
                    if (tag2 == LOC) {
                        p -= (double)length * this.p26;
                        continue;
                    }
                    if (tag2 == ORG) {
                        p -= (double)length * this.p27;
                        continue;
                    }
                    if (tag2 == PER || tag2 != MISC) continue;
                    p -= (double)length * this.p29;
                    continue;
                }
                if (tag1 != MISC) continue;
                if (tag2 == LOC) {
                    p -= (double)length * this.p30;
                    continue;
                }
                if (tag2 == ORG) {
                    p -= (double)length * this.p31;
                    continue;
                }
                if (tag2 == PER) {
                    p -= (double)length * this.p32;
                    continue;
                }
                if (tag2 != MISC) continue;
                p -= (double)length * this.p33;
            }
        }
        return p;
    }
}

