/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.common;

import edu.stanford.nlp.ie.machinereading.common.SimpleTokenize;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringDictionary {
    private String mName;
    private boolean mCreate;
    private HashMap<String, IndexAndCount> mDict;
    private HashMap<Integer, String> mInverse;
    public static final String NIL_VALUE = "nil";

    public StringDictionary(String name) {
        this.mName = name;
        this.mCreate = false;
        this.mDict = new HashMap();
        this.mInverse = new HashMap();
    }

    public void setMode(boolean mode) {
        this.mCreate = mode;
    }

    public int size() {
        return this.mDict.size();
    }

    public int get(String s) {
        return this.get(s, true);
    }

    public IndexAndCount getIndexAndCount(String s) {
        IndexAndCount ic = this.mDict.get(s);
        if (this.mCreate) {
            if (ic == null) {
                ic = new IndexAndCount(this.mDict.size(), 0);
                this.mDict.put(s, ic);
                this.mInverse.put(new Integer(ic.mIndex), s);
            }
            ++ic.mCount;
        }
        return ic;
    }

    public int get(String s, boolean shouldThrow) {
        IndexAndCount ic = this.mDict.get(s);
        if (this.mCreate) {
            if (ic == null) {
                ic = new IndexAndCount(this.mDict.size(), 0);
                this.mDict.put(s, ic);
                this.mInverse.put(new Integer(ic.mIndex), s);
            }
            ++ic.mCount;
        }
        if (ic != null) {
            return ic.mIndex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown entry \"" + s + "\" in dictionary \"" + this.mName + "\"!");
        }
        return -1;
    }

    public String get(int idx) {
        if (idx == -1) {
            return NIL_VALUE;
        }
        String s = this.mInverse.get(idx);
        if (s == null) {
            throw new RuntimeException("Unknown index \"" + idx + "\" in dictionary \"" + this.mName + "\"!");
        }
        return s;
    }

    public int getCount(int idx) {
        if (idx == -1) {
            return 0;
        }
        String s = this.mInverse.get(idx);
        if (s == null) {
            throw new RuntimeException("Unknown index \"" + idx + "\" in dictionary \"" + this.mName + "\"!");
        }
        return this.getIndexAndCount((String)s).mCount;
    }

    public void save(String path, String prefix, int threshold) throws IOException {
        String fileName = path + File.separator + prefix + "." + this.mName;
        PrintStream os = new PrintStream(new FileOutputStream(fileName));
        Set<String> keys = this.mDict.keySet();
        int index = 0;
        for (String key : keys) {
            IndexAndCount ic = this.mDict.get(key);
            if (ic.mCount <= threshold) continue;
            os.println(key + " " + index + " " + ic.mCount);
            ++index;
        }
        os.close();
        System.err.println("Saved " + index + "/" + this.mDict.size() + " entries for dictionary \"" + this.mName + "\".");
    }

    public void clear() {
        this.mDict.clear();
        this.mInverse.clear();
    }

    public Set<String> keySet() {
        return this.mDict.keySet();
    }

    public void load(String path, String prefix) throws IOException {
        String line;
        String fileName = path + File.separator + prefix + "." + this.mName;
        BufferedReader is = new BufferedReader(new FileReader(fileName));
        while ((line = is.readLine()) != null) {
            ArrayList<String> tokens = SimpleTokenize.tokenize(line);
            if (tokens.size() != 3) {
                throw new RuntimeException("Invalid dictionary line: " + line);
            }
            int index = Integer.parseInt(tokens.get(1));
            int count = Integer.parseInt(tokens.get(2));
            if (index < 0 || count <= 0) {
                throw new RuntimeException("Invalid dictionary line: " + line);
            }
            IndexAndCount ic = new IndexAndCount(index, count);
            this.mDict.put(tokens.get(0), ic);
            this.mInverse.put(new Integer(index), tokens.get(0));
        }
        is.close();
        System.err.println("Loaded " + this.mDict.size() + " entries for dictionary \"" + this.mName + "\".");
    }

    public Set<String> keys() {
        return this.mDict.keySet();
    }

    public class IndexAndCount {
        public int mIndex;
        public int mCount;

        IndexAndCount(int i, int c) {
            this.mIndex = i;
            this.mCount = c;
        }
    }
}

