/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceDocument;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntity;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEventMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceToken;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceEntityMention
extends AceMention {
    private String mType;
    private String mLdctype;
    private AceCharSeq mHead;
    private int mHeadTokenPosition;
    private AceEntity mParent;
    private List<AceRelationMention> mRelationMentions;
    private List<AceEventMention> mEventMentions;

    public String toString() {
        return "AceEntityMention [mHead=" + this.mHead + ", mLdctype=" + this.mLdctype + ", mType=" + this.mType + "]";
    }

    public AceEntityMention(String id, String type, String ldctype, AceCharSeq extent, AceCharSeq head) {
        super(id, extent);
        this.mType = type;
        this.mLdctype = ldctype;
        this.mHead = head;
        this.mExtent = extent;
        this.mHeadTokenPosition = -1;
        this.mParent = null;
        this.mRelationMentions = new ArrayList<AceRelationMention>();
        this.mEventMentions = new ArrayList<AceEventMention>();
    }

    public String getMention() {
        return this.mType;
    }

    public void setParent(AceEntity e) {
        this.mParent = e;
    }

    public AceEntity getParent() {
        return this.mParent;
    }

    public AceCharSeq getHead() {
        return this.mHead;
    }

    @Override
    public AceCharSeq getExtent() {
        return this.mExtent;
    }

    public int getHeadTokenPosition() {
        return this.mHeadTokenPosition;
    }

    public void setType(String s) {
        this.mType = s;
    }

    public String getType() {
        return this.mType;
    }

    public void setLdctype(String s) {
        this.mLdctype = s;
    }

    public String getLdctype() {
        return this.mLdctype;
    }

    public void addRelationMention(AceRelationMention rm) {
        this.mRelationMentions.add(rm);
    }

    public List<AceRelationMention> getRelationMentions() {
        return this.mRelationMentions;
    }

    public void addEventMention(AceEventMention rm) {
        this.mEventMentions.add(rm);
    }

    public List<AceEventMention> getEventMentions() {
        return this.mEventMentions;
    }

    @Override
    public String toXml(int offset) {
        StringBuffer buffer = new StringBuffer();
        String mentionType = this.mType;
        AceEntityMention.appendOffset(buffer, offset);
        buffer.append("<entity_mention ID=\"" + this.getId() + "\" TYPE =\"" + mentionType + "\" LDCTYPE=\"" + this.mLdctype + "\">\n");
        buffer.append(this.mExtent.toXml("extent", offset + 2));
        buffer.append("\n");
        buffer.append(this.mHead.toXml("head", offset + 2));
        buffer.append("\n");
        AceEntityMention.appendOffset(buffer, offset);
        buffer.append("</entity_mention>");
        if (mentionType.equals("NAM")) {
            buffer.append("\n");
            AceEntityMention.appendOffset(buffer, offset);
            buffer.append("<entity_attributes>\n");
            AceEntityMention.appendOffset(buffer, offset + 2);
            buffer.append("<name NAME=\"" + this.mHead.getText() + "\">\n");
            buffer.append(this.mHead.toXml(offset + 4) + "\n");
            AceEntityMention.appendOffset(buffer, offset + 2);
            buffer.append("</name>\n");
            AceEntityMention.appendOffset(buffer, offset);
            buffer.append("</entity_attributes>");
        }
        return buffer.toString();
    }

    private static boolean contains(ArrayList<Integer> set, int elem) {
        for (int i = 0; i < set.size(); ++i) {
            if (elem != set.get(i)) continue;
            return true;
        }
        return false;
    }

    public void detectHeadToken(AceDocument doc) {
        ArrayList<Integer> preps = new ArrayList<Integer>();
        preps.add(AceToken.OTHERS.get("IN"));
        for (int i = this.mHead.getTokenStart(); i <= this.mHead.getTokenEnd(); ++i) {
            if (!AceEntityMention.contains(preps, doc.getToken(i).getPos()) || i <= this.mHead.getTokenStart()) continue;
            this.mHeadTokenPosition = i - 1;
            return;
        }
        this.mHeadTokenPosition = this.mHead.getTokenEnd();
    }

    public boolean before(AceEntityMention em) {
        return this.mHead.getByteEnd() < em.mHead.getByteStart();
    }

    public boolean after(AceEntityMention em) {
        return this.mHead.getByteStart() > em.mHead.getByteEnd();
    }
}

