/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.common.SimpleTokenize;
import edu.stanford.nlp.ie.machinereading.common.StringDictionary;
import edu.stanford.nlp.trees.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceToken {
    private String mLiteral;
    private int mWord;
    private int mCase;
    private int[] mSuffixes;
    private int mLemma;
    private int mPos;
    private int mChunk;
    private int mNerc;
    private Span mByteOffset;
    private Span mRawByteOffset;
    private int mSentence;
    private String mMassiClass;
    private String mMassiBbn;
    private String mMassiWnss;
    public static StringDictionary WORDS;
    public static StringDictionary LEMMAS;
    public static StringDictionary OTHERS;
    public static HashMap<Integer, ArrayList<Integer>> PROX_CLASSES;
    private static final int PROXIMITY_CLASS_SIZE = 5;
    private static HashMap<String, String> LOC_GAZ;
    private static HashMap<String, String> FIRST_GAZ;
    private static HashMap<String, String> LAST_GAZ;
    private static HashMap<String, String> TRIGGER_GAZ;
    private static final Pattern SGML_PATTERN;
    public static final int CASE_OTHER = 0;
    public static final int CASE_ALLCAPS = 1;
    public static final int CASE_ALLCAPSORDOTS = 2;
    public static final int CASE_CAPINI = 3;
    public static final int CASE_INCAP = 4;
    public static final int CASE_ALLDIGITS = 5;
    public static final int CASE_ALLDIGITSORDOTS = 6;

    public static void loadGazetteers(String dataPath) throws FileNotFoundException, IOException {
        System.err.print("Loading location gazetteer... ");
        LOC_GAZ = new HashMap();
        AceToken.loadDictionary(LOC_GAZ, dataPath + File.separator + "world_small.gaz.nonambiguous");
        System.err.println("done.");
        System.err.print("Loading first-name gazetteer... ");
        FIRST_GAZ = new HashMap();
        AceToken.loadDictionary(FIRST_GAZ, dataPath + File.separator + "per_first.gaz");
        System.err.println("done.");
        System.err.print("Loading last-name gazetteer... ");
        LAST_GAZ = new HashMap();
        AceToken.loadDictionary(LAST_GAZ, dataPath + File.separator + "per_last.gaz");
        System.err.println("done.");
        System.err.print("Loading trigger-word gazetteer... ");
        TRIGGER_GAZ = new HashMap();
        AceToken.loadDictionary(TRIGGER_GAZ, dataPath + File.separator + "triggers.gaz");
        System.err.println("done.");
    }

    private static void loadDictionary(HashMap<String, String> dict, String file) throws FileNotFoundException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            ArrayList<String> tokens = SimpleTokenize.tokenize(line);
            if (tokens.size() <= 0) continue;
            String lower = tokens.get(0).toLowerCase();
            if (tokens.size() == 1) {
                dict.put(lower, "true");
                continue;
            }
            dict.put(lower, tokens.get(1));
        }
    }

    public static boolean isLocation(String lower) {
        return AceToken.exists(LOC_GAZ, lower);
    }

    public static boolean isFirstName(String lower) {
        return AceToken.exists(FIRST_GAZ, lower);
    }

    public static boolean isLastName(String lower) {
        return AceToken.exists(LAST_GAZ, lower);
    }

    public static String isTriggerWord(String lower) {
        return TRIGGER_GAZ.get(lower);
    }

    public static boolean exists(HashMap<String, String> dict, String elem) {
        return dict.get(elem) != null;
    }

    public static void loadProximityClasses(String proxFileName) throws IOException {
        String line;
        System.err.println("Loading proximity classes...");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(proxFileName));
        }
        catch (IOException e) {
            System.err.println("Warning: no proximity database found.");
            return;
        }
        while ((line = in.readLine()) != null) {
            ArrayList<String> tokens = SimpleTokenize.tokenize(line);
            if (tokens.size() <= 0) continue;
            Integer key = WORDS.get(tokens.get(0));
            ArrayList<Integer> value = new ArrayList<Integer>();
            for (int i = 0; i < tokens.size() && i < 5; ++i) {
                Integer word = WORDS.get(tokens.get(i));
                value.add(word);
            }
            PROX_CLASSES.put(key, value);
        }
        in.close();
        System.err.println("Finished loading proximity classes.");
    }

    public String getLiteral() {
        return this.mLiteral;
    }

    public int getWord() {
        return this.mWord;
    }

    public int getCase() {
        return this.mCase;
    }

    public int[] getSuffixes() {
        return this.mSuffixes;
    }

    public int getLemma() {
        return this.mLemma;
    }

    public int getPos() {
        return this.mPos;
    }

    public int getChunk() {
        return this.mChunk;
    }

    public int getNerc() {
        return this.mNerc;
    }

    public Span getByteOffset() {
        return this.mByteOffset;
    }

    public int getByteStart() {
        return this.mByteOffset.start();
    }

    public int getByteEnd() {
        return this.mByteOffset.end();
    }

    public int getSentence() {
        return this.mSentence;
    }

    public Span getRawByteOffset() {
        return this.mRawByteOffset;
    }

    public int getRawByteStart() {
        return this.mRawByteOffset.start();
    }

    public int getRawByteEnd() {
        return this.mRawByteOffset.end();
    }

    public void setMassiClass(String i) {
        this.mMassiClass = i;
    }

    public String getMassiClass() {
        return this.mMassiClass;
    }

    public void setMassiBbn(String i) {
        this.mMassiBbn = i;
    }

    public String getMassiBbn() {
        return this.mMassiBbn;
    }

    public void setMassiWnss(String i) {
        this.mMassiWnss = i;
    }

    public String getMassiWnss() {
        return this.mMassiWnss;
    }

    public static boolean isSgml(String s) {
        Matcher match = SGML_PATTERN.matcher(s);
        return match.find(0);
    }

    public static String removeSpaces(String s) {
        if (s == null) {
            return s;
        }
        return s.replaceAll(" ", "_");
    }

    private int detectCase(String word) {
        boolean isAllCaps = true;
        for (int i = 0; i < word.length(); ++i) {
            if (Character.isUpperCase(word.charAt(i))) continue;
            isAllCaps = false;
            break;
        }
        if (isAllCaps) {
            return 1;
        }
        boolean isAllCapsOrDots = true;
        if (Character.isUpperCase(word.charAt(0))) {
            for (int i = 0; i < word.length(); ++i) {
                if (Character.isUpperCase(word.charAt(i)) || word.charAt(i) == '.') continue;
                isAllCapsOrDots = false;
                break;
            }
        } else {
            isAllCapsOrDots = false;
        }
        if (isAllCapsOrDots) {
            return 2;
        }
        boolean isInitialCap = false;
        if (Character.isUpperCase(word.charAt(0))) {
            isInitialCap = true;
        }
        if (isInitialCap) {
            return 3;
        }
        boolean isInCap = false;
        for (int i = 1; i < word.length(); ++i) {
            if (!Character.isUpperCase(word.charAt(i))) continue;
            isInCap = true;
            break;
        }
        if (isInCap) {
            return 4;
        }
        boolean isAllDigits = false;
        for (int i = 0; i < word.length(); ++i) {
            if (Character.isDigit(word.charAt(i))) continue;
            isAllDigits = false;
            break;
        }
        if (isAllDigits) {
            return 5;
        }
        boolean isAllDigitsOrDots = true;
        if (Character.isDigit(word.charAt(0))) {
            for (int i = 0; i < word.length(); ++i) {
                if (Character.isDigit(word.charAt(i)) || word.charAt(i) == '.' || word.charAt(i) == ',') continue;
                isAllDigitsOrDots = false;
                break;
            }
        } else {
            isAllDigitsOrDots = false;
        }
        if (isAllDigitsOrDots) {
            return 6;
        }
        return 0;
    }

    private static int[] extractSuffixes(String word) {
        String lower = word.toLowerCase();
        ArrayList<Integer> suffixes = new ArrayList<Integer>();
        for (int i = 2; i <= 4 && lower.length() >= i; ++i) {
            try {
                String suf = lower.substring(lower.length() - i);
                suffixes.add(WORDS.get(suf));
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        int[] sufs = new int[suffixes.size()];
        for (int i = 0; i < suffixes.size(); ++i) {
            sufs[i] = (Integer)suffixes.get(i);
        }
        return sufs;
    }

    public AceToken(String word, String lemma, String pos, String chunk, String nerc, String start, String end, int sentence) {
        this.mLiteral = word;
        if (word == null) {
            this.mWord = -1;
            this.mCase = -1;
            this.mSuffixes = null;
        } else {
            this.mWord = WORDS.get(AceToken.removeSpaces(word), false);
            this.mCase = this.detectCase(word);
            this.mSuffixes = AceToken.extractSuffixes(word);
        }
        this.mLemma = lemma == null ? -1 : LEMMAS.get(AceToken.removeSpaces(lemma), false);
        this.mPos = pos == null ? -1 : OTHERS.get(pos, false);
        this.mChunk = chunk == null ? -1 : OTHERS.get(chunk, false);
        this.mNerc = nerc == null ? -1 : OTHERS.get(nerc, false);
        if (start != null && end != null) {
            this.mByteOffset = new Span(Integer.parseInt(start), Integer.parseInt(end));
            this.mRawByteOffset = new Span(Integer.parseInt(start), Integer.parseInt(end));
        }
        this.mSentence = sentence;
        this.mMassiClass = "";
        this.mMassiBbn = "";
        this.mMassiWnss = "";
    }

    public int adjustPhrasePositions(int offsetToSubtract, String word) {
        if (AceToken.isSgml(word)) {
            offsetToSubtract += this.mByteOffset.end() - this.mByteOffset.start();
            this.mByteOffset.setStart(-1);
            this.mByteOffset.setEnd(-1);
        } else {
            this.mByteOffset.setStart(this.mByteOffset.start() - offsetToSubtract);
            this.mByteOffset.setEnd(this.mByteOffset.end() - offsetToSubtract);
        }
        return offsetToSubtract;
    }

    public String display() {
        if (this.mByteOffset != null) {
            return new String("['" + WORDS.get(this.mWord) + "', " + OTHERS.get(this.mPos) + ", " + this.mByteOffset.start() + ", " + this.mByteOffset.end() + "]");
        }
        return new String("['" + WORDS.get(this.mWord) + "', " + OTHERS.get(this.mPos) + "]");
    }

    public String toString() {
        return this.display();
    }

    static {
        PROX_CLASSES = null;
        LOC_GAZ = null;
        FIRST_GAZ = null;
        LAST_GAZ = null;
        TRIGGER_GAZ = null;
        WORDS = new StringDictionary("words");
        LEMMAS = new StringDictionary("lemmas");
        OTHERS = new StringDictionary("others");
        WORDS.setMode(true);
        LEMMAS.setMode(true);
        OTHERS.setMode(true);
        PROX_CLASSES = new HashMap();
        SGML_PATTERN = Pattern.compile("<[^<>]+>");
    }
}

