/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.pascal.AcronymModel;
import edu.stanford.nlp.ie.pascal.Alignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentFactory {
    public static final byte SHIFT_LONG = 1;
    public static final byte SHIFT_SHORT = 2;
    public static final byte SHIFT_BOTH = 4;
    private char[] longForm;
    private char[] lcLongForm;
    private char[] shortForm;
    private char[] lcShortForm;
    private int[][] alignMatrix;
    private byte[][] backMatrix;
    private HashSet<Alignment> alignments;
    int addCount;

    public AlignmentFactory(String longForm, String shortForm) {
        this(longForm.toCharArray(), shortForm.toCharArray());
    }

    public static char[] toLower(char[] in) {
        char[] out2 = new char[in.length];
        for (int i = 0; i < in.length; ++i) {
            out2[i] = Character.toLowerCase(in[i]);
        }
        return out2;
    }

    public AlignmentFactory(char[] longForm, char[] shortForm) {
        this.longForm = longForm;
        this.lcLongForm = AlignmentFactory.toLower(longForm);
        this.shortForm = shortForm;
        this.lcShortForm = AlignmentFactory.toLower(shortForm);
        this.alignMatrix = new int[this.lcLongForm.length][this.lcShortForm.length];
        this.backMatrix = new byte[this.lcLongForm.length][this.lcShortForm.length];
        for (int l = 0; l < this.lcLongForm.length; ++l) {
            for (int s = 0; s < this.lcShortForm.length; ++s) {
                int match = this.lcLongForm[l] == this.lcShortForm[s] ? 1 : 0;
                int froml = l == 0 ? 0 : this.alignMatrix[l - 1][s];
                int froms = s == 0 ? 0 : this.alignMatrix[l][s - 1];
                int frommatch = (l == 0 || s == 0 ? 0 : this.alignMatrix[l - 1][s - 1]) + match;
                int max = Math.max(froml, Math.max(froms, frommatch));
                byte backp = 0;
                if (froml == max) {
                    backp = (byte)(backp | 1);
                }
                if (froms == max) {
                    backp = (byte)(backp | 2);
                }
                if (match == 1 && frommatch == max) {
                    backp = (byte)(backp | 4);
                }
                this.backMatrix[l][s] = backp;
                this.alignMatrix[l][s] = max;
            }
        }
        this.alignments = new HashSet();
        int[] pointers = new int[this.lcShortForm.length];
        Arrays.fill(pointers, -1);
        if (this.lcLongForm.length > 0 && this.lcShortForm.length > 0) {
            this.addCount = 0;
            this.findAlignments(pointers, this.lcLongForm.length - 1, this.lcShortForm.length - 1);
        }
    }

    public Iterator<Alignment> getAlignments() {
        return this.alignments.iterator();
    }

    public ArrayList<Alignment> getAlignmentsList() {
        return new ArrayList<Alignment>(this.alignments);
    }

    public static String dumpIntArray(int[] a) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int anA : a) {
            buf.append(anA).append(' ');
        }
        buf.append(']');
        return buf.toString();
    }

    private void findAlignments(int[] pointers, int lg, int s) {
        int[] ptrcpy;
        byte backp = this.backMatrix[lg][s];
        if (this.alignMatrix[lg][s] == 0) {
            ++this.addCount;
            this.alignments.add(new Alignment(this.longForm, this.shortForm, pointers));
            return;
        }
        if ((backp & 1) != 0) {
            int[] nArray = ptrcpy = (backp = (byte)(backp & 0xFFFFFFFE)) == 0 ? pointers : (int[])pointers.clone();
            if (lg == 0) {
                ++this.addCount;
                this.alignments.add(new Alignment(this.longForm, this.shortForm, ptrcpy));
            } else {
                this.findAlignments(ptrcpy, lg - 1, s);
            }
        }
        if ((backp & 2) != 0) {
            int[] nArray = ptrcpy = (backp = (byte)(backp & 0xFFFFFFFD)) == 0 ? pointers : (int[])pointers.clone();
            if (s == 0) {
                ++this.addCount;
                this.alignments.add(new Alignment(this.longForm, this.shortForm, ptrcpy));
            } else {
                this.findAlignments(ptrcpy, lg, s - 1);
            }
        }
        if (this.lcLongForm[lg] == this.lcShortForm[s]) assert ((this.backMatrix[lg][s] & 4) != 0);
        if ((backp & 4) != 0) {
            assert (this.lcLongForm[lg] == this.lcShortForm[s]);
            pointers[s] = lg;
            if (lg == 0 || s == 0) {
                ++this.addCount;
                this.alignments.add(new Alignment(this.longForm, this.shortForm, pointers));
            } else {
                this.findAlignments(pointers, lg - 1, s - 1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AlignmentFactory fact = new AlignmentFactory(args[0].toCharArray(), AcronymModel.stripAcronym(args[1]));
        Iterator<Alignment> iter = fact.getAlignments();
        while (iter.hasNext()) {
            Alignment a = iter.next();
            a.print();
        }
    }
}

