/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISODateInstance {
    private static final boolean DEBUG = false;
    private ArrayList<String> tokens = new ArrayList();
    public static final String OPEN_RANGE_AFTER = "A";
    public static final String OPEN_RANGE_BEFORE = "B";
    public static final String BOUNDED_RANGE = "C";
    public static final String NO_RANGE = "";
    public static final int DAY_OF_HALF_MONTH = 15;
    public static final int LAST_DAY_OF_MONTH = 31;
    public static final String MONTH_OF_HALF_YEAR = "07";
    public static final String LAST_MONTH_OF_YEAR = "12";
    private String isoDate = "";
    private boolean unparseable = false;
    public static final HashMap<String, Pair<DateField, Integer>> relativeDateMap = new HashMap();
    public static final HashMap<Integer, Integer> daysPerMonth;
    private static String[] rangeIndicators;
    private Pattern re1 = Pattern.compile("[1-2][0-9]{3}|'[0-9]{2}");
    private Pattern re2 = Pattern.compile("[0-9][^0-9].*([0-9]{2})\\s*$");
    private static final Pattern[] extractorArray;
    private static Pattern[] weekdayArray;

    public ISODateInstance() {
    }

    public ISODateInstance(String date) {
        this.extractFields(date);
    }

    public ISODateInstance(String date, String openRangeMarker) {
        this.extractFields(date);
        if (!NO_RANGE.equals(openRangeMarker) && !this.isoDate.contains("/")) {
            if (OPEN_RANGE_AFTER.equals(openRangeMarker)) {
                this.isoDate = this.isoDate + '/';
            } else if (OPEN_RANGE_BEFORE.equals(openRangeMarker)) {
                this.isoDate = '/' + this.isoDate;
            }
        }
    }

    public ISODateInstance(ISODateInstance start, ISODateInstance end) {
        String startString = start.getDateString();
        if (start.isRange()) {
            startString = start.getStartDate();
        }
        String endString = end.getDateString();
        if (end.isRange()) {
            endString = end.getEndDate();
        }
        this.isoDate = startString + '/' + endString;
        this.unparseable = start.isUnparseable() || end.isUnparseable();
    }

    public ISODateInstance(ISODateInstance referenceDate, String relativeDate) {
        Pair<DateField, Integer> relation = relativeDateMap.get(relativeDate.toLowerCase());
        if (relation != null) {
            switch (relation.first()) {
                case DAY: {
                    this.incrementDay(referenceDate, relation);
                    break;
                }
                case MONTH: {
                    this.incrementMonth(referenceDate, relation);
                    break;
                }
                case YEAR: {
                    this.incrementYear(referenceDate, relation);
                }
            }
        }
    }

    private void incrementYear(ISODateInstance referenceDate, Pair<DateField, Integer> relation) {
        String origDateString = referenceDate.getStartDate();
        String yearString = origDateString.substring(0, 4);
        if (yearString.contains("*")) {
            this.isoDate = origDateString;
            return;
        }
        this.isoDate = ISODateInstance.makeStringYearChange(origDateString, Integer.parseInt(yearString) + relation.second());
    }

    private void incrementMonth(ISODateInstance referenceDate, Pair<DateField, Integer> relation) {
        String origDateString = referenceDate.getStartDate();
        String monthString = origDateString.substring(4, 6);
        if (monthString.contains("*")) {
            this.isoDate = origDateString;
            return;
        }
        Integer monthNum = Integer.parseInt(monthString);
        if (monthNum + relation.second() > 12 || monthNum + (Integer)relation.second < 1) {
            boolean decreasing = monthNum + (Integer)relation.second < 1;
            int newMonthNum = (monthNum + relation.second()) % 12;
            if (newMonthNum < 0) {
                newMonthNum *= -1;
            }
            this.isoDate = ISODateInstance.makeStringMonthChange(origDateString, newMonthNum);
            String yearString = origDateString.substring(0, 4);
            if (!yearString.contains("*")) {
                int numYearsToIncrement = (int)Math.ceil((double)relation.second().intValue() / 12.0);
                this.isoDate = decreasing ? ISODateInstance.makeStringYearChange(this.isoDate, Integer.parseInt(yearString) - numYearsToIncrement) : ISODateInstance.makeStringYearChange(this.isoDate, Integer.parseInt(yearString) + numYearsToIncrement);
            }
        } else {
            this.isoDate = ISODateInstance.makeStringMonthChange(origDateString, monthNum + relation.second());
        }
    }

    private void incrementDay(ISODateInstance referenceDate, Pair<DateField, Integer> relation) {
        int newMonthNum;
        boolean decreasing;
        String origDateString = referenceDate.getStartDate();
        String dayString = origDateString.substring(origDateString.length() - 2, origDateString.length());
        if (dayString.contains("*")) {
            this.isoDate = origDateString;
            return;
        }
        Integer dayNum = Integer.parseInt(dayString);
        String monthString = origDateString.substring(origDateString.length() - 4, origDateString.length() - 2);
        int numDaysInMonth = 30;
        int monthNum = -1;
        if (!monthString.contains("*")) {
            monthNum = Integer.parseInt(monthString);
            numDaysInMonth = daysPerMonth.get(monthNum);
        }
        if (dayNum + relation.second() <= numDaysInMonth && dayNum + relation.second() >= 1) {
            dayNum = dayNum + relation.second();
            this.isoDate = ISODateInstance.makeStringDayChange(origDateString, dayNum);
            return;
        }
        if (monthNum == -1) {
            this.isoDate = origDateString;
            return;
        }
        this.isoDate = origDateString;
        boolean bl = decreasing = dayNum + relation.second() < 1;
        if (monthNum + 1 > 12 && !decreasing || monthNum - 1 < 1 && decreasing) {
            newMonthNum = decreasing ? 12 : 1;
            String yearString = origDateString.substring(0, 4);
            if (!yearString.contains("*")) {
                this.isoDate = decreasing ? ISODateInstance.makeStringYearChange(this.isoDate, Integer.parseInt(yearString) - 1) : ISODateInstance.makeStringYearChange(this.isoDate, Integer.parseInt(yearString) + 1);
            }
        } else {
            newMonthNum = decreasing ? monthNum - 1 : monthNum + 1;
        }
        this.isoDate = ISODateInstance.makeStringMonthChange(this.isoDate, newMonthNum);
        int newDateNum = decreasing ? -relation.second().intValue() + daysPerMonth.get(newMonthNum) - dayNum : relation.second() - dayNum + daysPerMonth.get(monthNum);
        this.isoDate = ISODateInstance.makeStringDayChange(this.isoDate, newDateNum);
    }

    private static String makeStringDayChange(String origDate, int newDay) {
        String newDayString = newDay < 10 ? "0" + newDay : String.valueOf(newDay);
        return origDate.substring(0, origDate.length() - 2) + newDayString;
    }

    private static String makeStringMonthChange(String origDate, int newMonth) {
        String newMonthString = newMonth < 10 ? "0" + newMonth : String.valueOf(newMonth);
        return origDate.substring(0, 4) + newMonthString + origDate.substring(6, 8);
    }

    private static String makeStringYearChange(String origDate, int newYear) {
        String newYearString = String.valueOf(newYear);
        while (newYearString.length() < 4) {
            newYearString = '0' + newYearString;
        }
        return newYearString + origDate.substring(4, origDate.length());
    }

    public static ISODateInstance fromDateString(String date) {
        ISODateInstance d = new ISODateInstance();
        d.isoDate = date;
        return d;
    }

    public String toString() {
        return this.isoDate;
    }

    public String getDateString() {
        return this.toString();
    }

    public boolean extractFields(String inputDate) {
        Pair<String, String> dateEndpoints;
        if (this.tokens.size() < 2) {
            this.tokenizeDate(inputDate);
        }
        if ((dateEndpoints = ISODateInstance.getRangeDates(inputDate)) != null) {
            ISODateInstance date1 = new ISODateInstance(dateEndpoints.first());
            if (dateEndpoints.first().contains(" ") && !dateEndpoints.second().contains(" ")) {
                String date = dateEndpoints.first().substring(0, dateEndpoints.first().indexOf(32)) + ' ' + dateEndpoints.second();
                ISODateInstance date2 = new ISODateInstance(date);
                if (!date1.isUnparseable() && !date2.isUnparseable()) {
                    this.isoDate = new ISODateInstance(date1, date2).getDateString();
                    return true;
                }
            }
            ISODateInstance date2 = new ISODateInstance(dateEndpoints.second());
            if (!date1.isUnparseable() && !date2.isUnparseable()) {
                this.isoDate = new ISODateInstance(date1, date2).getDateString();
                return true;
            }
        }
        if (this.extractYYYYMMDD(inputDate)) {
            return true;
        }
        if (this.extractMMDDYY(inputDate)) {
            return true;
        }
        boolean passed = false;
        passed = this.extractYear(inputDate) || passed;
        passed = this.extractMonth(inputDate) || passed;
        passed = this.extractDay(inputDate) || passed;
        boolean bl = passed = this.addExtraRanges(inputDate) || passed;
        if (!passed) {
            this.unparseable = true;
            boolean weekday = this.extractWeekday(inputDate);
            if (!weekday) {
                this.isoDate = inputDate;
            }
        }
        return passed;
    }

    private static Pair<String, String> getRangeDates(String inputDate) {
        for (String curIndicator : rangeIndicators) {
            String[] dates = inputDate.split(curIndicator);
            if (dates.length != 2) continue;
            return new Pair<String, String>(dates[0], dates[1]);
        }
        return null;
    }

    private boolean addExtraRanges(String inputDate) {
        if (this.isRange()) {
            return false;
        }
        if ((inputDate = inputDate.toLowerCase()).contains("half")) {
            if (inputDate.contains("first") && this.isoDate.length() <= 6) {
                String firstDate = this.isoDate + "01";
                String secondDate = this.isoDate.length() == 4 ? this.isoDate + MONTH_OF_HALF_YEAR : this.isoDate + 15;
                this.isoDate = firstDate + '/' + secondDate;
                return true;
            }
            if (inputDate.contains("second") && this.isoDate.length() <= 6) {
                String secondDate;
                String firstDate;
                if (this.isoDate.length() == 4) {
                    firstDate = this.isoDate + MONTH_OF_HALF_YEAR;
                    secondDate = this.isoDate + LAST_MONTH_OF_YEAR;
                    this.isoDate = firstDate + '/' + secondDate;
                } else {
                    firstDate = this.isoDate + 15;
                    secondDate = this.isoDate + 31;
                }
                this.isoDate = firstDate + '/' + secondDate;
                return true;
            }
        }
        return false;
    }

    public boolean isRange() {
        if (this.unparseable) {
            return false;
        }
        return this.isoDate.matches("/");
    }

    public boolean isUnparseable() {
        return this.unparseable;
    }

    public String getStartDate() {
        if (!this.isRange()) {
            return this.isoDate;
        }
        if (this.isoDate.startsWith("/")) {
            return NO_RANGE;
        }
        return this.isoDate.split("/")[0];
    }

    public String getEndDate() {
        if (!this.isRange()) {
            return this.isoDate;
        }
        if (this.isoDate.endsWith("/")) {
            return NO_RANGE;
        }
        String[] split = this.isoDate.split("/");
        return split[split.length - 1];
    }

    static boolean isAfter(String date1, String date2) {
        if (!ISODateInstance.isDateFormat(date1) || !ISODateInstance.isDateFormat(date2)) {
            return false;
        }
        boolean after = true;
        String year = date1.substring(0, 4);
        String yearOther = date2.substring(0, 4);
        if (year.contains("*") || yearOther.contains("*")) {
            after = after && ISODateInstance.checkWildcardCompatibility(year, yearOther);
        } else {
            if (Integer.valueOf(year) > Integer.valueOf(yearOther)) {
                return true;
            }
            if (Integer.valueOf(year) < Integer.valueOf(yearOther)) {
                return false;
            }
        }
        if (date1.length() < 6 || date2.length() < 6) {
            if (year.contains("*") || yearOther.contains("*")) {
                return after;
            }
            return after && !Integer.valueOf(year).equals(Integer.valueOf(yearOther));
        }
        String month = date1.substring(4, 6);
        String monthOther = date2.substring(4, 6);
        if (month.contains("*") || monthOther.contains("*")) {
            after = after && ISODateInstance.checkWildcardCompatibility(month, monthOther);
        } else {
            if (Integer.valueOf(month) > Integer.valueOf(monthOther)) {
                return true;
            }
            if (Integer.valueOf(month) < Integer.valueOf(monthOther)) {
                return false;
            }
        }
        if (date1.length() < 8 || date2.length() < 8) {
            if (month.contains("*") || monthOther.contains("*")) {
                return after;
            }
            return after && !Integer.valueOf(month).equals(Integer.valueOf(monthOther));
        }
        String day = date1.substring(6, 8);
        String dayOther = date2.substring(6, 8);
        if (day.contains("*") || dayOther.contains("*")) {
            after = after && ISODateInstance.checkWildcardCompatibility(day, dayOther);
        } else {
            if (Integer.valueOf(day) > Integer.valueOf(dayOther)) {
                return true;
            }
            if (Integer.valueOf(day) <= Integer.valueOf(dayOther)) {
                return false;
            }
        }
        return after;
    }

    private static boolean checkWildcardAfterCompatibility(String txt1, String txt2) {
        if (txt1.length() != txt2.length()) {
            return false;
        }
        for (int i = 0; i < txt1.length(); ++i) {
            Character t1 = Character.valueOf(txt1.charAt(i));
            Character t2 = Character.valueOf(txt2.charAt(i));
            if (t1.equals(Character.valueOf('*')) || t2.equals(Character.valueOf('*')) || t1.equals(t2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDateFormat(String txt) {
        String numberValue = txt.replace("*", NO_RANGE);
        try {
            Integer.parseInt(numberValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCompatible(String date1, String date2) {
        boolean compatible = true;
        compatible = compatible && ISODateInstance.isYearCompatible(date1, date2);
        compatible = compatible && ISODateInstance.isMonthCompatible(date1, date2);
        compatible = compatible && ISODateInstance.isDayCompatible(date1, date2);
        return compatible;
    }

    private static boolean isYearCompatible(String date1, String date2) {
        boolean compatible = true;
        if (date1.length() < 4 || date2.length() < 4) {
            return compatible;
        }
        String year = date1.substring(0, 4);
        String yearOther = date2.substring(0, 4);
        if (year.contains("*") || yearOther.contains("*")) {
            compatible = compatible && ISODateInstance.checkWildcardCompatibility(year, yearOther);
        } else if (!year.equals(yearOther)) {
            return false;
        }
        return compatible;
    }

    private static boolean isMonthCompatible(String date1, String date2) {
        boolean compatible = true;
        if (date1.length() < 6 || date2.length() < 6) {
            return compatible;
        }
        String month = date1.substring(4, 6);
        String monthOther = date2.substring(4, 6);
        if (month.contains("*") || monthOther.contains("*")) {
            compatible = compatible && ISODateInstance.checkWildcardCompatibility(month, monthOther);
        } else if (!month.equals(monthOther)) {
            return false;
        }
        return compatible;
    }

    private static boolean isDayCompatible(String date1, String date2) {
        boolean compatible = true;
        if (date1.length() < 8 || date2.length() < 8) {
            return compatible;
        }
        String day = date1.substring(6, 8);
        String dayOther = date2.substring(6, 8);
        if (day.contains("*") || dayOther.contains("*")) {
            compatible = compatible && ISODateInstance.checkWildcardCompatibility(day, dayOther);
        } else if (!day.equals(dayOther)) {
            return false;
        }
        return compatible;
    }

    private static boolean checkWildcardCompatibility(String txt1, String txt2) {
        if (txt1.length() != txt2.length()) {
            return false;
        }
        for (int i = 0; i < txt1.length(); ++i) {
            Character t1 = Character.valueOf(txt1.charAt(i));
            Character t2 = Character.valueOf(txt2.charAt(i));
            if (t1.equals(Character.valueOf('*')) || t2.equals(Character.valueOf('*')) || t1.equals(t2)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ISODateInstance other) {
        String end;
        if (this.isUnparseable() || other.isUnparseable()) {
            return this.isoDate.equals(other.isoDate);
        }
        String start = this.getStartDate();
        if (!start.equals(NO_RANGE)) {
            String startOther = other.getStartDate();
            if (startOther.equals(NO_RANGE)) {
                return false;
            }
            if (!ISODateInstance.isAfter(startOther, start)) {
                return false;
            }
        }
        if (!(end = this.getEndDate()).equals(NO_RANGE)) {
            String endOther = other.getEndDate();
            if (endOther.equals(NO_RANGE)) {
                return false;
            }
            if (!ISODateInstance.isAfter(end, endOther)) {
                return false;
            }
        }
        return true;
    }

    public boolean isAfter(String dateString) {
        if (this.isUnparseable()) {
            return false;
        }
        if (!ISODateInstance.isDateFormat(dateString)) {
            return false;
        }
        return ISODateInstance.isAfter(this.getEndDate(), dateString);
    }

    public boolean isCompatibleDate(ISODateInstance other) {
        if (this.isUnparseable() || other.isUnparseable()) {
            return this.isoDate.equals(other.isoDate);
        }
        if (this.isRange()) {
            return this.contains(other);
        }
        if (other.isRange()) {
            return false;
        }
        return ISODateInstance.isCompatible(this.isoDate, other.getDateString());
    }

    public boolean isYearCompatible(ISODateInstance other) {
        if (this.isUnparseable() || other.isUnparseable()) {
            return this.isoDate.equals(other.isoDate);
        }
        return ISODateInstance.isYearCompatible(this.isoDate, other.getDateString());
    }

    public boolean isMonthCompatible(ISODateInstance other) {
        if (this.isUnparseable() || other.isUnparseable()) {
            return this.isoDate.equals(other.isoDate);
        }
        return ISODateInstance.isMonthCompatible(this.isoDate, other.getDateString());
    }

    public boolean isDayCompatible(ISODateInstance other) {
        if (this.isUnparseable() || other.isUnparseable()) {
            return this.isoDate.equals(other.isoDate);
        }
        return ISODateInstance.isDayCompatible(this.isoDate, other.getDateString());
    }

    private void tokenizeDate(String inputDate) {
        this.tokens = new ArrayList();
        Pattern pat = Pattern.compile("[-]");
        if (inputDate == null) {
            System.out.println("Null input date");
        }
        Matcher m = pat.matcher(inputDate);
        String str = m.replaceAll(" - ");
        str = str.replaceAll(",", " ");
        PTBTokenizer<Word> tokenizer = PTBTokenizer.newPTBTokenizer(new BufferedReader(new StringReader(str)));
        while (tokenizer.hasNext()) {
            Word nextToken = (Word)tokenizer.next();
            this.tokens.add(nextToken.toString());
        }
    }

    private boolean extractYYYYMMDD(String inputDate) {
        Pattern pat = Pattern.compile("([12][0-9]{3})[ /-]?([01]?[0-9])[ /-]([0-3]?[0-9])[ \t\r\n\f]*");
        Matcher m = pat.matcher(inputDate);
        if (m.matches()) {
            String dayValue;
            String monthValue = m.group(2);
            if (monthValue.length() < 2) {
                monthValue = '0' + monthValue;
            }
            if ((dayValue = m.group(3)).length() < 2) {
                dayValue = '0' + dayValue;
            }
            String yearString = m.group(1);
            this.isoDate = yearString + monthValue + dayValue;
            return true;
        }
        return false;
    }

    private boolean extractMMDDYY(String inputDate) {
        Pattern pat = Pattern.compile("([0-1]??[0-9])[ \t\n\r\f]*[/-][ \t\n\r\f]*([0-3]??[0-9])[ \t\r\n\f]*[/-][ \t\r\n\f]*([0-2]??[0-9]??[0-9][0-9])[ \t\r\n\f]*");
        Matcher m = pat.matcher(inputDate);
        if (m.matches()) {
            int yearInt;
            String dayValue;
            String monthValue = m.group(1);
            if (monthValue.length() < 2) {
                monthValue = '0' + monthValue;
            }
            if ((dayValue = m.group(2)).length() < 2) {
                dayValue = '0' + dayValue;
            }
            String yearString = m.group(3).length() == 2 ? ((yearInt = Integer.parseInt(m.group(3))) < 50 ? "20" + m.group(3) : "19" + m.group(3)) : m.group(3);
            this.isoDate = yearString + monthValue + dayValue;
            return true;
        }
        return false;
    }

    public boolean extractYear(String inputDate) {
        String extract;
        Matcher m1 = this.re1.matcher(inputDate);
        Matcher m2 = this.re2.matcher(inputDate);
        if (m1.find()) {
            extract = m1.group(0);
        } else if (m2.find()) {
            extract = m2.group(1);
        } else {
            extract = ISODateInstance.foundMiscYearPattern(inputDate);
            if (extract == null || extract.equals(NO_RANGE)) {
                this.isoDate = "****";
                return false;
            }
        }
        if (!NO_RANGE.equals(extract)) {
            if (extract.charAt(0) == '\'') {
                extract = extract.substring(1);
            }
            if ((extract = extract.trim()).length() == 2) {
                extract = extract.charAt(0) < '5' ? "20" + extract : "19" + extract;
            }
            if (inputDate.charAt(inputDate.length() - 1) == 's') {
                if (extract.charAt(2) == '0') {
                    String endDate = Integer.toString(Integer.valueOf(extract) + 99);
                    extract = extract + '/' + endDate;
                } else {
                    String endDate = Integer.toString(Integer.valueOf(extract) + 9);
                    extract = extract + '/' + endDate;
                }
            }
            this.isoDate = extract;
            return true;
        }
        this.isoDate = "****";
        return false;
    }

    private static String foundMiscYearPattern(String inputDate) {
        String year = NO_RANGE;
        if (inputDate.toLowerCase().contains("century")) {
            if (inputDate.endsWith("A.D. ")) {
                inputDate = inputDate.substring(0, inputDate.length() - 5);
            }
            if (inputDate.startsWith("late")) {
                inputDate = inputDate.substring(5, inputDate.length());
            }
            if (inputDate.startsWith("early")) {
                inputDate = inputDate.substring(6, inputDate.length());
            }
            if (Character.isDigit(inputDate.charAt(0))) {
                year = QuantifiableEntityNormalizer.normalizedNumberStringQuiet(inputDate.substring(0, inputDate.length() - 2), 1.0, NO_RANGE);
                if (year.contains(".")) {
                    year = year.substring(0, year.indexOf(46));
                }
                while (year.length() < 4) {
                    year = year + '*';
                }
            } else if (QuantifiableEntityNormalizer.ordinalsToValues.containsKey(inputDate)) {
                year = Double.toString(QuantifiableEntityNormalizer.ordinalsToValues.getCount(inputDate));
                while (year.length() < 4) {
                    year = year + '*';
                }
            } else {
                year = NO_RANGE;
            }
        }
        return year;
    }

    public boolean extractMonth(String inputDate) {
        boolean foundMonth = false;
        for (int i = 0; i < 12; ++i) {
            String extract = NO_RANGE;
            Matcher m = extractorArray[i].matcher(inputDate);
            if (m.find()) {
                extract = m.group(0);
            }
            if (NO_RANGE.equals(extract) || foundMonth) continue;
            int monthNum = i + 1;
            if (this.isoDate.length() != 4) {
                this.isoDate = "****";
            }
            String month = monthNum < 10 ? "0" + monthNum : String.valueOf(monthNum);
            this.isoDate = this.isoDate + month;
            foundMonth = true;
        }
        return foundMonth;
    }

    public boolean extractDay(String inputDate) {
        for (int a = 0; a < this.tokens.size(); ++a) {
            String extract = this.tokens.get(a);
            if (QuantifiableEntityNormalizer.wordsToValues.containsKey(extract)) {
                extract = Integer.toString(Double.valueOf(QuantifiableEntityNormalizer.wordsToValues.getCount(extract)).intValue());
            } else if (QuantifiableEntityNormalizer.ordinalsToValues.containsKey(extract)) {
                extract = Integer.toString(Double.valueOf(QuantifiableEntityNormalizer.ordinalsToValues.getCount(extract)).intValue());
            }
            extract = extract.replaceAll("[^0-9]", NO_RANGE);
            if (extract.equals(NO_RANGE)) continue;
            try {
                Integer i = Integer.valueOf(extract);
                if (i >= 32 || i <= 0) continue;
                if (this.isoDate.length() < 6) {
                    this.isoDate = this.isoDate.length() != 4 ? this.isoDate + "******" : this.isoDate + "**";
                }
                String day = i < 10 ? "0" + i : String.valueOf(i);
                this.isoDate = this.isoDate + day;
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("Exception in extract Day.");
                System.err.println("tokens size :" + this.tokens.size());
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean extractWeekday(String inputDate) {
        for (Pattern p : weekdayArray) {
            Matcher m = p.matcher(inputDate);
            if (!m.find()) continue;
            String extract = m.group(0);
            this.isoDate = extract.toLowerCase();
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Properties props = StringUtils.argsToProperties(args);
        String dateProperty = props.getProperty("date");
        if (dateProperty != null) {
            ISODateInstance d = new ISODateInstance(dateProperty);
            System.out.println(dateProperty + " processed as " + d.toString());
        }
    }

    static {
        relativeDateMap.put("today", new Pair<DateField, Integer>(DateField.DAY, 0));
        relativeDateMap.put("tomorrow", new Pair<DateField, Integer>(DateField.DAY, 1));
        relativeDateMap.put("yesterday", new Pair<DateField, Integer>(DateField.DAY, -1));
        daysPerMonth = new HashMap();
        daysPerMonth.put(1, 31);
        daysPerMonth.put(2, 28);
        daysPerMonth.put(3, 31);
        daysPerMonth.put(4, 30);
        daysPerMonth.put(5, 31);
        daysPerMonth.put(6, 30);
        daysPerMonth.put(7, 31);
        daysPerMonth.put(8, 31);
        daysPerMonth.put(9, 30);
        daysPerMonth.put(10, 31);
        daysPerMonth.put(11, 30);
        daysPerMonth.put(12, 31);
        rangeIndicators = new String[]{"--", "-"};
        extractorArray = new Pattern[]{Pattern.compile("[Jj]anuary|JANUARY|[Jj]an\\.?|JAN\\.?"), Pattern.compile("[Ff]ebruary|FEBRUARY|[Ff]eb\\.?|FEB\\.?"), Pattern.compile("[Mm]arch|MARCH|[Mm]ar\\.?|MAR\\.?"), Pattern.compile("[Aa]pril|APRIL|[Aa]pr\\.?|APR\\.?"), Pattern.compile("[Mm]ay|MAY"), Pattern.compile("[Jj]une|JUNE|[Jj]un\\.?|JUN\\.?"), Pattern.compile("[Jj]uly|JULY|[Jj]ul\\.?|JUL\\.?"), Pattern.compile("[Aa]ugust|AUGUST|[Aa]ug\\.?|AUG\\.?"), Pattern.compile("[Ss]eptember|SEPTEMBER|[Ss]ept?\\.?|SEPT?\\.?"), Pattern.compile("[Oo]ctober|OCTOBER|[Oo]ct\\.?|OCT\\.?"), Pattern.compile("[Nn]ovember|NOVEMBER|[Nn]ov\\.?|NOV\\.?"), Pattern.compile("[Dd]ecember|DECEMBER|[Dd]ec(?:\\.|[^aeiou]|$)|DEC(?:\\.|[^aeiou]|$)")};
        weekdayArray = new Pattern[]{Pattern.compile("[Ss]unday"), Pattern.compile("[Mm]onday"), Pattern.compile("[Tt]uesday"), Pattern.compile("[Ww]ednesday"), Pattern.compile("[Tt]hursday"), Pattern.compile("[Ff]riday"), Pattern.compile("[Ss]aturday")};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateField {
        DAY,
        MONTH,
        YEAR;

    }
}

