/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.CoreMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedWord
extends CoreLabel
implements Comparable<IndexedWord> {
    private static final long serialVersionUID = 3739633991145239829L;
    public static final IndexedWord NO_WORD = new IndexedWord(null, -1, -1);
    public static final String WORD_FORMAT = "WORD_FORMAT";
    public static final String WORD_TAG_FORMAT = "WORD_TAG_FORMAT";
    public static final String WORD_TAG_INDEX_FORMAT = "WORD_TAG_INDEX_FORMAT";
    public static final String VALUE_FORMAT = "VALUE_FORMAT";
    public static final String COMPLETE_FORMAT = "COMPLETE_FORMAT";
    private static String printFormat = "WORD_TAG_FORMAT";

    public IndexedWord() {
    }

    public IndexedWord(Label w) {
        super(w);
        if (this.word() == null) {
            this.setWord(this.value());
        }
    }

    public IndexedWord(CoreLabel w) {
        this((CoreMap)w);
    }

    public IndexedWord(CoreMap w) {
        super(w);
        if (this.word() == null) {
            this.setWord(this.value());
        }
    }

    public IndexedWord(CyclicCoreLabel w) {
        super(w);
        if (this.word() == null) {
            this.setWord(this.value());
        }
    }

    public IndexedWord(String docID, int sentenceIndex, int index) {
        this.set(CoreAnnotations.DocIDAnnotation.class, docID);
        this.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
        this.set(CoreAnnotations.IndexAnnotation.class, index);
    }

    public IndexedWord(String docID, int sentenceIndex, int index, CoreLabel label) {
        this(label);
        this.set(CoreAnnotations.DocIDAnnotation.class, docID);
        this.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
        this.set(CoreAnnotations.IndexAnnotation.class, index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedWord)) {
            return false;
        }
        IndexedWord otherWord = (IndexedWord)o;
        String myDocID = this.getString(CoreAnnotations.DocIDAnnotation.class);
        String otherDocID = otherWord.getString(CoreAnnotations.DocIDAnnotation.class);
        if (myDocID == null ? otherDocID != null : !myDocID.equals(otherDocID)) {
            return false;
        }
        Integer mySentInd = (Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class);
        Integer otherSentInd = (Integer)otherWord.get(CoreAnnotations.SentenceIndexAnnotation.class);
        if (mySentInd == null ? otherSentInd != null : !mySentInd.equals(otherSentInd)) {
            return false;
        }
        Integer myInd = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
        Integer otherInd = (Integer)otherWord.get(CoreAnnotations.IndexAnnotation.class);
        return !(myInd == null ? otherInd != null : !myInd.equals(otherInd));
    }

    @Override
    public int hashCode() {
        boolean sensible = false;
        int result = 0;
        if (this.get(CoreAnnotations.DocIDAnnotation.class) != null) {
            result = ((String)this.get(CoreAnnotations.DocIDAnnotation.class)).hashCode();
            sensible = true;
        }
        if (this.has(CoreAnnotations.SentenceIndexAnnotation.class)) {
            result = 29 * result + (Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class);
            sensible = true;
        }
        if (this.has(CoreAnnotations.IndexAnnotation.class)) {
            result = 29 * result + (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            sensible = true;
        }
        if (!sensible) {
            System.err.println("WARNING!!!  You have hashed an IndexedWord with no docID, sentIndex or wordIndex. You will almost certainly lose");
        }
        return result;
    }

    @Override
    public int compareTo(IndexedWord w) {
        if (this.equals(NO_WORD)) {
            if (w.equals(NO_WORD)) {
                return 0;
            }
            return -1;
        }
        if (w.equals(NO_WORD)) {
            return 1;
        }
        String docID = this.getString(CoreAnnotations.DocIDAnnotation.class);
        int docComp = docID.compareTo(w.getString(CoreAnnotations.DocIDAnnotation.class));
        if (docComp != 0) {
            return docComp;
        }
        int sentComp = this.sentIndex() - w.sentIndex();
        if (sentComp != 0) {
            return sentComp;
        }
        return this.index() - w.index();
    }

    @Override
    public String toString() {
        return this.toString(printFormat);
    }

    public static void setPrintFormat(String printFormat) {
        IndexedWord.printFormat = printFormat;
    }

    public String toString(String format) {
        if (this.equals(NO_WORD)) {
            return "NO_WORD";
        }
        StringBuilder result = new StringBuilder();
        if (format == WORD_FORMAT || format == WORD_TAG_FORMAT || format == WORD_TAG_INDEX_FORMAT) {
            result.append(this.word());
            if (format == WORD_TAG_FORMAT || format == WORD_TAG_INDEX_FORMAT) {
                String tag = this.tag();
                if (tag != null && tag.length() != 0) {
                    result.append('-').append(tag);
                }
                if (format == WORD_TAG_INDEX_FORMAT) {
                    result.append('-').append(this.sentIndex()).append(':').append(this.index());
                }
            }
        } else if (format == VALUE_FORMAT) {
            result.append(this.value());
            if (this.index() >= 0) {
                result.append(':').append(this.index());
            }
        } else {
            return super.toString();
        }
        return result.toString();
    }

    public static LabelFactory factory() {
        return new LabelFactory(){

            public Label newLabel(String labelStr) {
                IndexedWord label = new IndexedWord();
                label.setValue(labelStr);
                return label;
            }

            public Label newLabel(String labelStr, int options) {
                return this.newLabel(labelStr);
            }

            public Label newLabel(Label oldLabel) {
                return new IndexedWord(oldLabel);
            }

            public Label newLabelFromString(String encodedLabelStr) {
                throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
            }
        };
    }

    @Override
    public LabelFactory labelFactory() {
        return IndexedWord.factory();
    }
}

