/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.HasInitial;
import java.util.Arrays;

public abstract class AbstractCachingDiffFunction
implements DiffFunction,
HasInitial {
    double[] lastX = null;
    int fevals = 0;
    protected double[] derivative = null;
    protected double value = 0.0;

    public abstract int domainDimension();

    protected abstract void calculate(double[] var1);

    protected void clearCache() {
        if (this.lastX != null) {
            this.lastX[0] = Double.NaN;
        }
    }

    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        Arrays.fill(initial, 0.0);
        return initial;
    }

    protected void copy(double[] y, double[] x) {
        System.arraycopy(x, 0, y, 0, x.length);
    }

    void ensure(double[] x) {
        if (Arrays.equals(x, this.lastX)) {
            return;
        }
        if (this.lastX == null) {
            this.lastX = new double[this.domainDimension()];
        }
        if (this.derivative == null) {
            this.derivative = new double[this.domainDimension()];
        }
        this.copy(this.lastX, x);
        ++this.fevals;
        this.calculate(x);
    }

    public double valueAt(double[] x) {
        this.ensure(x);
        return this.value;
    }

    public double[] derivativeAt(double[] x) {
        this.ensure(x);
        return this.derivative;
    }

    public double lastValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }
}

