/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.StochasticMinimizer;
import edu.stanford.nlp.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDMinimizer<T extends Function>
extends StochasticMinimizer<T> {
    @Override
    public void shutUp() {
        this.quiet = true;
    }

    public void setBatchSize(int batchSize) {
        bSize = batchSize;
    }

    public SGDMinimizer() {
    }

    public SGDMinimizer(double SGDGain, int batchSize) {
        this(SGDGain, batchSize, 50);
    }

    public SGDMinimizer(double SGDGain, int batchSize, int passes) {
        this(SGDGain, batchSize, passes, Long.MAX_VALUE, false);
    }

    public SGDMinimizer(double SGDGain, int batchSize, int passes, boolean outputToFile) {
        this(SGDGain, batchSize, passes, Long.MAX_VALUE, outputToFile);
    }

    public SGDMinimizer(double SGDGain, int batchSize, int passes, long maxTime) {
        this(SGDGain, batchSize, passes, maxTime, false);
    }

    public SGDMinimizer(double SGDGain, int batchSize, int passes, long maxTime, boolean outputToFile) {
        StochasticMinimizer.bSize = batchSize;
        StochasticMinimizer.gain = SGDGain;
        this.numPasses = passes;
        this.outputIterationsToFile = outputToFile;
        this.maxTime = maxTime;
    }

    @Override
    protected String getName() {
        int g = (int)gain * 1000;
        return "SGD" + bSize + "_g" + g;
    }

    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest, double gainLow, double gainHigh) {
        this.quiet = true;
        StochasticMinimizer.gain = this.tuneGain(function, initial, msPerTest, gainLow, gainHigh);
        StochasticMinimizer.bSize = this.tuneBatch(function, initial, msPerTest, 1);
        return new Pair<Integer, Double>(StochasticMinimizer.bSize, StochasticMinimizer.gain);
    }

    @Override
    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest) {
        return this.tune(function, initial, msPerTest, 1.0E-7, 1.0);
    }

    @Override
    protected void takeStep(AbstractStochasticCachingDiffFunction dfunction) {
        for (int i = 0; i < this.x.length; ++i) {
            this.newX[i] = this.x[i] - gain * this.gainSchedule(this.k, 5 * this.numBatches) * this.grad[i];
        }
    }

    public static void main(String[] args) {
        int dim = 500000;
        double maxVar = 5.0;
        final double[] var = new double[500000];
        double[] init = new double[500000];
        for (int i = 0; i < 500000; ++i) {
            init[i] = (double)(i + 1) / 500000.0 - 0.5;
            var[i] = 5.0 * (double)(i + 1) / 500000.0;
        }
        final double[] grads = new double[500000];
        DiffFunction f = new DiffFunction(){

            public double[] derivativeAt(double[] x) {
                double val = Math.PI * this.valuePow(x, 2.141592653589793);
                for (int i = 0; i < 500000; ++i) {
                    grads[i] = x[i] * var[i] * val;
                }
                return grads;
            }

            public double valueAt(double[] x) {
                return 1.0 + this.valuePow(x, Math.PI);
            }

            private double valuePow(double[] x, double pow) {
                double val = 0.0;
                for (int i = 0; i < 500000; ++i) {
                    val += x[i] * x[i] * var[i];
                }
                return Math.pow(val * 0.5, pow);
            }

            public int domainDimension() {
                return 500000;
            }
        };
        SGDMinimizer min = new SGDMinimizer();
        min.minimize(f, 1.0E-4, init);
    }
}

