/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ScaledSGDMinimizer;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDToQNMinimizer
implements Minimizer<DiffFunction>,
Serializable {
    private static final long serialVersionUID = -7551807670291500396L;
    private int k;
    private int bSize = 15;
    private boolean quiet = false;
    public boolean outputIterationsToFile = false;
    public int outputFrequency = 10;
    public double gain = 0.1;
    private List<double[]> gradList = null;
    private List<double[]> yList = null;
    private List<double[]> sList = null;
    private List<double[]> tmpYList = null;
    private List<double[]> tmpSList = null;
    private int memory = 5;
    public int SGDPasses = -1;
    public int QNPasses = -1;
    private int hessSampleSize = 50;
    private int QNMem = 10;
    private boolean toTest = false;
    private static NumberFormat nf = new DecimalFormat("0.000E0");

    public void shutUp() {
        this.quiet = true;
    }

    public void setBatchSize(int batchSize) {
        this.bSize = batchSize;
    }

    public SGDToQNMinimizer(SeqClassifierFlags flags) {
        this.bSize = flags.stochasticBatchSize;
        this.gain = flags.initialGain;
        this.SGDPasses = flags.SGDPasses;
        this.QNPasses = flags.QNPasses;
        this.QNMem = flags.QNsize;
        this.outputIterationsToFile = flags.outputIterationsToFile;
        this.toTest = flags.testObjFunction;
        this.hessSampleSize = flags.SGD2QNhessSamples;
    }

    public SGDToQNMinimizer(double SGDGain, int batchSize, int sgdPasses, int qnPasses, int hessSamples, int QNMem) {
        this(SGDGain, batchSize, sgdPasses, qnPasses, hessSamples, QNMem, false);
    }

    public SGDToQNMinimizer(double SGDGain, int batchSize, int sgdPasses, int qnPasses, int hessSamples, int QNMem, boolean outputToFile) {
        this.bSize = batchSize;
        this.gain = SGDGain;
        this.SGDPasses = sgdPasses;
        this.QNPasses = qnPasses;
        this.QNMem = QNMem;
        this.outputIterationsToFile = outputToFile;
        this.hessSampleSize = hessSamples;
    }

    public SGDToQNMinimizer(double SGDGain, int batchSize, int SGDPasses, int QNPasses) {
        this(SGDGain, batchSize, SGDPasses, QNPasses, 50, 10);
    }

    public void setQNMem(int mem) {
        this.QNMem = mem;
    }

    public void setHessSampleSize(int size) {
        this.hessSampleSize = size;
    }

    protected String getName() {
        int g = (int)(this.gain * 1000.0);
        return "SGD2QN" + this.bSize + "_g" + g;
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial, int maxIterations) {
        this.sayln("SGDToQNMinimizer called on function of " + function.domainDimension() + " variables;");
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        dfunction.method = StochasticCalculateMethods.GradientOnly;
        ScaledSGDMinimizer sgd = new ScaledSGDMinimizer(this.gain, this.bSize, this.SGDPasses, 1, this.outputIterationsToFile);
        QNMinimizer qn = new QNMinimizer(this.QNMem, true);
        double[] x = sgd.minimize(dfunction, functionTolerance, initial, this.SGDPasses);
        QNMinimizer qNMinimizer = qn;
        qNMinimizer.getClass();
        QNMinimizer.QNInfo qnInfo = qNMinimizer.new QNMinimizer.QNInfo(sgd.sList, sgd.yList);
        qnInfo.d = sgd.diag;
        qn.minimize(dfunction, functionTolerance, x, this.QNPasses, qnInfo);
        System.err.println("");
        System.err.println("Minimization complete.");
        System.err.println("");
        System.err.println("Exiting for Debug");
        return x;
    }

    private void sayln(String s) {
        if (!this.quiet) {
            System.err.println(s);
        }
    }

    private void say(String s) {
        if (!this.quiet) {
            System.err.print(s);
        }
    }
}

